/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.datafilters.service.attachmentfilters.systemattributes;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.migration.datafilters.model.Operator;
import com.atlassian.jira.migration.datafilters.model.SystemAttributeFilter;
import com.atlassian.jira.migration.datafilters.service.attachmentfilters.AttachmentAttributeFilterService;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import java.math.BigDecimal;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/attachmentfilters/systemattributes/AttachmentSizeFilterService;", "Lcom/atlassian/jira/migration/datafilters/service/attachmentfilters/AttachmentAttributeFilterService;", "Lcom/atlassian/jira/migration/datafilters/model/SystemAttributeFilter;", "()V", "log", "Lorg/slf4j/Logger;", "validate", "", "filter", "entity", "Lcom/atlassian/jira/issue/attachment/Attachment;", "Companion", "jira-migration-plugin"})
public final class AttachmentSizeFilterService
implements AttachmentAttributeFilterService<SystemAttributeFilter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    private static final Logger logger = LoggerFactory.getLogger(AttachmentSizeFilterService.class);

    public AttachmentSizeFilterService() {
        Logger logger2 = LoggerFactory.getLogger(AttachmentSizeFilterService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @Override
    public boolean validate(@NotNull SystemAttributeFilter filter, @NotNull Attachment entity) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        try {
            boolean bl;
            BigDecimal bigDecimal;
            Long l = entity.getFilesize();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFilesize(...)");
            BigDecimal entityValue = new BigDecimal(((Number)l).longValue());
            Operator operator = DataFiltersUtil.INSTANCE.parseOperator(filter.getOperator());
            String filterValue = (String)CollectionsKt.firstOrNull(filter.getValue());
            if (filterValue == null) {
                return true;
            }
            try {
                bigDecimal = DataFiltersUtil.INSTANCE.convertMbToBytes(filterValue);
            }
            catch (NumberFormatException e) {
                this.log.warn("Failed to parse filter value for attachment size. Provided value: '" + filterValue + "'. Please ensure it is a valid number.", (Throwable)e);
                return true;
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Resulting byte size exceeds maximum allowed value.", (Throwable)e);
                return true;
            }
            BigDecimal filterSizeInBytes = bigDecimal;
            switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
                case 1: {
                    if (entityValue.compareTo(filterSizeInBytes) >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (entityValue.compareTo(filterSizeInBytes) <= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }
        catch (Exception e) {
            logger.warn("Failed to apply size filter for attachment. Exception:", (Throwable)e);
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/attachmentfilters/systemattributes/AttachmentSizeFilterService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operator.values().length];
            try {
                nArray[Operator.GREATER_THAN_OR_EQUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.LESS_THAN_OR_EQUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

