/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.datafilters.service.issuefilters.customattributes;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.migration.datafilters.model.CustomAttributeFilter;
import com.atlassian.jira.migration.datafilters.service.issuefilters.IssueAttributeFilterService;
import java.util.Collection;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/issuefilters/customattributes/CFSelectFilterService;", "Lcom/atlassian/jira/migration/datafilters/service/issuefilters/IssueAttributeFilterService;", "Lcom/atlassian/jira/migration/datafilters/model/CustomAttributeFilter;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "(Lcom/atlassian/jira/issue/CustomFieldManager;)V", "validate", "", "filter", "entity", "Lcom/atlassian/jira/issue/Issue;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCFSelectFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CFSelectFilterService.kt\ncom/atlassian/jira/migration/datafilters/service/issuefilters/customattributes/CFSelectFilterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n288#2,2:41\n*S KotlinDebug\n*F\n+ 1 CFSelectFilterService.kt\ncom/atlassian/jira/migration/datafilters/service/issuefilters/customattributes/CFSelectFilterService\n*L\n22#1:41,2\n*E\n"})
public final class CFSelectFilterService
extends IssueAttributeFilterService<CustomAttributeFilter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomFieldManager customFieldManager;
    private static final Logger logger = LoggerFactory.getLogger(CFSelectFilterService.class);

    @Inject
    public CFSelectFilterService(@NotNull CustomFieldManager customFieldManager) {
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        this.customFieldManager = customFieldManager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean validate(@NotNull CustomAttributeFilter filter, @NotNull Issue entity) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        try {
            boolean bl;
            CustomField customField;
            Object v1;
            block6: {
                void $this$firstOrNull$iv;
                Collection collection = this.customFieldManager.getCustomFieldObjectsByName(filter.getName());
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCustomFieldObjectsByName(...)");
                Iterable iterable = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CustomField it = (CustomField)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getCustomFieldType().getKey(), (Object)"com.atlassian.jira.plugin.system.customfieldtypes:select")) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            CustomField customField2 = customField = (CustomField)v1;
            if ((customField2 != null ? customField2.getName() : null) == null) {
                return true;
            }
            Object customFieldValue = entity.getCustomFieldValue(customField);
            if (customFieldValue == null) {
                bl = this.validateNullCustomFieldValues(filter);
            } else {
                String string = ((Option)customFieldValue).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String entityValue = string3;
                bl = this.validateStringCustomFieldValues(CollectionsKt.listOf((Object)entityValue), filter);
            }
            return bl;
        }
        catch (Exception e) {
            logger.warn("Failed to apply custom field select filter. Exception:", (Throwable)e);
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/issuefilters/customattributes/CFSelectFilterService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

