/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.datafilters.service.issuefilters.systemattributes;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.migration.datafilters.model.Operator;
import com.atlassian.jira.migration.datafilters.model.SystemAttributeFilter;
import com.atlassian.jira.migration.datafilters.service.issuefilters.IssueAttributeFilterService;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/issuefilters/systemattributes/IssueLabelsFilterService;", "Lcom/atlassian/jira/migration/datafilters/service/issuefilters/IssueAttributeFilterService;", "Lcom/atlassian/jira/migration/datafilters/model/SystemAttributeFilter;", "()V", "validate", "", "filter", "entity", "Lcom/atlassian/jira/issue/Issue;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueLabelsFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueLabelsFilterService.kt\ncom/atlassian/jira/migration/datafilters/service/issuefilters/systemattributes/IssueLabelsFilterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1549#2:35\n1620#2,3:36\n1747#2,3:39\n1747#2,3:42\n*S KotlinDebug\n*F\n+ 1 IssueLabelsFilterService.kt\ncom/atlassian/jira/migration/datafilters/service/issuefilters/systemattributes/IssueLabelsFilterService\n*L\n18#1:35\n18#1:36,3\n22#1:39,3\n23#1:42,3\n*E\n"})
public final class IssueLabelsFilterService
extends IssueAttributeFilterService<SystemAttributeFilter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(IssueLabelsFilterService.class);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(@NotNull SystemAttributeFilter filter, @NotNull Issue entity) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        try {
            void $this$mapTo$iv$iv;
            Set set = entity.getLabels();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getLabels(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                Label label = (Label)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getLabel(), (String)"getLabel(...)");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
            List entityValues = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            List<String> lowerCaseFilterValues = DataFiltersUtil.INSTANCE.toLowerCaseList(filter.getValue());
            Operator operator = DataFiltersUtil.INSTANCE.parseOperator(filter.getOperator());
            switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
                case 1: {
                    Object element$iv;
                    String it;
                    Iterable $this$any$iv = entityValues;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator2 = $this$any$iv.iterator();
                    do {
                        if (!iterator2.hasNext()) return false;
                        element$iv = iterator2.next();
                        it = (String)element$iv;
                        boolean bl = false;
                    } while (!lowerCaseFilterValues.contains(it));
                    return true;
                }
                case 2: {
                    String it;
                    Object element$iv;
                    Iterable $this$any$iv = entityValues;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return true;
                    }
                    Iterator iterator2 = $this$any$iv.iterator();
                    do {
                        if (!iterator2.hasNext()) return true;
                        element$iv = iterator2.next();
                        it = (String)element$iv;
                        boolean bl = false;
                    } while (!lowerCaseFilterValues.contains(it));
                    return false;
                }
                default: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to apply labels filter for issue. Exception:", (Throwable)e);
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/issuefilters/systemattributes/IssueLabelsFilterService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operator.values().length];
            try {
                nArray[Operator.EQUALS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NOT_EQUALS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

