/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.datafilters.service.issuefilters.systemattributes;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.migration.datafilters.model.Operator;
import com.atlassian.jira.migration.datafilters.model.SystemAttributeFilter;
import com.atlassian.jira.migration.datafilters.service.issuefilters.IssueAttributeFilterService;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import java.util.List;
import java.util.Locale;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/issuefilters/systemattributes/IssueStatusFilterService;", "Lcom/atlassian/jira/migration/datafilters/service/issuefilters/IssueAttributeFilterService;", "Lcom/atlassian/jira/migration/datafilters/model/SystemAttributeFilter;", "()V", "validate", "", "filter", "entity", "Lcom/atlassian/jira/issue/Issue;", "Companion", "jira-migration-plugin"})
public final class IssueStatusFilterService
extends IssueAttributeFilterService<SystemAttributeFilter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(IssueStatusFilterService.class);

    @Override
    public boolean validate(@NotNull SystemAttributeFilter filter, @NotNull Issue entity) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        try {
            boolean bl;
            String string = entity.getStatus().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String entityValue = string3;
            List<String> lowerCaseFilterValues = DataFiltersUtil.INSTANCE.toLowerCaseList(filter.getValue());
            Operator operator = DataFiltersUtil.INSTANCE.parseOperator(filter.getOperator());
            switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
                case 1: {
                    bl = lowerCaseFilterValues.contains(entityValue);
                    break;
                }
                case 2: {
                    if (!lowerCaseFilterValues.contains(entityValue)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }
        catch (Exception e) {
            logger.warn("Failed to apply status filter for issue. Exception:", (Throwable)e);
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/issuefilters/systemattributes/IssueStatusFilterService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operator.values().length];
            try {
                nArray[Operator.EQUALS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operator.NOT_EQUALS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

