/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.datafilters.utils;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.datafilters.model.Operator;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013J\u0010\u0010\u0019\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013J\u0016\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/datafilters/utils/DataFiltersUtil;", "", "()V", "BYTES_IN_MB", "", "hasArchived", "Lkotlin/Function1;", "Lcom/atlassian/jira/issue/Issue;", "", "getHasArchived", "()Lkotlin/jvm/functions/Function1;", "hasArchived$delegate", "Lkotlin/Lazy;", "areFiltersNotEmpty", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "convertMbToBytes", "Ljava/math/BigDecimal;", "value", "", "isDateInRange", "date", "Ljava/time/LocalDate;", "startDateStr", "endDateStr", "isValidBooleanString", "parseOperator", "Lcom/atlassian/jira/migration/datafilters/model/Operator;", "operatorSymbol", "shouldApplyDataFilters", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "shouldSkipReferencedIssueExport", "toLowerCaseList", "", "values", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDataFiltersUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFiltersUtil.kt\ncom/atlassian/jira/migration/datafilters/utils/DataFiltersUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1549#2:69\n1620#2,3:70\n*S KotlinDebug\n*F\n+ 1 DataFiltersUtil.kt\ncom/atlassian/jira/migration/datafilters/utils/DataFiltersUtil\n*L\n34#1:69\n34#1:70,3\n*E\n"})
public final class DataFiltersUtil {
    @NotNull
    public static final DataFiltersUtil INSTANCE = new DataFiltersUtil();
    private static final int BYTES_IN_MB = 0x100000;
    @NotNull
    private static final Lazy hasArchived$delegate = LazyKt.lazy((Function0)hasArchived.2.INSTANCE);

    private DataFiltersUtil() {
    }

    @NotNull
    public final Function1<Issue, Boolean> getHasArchived() {
        Lazy lazy = hasArchived$delegate;
        return (Function1)lazy.getValue();
    }

    @NotNull
    public final Operator parseOperator(@NotNull String operatorSymbol) {
        Intrinsics.checkNotNullParameter((Object)operatorSymbol, (String)"operatorSymbol");
        return Operator.Companion.fromSymbol(operatorSymbol);
    }

    public final boolean isDateInRange(@NotNull LocalDate date, @NotNull String startDateStr, @NotNull String endDateStr) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)startDateStr, (String)"startDateStr");
        Intrinsics.checkNotNullParameter((Object)endDateStr, (String)"endDateStr");
        LocalDate startDate = LocalDate.parse(startDateStr);
        LocalDate endDate = LocalDate.parse(endDateStr);
        return 0 <= date.compareTo((Object)startDate) ? date.compareTo((Object)endDate) <= 0 : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> toLowerCaseList(@NotNull List<String> values) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable $this$map$iv = values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = var11_11.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final BigDecimal convertMbToBytes(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BigDecimal result2 = new BigDecimal(value).multiply(new BigDecimal(0x100000));
        if (result2.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
            throw new IllegalArgumentException("Resulting byte size exceeds maximum allowed value");
        }
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    public final boolean isValidBooleanString(@Nullable String value) {
        String string;
        Object[] objectArray = new String[]{"true", "false"};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        String string2 = value;
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return CollectionsKt.contains((Iterable)iterable, (Object)string);
    }

    public final boolean shouldApplyDataFilters(@NotNull MigrationFeatures migrationFeatures, @NotNull DataFilterContext dataFilterContext) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        return migrationFeatures.getEnableDataFilters() && this.areFiltersNotEmpty(dataFilterContext);
    }

    public final boolean shouldSkipReferencedIssueExport(@NotNull MigrationFeatures migrationFeatures, @NotNull DataFilterContext dataFilterContext) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        return migrationFeatures.getEnableDataFilters() && this.areFiltersNotEmpty(dataFilterContext) && migrationFeatures.getEnableSkipReferencedIssueExport();
    }

    private final boolean areFiltersNotEmpty(DataFilterContext dataFilterContext) {
        return !((Collection)dataFilterContext.getSystemAttributeFilters()).isEmpty() || !((Collection)dataFilterContext.getCustomAttributeFilters()).isEmpty();
    }
}

