/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.db.servicedesk.calendar;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.calendar.Calendar;
import com.atlassian.jira.migration.db.servicedesk.calendar.Holiday;
import com.atlassian.jira.migration.db.servicedesk.calendar.Tables;
import com.atlassian.jira.migration.db.servicedesk.calendar.WorkingTime;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.migration.jira.servicedesk.Calendar;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\nJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0010\u001a\u00020\nJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllCalendars", "", "Lcom/atlassian/jira/migration/db/servicedesk/calendar/Calendar;", "getCalendarById", "calenderId", "", "getHolidaysForCalendar", "Lcom/atlassian/jira/migration/db/servicedesk/calendar/Holiday;", "calendar", "getServiceDeskIdFromContext", "contextString", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getWorkingTimesForCalendar", "Lcom/atlassian/jira/migration/db/servicedesk/calendar/WorkingTime;", "stringToWeekday", "Lcom/atlassian/migration/jira/servicedesk/Calendar$Weekday;", "weekdayString", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCalendarReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarReader.kt\ncom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1603#2,9:154\n1855#2:163\n1856#2:165\n1612#2:166\n766#2:167\n857#2,2:168\n1549#2:170\n1620#2,3:171\n766#2:174\n857#2,2:175\n1603#2,9:177\n1855#2:186\n1856#2:188\n1612#2:189\n1#3:164\n1#3:187\n*S KotlinDebug\n*F\n+ 1 CalendarReader.kt\ncom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader\n*L\n56#1:154,9\n56#1:163\n56#1:165\n56#1:166\n85#1:167\n85#1:168,2\n87#1:170\n87#1:171,3\n115#1:174\n115#1:175,2\n117#1:177,9\n117#1:186\n117#1:188\n117#1:189\n56#1:164\n117#1:187\n*E\n"})
public final class CalendarReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;
    @NotNull
    public static final String CONTEXT_SERVICEDESK_ID_KEY = "serviceDeskId";
    @NotNull
    private static final Map<String, Calendar.Weekday> WEEKDAY_MAP;

    @Inject
    public CalendarReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(CalendarReader.class);
    }

    @Nullable
    public final Calendar getCalendarById(int calenderId) {
        Calendar calendar;
        this.log.debug("Executing db query for fetching calendar with id{}", (Object)calenderId);
        Tuple tuple = (Tuple)this.databaseAccessor.run(arg_0 -> CalendarReader.getCalendarById$lambda$0(calenderId, arg_0), CalendarReader::getCalendarById$lambda$1);
        if (tuple != null) {
            Tuple calendar2 = tuple;
            boolean bl = false;
            Integer n = this.getServiceDeskIdFromContext(String.valueOf(calendar2.get((Expression)Tables.INSTANCE.getCALENDAR().getCONTEXT())));
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Object object = calendar2.get((Expression)Tables.INSTANCE.getCALENDAR().getID());
                Intrinsics.checkNotNull((Object)object);
                calendar = new Calendar(((Number)object).intValue(), String.valueOf(calendar2.get((Expression)Tables.INSTANCE.getCALENDAR().getNAME())), String.valueOf(calendar2.get((Expression)Tables.INSTANCE.getCALENDAR().getTIMEZONE())), String.valueOf(calendar2.get((Expression)Tables.INSTANCE.getCALENDAR().getCONTEXT())), it);
            } else {
                calendar = null;
            }
        } else {
            calendar = null;
        }
        return calendar;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Calendar> getAllCalendars() {
        void $this$mapNotNullTo$iv$iv;
        this.log.debug("Executing db query for fetching all calendars");
        List calendars = (List)this.databaseAccessor.run(CalendarReader::getAllCalendars$lambda$4, CalendarReader::getAllCalendars$lambda$5);
        Intrinsics.checkNotNull((Object)calendars);
        Iterable $this$mapNotNull$iv = calendars;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Calendar calendar;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple it = (Tuple)element$iv$iv;
            boolean bl2 = false;
            Integer n = this.getServiceDeskIdFromContext(String.valueOf(it.get((Expression)Tables.INSTANCE.getCALENDAR().getCONTEXT())));
            if (n != null) {
                int serviceDeskId = ((Number)n).intValue();
                boolean bl3 = false;
                Object object = it.get((Expression)Tables.INSTANCE.getCALENDAR().getID());
                Intrinsics.checkNotNull((Object)object);
                calendar = new Calendar(((Number)object).intValue(), String.valueOf(it.get((Expression)Tables.INSTANCE.getCALENDAR().getNAME())), String.valueOf(it.get((Expression)Tables.INSTANCE.getCALENDAR().getTIMEZONE())), String.valueOf(it.get((Expression)Tables.INSTANCE.getCALENDAR().getCONTEXT())), serviceDeskId);
            } else {
                calendar = null;
            }
            if (calendar == null) continue;
            Calendar it$iv$iv = calendar;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Holiday> getHolidaysForCalendar(@NotNull Calendar calendar) {
        void $this$mapTo$iv$iv;
        Tuple it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        this.log.debug("Executing db query for fetching holidays for calendar with id{}", (Object)calendar.getId());
        Object object = this.databaseAccessor.run(arg_0 -> CalendarReader.getHolidaysForCalendar$lambda$8(calendar, arg_0), CalendarReader::getHolidaysForCalendar$lambda$9);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tuple)element$iv$iv;
            boolean bl = false;
            if (!(it.get((Expression)Tables.INSTANCE.getHOLIDAY().getCALENDAR_ID()) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List holidays = (List)destination$iv$iv;
        Iterable $this$map$iv = holidays;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = it.get((Expression)Tables.INSTANCE.getHOLIDAY().getID());
            Intrinsics.checkNotNull((Object)object2);
            int n = ((Number)object2).intValue();
            Object object3 = it.get((Expression)Tables.INSTANCE.getHOLIDAY().getCALENDAR_ID());
            Intrinsics.checkNotNull((Object)object3);
            int n2 = ((Number)object3).intValue();
            String string = String.valueOf(it.get((Expression)Tables.INSTANCE.getHOLIDAY().getNAME()));
            LocalDate localDate = LocalDate.parse((String)String.valueOf(it.get((Expression)Tables.INSTANCE.getHOLIDAY().getDATE_STRING())));
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
            Boolean bl2 = (Boolean)it.get((Expression)Tables.INSTANCE.getHOLIDAY().getRECURRING());
            if (bl2 == null) {
                bl2 = false;
            }
            Boolean bl3 = bl2;
            Intrinsics.checkNotNull((Object)bl3);
            collection.add(new Holiday(n, n2, string, localDate, bl3));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WorkingTime> getWorkingTimesForCalendar(@NotNull Calendar calendar) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        this.log.debug("Executing db query for fetching workingTimes associated with calendar {}", (Object)calendar.getId());
        Object object = this.databaseAccessor.run(arg_0 -> CalendarReader.getWorkingTimesForCalendar$lambda$12(calendar, arg_0), CalendarReader::getWorkingTimesForCalendar$lambda$13);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tuple it = (Tuple)element$iv$iv;
            boolean bl = false;
            if (!(it.get((Expression)Tables.INSTANCE.getWORKING_TIME().getCALENDAR_ID()) != null && it.get((Expression)Tables.INSTANCE.getWORKING_TIME().getDISABLED()) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List workingTimes = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = workingTimes;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WorkingTime workingTime;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple it = (Tuple)element$iv$iv;
            boolean bl2 = false;
            if (this.stringToWeekday(String.valueOf(it.get((Expression)Tables.INSTANCE.getWORKING_TIME().getDAY()))) != null) {
                Calendar.Weekday weekday;
                boolean bl3 = false;
                Object object2 = it.get((Expression)Tables.INSTANCE.getWORKING_TIME().getID());
                Intrinsics.checkNotNull((Object)object2);
                int n = ((Number)object2).intValue();
                Object object3 = it.get((Expression)Tables.INSTANCE.getWORKING_TIME().getCALENDAR_ID());
                Intrinsics.checkNotNull((Object)object3);
                int n2 = ((Number)object3).intValue();
                Object object4 = it.get((Expression)Tables.INSTANCE.getWORKING_TIME().getSTART_TIME());
                Intrinsics.checkNotNull((Object)object4);
                long l = ((Number)object4).longValue();
                Object object5 = it.get((Expression)Tables.INSTANCE.getWORKING_TIME().getEND_TIME());
                Intrinsics.checkNotNull((Object)object5);
                workingTime = new WorkingTime(n, n2, weekday, l, ((Number)object5).longValue());
            } else {
                workingTime = null;
            }
            if (workingTime == null) continue;
            WorkingTime it$iv$iv = workingTime;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Calendar.Weekday stringToWeekday(String weekdayString) {
        String string = weekdayString;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return WEEKDAY_MAP.get(string2);
    }

    private final Integer getServiceDeskIdFromContext(String contextString) {
        JSONObject contextJson = new JSONObject(contextString);
        return contextJson.has(CONTEXT_SERVICEDESK_ID_KEY) ? Integer.valueOf(contextJson.getInt(CONTEXT_SERVICEDESK_ID_KEY)) : null;
    }

    private static final Tuple getCalendarById$lambda$0(int $calenderId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getCALENDAR().getID(), Tables.INSTANCE.getCALENDAR().getNAME(), Tables.INSTANCE.getCALENDAR().getTIMEZONE(), Tables.INSTANCE.getCALENDAR().getCONTEXT()};
        return (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getCALENDAR())).where((Predicate)Tables.INSTANCE.getCALENDAR().getID().eq((Object)$calenderId))).fetchOne();
    }

    private static final void getCalendarById$lambda$1() {
    }

    private static final List getAllCalendars$lambda$4(DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getCALENDAR().getID(), Tables.INSTANCE.getCALENDAR().getNAME(), Tables.INSTANCE.getCALENDAR().getTIMEZONE(), Tables.INSTANCE.getCALENDAR().getCONTEXT()};
        return ((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getCALENDAR())).fetch();
    }

    private static final void getAllCalendars$lambda$5() {
    }

    private static final List getHolidaysForCalendar$lambda$8(Calendar $calendar, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$calendar, (String)"$calendar");
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getHOLIDAY().getID(), Tables.INSTANCE.getHOLIDAY().getCALENDAR_ID(), Tables.INSTANCE.getHOLIDAY().getNAME(), Tables.INSTANCE.getHOLIDAY().getDATE_STRING(), Tables.INSTANCE.getHOLIDAY().getRECURRING()};
        return ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getHOLIDAY())).where((Predicate)Tables.INSTANCE.getHOLIDAY().getCALENDAR_ID().eq((Object)$calendar.getId()))).fetch();
    }

    private static final void getHolidaysForCalendar$lambda$9() {
    }

    private static final List getWorkingTimesForCalendar$lambda$12(Calendar $calendar, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$calendar, (String)"$calendar");
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getWORKING_TIME().getID(), Tables.INSTANCE.getWORKING_TIME().getCALENDAR_ID(), Tables.INSTANCE.getWORKING_TIME().getDISABLED(), Tables.INSTANCE.getWORKING_TIME().getDAY(), Tables.INSTANCE.getWORKING_TIME().getSTART_TIME(), Tables.INSTANCE.getWORKING_TIME().getEND_TIME()};
        return ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getWORKING_TIME())).where((Predicate)Tables.INSTANCE.getWORKING_TIME().getCALENDAR_ID().eq((Object)$calendar.getId()).and((Predicate)Tables.INSTANCE.getWORKING_TIME().getDISABLED().isFalse()))).fetch();
    }

    private static final void getWorkingTimesForCalendar$lambda$13() {
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"MONDAY", (Object)Calendar.Weekday.monday), TuplesKt.to((Object)"TUESDAY", (Object)Calendar.Weekday.tuesday), TuplesKt.to((Object)"WEDNESDAY", (Object)Calendar.Weekday.wednesday), TuplesKt.to((Object)"THURSDAY", (Object)Calendar.Weekday.thursday), TuplesKt.to((Object)"FRIDAY", (Object)Calendar.Weekday.friday), TuplesKt.to((Object)"SATURDAY", (Object)Calendar.Weekday.saturday), TuplesKt.to((Object)"SUNDAY", (Object)Calendar.Weekday.sunday)};
        WEEKDAY_MAP = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader$Companion;", "", "()V", "CONTEXT_SERVICEDESK_ID_KEY", "", "WEEKDAY_MAP", "", "Lcom/atlassian/migration/jira/servicedesk/Calendar$Weekday;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

