/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.db.servicedesk.comment;

import com.atlassian.jira.migration.db.JiraActionTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.db.servicedesk.comment.EntityPropertyTable;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.DialectProvider;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000b\u001a\u00020\nJ\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/db/servicedesk/comment/CommentReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getCommentIds", "Lcom/querydsl/sql/SQLQuery;", "", "projectId", "getInternalServiceDeskComments", "", "containsCaseInsensitive", "Lcom/querydsl/core/types/dsl/BooleanExpression;", "Lcom/querydsl/core/types/dsl/StringExpression;", "value", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCommentReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentReader.kt\ncom/atlassian/jira/migration/db/servicedesk/comment/CommentReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n766#2:100\n857#2,2:101\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 CommentReader.kt\ncom/atlassian/jira/migration/db/servicedesk/comment/CommentReader\n*L\n48#1:100\n48#1:101,2\n53#1:103\n53#1:104,3\n*E\n"})
public final class CommentReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;
    @NotNull
    private static final String SERVICE_DESK_COMMENT_PROPERTY = "sd.comment.property";
    @NotNull
    private static final String SERVICE_DESK_PUBLIC_COMMENT = "sd.public.comment";
    @NotNull
    private static final String INTERNAL_COMMENT = "internal";

    @Inject
    public CommentReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(CommentReader.class);
    }

    @NotNull
    public final List<Long> getInternalServiceDeskComments(long projectId) {
        this.log.debug("Executing db query for fetching internal serviceDesk comments associated with project {}", (Object)projectId);
        Object object = this.databaseAccessor.run(arg_0 -> CommentReader.getInternalServiceDeskComments$lambda$3(this, projectId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @NotNull
    public final BooleanExpression containsCaseInsensitive(@NotNull StringExpression $this$containsCaseInsensitive, @NotNull String value, @NotNull DatabaseConnection db) {
        BooleanExpression booleanExpression;
        Intrinsics.checkNotNullParameter((Object)$this$containsCaseInsensitive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        if (db.getDialectConfig().getDatabaseInfo().getSupportedDatabase() == DialectProvider.SupportedDatabase.SQLSERVER) {
            BooleanExpression booleanExpression2 = $this$containsCaseInsensitive.contains(value);
            Intrinsics.checkNotNull((Object)booleanExpression2);
            booleanExpression = booleanExpression2;
        } else {
            BooleanExpression booleanExpression3 = $this$containsCaseInsensitive.containsIgnoreCase(value);
            Intrinsics.checkNotNull((Object)booleanExpression3);
            booleanExpression = booleanExpression3;
        }
        return booleanExpression;
    }

    private final SQLQuery<Long> getCommentIds(long projectId) {
        QueryBase queryBase = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression)((Expression)JiraActionTable.INSTANCE.getID())).distinct()).from((Expression)JiraActionTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)JiraActionTable.INSTANCE.getISSUE_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)JiraActionTable.INSTANCE.getACTION_TYPE().eq((Object)"comment").and((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)projectId)));
        Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
        return (SQLQuery)queryBase;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getInternalServiceDeskComments$lambda$3(CommentReader this$0, long $projectId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Tuple it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), EntityPropertyTable.INSTANCE.getJSON_VALUE()};
        SQLQuery sQLQuery = (SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE);
        expressionArray = new Predicate[5];
        expressionArray[0] = EntityPropertyTable.INSTANCE.getENTITY_NAME().eq((Object)SERVICE_DESK_COMMENT_PROPERTY);
        expressionArray[1] = EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)SERVICE_DESK_PUBLIC_COMMENT);
        expressionArray[2] = EntityPropertyTable.INSTANCE.getENTITY_ID().in((SubQueryExpression)this$0.getCommentIds($projectId));
        StringExpression stringExpression = (StringExpression)EntityPropertyTable.INSTANCE.getJSON_VALUE();
        Intrinsics.checkNotNull((Object)db);
        expressionArray[3] = this$0.containsCaseInsensitive(stringExpression, INTERNAL_COMMENT, db);
        expressionArray[4] = this$0.containsCaseInsensitive((StringExpression)EntityPropertyTable.INSTANCE.getJSON_VALUE(), "true", db);
        Iterable iterable = ((SQLQuery)sQLQuery.where((Predicate[])expressionArray)).fetchResults().getResults();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getResults(...)");
        iterable = iterable;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object object;
            it = (Tuple)element$iv$iv;
            boolean bl = false;
            Object object2 = this$0;
            try {
                CommentReader $this$getInternalServiceDeskComments_u24lambda_u243_u24lambda_u241_u24lambda_u240 = object2;
                boolean bl2 = false;
                object = Result.constructor-impl((Object)new JSONObject((String)it.get((Expression)EntityPropertyTable.INSTANCE.getJSON_VALUE())).getBoolean(INTERNAL_COMMENT));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = false;
            Object object3 = Result.isFailure-impl((Object)object2) ? object : object2;
            if (!((Boolean)object3).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tuple;
            it = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Long)tuple.get((Expression)EntityPropertyTable.INSTANCE.getENTITY_ID()));
        }
        return CollectionsKt.sorted((Iterable)CollectionsKt.requireNoNulls((List)((List)destination$iv$iv)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/db/servicedesk/comment/CommentReader$Companion;", "", "()V", "INTERNAL_COMMENT", "", "SERVICE_DESK_COMMENT_PROPERTY", "SERVICE_DESK_PUBLIC_COMMENT", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

