/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.db.servicedesk.requesttype;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.IssueTypeTable;
import com.atlassian.jira.migration.db.servicedesk.requesttype.GroupToRequestTypeTable;
import com.atlassian.jira.migration.db.servicedesk.requesttype.JiraGroupAndOrder;
import com.atlassian.jira.migration.db.servicedesk.requesttype.JiraRequestTypeGroup;
import com.atlassian.jira.migration.db.servicedesk.requesttype.PortalTable;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestType;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeGroupMapper;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeGroupTable;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002JJ\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00060\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00060\r2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u000eJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J4\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062$\u0010\u001d\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u00060\rH\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u001e\u0010!\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0016\u0010\"\u001a\u00020#2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getCorrectIssueTypes", "", "", "getJiraGroupAndOrderWithOverriddenOrder", "Lkotlin/Pair;", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/JiraRequestTypeGroup;", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/JiraGroupAndOrder;", "mappedGroupToRequests", "", "", "groupToOrder", "requestType", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestType;", "getMappedGroupToRequests", "projectId", "getRequestTypeWithoutGroupsByIdOrNull", "requestTypeId", "getRequestTypesForServiceDeskProject", "Lkotlin/sequences/Sequence;", "serviceDesk", "Lcom/atlassian/servicedesk/api/ServiceDesk;", "getValidRequestTypes", "", "mapToRequestTypeList", "transform", "populateExtractedRequestTypeOrderIfNeeded", "", "requestTypes", "populateRequestTypeOrderBasedOnEntriesInGroupToRequestTable", "shouldOverrideOrderValuesIfOrderAbsent", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRequestTypeReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestTypeReader.kt\ncom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1747#2,2:243\n1549#2:245\n1620#2,3:246\n1747#2,3:249\n1749#2:252\n1855#2:253\n1549#2:254\n1620#2,3:255\n1856#2:258\n1549#2:259\n1620#2,3:260\n*S KotlinDebug\n*F\n+ 1 RequestTypeReader.kt\ncom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeReader\n*L\n129#1:243,2\n133#1:245\n133#1:246,3\n135#1:249,3\n129#1:252\n144#1:253\n145#1:254\n145#1:255,3\n144#1:258\n197#1:259\n197#1:260,3\n*E\n"})
public final class RequestTypeReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public RequestTypeReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final Sequence<RequestType> getRequestTypesForServiceDeskProject(@NotNull ServiceDesk serviceDesk) {
        Intrinsics.checkNotNullParameter((Object)serviceDesk, (String)"serviceDesk");
        return CollectionsKt.asSequence((Iterable)this.getValidRequestTypes(serviceDesk.getProjectId()));
    }

    @Nullable
    public final RequestType getRequestTypeWithoutGroupsByIdOrNull(int requestTypeId2) {
        return (RequestType)this.databaseAccessor.run(arg_0 -> RequestTypeReader.getRequestTypeWithoutGroupsByIdOrNull$lambda$1(requestTypeId2, arg_0), OnRollback.NOOP);
    }

    private final List<Long> getCorrectIssueTypes() {
        Object object = this.databaseAccessor.run(RequestTypeReader::getCorrectIssueTypes$lambda$2, OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    private final Collection<RequestType> getValidRequestTypes(long projectId) {
        Collection collection;
        Object object = this.databaseAccessor.run(arg_0 -> RequestTypeReader.getValidRequestTypes$lambda$3(projectId, this, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        Map requestTypeToGroupsAndOrdersMap = (Map)object;
        List<RequestType> requestTypes = this.mapToRequestTypeList(requestTypeToGroupsAndOrdersMap);
        this.populateExtractedRequestTypeOrderIfNeeded(requestTypes, projectId);
        Collection collection2 = requestTypes;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return collection;
    }

    private final void populateExtractedRequestTypeOrderIfNeeded(List<RequestType> requestTypes, long projectId) {
        if (this.shouldOverrideOrderValuesIfOrderAbsent(requestTypes)) {
            this.populateRequestTypeOrderBasedOnEntriesInGroupToRequestTable(requestTypes, projectId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldOverrideOrderValuesIfOrderAbsent(List<RequestType> requestTypes) {
        boolean bl;
        block10: {
            Iterable $this$any$iv = requestTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block9: {
                        RequestType it = (RequestType)element$iv;
                        boolean bl3 = false;
                        if (it.getGroupsToOrders().isEmpty()) {
                            bl2 = false;
                        } else {
                            void $this$any$iv2;
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = it.getGroupsToOrders();
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void item;
                                Pair pair = (Pair)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl4 = false;
                                collection.add((JiraGroupAndOrder)item.getSecond());
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    JiraGroupAndOrder group = (JiraGroupAndOrder)element$iv2;
                                    boolean bl5 = false;
                                    if (!(group.getOrder() == null)) continue;
                                    bl2 = true;
                                    break block9;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void populateRequestTypeOrderBasedOnEntriesInGroupToRequestTable(List<RequestType> requestTypes, long projectId) {
        Map<Integer, List<Integer>> mappedGroupToRequests = this.getMappedGroupToRequests(projectId);
        Iterable $this$forEach$iv = requestTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            RequestType requestType = (RequestType)element$iv;
            boolean bl = false;
            Iterable $this$map$iv = requestType.getGroupsToOrders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void groupToOrder;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((JiraGroupAndOrder)groupToOrder.getSecond()).getOrder() == null ? this.getJiraGroupAndOrderWithOverriddenOrder(mappedGroupToRequests, (Pair<JiraRequestTypeGroup, JiraGroupAndOrder>)groupToOrder, requestType) : groupToOrder);
            }
            List refreshedGroupToOrders = (List)destination$iv$iv;
            requestType.setGroupsToOrders(CollectionsKt.toMutableList((Collection)refreshedGroupToOrders));
        }
    }

    private final Pair<JiraRequestTypeGroup, JiraGroupAndOrder> getJiraGroupAndOrderWithOverriddenOrder(Map<Integer, ? extends List<Integer>> mappedGroupToRequests, Pair<JiraRequestTypeGroup, JiraGroupAndOrder> groupToOrder, RequestType requestType) {
        int groupId = ((JiraGroupAndOrder)groupToOrder.getSecond()).getGroupId();
        List<Integer> list = mappedGroupToRequests.get(groupId);
        return new Pair(groupToOrder.getFirst(), (Object)new JiraGroupAndOrder(groupId, list != null ? Integer.valueOf(list.indexOf(requestType.getId())) : null));
    }

    private final Map<Integer, List<Integer>> getMappedGroupToRequests(long projectId) {
        Object object = this.databaseAccessor.run(arg_0 -> RequestTypeReader.getMappedGroupToRequests$lambda$10(projectId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Map)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RequestType> mapToRequestTypeList(Map<RequestType, ? extends List<Pair<JiraRequestTypeGroup, JiraGroupAndOrder>>> transform) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = transform.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RequestType requestType = (RequestType)it.getKey();
            requestType.setGroupsToOrders(new ArrayList((Collection)it.getValue()));
            collection.add(requestType);
        }
        return (List)destination$iv$iv;
    }

    private static final RequestType getRequestTypeWithoutGroupsByIdOrNull$lambda$1(int $requestTypeId, DatabaseConnection db) {
        RequestType requestType;
        Path[] pathArray = RequestTypeTable.INSTANCE.all();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)RequestTypeTable.INSTANCE)).where((Predicate)RequestTypeTable.INSTANCE.getID().eq((Object)$requestTypeId))).fetchOne();
        if (tuple != null) {
            String string;
            Tuple tuple2 = tuple;
            boolean bl = false;
            Object object = tuple2.get((Expression)RequestTypeTable.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Object object2 = tuple2.get((Expression)RequestTypeTable.INSTANCE.getVIEWPORT_ID());
            Intrinsics.checkNotNull((Object)object2);
            int n2 = ((Number)object2).intValue();
            Object object3 = tuple2.get((Expression)RequestTypeTable.INSTANCE.getISSUE_TYPE_ID());
            Intrinsics.checkNotNull((Object)object3);
            long l = ((Number)object3).longValue();
            Object object4 = tuple2.get((Expression)RequestTypeTable.INSTANCE.getICON_ID());
            Intrinsics.checkNotNull((Object)object4);
            long l2 = ((Number)object4).longValue();
            Object object5 = tuple2.get((Expression)RequestTypeTable.INSTANCE.getNAME());
            Intrinsics.checkNotNull((Object)object5);
            String string2 = (String)object5;
            String string3 = (String)tuple2.get((Expression)RequestTypeTable.INSTANCE.getINTRO());
            if (string3 == null) {
                string3 = "";
            }
            if ((string = (String)tuple2.get((Expression)RequestTypeTable.INSTANCE.getDESCRIPTION())) == null) {
                string = "";
            }
            Object object6 = tuple2.get((Expression)RequestTypeTable.INSTANCE.getKEY());
            Intrinsics.checkNotNull((Object)object6);
            String string4 = (String)object6;
            List<Pair<JiraRequestTypeGroup, JiraGroupAndOrder>> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            requestType = new RequestType(n, n2, l, l2, string2, string3, string, string4, list);
        } else {
            requestType = null;
        }
        return requestType;
    }

    private static final List getCorrectIssueTypes$lambda$2(DatabaseConnection db) {
        return ((SQLQuery)db.select((Expression)IssueTypeTable.INSTANCE.getID()).from((Expression)IssueTypeTable.INSTANCE)).fetch();
    }

    private static final Map getValidRequestTypes$lambda$3(long $projectId, RequestTypeReader this$0, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Expression[] expressionArray = new Expression[]{RequestTypeTable.INSTANCE.getID(), RequestTypeTable.INSTANCE.getVIEWPORT_ID(), RequestTypeTable.INSTANCE.getICON_ID(), RequestTypeTable.INSTANCE.getISSUE_TYPE_ID(), RequestTypeTable.INSTANCE.getNAME(), RequestTypeTable.INSTANCE.getINTRO(), RequestTypeTable.INSTANCE.getDESCRIPTION(), RequestTypeTable.INSTANCE.getKEY()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)RequestTypeTable.INSTANCE)).innerJoin((EntityPath)PortalTable.INSTANCE)).on((Predicate)PortalTable.INSTANCE.getID().eq((Expression)RequestTypeTable.INSTANCE.getVIEWPORT_ID()))).leftJoin((EntityPath)GroupToRequestTypeTable.INSTANCE)).on((Predicate)RequestTypeTable.INSTANCE.getID().eq((Expression)GroupToRequestTypeTable.INSTANCE.getREQUEST_TYPE_ID()))).leftJoin((EntityPath)RequestTypeGroupTable.INSTANCE)).on((Predicate)RequestTypeGroupTable.INSTANCE.getID().eq((Expression)GroupToRequestTypeTable.INSTANCE.getGROUP_ID()).and((Predicate)RequestTypeGroupTable.INSTANCE.getDELETED_TIME().isNull()))).where((Predicate)PortalTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId).and((Predicate)RequestTypeTable.INSTANCE.getISSUE_TYPE_ID().in((Collection)this$0.getCorrectIssueTypes())));
        expressionArray = new Expression[]{RequestTypeTable.INSTANCE.getID(), RequestTypeTable.INSTANCE.getVIEWPORT_ID(), RequestTypeTable.INSTANCE.getISSUE_TYPE_ID(), RequestTypeTable.INSTANCE.getICON_ID(), RequestTypeTable.INSTANCE.getNAME(), RequestTypeTable.INSTANCE.getINTRO(), RequestTypeTable.INSTANCE.getDESCRIPTION(), RequestTypeTable.INSTANCE.getKEY()};
        return (Map)sQLQuery.transform(GroupBy.groupBy((Expression)((Expression)Projections.constructor(RequestType.class, (Expression[])expressionArray))).as((Expression)GroupBy.list((Expression)((Expression)new RequestTypeGroupMapper()))));
    }

    private static final Map getMappedGroupToRequests$lambda$10(long $projectId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{GroupToRequestTypeTable.INSTANCE.getREQUEST_TYPE_ID(), GroupToRequestTypeTable.INSTANCE.getGROUP_ID()};
        return (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)PortalTable.INSTANCE)).innerJoin((EntityPath)RequestTypeGroupTable.INSTANCE)).on((Predicate)PortalTable.INSTANCE.getID().eq((Expression)RequestTypeGroupTable.INSTANCE.getVIEWPORT_ID()))).innerJoin((EntityPath)GroupToRequestTypeTable.INSTANCE)).on((Predicate)RequestTypeGroupTable.INSTANCE.getID().eq((Expression)GroupToRequestTypeTable.INSTANCE.getGROUP_ID()))).where((Predicate)PortalTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId))).transform(GroupBy.groupBy((Expression)((Expression)GroupToRequestTypeTable.INSTANCE.getGROUP_ID())).as((Expression)GroupBy.list((Expression)((Expression)GroupToRequestTypeTable.INSTANCE.getREQUEST_TYPE_ID()))));
    }
}

