/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.discovery;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.legal.LegalService;
import com.atlassian.jira.migration.migration.DryRunMigration;
import com.atlassian.jira.migration.migration.DryRunMigrationRepository;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\u0019J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u0012J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u001c\u001a\u00020\u0019J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "dryRunMigrationRepository", "Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "legalService", "Lcom/atlassian/jira/migration/legal/LegalService;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/legal/LegalService;Lcom/atlassian/beehive/ClusterLockService;)V", "findByMigrationId", "Lcom/atlassian/jira/migration/migration/Migration;", "migrationId", "", "findLatestByPlanId", "planId", "getLockForName", "Lcom/atlassian/beehive/ClusterLock;", "name", "isUserAgreedCollectErrors", "", "retrieveCloudSiteFor", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "includeDryRuns", "retrieveCloudSiteForCloudId", "cloudId", "retrievePlanFor", "Lcom/atlassian/jira/migration/plan/Plan;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDiscoveryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscoveryService.kt\ncom/atlassian/jira/migration/discovery/DiscoveryService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class DiscoveryService {
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final DryRunMigrationRepository dryRunMigrationRepository;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final LegalService legalService;
    @NotNull
    private final ClusterLockService clusterLockService;

    @Inject
    public DiscoveryService(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationRepository migrationRepository, @NotNull DryRunMigrationRepository dryRunMigrationRepository, @NotNull PlanRepository planRepository, @NotNull LegalService legalService, @NotNull ClusterLockService clusterLockService) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)dryRunMigrationRepository, (String)"dryRunMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)legalService, (String)"legalService");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationRepository = migrationRepository;
        this.dryRunMigrationRepository = dryRunMigrationRepository;
        this.planRepository = planRepository;
        this.legalService = legalService;
        this.clusterLockService = clusterLockService;
    }

    @Nullable
    public final CloudSite retrieveCloudSiteForCloudId(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        return this.cloudSiteRepository.getSite(cloudId2);
    }

    @Nullable
    public final CloudSite retrieveCloudSiteFor(@NotNull String migrationId, boolean includeDryRuns) {
        CloudSite cloudSite2;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Plan plan2 = this.retrievePlanFor(migrationId, includeDryRuns);
        if (plan2 != null) {
            Plan it = plan2;
            boolean bl = false;
            cloudSite2 = this.retrieveCloudSiteForCloudId(it.getCloudId());
        } else {
            cloudSite2 = null;
        }
        return cloudSite2;
    }

    public static /* synthetic */ CloudSite retrieveCloudSiteFor$default(DiscoveryService discoveryService, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return discoveryService.retrieveCloudSiteFor(string, bl);
    }

    @NotNull
    public final Plan retrievePlanFor(@NotNull Task task, boolean includeDryRuns) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Plan plan2 = this.retrievePlanFor(task.getMigrationId(), includeDryRuns);
        if (plan2 == null) {
            throw new IllegalStateException(("Plan for migration id=" + task.getMigrationId() + " not found").toString());
        }
        return plan2;
    }

    public static /* synthetic */ Plan retrievePlanFor$default(DiscoveryService discoveryService, Task task, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return discoveryService.retrievePlanFor(task, bl);
    }

    @Nullable
    public final Plan retrievePlanFor(@NotNull String migrationId, boolean includeDryRuns) {
        Plan plan2;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String planId = this.migrationRepository.findPlanIdByMigrationId(migrationId);
        if (includeDryRuns && planId == null) {
            DryRunMigration dryRunMigration = this.dryRunMigrationRepository.findByMigrationId(migrationId);
            planId = dryRunMigration != null ? dryRunMigration.getPlanId() : null;
        }
        String string = planId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            plan2 = this.planRepository.get(it);
        } else {
            plan2 = null;
        }
        return plan2;
    }

    public static /* synthetic */ Plan retrievePlanFor$default(DiscoveryService discoveryService, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return discoveryService.retrievePlanFor(string, bl);
    }

    @Nullable
    public final Migration findByMigrationId(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        return this.migrationRepository.findByMigrationId(migrationId);
    }

    @Nullable
    public final Migration findLatestByPlanId(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        return this.migrationRepository.findLatestByPlanId(planId);
    }

    public final boolean isUserAgreedCollectErrors() {
        return this.legalService.isLegalOptIn();
    }

    @NotNull
    public final ClusterLock getLockForName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ClusterLock clusterLock = this.clusterLockService.getLockForName(name);
        Intrinsics.checkNotNullExpressionValue((Object)clusterLock, (String)"getLockForName(...)");
        return clusterLock;
    }
}

