/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.duplicates.configOnly;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.analytics.ReconEventHandler;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.duplicates.configOnly.AllConfigCloudServiceKt;
import com.atlassian.jira.migration.duplicates.configOnly.AllConfigException;
import com.atlassian.jira.migration.duplicates.configOnly.CloudEntityType;
import com.atlassian.jira.migration.duplicates.configOnly.ConfigEntity;
import com.atlassian.jira.migration.duplicates.configOnly.ConfigOnlyContext;
import com.atlassian.jira.migration.duplicates.configOnly.CustomField;
import com.atlassian.jira.migration.duplicates.configOnly.EntityType;
import com.atlassian.jira.migration.events.ReconEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.httpclient.DuplicateEntitiesClient;
import com.atlassian.jira.migration.recon.service.MonitorService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0002J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0013J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0013H\u0002J\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001f0$2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010&\u001a\u00020'J,\u0010(\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001f0$2\u0006\u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001fH\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0002J&\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0013J&\u00103\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010+\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/duplicates/configOnly/AllConfigCloudService;", "", "duplicateEntitiesClient", "Lcom/atlassian/jira/migration/httpclient/DuplicateEntitiesClient;", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "monitorService", "Lcom/atlassian/jira/migration/recon/service/MonitorService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "reconEventHandler", "Lcom/atlassian/jira/migration/analytics/ReconEventHandler;", "(Lcom/atlassian/jira/migration/httpclient/DuplicateEntitiesClient;Lcom/atlassian/jira/config/util/JiraHome;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/recon/service/MonitorService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/ReconEventHandler;)V", "entityStore", "", "Lcom/atlassian/jira/migration/duplicates/configOnly/CloudEntityType;", "", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "cacheEntityIds", "", "configEntity", "entities", "Lcom/atlassian/jira/migration/duplicates/configOnly/ConfigEntity;", "createOutputDirectory", "Ljava/nio/file/Path;", "executionId", "deleteAllConfig", "deleteOutputDirectory", "exportAllConfig", "", "Lcom/atlassian/jira/migration/duplicates/configOnly/EntityType;", "context", "Lcom/atlassian/jira/migration/duplicates/configOnly/ConfigOnlyContext;", "exportConfigEntities", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "outputPath", "exportConfigEntity", "getOutputDirectoryPath", "sendEntityExportReconAnalytics", "cloudId", "reconEventState", "Lcom/atlassian/jira/migration/events/ReconEvent$STATE;", "entity", "writeConfigEntityToFile", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAllConfigCloudService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllConfigCloudService.kt\ncom/atlassian/jira/migration/duplicates/configOnly/AllConfigCloudService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n8406#2,2:182\n9088#2,4:184\n800#3,11:188\n1549#3:199\n1620#3,3:200\n*S KotlinDebug\n*F\n+ 1 AllConfigCloudService.kt\ncom/atlassian/jira/migration/duplicates/configOnly/AllConfigCloudService\n*L\n64#1:182,2\n64#1:184,4\n126#1:188,11\n126#1:199\n126#1:200,3\n*E\n"})
public final class AllConfigCloudService {
    @NotNull
    private final DuplicateEntitiesClient duplicateEntitiesClient;
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private final MonitorService monitorService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ReconEventHandler reconEventHandler;
    private final Logger log;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Map<CloudEntityType, List<String>> entityStore;

    @Inject
    public AllConfigCloudService(@NotNull DuplicateEntitiesClient duplicateEntitiesClient, @NotNull JiraHome jiraHome, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MonitorService monitorService, @NotNull MigrationFeatures migrationFeatures, @NotNull ReconEventHandler reconEventHandler) {
        Intrinsics.checkNotNullParameter((Object)duplicateEntitiesClient, (String)"duplicateEntitiesClient");
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)monitorService, (String)"monitorService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)reconEventHandler, (String)"reconEventHandler");
        this.duplicateEntitiesClient = duplicateEntitiesClient;
        this.jiraHome = jiraHome;
        this.monitorService = monitorService;
        this.migrationFeatures = migrationFeatures;
        this.reconEventHandler = reconEventHandler;
        this.log = LoggerFactory.getLogger(AllConfigCloudService.class);
        this.objectMapper = objectMapperFactory.createObjectMapper();
        this.entityStore = new LinkedHashMap();
    }

    @NotNull
    public final Map<EntityType, Path> exportAllConfig(@NotNull String executionId, @NotNull ConfigOnlyContext context) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getCloudSite() == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Path $this$exportAllConfig_u24lambda_u240 = this.createOutputDirectory(executionId);
        boolean bl = false;
        return this.exportConfigEntities(context.getCloudSite(), executionId, $this$exportAllConfig_u24lambda_u240);
    }

    public final void deleteAllConfig(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.deleteOutputDirectory(executionId);
    }

    public final void sendEntityExportReconAnalytics(@NotNull String cloudId2, @NotNull String executionId, @NotNull ReconEvent.STATE reconEventState, @NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)reconEventState), (String)"reconEventState");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!this.migrationFeatures.getEnableReconMigrationFlow()) {
            return;
        }
        this.reconEventHandler.sendEntityReconEvent(new ReconEvent(cloudId2, executionId, reconEventState.getValue(), ReconEvent.STATUS.SUCCESS.getValue(), entity, 0L, 32, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<EntityType, Path> exportConfigEntities(CloudSite cloudSite2, String executionId, Path outputPath) {
        void $this$associateTo$iv$iv;
        this.duplicateEntitiesClient.setCloudAuthentication(cloudSite2.getCloudId(), cloudSite2.getContainerToken());
        this.log.info("Started cloud entity export for cloud site " + cloudSite2.getCloudId() + " and execution " + executionId);
        int totalCloudEntityCount = CloudEntityType.values().length;
        int processedCloudEntityCount = 0;
        long startTime = System.currentTimeMillis();
        CloudEntityType[] $this$associate$iv = CloudEntityType.values();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        CloudEntityType[] cloudEntityTypeArray = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            void configEntity = element$iv$iv;
            boolean bl = false;
            this.sendEntityExportReconAnalytics(cloudSite2.getCloudId(), executionId, ReconEvent.STATE.START_CLOUD_CONFIG_INDIVIDUAL_ENTITY, configEntity.name());
            this.log.info("Started " + configEntity.name() + " entity export");
            this.monitorService.updateCache(executionId, cloudSite2.getCloudId(), configEntity.name(), "IN_PROGRESS", totalCloudEntityCount, processedCloudEntityCount);
            List<ConfigEntity> entities = this.exportConfigEntity((CloudEntityType)configEntity);
            Path exportFilePath = this.writeConfigEntityToFile((CloudEntityType)configEntity, entities, outputPath);
            this.monitorService.updateCache(executionId, cloudSite2.getCloudId(), configEntity.name(), "COMPLETED", totalCloudEntityCount, ++processedCloudEntityCount);
            this.log.info("Finished " + configEntity.name() + " entity export");
            this.sendEntityExportReconAnalytics(cloudSite2.getCloudId(), executionId, ReconEvent.STATE.END_CLOUD_CONFIG_INDIVIDUAL_ENTITY, configEntity.name());
            Intrinsics.checkNotNull((Object)configEntity, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.duplicates.configOnly.EntityType");
            Pair pair = TuplesKt.to((Object)((EntityType)configEntity), (Object)exportFilePath);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map exportFilePaths = destination$iv$iv;
        long endTime = System.currentTimeMillis() - startTime;
        this.log.info("Finished cloud entity export for cloud site " + cloudSite2.getCloudId() + " and execution " + executionId + ' ' + endTime);
        return exportFilePaths;
    }

    private final List<ConfigEntity> exportConfigEntity(CloudEntityType configEntity) {
        List<ConfigEntity> list;
        switch (WhenMappings.$EnumSwitchMapping$0[configEntity.ordinal()]) {
            case 1: {
                list = DuplicateEntitiesClient.getCustomFields$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 2: {
                list = DuplicateEntitiesClient.getCustomFieldSchemes$default(this.duplicateEntitiesClient, this.entityStore.getOrDefault(CloudEntityType.CustomField, CollectionsKt.emptyList()), 0, 2, null);
                break;
            }
            case 3: {
                list = DuplicateEntitiesClient.getFieldLayouts$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 4: {
                list = DuplicateEntitiesClient.getFieldLayoutSchemes$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 5: {
                list = this.duplicateEntitiesClient.getIssueStatuses();
                break;
            }
            case 6: {
                list = this.duplicateEntitiesClient.getIssueTypes();
                break;
            }
            case 7: {
                list = DuplicateEntitiesClient.getIssueTypeScreenSchemes$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 8: {
                list = DuplicateEntitiesClient.getNotificationSchemes$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 9: {
                list = this.duplicateEntitiesClient.getPermissionSchemes();
                break;
            }
            case 10: {
                list = this.duplicateEntitiesClient.getProjectRoles();
                break;
            }
            case 11: {
                list = DuplicateEntitiesClient.getScreens$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 12: {
                list = DuplicateEntitiesClient.getScreenSchemes$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 13: {
                list = DuplicateEntitiesClient.getWorkflows$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            case 14: {
                list = DuplicateEntitiesClient.getWorkflowSchemes$default(this.duplicateEntitiesClient, 0, 1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path writeConfigEntityToFile(CloudEntityType configEntity, List<? extends ConfigEntity> entities, Path outputPath) {
        String exportFilename = AllConfigCloudServiceKt.camelCase(configEntity.name()) + ".json";
        Path exportFilePath = null;
        try {
            File $this$writeConfigEntityToFile_u24lambda_u242 = new File(((Object)outputPath).toString(), exportFilename);
            boolean bl = false;
            this.log.info("Writing " + configEntity.name() + " entity data to " + $this$writeConfigEntityToFile_u24lambda_u242.getPath());
            Path path = Paths.get($this$writeConfigEntityToFile_u24lambda_u242.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            exportFilePath = path;
            Closeable closeable = new FileOutputStream($this$writeConfigEntityToFile_u24lambda_u242);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl2 = false;
                this.objectMapper.writeValue((OutputStream)it, entities);
                this.cacheEntityIds(configEntity, entities);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return exportFilePath;
        }
        catch (IOException e) {
            throw new AllConfigException("Error writing " + configEntity.name() + " entity data to export file", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cacheEntityIds(CloudEntityType configEntity, List<? extends ConfigEntity> entities) {
        block2: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            if (WhenMappings.$EnumSwitchMapping$0[configEntity.ordinal()] != 1) break block2;
            Map<CloudEntityType, List<String>> map = this.entityStore;
            Iterable $this$filterIsInstance$iv = entities;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CustomField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                CustomField customField = (CustomField)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getId());
            }
            List list = (List)destination$iv$iv;
            map.put(configEntity, list);
        }
    }

    private final Path createOutputDirectory(String executionId) {
        Path outputPath = this.getOutputDirectoryPath(executionId);
        try {
            File outputDirectory = outputPath.toFile();
            if (outputDirectory.exists()) {
                this.log.info("Deleting existing report data directory (" + outputPath + ')');
                Intrinsics.checkNotNull((Object)outputDirectory);
                FilesKt.deleteRecursively((File)outputDirectory);
            }
            this.log.info("Creating empty report data directory (" + outputPath + ')');
            Files.createDirectories(outputPath, new FileAttribute[0]).toFile().deleteOnExit();
            return outputPath;
        }
        catch (IOException e) {
            throw new AllConfigException("Error creating data output directory (" + outputPath + ')', e);
        }
    }

    private final void deleteOutputDirectory(String executionId) {
        Path outputPath = this.getOutputDirectoryPath(executionId);
        try {
            File outputDirectory = outputPath.toFile();
            if (outputDirectory.exists()) {
                this.log.info("Deleting existing report data directory (" + outputPath + ')');
                Intrinsics.checkNotNull((Object)outputDirectory);
                FilesKt.deleteRecursively((File)outputDirectory);
            }
        }
        catch (IOException e) {
            throw new AllConfigException("Error deleting data output directory (" + outputPath + ')', e);
        }
    }

    private final Path getOutputDirectoryPath(String executionId) {
        String[] stringArray = new String[]{"export", "migration-to-cloud", "config-alignment", executionId};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloudEntityType.values().length];
            try {
                nArray[CloudEntityType.CustomField.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.CustomFieldScheme.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.FieldLayout.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.FieldLayoutScheme.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.IssueStatus.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.IssueType.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.IssueTypeScreenScheme.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.NotificationScheme.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.PermissionScheme.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.ProjectRole.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.Screen.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.ScreenScheme.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.Workflow.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudEntityType.WorkflowScheme.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

