/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.duplicates.configOnly;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.duplicates.configOnly.AllConfigCloudService;
import com.atlassian.jira.migration.duplicates.configOnly.CloudEntityType;
import com.atlassian.jira.migration.duplicates.configOnly.ConfigOnlyContext;
import com.atlassian.jira.migration.duplicates.configOnly.ConfigSource;
import com.atlassian.jira.migration.duplicates.configOnly.CustomField;
import com.atlassian.jira.migration.duplicates.configOnly.CustomFieldScheme;
import com.atlassian.jira.migration.duplicates.configOnly.EntityType;
import com.atlassian.jira.migration.duplicates.configOnly.FieldLayout;
import com.atlassian.jira.migration.duplicates.configOnly.FieldLayoutScheme;
import com.atlassian.jira.migration.duplicates.configOnly.IdentifiableEntityDeserializer;
import com.atlassian.jira.migration.duplicates.configOnly.IdentifiableEntityList;
import com.atlassian.jira.migration.duplicates.configOnly.IssueStatus;
import com.atlassian.jira.migration.duplicates.configOnly.IssueType;
import com.atlassian.jira.migration.duplicates.configOnly.IssueTypeScreenScheme;
import com.atlassian.jira.migration.duplicates.configOnly.NotificationScheme;
import com.atlassian.jira.migration.duplicates.configOnly.PermissionScheme;
import com.atlassian.jira.migration.duplicates.configOnly.ProjectRole;
import com.atlassian.jira.migration.duplicates.configOnly.Screen;
import com.atlassian.jira.migration.duplicates.configOnly.ScreenScheme;
import com.atlassian.jira.migration.duplicates.configOnly.ServerEntityType;
import com.atlassian.jira.migration.duplicates.configOnly.Workflow;
import com.atlassian.jira.migration.duplicates.configOnly.WorkflowScheme;
import com.atlassian.jira.migration.export.AllConfigExporterService;
import com.atlassian.migration.base.IdentifiableEntity;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000bJ$\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ,\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010%\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\r2\u0006\u0010\u001b\u001a\u00020\u000bJ\u001a\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000fJ\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u0018\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00180\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/duplicates/configOnly/ServerCloudDataProvider;", "", "serverConfig", "Lcom/atlassian/jira/migration/export/AllConfigExporterService;", "cloudConfig", "Lcom/atlassian/jira/migration/duplicates/configOnly/AllConfigCloudService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/export/AllConfigExporterService;Lcom/atlassian/jira/migration/duplicates/configOnly/AllConfigCloudService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "exportStore", "", "", "Lcom/atlassian/jira/migration/duplicates/configOnly/ConfigSource;", "", "Lcom/atlassian/jira/migration/duplicates/configOnly/EntityType;", "Ljava/nio/file/Path;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "typeReferenceMap", "Lcom/fasterxml/jackson/core/type/TypeReference;", "asyncExportData", "Lkotlinx/coroutines/Job;", "executionId", "context", "Lcom/atlassian/jira/migration/duplicates/configOnly/ConfigOnlyContext;", "isScope", "", "deleteData", "", "exportCloudData", "exportData", "exportServerData", "getExecutionStore", "parseExportFile", "", "entityType", "exportFilePath", "readExportFile", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServerCloudDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerCloudDataProvider.kt\ncom/atlassian/jira/migration/duplicates/configOnly/ServerCloudDataProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,122:1\n372#2,7:123\n*S KotlinDebug\n*F\n+ 1 ServerCloudDataProvider.kt\ncom/atlassian/jira/migration/duplicates/configOnly/ServerCloudDataProvider\n*L\n52#1:123,7\n*E\n"})
public final class ServerCloudDataProvider {
    @NotNull
    private final AllConfigExporterService serverConfig;
    @NotNull
    private final AllConfigCloudService cloudConfig;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Map<String, Map<ConfigSource, Map<EntityType, Path>>> exportStore;
    private final Logger log;
    @NotNull
    private final Map<? extends Object, TypeReference<? extends Object>> typeReferenceMap;

    /*
     * WARNING - void declaration
     */
    @Inject
    public ServerCloudDataProvider(@NotNull AllConfigExporterService serverConfig, @NotNull AllConfigCloudService cloudConfig, @NotNull ObjectMapperFactory objectMapperFactory) {
        void $this$objectMapper_u24lambda_u240;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)cloudConfig, (String)"cloudConfig");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.serverConfig = serverConfig;
        this.cloudConfig = cloudConfig;
        Pair[] pairArray2 = pairArray = objectMapperFactory.createObjectMapper();
        ServerCloudDataProvider serverCloudDataProvider = this;
        boolean bl = false;
        SimpleModule module = new SimpleModule();
        module.addDeserializer(IdentifiableEntity.class, (JsonDeserializer)new IdentifiableEntityDeserializer());
        $this$objectMapper_u24lambda_u240.registerModule((Module)module);
        serverCloudDataProvider.objectMapper = pairArray;
        this.exportStore = new LinkedHashMap();
        this.log = LoggerFactory.getLogger(ServerCloudDataProvider.class);
        pairArray = new Pair[]{TuplesKt.to((Object)ServerEntityType.Any, (Object)new TypeReference<IdentifiableEntityList>(){}), TuplesKt.to((Object)CloudEntityType.CustomField, (Object)new TypeReference<List<? extends CustomField>>(){}), TuplesKt.to((Object)CloudEntityType.CustomFieldScheme, (Object)new TypeReference<List<? extends CustomFieldScheme>>(){}), TuplesKt.to((Object)CloudEntityType.FieldLayout, (Object)new TypeReference<List<? extends FieldLayout>>(){}), TuplesKt.to((Object)CloudEntityType.FieldLayoutScheme, (Object)new TypeReference<List<? extends FieldLayoutScheme>>(){}), TuplesKt.to((Object)CloudEntityType.IssueStatus, (Object)new TypeReference<List<? extends IssueStatus>>(){}), TuplesKt.to((Object)CloudEntityType.IssueType, (Object)new TypeReference<List<? extends IssueType>>(){}), TuplesKt.to((Object)CloudEntityType.IssueTypeScreenScheme, (Object)new TypeReference<List<? extends IssueTypeScreenScheme>>(){}), TuplesKt.to((Object)CloudEntityType.NotificationScheme, (Object)new TypeReference<List<? extends NotificationScheme>>(){}), TuplesKt.to((Object)CloudEntityType.PermissionScheme, (Object)new TypeReference<List<? extends PermissionScheme>>(){}), TuplesKt.to((Object)CloudEntityType.ProjectRole, (Object)new TypeReference<List<? extends ProjectRole>>(){}), TuplesKt.to((Object)CloudEntityType.Screen, (Object)new TypeReference<List<? extends Screen>>(){}), TuplesKt.to((Object)CloudEntityType.ScreenScheme, (Object)new TypeReference<List<? extends ScreenScheme>>(){}), TuplesKt.to((Object)CloudEntityType.Workflow, (Object)new TypeReference<List<? extends Workflow>>(){}), TuplesKt.to((Object)CloudEntityType.WorkflowScheme, (Object)new TypeReference<List<? extends WorkflowScheme>>(){})};
        this.typeReferenceMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public final Map<ConfigSource, Map<EntityType, Path>> getExecutionStore(@NotNull String executionId) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Map<String, Map<ConfigSource, Map<EntityType, Path>>> $this$getOrPut$iv = this.exportStore;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(executionId);
        if (value$iv == null) {
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)ConfigSource.Server), (Object)MapsKt.emptyMap()), TuplesKt.to((Object)((Object)ConfigSource.Cloud), (Object)MapsKt.emptyMap())};
            Map answer$iv = MapsKt.mutableMapOf((Pair[])pairArray);
            $this$getOrPut$iv.put(executionId, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        return map;
    }

    @NotNull
    public final List<?> parseExportFile(@NotNull EntityType entityType, @NotNull Path exportFilePath) {
        List<IdentifiableEntity> list;
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)exportFilePath, (String)"exportFilePath");
        try {
            List<IdentifiableEntity> list2;
            String json = this.readExportFile(exportFilePath);
            Object $this$parseExportFile_u24lambda_u242 = this.objectMapper.readValue(json, this.typeReferenceMap.get(entityType));
            boolean bl = false;
            if (entityType == ServerEntityType.Any) {
                Intrinsics.checkNotNull((Object)$this$parseExportFile_u24lambda_u242, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.duplicates.configOnly.IdentifiableEntityList");
                list2 = ((IdentifiableEntityList)$this$parseExportFile_u24lambda_u242).getEntities();
            } else {
                Intrinsics.checkNotNull((Object)$this$parseExportFile_u24lambda_u242, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                list2 = (List<IdentifiableEntity>)$this$parseExportFile_u24lambda_u242;
            }
            list = list2;
        }
        catch (JsonProcessingException e) {
            this.log.error("Error parsing entity data export file (" + exportFilePath + ')', (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    public final String readExportFile(@NotNull Path exportFilePath) {
        Intrinsics.checkNotNullParameter((Object)exportFilePath, (String)"exportFilePath");
        File file2 = exportFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return FilesKt.readText$default((File)file2, null, (int)1, null);
    }

    public final void exportData(@NotNull String executionId, @NotNull ConfigOnlyContext context, boolean isScope) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.asyncExportData(executionId, context, isScope);
    }

    public static /* synthetic */ void exportData$default(ServerCloudDataProvider serverCloudDataProvider, String string, ConfigOnlyContext configOnlyContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        serverCloudDataProvider.exportData(string, configOnlyContext, bl);
    }

    private final Job asyncExportData(String executionId, ConfigOnlyContext context, boolean isScope) {
        return (Job)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(this, executionId, context, isScope, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ServerCloudDataProvider this$0;
            final /* synthetic */ String $executionId;
            final /* synthetic */ ConfigOnlyContext $context;
            final /* synthetic */ boolean $isScope;
            {
                this.this$0 = $receiver;
                this.$executionId = $executionId;
                this.$context = $context;
                this.$isScope = $isScope;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        Map<ConfigSource, Map<EntityType, Path>> map = this.this$0.getExecutionStore(this.$executionId);
                        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<com.atlassian.jira.migration.duplicates.configOnly.ConfigSource, kotlin.collections.Map<com.atlassian.jira.migration.duplicates.configOnly.EntityType, java.nio.file.Path>>");
                        Map executionExportStore = TypeIntrinsics.asMutableMap(map);
                        BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Map<ConfigSource, Map<EntityType, Path>>)executionExportStore, this.this$0, this.$executionId, this.$context, this.$isScope, null){
                            int label;
                            final /* synthetic */ Map<ConfigSource, Map<EntityType, Path>> $executionExportStore;
                            final /* synthetic */ ServerCloudDataProvider this$0;
                            final /* synthetic */ String $executionId;
                            final /* synthetic */ ConfigOnlyContext $context;
                            final /* synthetic */ boolean $isScope;
                            {
                                this.$executionExportStore = $executionExportStore;
                                this.this$0 = $receiver;
                                this.$executionId = $executionId;
                                this.$context = $context;
                                this.$isScope = $isScope;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$executionExportStore.put(ConfigSource.Server, ServerCloudDataProvider.access$exportServerData(this.this$0, this.$executionId, this.$context, this.$isScope));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Map<ConfigSource, Map<EntityType, Path>>)executionExportStore, this.this$0, this.$executionId, this.$context, null){
                            int label;
                            final /* synthetic */ Map<ConfigSource, Map<EntityType, Path>> $executionExportStore;
                            final /* synthetic */ ServerCloudDataProvider this$0;
                            final /* synthetic */ String $executionId;
                            final /* synthetic */ ConfigOnlyContext $context;
                            {
                                this.$executionExportStore = $executionExportStore;
                                this.this$0 = $receiver;
                                this.$executionId = $executionId;
                                this.$context = $context;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$executionExportStore.put(ConfigSource.Cloud, ServerCloudDataProvider.access$exportCloudData(this.this$0, this.$executionId, this.$context));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void deleteData(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.cloudConfig.deleteAllConfig(executionId);
    }

    private final Map<EntityType, Path> exportServerData(String executionId, ConfigOnlyContext context, boolean isScope) {
        this.log.info("Exporting server data for execution ID " + executionId);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)ServerEntityType.Any, (Object)this.serverConfig.exportAllConfig(context.getUser(), context.getProjectKeys(), isScope).getFile().toPath()));
    }

    private final Map<EntityType, Path> exportCloudData(String executionId, ConfigOnlyContext context) {
        this.log.info("Exporting cloud data for execution ID " + executionId);
        return this.cloudConfig.exportAllConfig(executionId, context);
    }

    public static final /* synthetic */ Map access$exportServerData(ServerCloudDataProvider $this, String executionId, ConfigOnlyContext context, boolean isScope) {
        return $this.exportServerData(executionId, context, isScope);
    }

    public static final /* synthetic */ Map access$exportCloudData(ServerCloudDataProvider $this, String executionId, ConfigOnlyContext context) {
        return $this.exportCloudData(executionId, context);
    }
}

