/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailFormatChecker;
import com.atlassian.jira.migration.common.DomainId;
import com.atlassian.jira.migration.email.InvalidEmailService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/email/BlockedDomainUmsService;", "", "invalidEmailService", "Lcom/atlassian/jira/migration/email/InvalidEmailService;", "(Lcom/atlassian/jira/migration/email/InvalidEmailService;)V", "getBlockedDomainsFromUms", "", "Lcom/atlassian/jira/migration/common/DomainId;", "containerToken", "", "migrationScopeId", "domains", "processBlockedDomains", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBlockedDomainUmsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockedDomainUmsService.kt\ncom/atlassian/jira/migration/email/BlockedDomainUmsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1549#2:44\n1620#2,3:45\n1603#2,9:48\n1855#2:57\n1856#2:59\n1612#2:60\n1#3:58\n*S KotlinDebug\n*F\n+ 1 BlockedDomainUmsService.kt\ncom/atlassian/jira/migration/email/BlockedDomainUmsService\n*L\n32#1:44\n32#1:45,3\n40#1:48,9\n40#1:57\n40#1:59\n40#1:60\n40#1:58\n*E\n"})
public final class BlockedDomainUmsService {
    @NotNull
    private final InvalidEmailService invalidEmailService;

    @Inject
    public BlockedDomainUmsService(@NotNull InvalidEmailService invalidEmailService) {
        Intrinsics.checkNotNullParameter((Object)invalidEmailService, (String)"invalidEmailService");
        this.invalidEmailService = invalidEmailService;
    }

    @NotNull
    public final List<DomainId> getBlockedDomainsFromUms(@NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull List<DomainId> domains) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        if (domains.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String executionId = string;
        Iterable $this$map$iv = domains;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DomainId domainId = (DomainId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((DomainId)((Object)it)).generateRandomEmail());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JiraUser.Companion.fromEmailAsActive(it));
        }
        List users2 = (List)destination$iv$iv;
        CheckResult checkResult = this.invalidEmailService.validate(executionId, containerToken, migrationScopeId2, users2);
        return this.processBlockedDomains(checkResult);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DomainId> processBlockedDomains(CheckResult checkResult) {
        void $this$mapNotNullTo$iv$iv;
        List list = EmailFormatChecker.retrieveInvalidEmails((Map)checkResult.details);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"retrieveInvalidEmails(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DomainId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            EmailData it = (EmailData)element$iv$iv;
            boolean bl2 = false;
            String string = it.email;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"email");
            if (DomainId.Companion.fromEmail(string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }
}

