/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.common.SequenceExtensionKt;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.email.BatchUpsertResultAggregator;
import com.atlassian.jira.migration.email.CorrectedEmailService;
import com.atlassian.jira.migration.email.CorrectedEmails;
import com.atlassian.jira.migration.email.CsvRecordResult;
import com.atlassian.jira.migration.email.CsvUploadStatus;
import com.atlassian.jira.migration.email.DuplicatedEmails;
import com.atlassian.jira.migration.email.InvalidEmailService;
import com.atlassian.jira.migration.email.InvalidEmailsCsvService;
import com.atlassian.jira.migration.email.InvalidReason;
import com.atlassian.jira.migration.email.db.CorrectedEmailRepository;
import com.atlassian.jira.migration.email.db.IncorrectEmailRepository;
import com.atlassian.jira.migration.email.db.UserBaseScanRepository;
import com.atlassian.jira.migration.email.model.BatchUpsertResult;
import com.atlassian.jira.migration.email.model.CorrectedEmail;
import com.atlassian.jira.migration.email.model.CorrectedUserFileRecord;
import com.atlassian.jira.migration.email.model.IncorrectEmail;
import com.atlassian.jira.migration.email.model.ModelKt;
import com.atlassian.jira.migration.email.model.UmsInvalidEmailsResponseDTO;
import com.atlassian.jira.migration.events.EmailCorrectionEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.utils.CsvUtil;
import com.atlassian.jira.migration.utils.EmailValidityCheckerUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.correctedemails.AdvancedCsvState;
import com.atlassian.migration.udc.common.model.correctedemails.CsvState;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseEnum;
import org.supercsv.cellprocessor.Trim;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 h2\u00020\u0001:\u0001hBo\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cB}\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J \u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&J\u000e\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010.\u001a\u00020$2\u0006\u0010%\u001a\u00020&J(\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f002\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+J:\u00101\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u000203\u0012\u0006\u0012\u0004\u0018\u00010302002\u0006\u00104\u001a\u0002032\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u00020)H\u0002J&\u00109\u001a\b\u0012\u0004\u0012\u000203002\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+J\u0014\u0010:\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$02H\u0002J\u000e\u0010;\u001a\u00020<2\u0006\u0010*\u001a\u00020+J\u000e\u0010=\u001a\u00020>2\u0006\u00108\u001a\u00020)J\u0016\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u0002032\u0006\u0010%\u001a\u00020&J(\u0010A\u001a\u00020+2\u0006\u00104\u001a\u0002032\f\u0010B\u001a\b\u0012\u0004\u0012\u000207062\b\u00108\u001a\u0004\u0018\u00010)H\u0002J\u0018\u0010C\u001a\u00020+2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+J\"\u0010D\u001a\u00020+2\u0006\u00108\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+H\u0002J \u0010E\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+J\u000e\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020+J\u0018\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u00104\u001a\u000203H\u0002J*\u0010M\u001a\u00020N2\u0006\u00104\u001a\u0002032\b\u0010O\u001a\u0004\u0018\u0001032\u0006\u0010P\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010)J0\u0010S\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020U06\u0012\n\u0012\b\u0012\u0004\u0012\u00020706\u0012\u0006\u0012\u0004\u0018\u00010)0T2\u0006\u0010P\u001a\u00020QH\u0002J\u0012\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020YH\u0007J\u0016\u0010Z\u001a\u00020N2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020706H\u0002J\u0010\u0010[\u001a\u00020\u001f2\u0006\u0010\\\u001a\u00020]H\u0002J(\u0010^\u001a\u00020N2\u0006\u00104\u001a\u0002032\f\u0010B\u001a\b\u0012\u0004\u0012\u000207062\b\u00108\u001a\u0004\u0018\u00010)H\u0002J@\u0010_\u001a\u00020N2\u0006\u00104\u001a\u0002032\b\u0010O\u001a\u0004\u0018\u0001032\f\u0010`\u001a\b\u0012\u0004\u0012\u00020U062\f\u0010B\u001a\b\u0012\u0004\u0012\u000207062\b\u00108\u001a\u0004\u0018\u00010)H\u0002J4\u0010a\u001a\b\u0012\u0004\u0012\u00020b002\f\u0010B\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00104\u001a\u0002032\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u000203H\u0002J\u0016\u0010f\u001a\u00020+2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020706H\u0002R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/atlassian/jira/migration/email/CorrectedEmailService;", "", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "incorrectEmailRepository", "Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;", "correctedEmailRepository", "Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "userBaseScanRepository", "Lcom/atlassian/jira/migration/email/db/UserBaseScanRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "invalidEmailService", "Lcom/atlassian/jira/migration/email/InvalidEmailService;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "invalidEmailsCsvService", "Lcom/atlassian/jira/migration/email/InvalidEmailsCsvService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/email/db/UserBaseScanRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/email/InvalidEmailService;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;Lcom/atlassian/jira/migration/email/InvalidEmailsCsvService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "batchUpsertResultAggregator", "Lcom/atlassian/jira/migration/email/BatchUpsertResultAggregator;", "Lcom/atlassian/jira/migration/email/model/CorrectedEmail;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;Lcom/atlassian/jira/migration/email/BatchUpsertResultAggregator;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/email/db/UserBaseScanRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/email/InvalidEmailService;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;Lcom/atlassian/jira/migration/email/InvalidEmailsCsvService;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "changeDraftDataToConfirmed", "", "udcMode", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UDCMode;", "countByCheckType", "type", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "draft", "", "deleteByEmailCheckType", "deleteByUdcMode", "deleteDraft", "fetchByEmailCheckType", "", "findMismatchedRecords", "Lkotlin/Pair;", "", "executionId", "csvRecords", "", "Lcom/atlassian/jira/migration/email/CsvRecordResult$CorrectedEmailResult;", "checkType", "findUserKeysByCheckType", "getEmailsCount", "getStateForAdvancedMode", "Lcom/atlassian/migration/udc/common/model/correctedemails/AdvancedCsvState;", "getStateForBasicMode", "Lcom/atlassian/migration/udc/common/model/correctedemails/CsvState;", "hasCorrectedByTombstoning", "userKey", "hasFileStructureMismatch", "correctedRecords", "isAnyRecordFound", "isCsvOutdatedForCheckType", "isRecordFoundForEmailCheckType", "loadAllCorrectedEmails", "Lcom/atlassian/jira/migration/email/CorrectedEmails;", "skipValidation", "postEvent", "", "numberOfRecords", "", "processCsvContent", "Lcom/atlassian/jira/migration/email/CsvUploadStatus;", "cloudId", "inputStream", "Ljava/io/InputStream;", "expectedCheckType", "readContent", "Lkotlin/Triple;", "Lcom/atlassian/jira/migration/email/CsvRecordResult$CsvRecordError;", "readCsvLine", "Lcom/atlassian/jira/migration/email/CsvRecordResult;", "reader", "Lorg/supercsv/io/CsvBeanReader;", "recordCorrectedEmailData", "toCorrectedEmail", "correctedUserFileRecord", "Lcom/atlassian/jira/migration/email/model/CorrectedUserFileRecord;", "uploadCorrectEmails", "validateAndUploadContent", "errorRecords", "validateNewEmails", "Lcom/atlassian/cmpt/check/email/EmailData;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "containerToken", "verifyFileFixesAllGivenUsers", "listOfCorrectedEmails", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCorrectedEmailService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorrectedEmailService.kt\ncom/atlassian/jira/migration/email/CorrectedEmailService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,491:1\n1284#2,3:492\n1271#3,2:495\n1285#3,4:497\n1747#3,3:501\n1549#3:504\n1620#3,3:505\n766#3:508\n857#3,2:509\n1549#3:512\n1620#3,3:513\n1789#3,3:516\n1774#3,4:519\n1774#3,4:523\n1549#3:527\n1620#3,3:528\n1477#3:531\n1502#3,3:532\n1505#3,3:542\n766#3:545\n857#3,2:546\n1549#3:548\n1620#3,3:549\n1855#3,2:552\n1#4:511\n372#5,7:535\n*S KotlinDebug\n*F\n+ 1 CorrectedEmailService.kt\ncom/atlassian/jira/migration/email/CorrectedEmailService\n*L\n157#1:492,3\n210#1:495,2\n210#1:497,4\n227#1:501,3\n249#1:504\n249#1:505,3\n251#1:508\n251#1:509,2\n278#1:512\n278#1:513,3\n279#1:516,3\n316#1:519,4\n318#1:523,4\n466#1:527\n466#1:528,3\n467#1:531\n467#1:532,3\n467#1:542,3\n469#1:545\n469#1:546,2\n470#1:548\n470#1:549,3\n481#1:552,2\n467#1:535,7\n*E\n"})
public final class CorrectedEmailService {
    @org.jetbrains.annotations.NotNull
    public static final Companion Companion = new Companion(null);
    @org.jetbrains.annotations.NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @org.jetbrains.annotations.NotNull
    private final IncorrectEmailRepository incorrectEmailRepository;
    @org.jetbrains.annotations.NotNull
    private final CorrectedEmailRepository correctedEmailRepository;
    @org.jetbrains.annotations.NotNull
    private final BatchUpsertResultAggregator<CorrectedEmail> batchUpsertResultAggregator;
    @org.jetbrains.annotations.NotNull
    private final MigrationEventBus migrationEventBus;
    @org.jetbrains.annotations.NotNull
    private final UserBaseScanRepository userBaseScanRepository;
    @org.jetbrains.annotations.NotNull
    private final MigrationFeatures migrationFeatures;
    @org.jetbrains.annotations.NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @org.jetbrains.annotations.NotNull
    private final MigrationScopeManager migrationScopeManager;
    @org.jetbrains.annotations.NotNull
    private final InvalidEmailService invalidEmailService;
    @org.jetbrains.annotations.NotNull
    private final UserManager userManager;
    @org.jetbrains.annotations.NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    @org.jetbrains.annotations.NotNull
    private final InvalidEmailsCsvService invalidEmailsCsvService;
    @org.jetbrains.annotations.NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(CorrectedEmailService.class);

    @VisibleForTesting
    public CorrectedEmailService(@org.jetbrains.annotations.NotNull JiraAuthenticationContext jiraAuthenticationContext, @org.jetbrains.annotations.NotNull IncorrectEmailRepository incorrectEmailRepository, @org.jetbrains.annotations.NotNull CorrectedEmailRepository correctedEmailRepository, @org.jetbrains.annotations.NotNull BatchUpsertResultAggregator<CorrectedEmail> batchUpsertResultAggregator, @org.jetbrains.annotations.NotNull MigrationEventBus migrationEventBus, @org.jetbrains.annotations.NotNull UserBaseScanRepository userBaseScanRepository, @org.jetbrains.annotations.NotNull MigrationFeatures migrationFeatures, @org.jetbrains.annotations.NotNull CloudSiteRepository cloudSiteRepository, @org.jetbrains.annotations.NotNull MigrationScopeManager migrationScopeManager, @org.jetbrains.annotations.NotNull InvalidEmailService invalidEmailService, @org.jetbrains.annotations.NotNull UserManager userManager, @org.jetbrains.annotations.NotNull ContainerTokenTTLService containerTokenTTLService, @org.jetbrains.annotations.NotNull InvalidEmailsCsvService invalidEmailsCsvService, @org.jetbrains.annotations.NotNull ObjectMapper objectMapper2) {
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailRepository, (String)"incorrectEmailRepository");
        Intrinsics.checkNotNullParameter((Object)correctedEmailRepository, (String)"correctedEmailRepository");
        Intrinsics.checkNotNullParameter(batchUpsertResultAggregator, (String)"batchUpsertResultAggregator");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)userBaseScanRepository, (String)"userBaseScanRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)invalidEmailService, (String)"invalidEmailService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        Intrinsics.checkNotNullParameter((Object)invalidEmailsCsvService, (String)"invalidEmailsCsvService");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.incorrectEmailRepository = incorrectEmailRepository;
        this.correctedEmailRepository = correctedEmailRepository;
        this.batchUpsertResultAggregator = batchUpsertResultAggregator;
        this.migrationEventBus = migrationEventBus;
        this.userBaseScanRepository = userBaseScanRepository;
        this.migrationFeatures = migrationFeatures;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationScopeManager = migrationScopeManager;
        this.invalidEmailService = invalidEmailService;
        this.userManager = userManager;
        this.containerTokenTTLService = containerTokenTTLService;
        this.invalidEmailsCsvService = invalidEmailsCsvService;
        this.objectMapper = objectMapper2;
    }

    @Inject
    public CorrectedEmailService(@org.jetbrains.annotations.NotNull JiraAuthenticationContext jiraAuthenticationContext, @org.jetbrains.annotations.NotNull IncorrectEmailRepository incorrectEmailRepository, @org.jetbrains.annotations.NotNull CorrectedEmailRepository correctedEmailRepository, @org.jetbrains.annotations.NotNull MigrationEventBus migrationEventBus, @org.jetbrains.annotations.NotNull UserBaseScanRepository userBaseScanRepository, @org.jetbrains.annotations.NotNull MigrationFeatures migrationFeatures, @org.jetbrains.annotations.NotNull CloudSiteRepository cloudSiteRepository, @org.jetbrains.annotations.NotNull MigrationScopeManager migrationScopeManager, @org.jetbrains.annotations.NotNull InvalidEmailService invalidEmailService, @org.jetbrains.annotations.NotNull UserManager userManager, @org.jetbrains.annotations.NotNull ContainerTokenTTLService containerTokenTTLService, @org.jetbrains.annotations.NotNull InvalidEmailsCsvService invalidEmailsCsvService, @org.jetbrains.annotations.NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailRepository, (String)"incorrectEmailRepository");
        Intrinsics.checkNotNullParameter((Object)correctedEmailRepository, (String)"correctedEmailRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)userBaseScanRepository, (String)"userBaseScanRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)invalidEmailService, (String)"invalidEmailService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        Intrinsics.checkNotNullParameter((Object)invalidEmailsCsvService, (String)"invalidEmailsCsvService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this(jiraAuthenticationContext, incorrectEmailRepository, correctedEmailRepository, new BatchUpsertResultAggregator<CorrectedEmail>(), migrationEventBus, userBaseScanRepository, migrationFeatures, cloudSiteRepository, migrationScopeManager, invalidEmailService, userManager, containerTokenTTLService, invalidEmailsCsvService, objectMapperFactory.createObjectMapper());
    }

    @org.jetbrains.annotations.NotNull
    public final CsvUploadStatus processCsvContent(@org.jetbrains.annotations.NotNull String executionId, @Nullable String cloudId2, @org.jetbrains.annotations.NotNull InputStream inputStream, @Nullable EmailCheckType expectedCheckType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Triple<List<CsvRecordResult.CsvRecordError>, List<CsvRecordResult.CorrectedEmailResult>, EmailCheckType> triple = this.readContent(inputStream);
        List errorRecords = (List)triple.component1();
        List correctedRecords = (List)triple.component2();
        EmailCheckType checkType = (EmailCheckType)triple.component3();
        EmailCheckType emailCheckType = expectedCheckType;
        if (emailCheckType == null) {
            emailCheckType = checkType;
        }
        return this.validateAndUploadContent(executionId, cloudId2, errorRecords, correctedRecords, emailCheckType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Triple<List<CsvRecordResult.CsvRecordError>, List<CsvRecordResult.CorrectedEmailResult>, EmailCheckType> readContent(InputStream inputStream) {
        Closeable closeable = (Closeable)new CsvBeanReader((Reader)new InputStreamReader(inputStream), CsvPreference.STANDARD_PREFERENCE);
        Throwable throwable = null;
        try {
            void $this$fold$iv;
            void initial$iv;
            CsvBeanReader reader = (CsvBeanReader)closeable;
            boolean bl = false;
            reader.getHeader(true);
            EmailCheckType checkType = null;
            Sequence sequence = SequencesKt.generateSequence((Function0)((Function0)new Function0<CsvRecordResult>(this, reader){
                final /* synthetic */ CorrectedEmailService this$0;
                final /* synthetic */ CsvBeanReader $reader;
                {
                    this.this$0 = $receiver;
                    this.$reader = $reader;
                    super(0);
                }

                @Nullable
                public final CsvRecordResult invoke() {
                    return this.this$0.readCsvLine(this.$reader);
                }
            }));
            Pair pair = new Pair((Object)new ArrayList(), (Object)new ArrayList());
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void res;
                void var16_18;
                CsvRecordResult csvRecordResult = (CsvRecordResult)element$iv;
                void acc = accumulator$iv;
                boolean bl2 = false;
                void $this$readContent_u24lambda_u243_u24lambda_u242_u24lambda_u241 = var16_18 = acc;
                boolean bl3 = false;
                void var19_21 = res;
                if (var19_21 instanceof CsvRecordResult.CsvRecordError) {
                    ((List)acc.getFirst()).add(res);
                } else if (var19_21 instanceof CsvRecordResult.CorrectedEmailResult) {
                    boolean bl4;
                    boolean it = bl4 = ((List)acc.getSecond()).add(res);
                    boolean bl5 = false;
                    checkType = ((CsvRecordResult.CorrectedEmailResult)res).getCorrectedUserFileRecord().getType();
                }
                accumulator$iv = var16_18;
            }
            void var23_25 = accumulator$iv;
            List errorRecords = (List)var23_25.component1();
            List correctedRecords = (List)var23_25.component2();
            Triple triple = new Triple((Object)errorRecords, (Object)correctedRecords, checkType);
            return triple;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CsvUploadStatus validateAndUploadContent(String executionId, String cloudId2, List<CsvRecordResult.CsvRecordError> errorRecords, List<CsvRecordResult.CorrectedEmailResult> correctedRecords, EmailCheckType checkType) {
        CsvUploadStatus csvUploadStatus;
        if (!((Collection)errorRecords).isEmpty()) {
            csvUploadStatus = new CsvUploadStatus.CvsRecordValidationFailed(errorRecords);
        } else if (!this.verifyFileFixesAllGivenUsers(correctedRecords)) {
            csvUploadStatus = new CsvUploadStatus.CsvRecordCountFailed("The uploaded CSV file contains a different number of users than the original file.");
        } else if (this.hasFileStructureMismatch(executionId, correctedRecords, checkType)) {
            csvUploadStatus = new CsvUploadStatus.CsvFileStructureMismatch("The uploaded CSV file has a structure mismatch");
        } else if (StringExtensionsKt.isNotNullOrBlank(cloudId2)) {
            CloudSite cloudSite2;
            String string = cloudId2;
            Intrinsics.checkNotNull((Object)string);
            CloudSite cloudSite3 = cloudSite2 = this.cloudSiteRepository.getSite(string);
            String containerToken = cloudSite3 != null ? cloudSite3.getContainerToken() : null;
            if (containerToken == null) {
                csvUploadStatus = new CsvUploadStatus.CsvUmsInvalidEmailCheckFailed(new UmsInvalidEmailsResponseDTO("Invalid cloud site."));
            } else if (!this.containerTokenTTLService.isValidToken(containerToken)) {
                csvUploadStatus = new CsvUploadStatus.CsvUmsInvalidEmailCheckFailed(new UmsInvalidEmailsResponseDTO("Container token expired."));
            } else {
                List<EmailData> invalidEmails = this.validateNewEmails(correctedRecords, executionId, cloudSite2, containerToken);
                if (invalidEmails.isEmpty()) {
                    csvUploadStatus = this.uploadCorrectEmails(executionId, correctedRecords, checkType);
                } else {
                    Iterable $this$associateWith$iv = invalidEmails;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                        void it;
                        EmailData emailData = (EmailData)element$iv$iv;
                        Object t = element$iv$iv;
                        Map map = result$iv;
                        boolean bl = false;
                        InvalidReason invalidReason = IdentityAcceptedEmailValidator.isValidEmailAddress((String)it.email) ? InvalidReason.BLOCKED_DOMAIN : InvalidReason.INVALID_EMAIL;
                        map.put(t, invalidReason);
                    }
                    Map invalidEmailsMap = result$iv;
                    csvUploadStatus = new CsvUploadStatus.CsvInvalidEmailsCsv(this.invalidEmailsCsvService.generateCsvString(invalidEmailsMap));
                }
            }
        } else {
            csvUploadStatus = this.uploadCorrectEmails(executionId, correctedRecords, checkType);
        }
        return csvUploadStatus;
    }

    private final boolean hasFileStructureMismatch(String executionId, List<CsvRecordResult.CorrectedEmailResult> correctedRecords, EmailCheckType checkType) {
        if (checkType != null && this.migrationFeatures.getEnableUdcCsvFileStructureMismatchValidation()) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = correctedRecords;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CsvRecordResult.CorrectedEmailResult it = (CsvRecordResult.CorrectedEmailResult)element$iv;
                        boolean bl2 = false;
                        if (!(it.getCorrectedUserFileRecord().getType() != checkType)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                log.warn("CSV validation failed with file structure mismatch due to having a record with type that is not {}", (Object)checkType);
                return true;
            }
            List<Pair<String, String>> mismatchedPairs = this.findMismatchedRecords(executionId, correctedRecords, checkType);
            if (!((Collection)mismatchedPairs).isEmpty()) {
                String users2 = CollectionsKt.joinToString$default((Iterable)mismatchedPairs, null, null, null, (int)0, null, (Function1)hasFileStructureMismatch.users.1.INSTANCE, (int)31, null);
                log.warn("CSV validation failed with file structure mismatch due to following users not being found in db: {}", (Object)users2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> findMismatchedRecords(String executionId, List<CsvRecordResult.CorrectedEmailResult> csvRecords, EmailCheckType checkType) {
        void $this$filterTo$iv$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Set dbPairs2 = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable(SequenceExtensionKt.takeWhileInclusive(this.incorrectEmailRepository.readByType(executionId, checkType, 1000, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>((Object)this.objectMapper){

            @org.jetbrains.annotations.NotNull
            public final IncorrectEmail invoke(@org.jetbrains.annotations.NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ObjectMapper $this$readValue$iv = (ObjectMapper)this.receiver;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                return (IncorrectEmail)$this$readValue$iv.readValue(p0, (TypeReference)new TypeReference<IncorrectEmail>(){});
            }
        })), findMismatchedRecords.dbPairs.2.INSTANCE), (Function1)findMismatchedRecords.dbPairs.3.INSTANCE), (Function1)findMismatchedRecords.dbPairs.4.INSTANCE));
        Iterable iterable = csvRecords;
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CsvRecordResult.CorrectedEmailResult correctedEmailResult = (CsvRecordResult.CorrectedEmailResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it.getCorrectedUserFileRecord().getUserKey(), (Object)it.getCorrectedUserFileRecord().getUserName()));
        }
        List csvPairs = (List)destination$iv$iv;
        Iterable $this$filter$iv = csvPairs;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!dbPairs2.remove(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CsvUploadStatus uploadCorrectEmails(String executionId, List<CsvRecordResult.CorrectedEmailResult> correctedRecords, EmailCheckType checkType) {
        Object it;
        EmailCheckType emailCheckType = checkType;
        if (emailCheckType != null) {
            it = emailCheckType;
            boolean bl = false;
            this.deleteByEmailCheckType((EmailCheckType)it, UDCMode.BASIC);
        }
        CsvUploadStatus csvUploadStatus = this.recordCorrectedEmailData(correctedRecords);
        it = csvUploadStatus;
        boolean bl = false;
        if (it instanceof CsvUploadStatus.CsvUploadSuccess) {
            this.postEvent(((CsvUploadStatus.CsvUploadSuccess)it).getNumberOfRecords(), executionId);
            log.info("CSV file uploaded successfully with " + ((CsvUploadStatus.CsvUploadSuccess)it).getNumberOfRecords() + " records for executionId=" + executionId);
        }
        return csvUploadStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EmailData> validateNewEmails(List<CsvRecordResult.CorrectedEmailResult> correctedRecords, String executionId, CloudSite cloudSite2, String containerToken) {
        void $this$fold$iv;
        void initial$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite2);
        Iterable iterable = correctedRecords;
        boolean $i$f$map22 = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void correctedEmailResult;
            CsvRecordResult.CorrectedEmailResult correctedEmailResult2 = (CsvRecordResult.CorrectedEmailResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(correctedEmailResult.getCorrectedUserFileRecord());
        }
        $this$map$iv = (List)destination$iv$iv;
        Pair $i$f$map22 = new Pair((Object)new ArrayList(), (Object)new ArrayList());
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void userRecord;
            void var16_20;
            Object item$iv$iv;
            item$iv$iv = (CorrectedUserFileRecord)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            void $this$validateNewEmails_u24lambda_u2412_u24lambda_u2411 = var16_20 = acc;
            boolean bl2 = false;
            ApplicationUser applicationUser = this.userManager.getUserByKey(userRecord.getUserKey());
            if (applicationUser == null) {
                ((List)acc.getFirst()).add(new EmailData(userRecord.getUserName(), userRecord.getNewEmail()));
            } else {
                ((List)acc.getSecond()).add(JiraUser.copy$default(JiraUser.Companion.fromApplicationUser(applicationUser), userRecord.getNewEmail(), null, false, null, null, null, null, null, null, 510, null));
            }
            accumulator$iv = var16_20;
        }
        void var6_24 = accumulator$iv;
        List invalidEmails = (List)var6_24.component1();
        List jiraUsers = (List)var6_24.component2();
        if (!((Collection)invalidEmails).isEmpty()) {
            return invalidEmails;
        }
        CheckResult checkResult = this.invalidEmailService.validate(executionId, containerToken, migrationScopeId2, jiraUsers);
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        return EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map);
    }

    private final void postEvent(int numberOfRecords, String executionId) {
        this.migrationEventBus.post(new EmailCorrectionEvent(executionId, numberOfRecords));
    }

    private final boolean verifyFileFixesAllGivenUsers(List<CsvRecordResult.CorrectedEmailResult> listOfCorrectedEmails) {
        int n;
        int n2;
        Iterable $this$count$iv = listOfCorrectedEmails;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CsvRecordResult.CorrectedEmailResult result2 = (CsvRecordResult.CorrectedEmailResult)element$iv;
                boolean bl = false;
                if (!(result2.getCorrectedUserFileRecord().getType() == EmailCheckType.DUP) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int duplicatedEmailsCount = n2;
        Iterable $this$count$iv2 = listOfCorrectedEmails;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                CsvRecordResult.CorrectedEmailResult result3 = (CsvRecordResult.CorrectedEmailResult)element$iv;
                boolean bl = false;
                if (!(result3.getCorrectedUserFileRecord().getType() == EmailCheckType.INV) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int invalidEmailsCount = n;
        Pair<Long, Long> pair = this.getEmailsCount();
        long invalidUsersFromScan = ((Number)pair.component1()).longValue();
        long duplicatedUsersFromScan = ((Number)pair.component2()).longValue();
        if (invalidUsersFromScan + duplicatedUsersFromScan > 0L && duplicatedEmailsCount == 0 && invalidEmailsCount == 0) {
            return false;
        }
        if (invalidUsersFromScan > 0L && (long)invalidEmailsCount > 0L && invalidUsersFromScan != (long)invalidEmailsCount) {
            return false;
        }
        return duplicatedUsersFromScan <= 0L || (long)duplicatedEmailsCount <= 0L || duplicatedUsersFromScan == (long)duplicatedEmailsCount;
    }

    private final Pair<Long, Long> getEmailsCount() {
        UserBaseScan userBaseScan = this.userBaseScanRepository.getLatestStarted();
        Intrinsics.checkNotNull((Object)userBaseScan);
        UserBaseScan latestStarted = userBaseScan;
        return new Pair((Object)(latestStarted.getInvalidUsersCount() + latestStarted.getInvalidCustomersCount()), (Object)(latestStarted.getDuplicatedUsersCount() + latestStarted.getDuplicatedCustomersCount()));
    }

    @VisibleForTesting
    @Nullable
    public final CsvRecordResult readCsvLine(@org.jetbrains.annotations.NotNull CsvBeanReader reader) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            CsvRecordResult.CorrectedEmailResult correctedEmailResult;
            CellProcessor[] cellProcessorArray = new CellProcessor[]{new CsvUtil.StrNotBlank((CellProcessor)new StrMinMax(1L, 255L)), new CsvUtil.StrNotBlank((CellProcessor)new StrMinMax(1L, 255L)), new NotNull((CellProcessor)new Trim((StringCellProcessor)new ParseEnum(EmailCheckType.class))), new Optional((CellProcessor)new Trim()), new NotNull((CellProcessor)new Trim((StringCellProcessor)new StrMinMax(1L, 450L))), new NotNull((CellProcessor)new Trim((StringCellProcessor)new ParseBool()))};
            object = (CorrectedUserFileRecord)reader.read(CorrectedUserFileRecord.class, ModelKt.getFileHeaders(), cellProcessorArray);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                correctedEmailResult = new CsvRecordResult.CorrectedEmailResult((CorrectedUserFileRecord)it);
            } else {
                correctedEmailResult = null;
            }
            object = correctedEmailResult;
        }
        catch (SuperCsvCellProcessorException ex) {
            object = new CsvRecordResult.CsvRecordError("Message= [" + ex.getLocalizedMessage() + "] row= " + ex.getCsvContext().getRowNumber() + ", column=" + ex.getCsvContext().getColumnNumber());
        }
        catch (IllegalArgumentException ex) {
            String string = ex.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
            object = new CsvRecordResult.CsvRecordError(string);
        }
        return object;
    }

    private final CsvUploadStatus recordCorrectedEmailData(List<CsvRecordResult.CorrectedEmailResult> correctedRecords) {
        CsvUploadStatus csvUploadStatus;
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)correctedRecords), (Function1)recordCorrectedEmailData.aggregateResult.1.INSTANCE), (Function1)((Function1)new Function1<CorrectedUserFileRecord, CorrectedEmail>((Object)this){

            @org.jetbrains.annotations.NotNull
            public final CorrectedEmail invoke(@org.jetbrains.annotations.NotNull CorrectedUserFileRecord p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CorrectedEmailService.access$toCorrectedEmail((CorrectedEmailService)this.receiver, p0);
            }
        }));
        String string = this.jiraAuthenticationContext.getLoggedInUser().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        BatchUpsertResultAggregator.FailFastAggregateResult<CorrectedEmail> aggregateResult2 = this.batchUpsertResultAggregator.aggregateFailFast(this.correctedEmailRepository.upsert((Sequence<CorrectedEmail>)sequence, string));
        BatchUpsertResult.Failed<CorrectedEmail> failed = aggregateResult2.getFailed();
        if (failed != null) {
            BatchUpsertResult.Failed<CorrectedEmail> it = failed;
            boolean bl = false;
            csvUploadStatus = new CsvUploadStatus.CsvRecordInsertFailed(it.getError().getLocalizedMessage() + ", Please check the server log");
        } else {
            csvUploadStatus = new CsvUploadStatus.CsvUploadSuccess(correctedRecords.size());
        }
        return csvUploadStatus;
    }

    @org.jetbrains.annotations.NotNull
    public final List<CorrectedEmail> fetchByEmailCheckType(@Nullable EmailCheckType type, @org.jetbrains.annotations.NotNull UDCMode udcMode, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.fetchByEmailCheckType(type, udcMode, draft);
    }

    public static /* synthetic */ List fetchByEmailCheckType$default(CorrectedEmailService correctedEmailService, EmailCheckType emailCheckType, UDCMode uDCMode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return correctedEmailService.fetchByEmailCheckType(emailCheckType, uDCMode, bl);
    }

    public final long deleteByEmailCheckType(@org.jetbrains.annotations.NotNull EmailCheckType type, @org.jetbrains.annotations.NotNull UDCMode udcMode) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.deleteByEmailCheckType(type, udcMode);
    }

    public final long deleteDraft(@org.jetbrains.annotations.NotNull UDCMode udcMode) {
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.deleteDraft(udcMode);
    }

    public final long deleteByUdcMode(@org.jetbrains.annotations.NotNull UDCMode udcMode) {
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.deleteByUdcMode(udcMode);
    }

    public final long changeDraftDataToConfirmed(@org.jetbrains.annotations.NotNull UDCMode udcMode) {
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.changeDraftDataToConfirmed(udcMode);
    }

    public final boolean isRecordFoundForEmailCheckType(@org.jetbrains.annotations.NotNull EmailCheckType type, @org.jetbrains.annotations.NotNull UDCMode udcMode, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.isRecordFoundForEmailCheckType(type, udcMode, draft);
    }

    public static /* synthetic */ boolean isRecordFoundForEmailCheckType$default(CorrectedEmailService correctedEmailService, EmailCheckType emailCheckType, UDCMode uDCMode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return correctedEmailService.isRecordFoundForEmailCheckType(emailCheckType, uDCMode, bl);
    }

    public final boolean isAnyRecordFound(@org.jetbrains.annotations.NotNull UDCMode udcMode, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.isAnyRecordFound(udcMode, draft);
    }

    public static /* synthetic */ boolean isAnyRecordFound$default(CorrectedEmailService correctedEmailService, UDCMode uDCMode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return correctedEmailService.isAnyRecordFound(uDCMode, bl);
    }

    public final long countByCheckType(@org.jetbrains.annotations.NotNull EmailCheckType type, @org.jetbrains.annotations.NotNull UDCMode udcMode, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.countByCheckType(type, udcMode, draft);
    }

    public static /* synthetic */ long countByCheckType$default(CorrectedEmailService correctedEmailService, EmailCheckType emailCheckType, UDCMode uDCMode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return correctedEmailService.countByCheckType(emailCheckType, uDCMode, bl);
    }

    @org.jetbrains.annotations.NotNull
    public final List<String> findUserKeysByCheckType(@org.jetbrains.annotations.NotNull EmailCheckType type, @org.jetbrains.annotations.NotNull UDCMode udcMode, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        return this.correctedEmailRepository.findUserKeysByType(type, udcMode, draft);
    }

    public static /* synthetic */ List findUserKeysByCheckType$default(CorrectedEmailService correctedEmailService, EmailCheckType emailCheckType, UDCMode uDCMode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return correctedEmailService.findUserKeysByCheckType(emailCheckType, uDCMode, bl);
    }

    public final boolean hasCorrectedByTombstoning(@org.jetbrains.annotations.NotNull String userKey, @org.jetbrains.annotations.NotNull UDCMode udcMode) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        CorrectedEmail correctedEmail = this.correctedEmailRepository.findByUserKeyOrNull(userKey, udcMode);
        return correctedEmail != null ? correctedEmail.getTombstone() : false;
    }

    @org.jetbrains.annotations.NotNull
    public final AdvancedCsvState getStateForAdvancedMode(boolean draft) {
        boolean isCsvUploaded = this.isAnyRecordFound(UDCMode.ADVANCED, draft);
        boolean confirmedConfigurationExists = draft ? this.isAnyRecordFound(UDCMode.ADVANCED, false) : isCsvUploaded;
        return isCsvUploaded ? new AdvancedCsvState(true, this.isCsvOutdatedForCheckType(EmailCheckType.INV, UDCMode.ADVANCED, draft), this.isCsvOutdatedForCheckType(EmailCheckType.DUP, UDCMode.ADVANCED, draft), confirmedConfigurationExists, false, 16, null) : new AdvancedCsvState(false, false, false, confirmedConfigurationExists, false, 16, null);
    }

    @org.jetbrains.annotations.NotNull
    public final CsvState getStateForBasicMode(@org.jetbrains.annotations.NotNull EmailCheckType checkType) {
        Intrinsics.checkNotNullParameter((Object)checkType, (String)"checkType");
        boolean isCsvUploaded = CorrectedEmailService.isRecordFoundForEmailCheckType$default(this, checkType, UDCMode.BASIC, false, 4, null);
        boolean isCsvOutdated = isCsvUploaded && CorrectedEmailService.isCsvOutdatedForCheckType$default(this, checkType, UDCMode.BASIC, false, 4, null);
        return new CsvState(isCsvUploaded, isCsvOutdated);
    }

    private final boolean isCsvOutdatedForCheckType(EmailCheckType checkType, UDCMode udcMode, boolean draft) {
        String string;
        UserBaseScan userBaseScan = this.userBaseScanRepository.getLatestStarted();
        if (userBaseScan != null && (string = userBaseScan.getId()) != null) {
            List<String> correctedEmailUserKeys;
            String it = string;
            boolean bl = false;
            if (this.incorrectEmailRepository.countByTypeAndExecutionId(it, checkType) != this.countByCheckType(checkType, udcMode, draft)) {
                return true;
            }
            List<String> incorrectEmailUserKeys = this.incorrectEmailRepository.findUserKeysByTypeAndExecutionId(it, checkType);
            return !incorrectEmailUserKeys.containsAll((Collection)(correctedEmailUserKeys = this.findUserKeysByCheckType(checkType, udcMode, draft))) || !correctedEmailUserKeys.containsAll((Collection)incorrectEmailUserKeys);
        }
        return false;
    }

    static /* synthetic */ boolean isCsvOutdatedForCheckType$default(CorrectedEmailService correctedEmailService, EmailCheckType emailCheckType, UDCMode uDCMode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return correctedEmailService.isCsvOutdatedForCheckType(emailCheckType, uDCMode, bl);
    }

    private final CorrectedEmail toCorrectedEmail(CorrectedUserFileRecord correctedUserFileRecord) {
        CorrectedUserFileRecord $this$toCorrectedEmail_u24lambda_u2418 = correctedUserFileRecord;
        boolean bl = false;
        return new CorrectedEmail($this$toCorrectedEmail_u24lambda_u2418.getUserKey(), $this$toCorrectedEmail_u24lambda_u2418.getUserName(), $this$toCorrectedEmail_u24lambda_u2418.getType(), $this$toCorrectedEmail_u24lambda_u2418.getOldEmail(), $this$toCorrectedEmail_u24lambda_u2418.getNewEmail(), $this$toCorrectedEmail_u24lambda_u2418.getTombstone(), null, UDCMode.BASIC, false, null, 576, null);
    }

    /*
     * WARNING - void declaration
     */
    @org.jetbrains.annotations.NotNull
    public final CorrectedEmails loadAllCorrectedEmails(boolean skipValidation) {
        List allCorrectedEmail = CorrectedEmailRepository.fetchAll$default(this.correctedEmailRepository, UDCMode.BASIC, false, 2, null);
        if (!skipValidation) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv;
            Object it;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = allCorrectedEmail;
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CorrectedEmail correctedEmail = (CorrectedEmail)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(((CorrectedEmail)it).getNewEmail());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                it = (String)element$iv$iv;
                boolean bl = false;
                String string = ((String)it).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String key$iv$iv = IdentityAcceptedEmailValidator.cleanse((String)string);
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv.values();
            boolean $i$f$filter = false;
            $this$groupByTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (List)element$iv$iv;
                boolean bl = false;
                if (!(it.size() > 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (List)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(CollectionsKt.toSet((Iterable)((Iterable)it)));
            }
            List duplicates = CollectionsKt.toList((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            if (!((Collection)duplicates).isEmpty()) {
                return new CorrectedEmails.DuplicatesValidationError(new DuplicatedEmails(duplicates));
            }
        }
        return new CorrectedEmails.Stream(arg_0 -> CorrectedEmailService.loadAllCorrectedEmails$lambda$25(allCorrectedEmail, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadAllCorrectedEmails$lambda$25(List $allCorrectedEmail, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)$allCorrectedEmail, (String)"$allCorrectedEmail");
        Closeable closeable = (Closeable)new CsvBeanWriter((Writer)new OutputStreamWriter(it, StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);
        Throwable throwable = null;
        try {
            CsvBeanWriter writer = (CsvBeanWriter)closeable;
            boolean bl = false;
            String[] stringArray = ModelKt.getFileHeaders();
            writer.writeHeader(Arrays.copyOf(stringArray, stringArray.length));
            Iterable $this$forEach$iv = $allCorrectedEmail;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CorrectedEmail record = (CorrectedEmail)element$iv;
                boolean bl2 = false;
                String[] stringArray2 = ModelKt.getFileHeaders();
                writer.write((Object)record.toFileRecord(), Arrays.copyOf(stringArray2, stringArray2.length));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ CorrectedEmail access$toCorrectedEmail(CorrectedEmailService $this, CorrectedUserFileRecord correctedUserFileRecord) {
        return $this.toCorrectedEmail(correctedUserFileRecord);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/email/CorrectedEmailService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

