/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.jira.migration.email.db.EmailRepositoryCleaner;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\fH\u0007J\b\u0010\u0013\u001a\u00020\fH\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/email/EmailCleanupService;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "emailRepositoryCleaner", "Lcom/atlassian/jira/migration/email/db/EmailRepositoryCleaner;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/email/db/EmailRepositoryCleaner;)V", "cleanup", "", "migrationId", "", "onMigrationStatusUpdate", "event", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "postConstruct", "preDestroy", "jira-migration-plugin"})
public final class EmailCleanupService {
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final EmailRepositoryCleaner emailRepositoryCleaner;

    @Inject
    public EmailCleanupService(@NotNull MigrationEventBus migrationEventBus, @NotNull PlanRepository planRepository, @NotNull MigrationRepository migrationRepository, @NotNull EmailRepositoryCleaner emailRepositoryCleaner) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)emailRepositoryCleaner, (String)"emailRepositoryCleaner");
        this.migrationEventBus = migrationEventBus;
        this.planRepository = planRepository;
        this.migrationRepository = migrationRepository;
        this.emailRepositoryCleaner = emailRepositoryCleaner;
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    @Subscribe
    public final void onMigrationStatusUpdate(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (MigrationStatusUpdatedEvent.Status.ERRORED == event.getStatus() || MigrationStatusUpdatedEvent.Status.FINISHED == event.getStatus() || MigrationStatusUpdatedEvent.Status.CANCELLED == event.getStatus()) {
            this.cleanup(event.getMigrationId());
        }
    }

    private final void cleanup(String migrationId) {
        block1: {
            String string = this.migrationRepository.findPlanIdByMigrationId(migrationId);
            if (string == null) break block1;
            String planId = string;
            boolean bl = false;
            Plan plan2 = this.planRepository.get(planId);
            if (plan2 != null) {
                Plan plan3 = plan2;
                boolean bl2 = false;
                this.emailRepositoryCleaner.cleanup(plan3.getPreflightCheckExecutionId());
            }
        }
    }
}

