/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.email.EmailConfig;
import com.atlassian.jira.migration.email.EmailConfigServiceKt;
import com.atlassian.jira.migration.utils.LocalDateSerializerUtilKt;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0013R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/email/EmailConfigService;", "", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "pluginSettings", "Lcom/atlassian/sal/api/pluginsettings/PluginSettings;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettings;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "cutOffMillisForMergeDuplicateEmails", "", "getCutOffMillisForMergeDuplicateEmails", "()J", "cutOffMillisForTombstoneInvalidEmails", "getCutOffMillisForTombstoneInvalidEmails", "getConfig", "Lcom/atlassian/jira/migration/email/EmailConfig;", "postConstruct", "", "saveConfig", "emailConfig", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailConfigService.kt\ncom/atlassian/jira/migration/email/EmailConfigService\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,126:1\n51#2:127\n*S KotlinDebug\n*F\n+ 1 EmailConfigService.kt\ncom/atlassian/jira/migration/email/EmailConfigService\n*L\n55#1:127\n*E\n"})
public final class EmailConfigService {
    @NotNull
    private final PluginSettings pluginSettings;
    @NotNull
    private final ObjectMapper objectMapper;

    public EmailConfigService(@NotNull PluginSettings pluginSettings, @NotNull ObjectMapper objectMapper2) {
        Intrinsics.checkNotNullParameter((Object)pluginSettings, (String)"pluginSettings");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        this.pluginSettings = pluginSettings;
        this.objectMapper = objectMapper2;
    }

    @PostConstruct
    public final void postConstruct() {
        if (this.getConfig() == null) {
            this.saveConfig(new EmailConfig(EmailConfig.Scope.BEFORE_DAY, EmailConfig.Scope.BEFORE_DAY, LocalDate.parse("1900-01-01", LocalDateSerializerUtilKt.getConfigDateFormat()), LocalDate.parse("1900-01-01", LocalDateSerializerUtilKt.getConfigDateFormat())));
        }
    }

    @Inject
    public EmailConfigService(@NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pluginSettings, (String)"createGlobalSettings(...)");
        this(pluginSettings, objectMapperFactory.createObjectMapper());
    }

    public final void saveConfig(@NotNull EmailConfig emailConfig) {
        Intrinsics.checkNotNullParameter((Object)emailConfig, (String)"emailConfig");
        this.pluginSettings.put("com.atlassian.jira.migration.jira-migration-plugin:emailConfig", (Object)this.objectMapper.writeValueAsString((Object)emailConfig));
    }

    @Nullable
    public final EmailConfig getConfig() {
        EmailConfig emailConfig;
        String string = (String)this.pluginSettings.get("com.atlassian.jira.migration.jira-migration-plugin:emailConfig");
        if (string != null) {
            String it = string;
            boolean bl = false;
            boolean $i$f$jacksonTypeRef = false;
            emailConfig = (EmailConfig)this.objectMapper.readValue(it, (TypeReference)new TypeReference<EmailConfig>(){});
        } else {
            emailConfig = null;
        }
        return emailConfig;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long getCutOffMillisForMergeDuplicateEmails() {
        long l;
        Object object = this.getConfig();
        if (object != null) {
            Long l2;
            EmailConfig $this$_get_cutOffMillisForMergeDuplicateEmails__u24lambda_u241 = object;
            boolean bl = false;
            EmailConfig.Scope scope = $this$_get_cutOffMillisForMergeDuplicateEmails__u24lambda_u241.getDuplicateMergeScope();
            switch (scope == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
                case 1: {
                    l2 = Long.MAX_VALUE;
                    break;
                }
                case 2: {
                    LocalDate localDate = $this$_get_cutOffMillisForMergeDuplicateEmails__u24lambda_u241.getDuplicateMergeDate();
                    if (localDate != null) {
                        l2 = EmailConfigServiceKt.toMillis(localDate);
                        break;
                    }
                    l2 = null;
                    break;
                }
                default: {
                    l2 = null;
                }
            }
            object = l2;
            if (l2 != null) {
                l = (Long)object;
                return l;
            }
        }
        l = EmailConfigServiceKt.neverLogInMillis();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long getCutOffMillisForTombstoneInvalidEmails() {
        long l;
        Object object = this.getConfig();
        if (object != null) {
            Long l2;
            EmailConfig $this$_get_cutOffMillisForTombstoneInvalidEmails__u24lambda_u242 = object;
            boolean bl = false;
            EmailConfig.Scope scope = $this$_get_cutOffMillisForTombstoneInvalidEmails__u24lambda_u242.getTombstoneScope();
            switch (scope == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
                case 1: {
                    l2 = Long.MAX_VALUE;
                    break;
                }
                case 2: {
                    LocalDate localDate = $this$_get_cutOffMillisForTombstoneInvalidEmails__u24lambda_u242.getTombstoneDate();
                    if (localDate != null) {
                        l2 = EmailConfigServiceKt.toMillis(localDate);
                        break;
                    }
                    l2 = null;
                    break;
                }
                default: {
                    l2 = null;
                }
            }
            object = l2;
            if (l2 != null) {
                l = (Long)object;
                return l;
            }
        }
        l = EmailConfigServiceKt.neverLogInMillis();
        return l;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EmailConfig.Scope.values().length];
            try {
                nArray[EmailConfig.Scope.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmailConfig.Scope.BEFORE_DAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

