/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ResourceInputFactory;
import com.atlassian.jira.migration.email.FileCreationResult;
import com.atlassian.jira.migration.email.OutputStreamWritingResult;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/email/EmailCsvFileService;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "resourceInputFactory", "Lcom/atlassian/jira/migration/common/ResourceInputFactory;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/common/ResourceInputFactory;)V", "createNewFile", "Ljava/nio/file/Path;", "path", "tryCreateCsv", "Lcom/atlassian/jira/migration/email/FileCreationResult;", "preflightExecutionId", "", "prefix", "tryDeleteCsv", "", "success", "Lcom/atlassian/jira/migration/email/FileCreationResult$Success;", "writeAsZip", "Lcom/atlassian/jira/migration/email/OutputStreamWritingResult;", "fileCreated", "outputStream", "Ljava/io/OutputStream;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailCsvFileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailCsvFileService.kt\ncom/atlassian/jira/migration/email/EmailCsvFileService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class EmailCsvFileService {
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final ResourceInputFactory resourceInputFactory;

    @Inject
    public EmailCsvFileService(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull ResourceInputFactory resourceInputFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)resourceInputFactory, (String)"resourceInputFactory");
        this.localFileDataOutput = localFileDataOutput;
        this.resourceInputFactory = resourceInputFactory;
    }

    @NotNull
    public final FileCreationResult tryCreateCsv(@NotNull String preflightExecutionId, @NotNull String prefix2) {
        FileCreationResult fileCreationResult;
        Intrinsics.checkNotNullParameter((Object)preflightExecutionId, (String)"preflightExecutionId");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        try {
            Path dir = this.localFileDataOutput.migrationCheckDirectory(preflightExecutionId);
            boolean bl = false;
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            long now = Instant.now().toEpochMilli();
            Path file2 = dir.resolve(prefix2 + '-' + preflightExecutionId + '-' + now + ".csv");
            Intrinsics.checkNotNull((Object)file2);
            Path p0 = this.createNewFile(file2);
            boolean bl2 = false;
            File it = p0.toFile();
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            fileCreationResult = new FileCreationResult.Success(preflightExecutionId, it);
        }
        catch (Throwable e) {
            fileCreationResult = new FileCreationResult.Failed(preflightExecutionId, e);
        }
        return fileCreationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final OutputStreamWritingResult writeAsZip(@NotNull FileCreationResult.Success fileCreated, @NotNull OutputStream outputStream) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileCreated, (String)"fileCreated");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        FileCreationResult.Success $this$writeAsZip_u24lambda_u244 = fileCreated;
        boolean bl = false;
        try {
            object = new ZipOutputStream(new BufferedOutputStream(outputStream));
            Throwable throwable = null;
            try {
                Unit unit;
                ZipOutputStream zipOut = (ZipOutputStream)object;
                boolean bl2 = false;
                com.atlassian.migration.udc.file.LocalFileDataOutput localFileDataOutput = this.localFileDataOutput;
                Path path = $this$writeAsZip_u24lambda_u244.getFile().toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                com.atlassian.migration.udc.file.LocalFileDataOutput.addToZip$default((com.atlassian.migration.udc.file.LocalFileDataOutput)localFileDataOutput, (ZipOutputStream)zipOut, (Path)path, null, (int)4, null);
                InputStream inputStream = this.resourceInputFactory.emailReadme();
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    Throwable throwable2 = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl3 = false;
                        this.localFileDataOutput.addToZip(zipOut, "readme.txt", it);
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit3 = unit;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            String string = $this$writeAsZip_u24lambda_u244.getFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = StringsKt.replace$default((String)string, (String)"\\.csv$", (String)".zip", (boolean)false, (int)4, null);
            object = new OutputStreamWritingResult.Success($this$writeAsZip_u24lambda_u244.getExecutionId(), outputStream, name);
        }
        catch (Throwable e) {
            object = new OutputStreamWritingResult.Failed($this$writeAsZip_u24lambda_u244.getExecutionId(), outputStream, e);
        }
        return object;
    }

    private final Path createNewFile(Path path) {
        Comparable<Path> comparable = path;
        Path p0 = comparable;
        boolean bl = false;
        Files.deleteIfExists(p0);
        p0 = comparable;
        boolean bl2 = false;
        p0 = Files.createFile(p0, new FileAttribute[0]);
        boolean bl3 = false;
        comparable = p0.toFile();
        p0 = comparable;
        boolean bl4 = false;
        ((File)((Object)p0)).deleteOnExit();
        Path path2 = ((File)comparable).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        return path2;
    }

    public final void tryDeleteCsv(@NotNull FileCreationResult.Success success) {
        Intrinsics.checkNotNullParameter((Object)success, (String)"success");
        try {
            Files.deleteIfExists(success.getFile().toPath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

