/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.jira.migration.email.BatchUpsertResultAggregator;
import com.atlassian.jira.migration.email.EmailTrustedDomainServiceKt;
import com.atlassian.jira.migration.email.db.EmailTrustedDomainRepository;
import com.atlassian.jira.migration.email.model.BatchUpsertResult;
import com.atlassian.jira.migration.email.model.EmailTrustedDomain;
import com.atlassian.jira.migration.email.model.EmailTrustedDomainRecord;
import com.atlassian.jira.migration.email.model.ModelKt;
import com.atlassian.jira.migration.email.model.UserEmailDomain;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.TrustedDomainsUpdatedEvent;
import com.atlassian.jira.migration.utils.CsvUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.Trim;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.util.CsvContext;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 =2\u00020\u0001:\u0004=>?@B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ&\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0016H\u0002J\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020\u001e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0 H\u0002J\u0006\u0010/\u001a\u00020\fJ\u0014\u00100\u001a\u00020\f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\u0010\u00102\u001a\u00020\t2\u0006\u00103\u001a\u000204H\u0002J\u000e\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\tJ\u0016\u00107\u001a\u0002082\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0 H\u0002J$\u00109\u001a\u0002082\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0 2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u000fH\u0002J$\u0010<\u001a\u0002082\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0 2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u000fH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;", "", "emailTrustedDomainRepository", "Lcom/atlassian/jira/migration/email/db/EmailTrustedDomainRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/email/db/EmailTrustedDomainRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "batchUpsertResultAggregator", "Lcom/atlassian/jira/migration/email/BatchUpsertResultAggregator;", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomain;", "(Lcom/atlassian/jira/migration/email/db/EmailTrustedDomainRepository;Lcom/atlassian/jira/migration/email/BatchUpsertResultAggregator;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "batchDeleteAllBlockedDomains", "", "batchDeleteStaleDomains", "domainsFromUsers", "", "Lcom/atlassian/jira/migration/email/model/UserEmailDomain;", "batchUpsertBlockedDomains", "blockedDomains", "batchUpsertNonBlockedDomains", "nonBlockedDomains", "countByReviewMethod", "", "reviewMethod", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomain$ReviewMethod;", "getAllDomains", "getNotBlockedDomains", "getPersistedBlockedDomains", "getTrustedDomains", "performValidation", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus;", "errors", "", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult$CsvDomainRecordError;", "domainDecisions", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult$EmailDomainDecisionResult;", "postEvent", "numberOfRecords", "processDomainCsvContent", "inputStream", "Ljava/io/InputStream;", "readCsvLine", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult;", "reader", "Lorg/supercsv/io/CsvBeanReader;", "recordAllTrustedDomainData", "emailDomainDecisionRecords", "resetUserModifiedDomainRules", "setDomains", "domains", "toEmailTrustedDomain", "emailTrustedDomainRecord", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomainRecord;", "updateTrustedDomain", "trustedDomain", "verifyFileDoesntIncludeInvalidRules", "", "verifyFileIncludesCorrectNumberOfDomains", "domainNames", "", "verifyFileIncludesOnlyValidDomains", "Companion", "CsvDomainRecordResult", "CsvDomainUploadStatus", "NotBlank", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailTrustedDomainService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailTrustedDomainService.kt\ncom/atlassian/jira/migration/email/EmailTrustedDomainService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,316:1\n1284#2,3:317\n1#3:320\n1549#4:321\n1620#4,3:322\n1549#4:325\n1620#4,3:326\n1549#4:329\n1620#4,3:330\n766#4:333\n857#4,2:334\n1549#4:336\n1620#4,3:337\n2624#4,3:340\n766#4:343\n857#4,2:344\n1549#4:346\n1620#4,3:347\n819#4:354\n847#4,2:355\n766#4:357\n857#4,2:358\n1549#4:360\n1620#4,3:361\n1549#4:364\n1620#4,3:365\n1549#4:368\n1620#4,3:369\n11065#5:350\n11400#5,3:351\n*S KotlinDebug\n*F\n+ 1 EmailTrustedDomainService.kt\ncom/atlassian/jira/migration/email/EmailTrustedDomainService\n*L\n90#1:317,3\n132#1:321\n132#1:322,3\n155#1:325\n155#1:326,3\n173#1:329\n173#1:330,3\n175#1:333\n175#1:334,2\n194#1:336\n194#1:337,3\n224#1:340,3\n227#1:343\n227#1:344,2\n228#1:346\n228#1:347,3\n236#1:354\n236#1:355,2\n238#1:357\n238#1:358,2\n241#1:360\n241#1:361,3\n251#1:364\n251#1:365,3\n252#1:368\n252#1:369,3\n235#1:350\n235#1:351,3\n*E\n"})
public final class EmailTrustedDomainService {
    @org.jetbrains.annotations.NotNull
    public static final Companion Companion = new Companion(null);
    @org.jetbrains.annotations.NotNull
    private final EmailTrustedDomainRepository emailTrustedDomainRepository;
    @org.jetbrains.annotations.NotNull
    private final BatchUpsertResultAggregator<EmailTrustedDomain> batchUpsertResultAggregator;
    @org.jetbrains.annotations.NotNull
    private final MigrationEventBus migrationEventBus;
    public static final long minCsvEntryLength = 1L;
    public static final long maxCsvEntryLength = 255L;

    public EmailTrustedDomainService(@org.jetbrains.annotations.NotNull EmailTrustedDomainRepository emailTrustedDomainRepository, @org.jetbrains.annotations.NotNull BatchUpsertResultAggregator<EmailTrustedDomain> batchUpsertResultAggregator, @org.jetbrains.annotations.NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)emailTrustedDomainRepository, (String)"emailTrustedDomainRepository");
        Intrinsics.checkNotNullParameter(batchUpsertResultAggregator, (String)"batchUpsertResultAggregator");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.emailTrustedDomainRepository = emailTrustedDomainRepository;
        this.batchUpsertResultAggregator = batchUpsertResultAggregator;
        this.migrationEventBus = migrationEventBus;
    }

    @Inject
    public EmailTrustedDomainService(@org.jetbrains.annotations.NotNull EmailTrustedDomainRepository emailTrustedDomainRepository, @org.jetbrains.annotations.NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)emailTrustedDomainRepository, (String)"emailTrustedDomainRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this(emailTrustedDomainRepository, new BatchUpsertResultAggregator<EmailTrustedDomain>(), migrationEventBus);
    }

    @org.jetbrains.annotations.NotNull
    public final List<EmailTrustedDomain> getAllDomains() {
        return this.emailTrustedDomainRepository.findAllForSite();
    }

    @org.jetbrains.annotations.NotNull
    public final List<EmailTrustedDomain> getTrustedDomains() {
        return this.emailTrustedDomainRepository.findAllTrustedDomainsForSite();
    }

    @org.jetbrains.annotations.NotNull
    public final List<EmailTrustedDomain> getNotBlockedDomains() {
        return this.emailTrustedDomainRepository.findAllNotBlockedDomainsForSite();
    }

    @org.jetbrains.annotations.NotNull
    public final List<EmailTrustedDomain> getPersistedBlockedDomains() {
        return this.emailTrustedDomainRepository.findAllBlockedDomainsForSite();
    }

    public final void setDomains(@org.jetbrains.annotations.NotNull List<EmailTrustedDomain> domains) {
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        this.emailTrustedDomainRepository.setAllForSite(domains);
    }

    @org.jetbrains.annotations.NotNull
    public final Object updateTrustedDomain(@org.jetbrains.annotations.NotNull EmailTrustedDomain trustedDomain) {
        Intrinsics.checkNotNullParameter((Object)trustedDomain, (String)"trustedDomain");
        return this.emailTrustedDomainRepository.upsert(trustedDomain, false);
    }

    public final void resetUserModifiedDomainRules() {
        this.emailTrustedDomainRepository.resetUserModifiedDomainRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @org.jetbrains.annotations.NotNull
    public final CsvDomainUploadStatus processDomainCsvContent(@org.jetbrains.annotations.NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Closeable closeable = (Closeable)new CsvBeanReader((Reader)new InputStreamReader(inputStream), CsvUtil.INSTANCE.determineCsvPreference(inputStream));
        Throwable throwable = null;
        try {
            List emailDomainDecisionRecords;
            void $this$fold$iv;
            void initial$iv;
            Object reader = (CsvBeanReader)closeable;
            boolean bl = false;
            reader.getHeader(true);
            Sequence sequence = SequencesKt.generateSequence((Function0)((Function0)new Function0<CsvDomainRecordResult>(this, reader){
                final /* synthetic */ EmailTrustedDomainService this$0;
                final /* synthetic */ CsvBeanReader $reader;
                {
                    this.this$0 = $receiver;
                    this.$reader = $reader;
                    super(0);
                }

                @Nullable
                public final CsvDomainRecordResult invoke() {
                    return EmailTrustedDomainService.access$readCsvLine(this.this$0, this.$reader);
                }
            }));
            Pair pair = new Pair((Object)new ArrayList(), (Object)new ArrayList());
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void res;
                void var15_18;
                CsvDomainRecordResult csvDomainRecordResult = (CsvDomainRecordResult)element$iv;
                void acc = accumulator$iv;
                boolean bl2 = false;
                void $this$processDomainCsvContent_u24lambda_u242_u24lambda_u241_u24lambda_u240 = var15_18 = acc;
                boolean bl3 = false;
                void var18_21 = res;
                if (var18_21 instanceof CsvDomainRecordResult.CsvDomainRecordError) {
                    ((List)acc.getFirst()).add(res);
                } else if (var18_21 instanceof CsvDomainRecordResult.EmailDomainDecisionResult) {
                    ((List)acc.getSecond()).add(res);
                }
                accumulator$iv = var15_18;
            }
            void var19_22 = accumulator$iv;
            List errorRecords = (List)var19_22.component1();
            CsvDomainUploadStatus csvDomainUploadStatus = this.performValidation(errorRecords, emailDomainDecisionRecords = (List)var19_22.component2());
            if (csvDomainUploadStatus == null) {
                csvDomainUploadStatus = this.recordAllTrustedDomainData(emailDomainDecisionRecords);
            }
            reader = csvDomainUploadStatus;
        }
        catch (Throwable reader) {
            throwable = reader;
            throw reader;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Closeable it = closeable = reader;
        boolean bl = false;
        if (it instanceof CsvDomainUploadStatus.CsvDomainUploadSuccess) {
            this.postEvent(((CsvDomainUploadStatus.CsvDomainUploadSuccess)((Object)it)).getNumberOfRecords());
        }
        return closeable;
    }

    private final CsvDomainRecordResult readCsvLine(CsvBeanReader reader) {
        Object object;
        try {
            CsvDomainRecordResult.EmailDomainDecisionResult emailDomainDecisionResult;
            CellProcessor[] cellProcessorArray = new CellProcessor[]{new NotNull((CellProcessor)new NotBlank((CellProcessor)new Trim((StringCellProcessor)new StrMinMax(1L, 255L)))), new Optional((CellProcessor)new Trim((StringCellProcessor)new StrMinMax(1L, 255L)))};
            object = (EmailTrustedDomainRecord)reader.read(EmailTrustedDomainRecord.class, ModelKt.getDomainFileHeaders(), cellProcessorArray);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                emailDomainDecisionResult = new CsvDomainRecordResult.EmailDomainDecisionResult((EmailTrustedDomainRecord)it);
            } else {
                emailDomainDecisionResult = null;
            }
            object = emailDomainDecisionResult;
        }
        catch (SuperCsvCellProcessorException ex) {
            object = new CsvDomainRecordResult.CsvDomainRecordError("Message= [" + ex.getLocalizedMessage() + "] row= " + ex.getCsvContext().getRowNumber() + ", column=" + ex.getCsvContext().getColumnNumber());
        }
        catch (IllegalArgumentException ex) {
            String string = ex.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
            object = new CsvDomainRecordResult.CsvDomainRecordError(string);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void batchUpsertNonBlockedDomains(@org.jetbrains.annotations.NotNull List<UserEmailDomain> nonBlockedDomains) {
        block3: {
            Unit unit;
            Collection<EmailTrustedDomain> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(nonBlockedDomains, (String)"nonBlockedDomains");
            Iterable iterable = nonBlockedDomains;
            EmailTrustedDomainRepository emailTrustedDomainRepository = this.emailTrustedDomainRepository;
            BatchUpsertResultAggregator<EmailTrustedDomain> batchUpsertResultAggregator = this.batchUpsertResultAggregator;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UserEmailDomain userEmailDomain = (UserEmailDomain)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EmailTrustedDomain(it.getDomainName(), EmailTrustedDomain.DomainNameRule.NO_DECISION_MADE, it.getActiveUsers(), it.getInactiveUsers(), null, 16, null));
            }
            collection = (List)destination$iv$iv;
            BatchUpsertResultAggregator.FailFastAggregateResult<EmailTrustedDomain> aggregateResult2 = batchUpsertResultAggregator.aggregateFailFast((Sequence<BatchUpsertResult<EmailTrustedDomain>>)EmailTrustedDomainRepository.batchUpsert$default(emailTrustedDomainRepository, (List)collection, false, false, 2, null));
            BatchUpsertResult.Failed<EmailTrustedDomain> failed = aggregateResult2.getFailed();
            if (failed != null) {
                BatchUpsertResult.Failed<EmailTrustedDomain> it = failed;
                boolean bl = false;
                EmailTrustedDomainServiceKt.access$getLog$p().warn("Failed to upsert non-blocked domains", it.getError());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            this.postEvent(nonBlockedDomains.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void batchUpsertBlockedDomains(@org.jetbrains.annotations.NotNull List<UserEmailDomain> blockedDomains) {
        block3: {
            Unit unit;
            Collection<EmailTrustedDomain> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(blockedDomains, (String)"blockedDomains");
            Iterable iterable = blockedDomains;
            EmailTrustedDomainRepository emailTrustedDomainRepository = this.emailTrustedDomainRepository;
            BatchUpsertResultAggregator<EmailTrustedDomain> batchUpsertResultAggregator = this.batchUpsertResultAggregator;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UserEmailDomain userEmailDomain = (UserEmailDomain)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EmailTrustedDomain(it.getDomainName(), EmailTrustedDomain.DomainNameRule.BLOCKED, it.getActiveUsers(), it.getInactiveUsers(), null, 16, null));
            }
            collection = (List)destination$iv$iv;
            BatchUpsertResultAggregator.FailFastAggregateResult<EmailTrustedDomain> aggregateResult2 = batchUpsertResultAggregator.aggregateFailFast((Sequence<BatchUpsertResult<EmailTrustedDomain>>)EmailTrustedDomainRepository.batchUpsert$default(emailTrustedDomainRepository, (List)collection, false, false, 6, null));
            BatchUpsertResult.Failed<EmailTrustedDomain> failed = aggregateResult2.getFailed();
            if (failed != null) {
                BatchUpsertResult.Failed<EmailTrustedDomain> it = failed;
                boolean bl = false;
                EmailTrustedDomainServiceKt.access$getLog$p().warn("Failed to upsert blocked domains", it.getError());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            this.postEvent(blockedDomains.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void batchDeleteStaleDomains(@org.jetbrains.annotations.NotNull List<UserEmailDomain> domainsFromUsers) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(domainsFromUsers, (String)"domainsFromUsers");
        Iterable $this$map$iv = domainsFromUsers;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserEmailDomain userEmailDomain = (UserEmailDomain)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDomainName());
        }
        HashSet domainSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = this.getAllDomains();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EmailTrustedDomain it = (EmailTrustedDomain)element$iv$iv;
            boolean bl = false;
            if (!(!domainSet.contains(it.getDomainName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List staleRuleReferences = (List)destination$iv$iv2;
        this.emailTrustedDomainRepository.batchDelete(staleRuleReferences);
    }

    public final int countByReviewMethod(@org.jetbrains.annotations.NotNull EmailTrustedDomain.ReviewMethod reviewMethod) {
        Intrinsics.checkNotNullParameter((Object)((Object)reviewMethod), (String)"reviewMethod");
        return this.emailTrustedDomainRepository.countByReviewMethod(reviewMethod);
    }

    public final void batchDeleteAllBlockedDomains() {
        this.emailTrustedDomainRepository.deleteBlockedDomainRules();
    }

    /*
     * WARNING - void declaration
     */
    private final CsvDomainUploadStatus performValidation(List<CsvDomainRecordResult.CsvDomainRecordError> errors, List<CsvDomainRecordResult.EmailDomainDecisionResult> domainDecisions) {
        CsvDomainUploadStatus csvDomainUploadStatus;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getNotBlockedDomains();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailTrustedDomain emailTrustedDomain = (EmailTrustedDomain)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDomainName());
        }
        List domainNames = (List)destination$iv$iv;
        if (!((Collection)errors).isEmpty()) {
            EmailTrustedDomainServiceKt.access$getLog$p().warn("Failed to parse CSV file: " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + " errors");
            csvDomainUploadStatus = new CsvDomainUploadStatus.CvsDomainRecordValidationFailed(errors);
        } else {
            csvDomainUploadStatus = !this.verifyFileIncludesCorrectNumberOfDomains(domainDecisions, domainNames) ? (CsvDomainUploadStatus)new CsvDomainUploadStatus.CsvDomainRecordFailed("incorrect-domain-count") : (!this.verifyFileIncludesOnlyValidDomains(domainDecisions, domainNames) ? (CsvDomainUploadStatus)new CsvDomainUploadStatus.CsvDomainRecordFailed("invalid-domain-names") : (!this.verifyFileDoesntIncludeInvalidRules(domainDecisions) ? (CsvDomainUploadStatus)new CsvDomainUploadStatus.CsvDomainRecordFailed("invalid-rules") : null));
        }
        return csvDomainUploadStatus;
    }

    private final boolean verifyFileIncludesCorrectNumberOfDomains(List<CsvDomainRecordResult.EmailDomainDecisionResult> emailDomainDecisionRecords, List<String> domainNames) {
        boolean result2;
        boolean bl = result2 = emailDomainDecisionRecords.size() == domainNames.size();
        if (!result2) {
            EmailTrustedDomainServiceKt.access$getLog$p().warn("Failed to parse CSV file: incorrect number of domains " + emailDomainDecisionRecords.size() + " != " + domainNames.size());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean verifyFileIncludesOnlyValidDomains(List<CsvDomainRecordResult.EmailDomainDecisionResult> emailDomainDecisionRecords, List<String> domainNames) {
        boolean result2;
        Iterable $this$none$iv;
        block6: {
            boolean bl;
            $this$none$iv = emailDomainDecisionRecords;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    CsvDomainRecordResult.EmailDomainDecisionResult it = (CsvDomainRecordResult.EmailDomainDecisionResult)element$iv;
                    boolean bl2 = false;
                    if (!(!domainNames.contains(it.getUserEmailDomain().getDomain()))) continue;
                    bl = false;
                    break block6;
                }
                bl = result2 = true;
            }
        }
        if (!result2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CsvDomainRecordResult.EmailDomainDecisionResult it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$none$iv = emailDomainDecisionRecords;
            StringBuilder stringBuilder = new StringBuilder().append("Failed to parse CSV file: invalid domains ");
            Logger logger2 = EmailTrustedDomainServiceKt.access$getLog$p();
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CsvDomainRecordResult.EmailDomainDecisionResult)element$iv$iv;
                boolean bl = false;
                if (!(!domainNames.contains(it.getUserEmailDomain().getDomain()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<String> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (CsvDomainRecordResult.EmailDomainDecisionResult)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUserEmailDomain().getDomain());
            }
            collection = (List)destination$iv$iv;
            logger2.warn(stringBuilder.append(collection).append('}').toString());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean verifyFileDoesntIncludeInvalidRules(List<CsvDomainRecordResult.EmailDomainDecisionResult> emailDomainDecisionRecords) {
        void $this$filterTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        EmailTrustedDomain.DomainNameRule[] domainNameRuleArray = EmailTrustedDomain.DomainNameRule.values();
        Collection collection = CollectionsKt.listOf((Object)"");
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var11_18 = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.name());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"BLOCKED")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validRuleValues = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = emailDomainDecisionRecords;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CsvDomainRecordResult.EmailDomainDecisionResult it = (CsvDomainRecordResult.EmailDomainDecisionResult)element$iv$iv;
            boolean bl = false;
            String string = it.getUserEmailDomain().getDecision().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            if (!(!validRuleValues.contains(string))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List invalidRules = (List)destination$iv$iv2;
        if (!((Collection)invalidRules).isEmpty()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            $this$filter$iv = invalidRules;
            object = new StringBuilder().append("Failed to parse CSV file: invalid rules ");
            collection = EmailTrustedDomainServiceKt.access$getLog$p();
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                CsvDomainRecordResult.EmailDomainDecisionResult it = (CsvDomainRecordResult.EmailDomainDecisionResult)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(it.getUserEmailDomain().getDomain() + ':' + it.getUserEmailDomain().getDecision());
            }
            collection2 = (List)destination$iv$iv2;
            collection.warn(((StringBuilder)object).append(collection2).toString());
        }
        return invalidRules.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final CsvDomainUploadStatus recordAllTrustedDomainData(List<CsvDomainRecordResult.EmailDomainDecisionResult> emailDomainDecisionRecords) {
        CsvDomainUploadStatus csvDomainUploadStatus;
        EmailTrustedDomainRecord it;
        Collection<EmailTrustedDomain> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = emailDomainDecisionRecords;
        EmailTrustedDomainRepository emailTrustedDomainRepository = this.emailTrustedDomainRepository;
        BatchUpsertResultAggregator<EmailTrustedDomain> batchUpsertResultAggregator = this.batchUpsertResultAggregator;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CsvDomainRecordResult.EmailDomainDecisionResult emailDomainDecisionResult = (CsvDomainRecordResult.EmailDomainDecisionResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((EmailTrustedDomain)((Object)((CsvDomainRecordResult.EmailDomainDecisionResult)((Object)it)).getUserEmailDomain()));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (EmailTrustedDomainRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toEmailTrustedDomain((EmailTrustedDomainRecord)p0));
        }
        collection = (List)destination$iv$iv;
        BatchUpsertResultAggregator.FailFastAggregateResult<EmailTrustedDomain> aggregateResult2 = batchUpsertResultAggregator.aggregateFailFast((Sequence<BatchUpsertResult<EmailTrustedDomain>>)EmailTrustedDomainRepository.batchUpsert$default(emailTrustedDomainRepository, collection, false, false, 4, null));
        BatchUpsertResult.Failed<EmailTrustedDomain> failed = aggregateResult2.getFailed();
        if (failed != null) {
            BatchUpsertResult.Failed<EmailTrustedDomain> it2 = failed;
            boolean bl = false;
            csvDomainUploadStatus = new CsvDomainUploadStatus.CsvDomainRecordInsertFailed(it2.getError().getLocalizedMessage() + ", Please check the server log");
        } else {
            csvDomainUploadStatus = new CsvDomainUploadStatus.CsvDomainUploadSuccess(emailDomainDecisionRecords.size());
        }
        return csvDomainUploadStatus;
    }

    private final EmailTrustedDomain toEmailTrustedDomain(EmailTrustedDomainRecord emailTrustedDomainRecord) {
        EmailTrustedDomain.DomainNameRule domainNameRule;
        EmailTrustedDomainRecord $this$toEmailTrustedDomain_u24lambda_u2421 = emailTrustedDomainRecord;
        boolean bl = false;
        String string = $this$toEmailTrustedDomain_u24lambda_u2421.getDomain();
        if (StringsKt.isBlank((CharSequence)$this$toEmailTrustedDomain_u24lambda_u2421.getDecision())) {
            domainNameRule = EmailTrustedDomain.DomainNameRule.NO_DECISION_MADE;
        } else {
            String string2 = $this$toEmailTrustedDomain_u24lambda_u2421.getDecision().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            domainNameRule = EmailTrustedDomain.DomainNameRule.valueOf(string2);
        }
        return new EmailTrustedDomain(string, domainNameRule, 0, 0, EmailTrustedDomain.ReviewMethod.CSV, 12, null);
    }

    private final void postEvent(int numberOfRecords) {
        this.migrationEventBus.post(new TrustedDomainsUpdatedEvent(numberOfRecords));
    }

    public static final /* synthetic */ CsvDomainRecordResult access$readCsvLine(EmailTrustedDomainService $this, CsvBeanReader reader) {
        return $this.readCsvLine(reader);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$Companion;", "", "()V", "maxCsvEntryLength", "", "minCsvEntryLength", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult;", "", "()V", "CsvDomainRecordError", "EmailDomainDecisionResult", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult$CsvDomainRecordError;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult$EmailDomainDecisionResult;", "jira-migration-plugin"})
    public static abstract class CsvDomainRecordResult {
        private CsvDomainRecordResult() {
        }

        public /* synthetic */ CsvDomainRecordResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult$CsvDomainRecordError;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult;", "errorMessage", "", "(Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jira-migration-plugin"})
        public static final class CsvDomainRecordError
        extends CsvDomainRecordResult {
            @org.jetbrains.annotations.NotNull
            private final String errorMessage;

            public CsvDomainRecordError(@org.jetbrains.annotations.NotNull String errorMessage2) {
                Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
                super(null);
                this.errorMessage = errorMessage2;
            }

            @org.jetbrains.annotations.NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }

            @org.jetbrains.annotations.NotNull
            public final String component1() {
                return this.errorMessage;
            }

            @org.jetbrains.annotations.NotNull
            public final CsvDomainRecordError copy(@org.jetbrains.annotations.NotNull String errorMessage2) {
                Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
                return new CsvDomainRecordError(errorMessage2);
            }

            public static /* synthetic */ CsvDomainRecordError copy$default(CsvDomainRecordError csvDomainRecordError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = csvDomainRecordError.errorMessage;
                }
                return csvDomainRecordError.copy(string);
            }

            @org.jetbrains.annotations.NotNull
            public String toString() {
                return "CsvDomainRecordError(errorMessage=" + this.errorMessage + ')';
            }

            public int hashCode() {
                return this.errorMessage.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CsvDomainRecordError)) {
                    return false;
                }
                CsvDomainRecordError csvDomainRecordError = (CsvDomainRecordError)other;
                return Intrinsics.areEqual((Object)this.errorMessage, (Object)csvDomainRecordError.errorMessage);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult$EmailDomainDecisionResult;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult;", "userEmailDomain", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomainRecord;", "(Lcom/atlassian/jira/migration/email/model/EmailTrustedDomainRecord;)V", "getUserEmailDomain", "()Lcom/atlassian/jira/migration/email/model/EmailTrustedDomainRecord;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jira-migration-plugin"})
        public static final class EmailDomainDecisionResult
        extends CsvDomainRecordResult {
            @org.jetbrains.annotations.NotNull
            private final EmailTrustedDomainRecord userEmailDomain;

            public EmailDomainDecisionResult(@org.jetbrains.annotations.NotNull EmailTrustedDomainRecord userEmailDomain) {
                Intrinsics.checkNotNullParameter((Object)userEmailDomain, (String)"userEmailDomain");
                super(null);
                this.userEmailDomain = userEmailDomain;
            }

            @org.jetbrains.annotations.NotNull
            public final EmailTrustedDomainRecord getUserEmailDomain() {
                return this.userEmailDomain;
            }

            @org.jetbrains.annotations.NotNull
            public final EmailTrustedDomainRecord component1() {
                return this.userEmailDomain;
            }

            @org.jetbrains.annotations.NotNull
            public final EmailDomainDecisionResult copy(@org.jetbrains.annotations.NotNull EmailTrustedDomainRecord userEmailDomain) {
                Intrinsics.checkNotNullParameter((Object)userEmailDomain, (String)"userEmailDomain");
                return new EmailDomainDecisionResult(userEmailDomain);
            }

            public static /* synthetic */ EmailDomainDecisionResult copy$default(EmailDomainDecisionResult emailDomainDecisionResult, EmailTrustedDomainRecord emailTrustedDomainRecord, int n, Object object) {
                if ((n & 1) != 0) {
                    emailTrustedDomainRecord = emailDomainDecisionResult.userEmailDomain;
                }
                return emailDomainDecisionResult.copy(emailTrustedDomainRecord);
            }

            @org.jetbrains.annotations.NotNull
            public String toString() {
                return "EmailDomainDecisionResult(userEmailDomain=" + this.userEmailDomain + ')';
            }

            public int hashCode() {
                return this.userEmailDomain.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EmailDomainDecisionResult)) {
                    return false;
                }
                EmailDomainDecisionResult emailDomainDecisionResult = (EmailDomainDecisionResult)other;
                return Intrinsics.areEqual((Object)this.userEmailDomain, (Object)emailDomainDecisionResult.userEmailDomain);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus;", "", "()V", "CsvDomainRecordFailed", "CsvDomainRecordInsertFailed", "CsvDomainUploadSuccess", "CvsDomainRecordValidationFailed", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CsvDomainRecordFailed;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CsvDomainRecordInsertFailed;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CsvDomainUploadSuccess;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CvsDomainRecordValidationFailed;", "jira-migration-plugin"})
    public static abstract class CsvDomainUploadStatus {
        private CsvDomainUploadStatus() {
        }

        public /* synthetic */ CsvDomainUploadStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CsvDomainRecordFailed;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus;", "errorMessage", "", "(Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jira-migration-plugin"})
        public static final class CsvDomainRecordFailed
        extends CsvDomainUploadStatus {
            @org.jetbrains.annotations.NotNull
            private final String errorMessage;

            public CsvDomainRecordFailed(@org.jetbrains.annotations.NotNull String errorMessage2) {
                Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
                super(null);
                this.errorMessage = errorMessage2;
            }

            @org.jetbrains.annotations.NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }

            @org.jetbrains.annotations.NotNull
            public final String component1() {
                return this.errorMessage;
            }

            @org.jetbrains.annotations.NotNull
            public final CsvDomainRecordFailed copy(@org.jetbrains.annotations.NotNull String errorMessage2) {
                Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
                return new CsvDomainRecordFailed(errorMessage2);
            }

            public static /* synthetic */ CsvDomainRecordFailed copy$default(CsvDomainRecordFailed csvDomainRecordFailed, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = csvDomainRecordFailed.errorMessage;
                }
                return csvDomainRecordFailed.copy(string);
            }

            @org.jetbrains.annotations.NotNull
            public String toString() {
                return "CsvDomainRecordFailed(errorMessage=" + this.errorMessage + ')';
            }

            public int hashCode() {
                return this.errorMessage.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CsvDomainRecordFailed)) {
                    return false;
                }
                CsvDomainRecordFailed csvDomainRecordFailed = (CsvDomainRecordFailed)other;
                return Intrinsics.areEqual((Object)this.errorMessage, (Object)csvDomainRecordFailed.errorMessage);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CsvDomainRecordInsertFailed;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus;", "errorMessage", "", "(Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jira-migration-plugin"})
        public static final class CsvDomainRecordInsertFailed
        extends CsvDomainUploadStatus {
            @org.jetbrains.annotations.NotNull
            private final String errorMessage;

            public CsvDomainRecordInsertFailed(@org.jetbrains.annotations.NotNull String errorMessage2) {
                Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
                super(null);
                this.errorMessage = errorMessage2;
            }

            @org.jetbrains.annotations.NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }

            @org.jetbrains.annotations.NotNull
            public final String component1() {
                return this.errorMessage;
            }

            @org.jetbrains.annotations.NotNull
            public final CsvDomainRecordInsertFailed copy(@org.jetbrains.annotations.NotNull String errorMessage2) {
                Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
                return new CsvDomainRecordInsertFailed(errorMessage2);
            }

            public static /* synthetic */ CsvDomainRecordInsertFailed copy$default(CsvDomainRecordInsertFailed csvDomainRecordInsertFailed, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = csvDomainRecordInsertFailed.errorMessage;
                }
                return csvDomainRecordInsertFailed.copy(string);
            }

            @org.jetbrains.annotations.NotNull
            public String toString() {
                return "CsvDomainRecordInsertFailed(errorMessage=" + this.errorMessage + ')';
            }

            public int hashCode() {
                return this.errorMessage.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CsvDomainRecordInsertFailed)) {
                    return false;
                }
                CsvDomainRecordInsertFailed csvDomainRecordInsertFailed = (CsvDomainRecordInsertFailed)other;
                return Intrinsics.areEqual((Object)this.errorMessage, (Object)csvDomainRecordInsertFailed.errorMessage);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CsvDomainUploadSuccess;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus;", "numberOfRecords", "", "(I)V", "getNumberOfRecords", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "jira-migration-plugin"})
        public static final class CsvDomainUploadSuccess
        extends CsvDomainUploadStatus {
            private final int numberOfRecords;

            public CsvDomainUploadSuccess(int numberOfRecords) {
                super(null);
                this.numberOfRecords = numberOfRecords;
            }

            public final int getNumberOfRecords() {
                return this.numberOfRecords;
            }

            public final int component1() {
                return this.numberOfRecords;
            }

            @org.jetbrains.annotations.NotNull
            public final CsvDomainUploadSuccess copy(int numberOfRecords) {
                return new CsvDomainUploadSuccess(numberOfRecords);
            }

            public static /* synthetic */ CsvDomainUploadSuccess copy$default(CsvDomainUploadSuccess csvDomainUploadSuccess, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = csvDomainUploadSuccess.numberOfRecords;
                }
                return csvDomainUploadSuccess.copy(n);
            }

            @org.jetbrains.annotations.NotNull
            public String toString() {
                return "CsvDomainUploadSuccess(numberOfRecords=" + this.numberOfRecords + ')';
            }

            public int hashCode() {
                return Integer.hashCode(this.numberOfRecords);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CsvDomainUploadSuccess)) {
                    return false;
                }
                CsvDomainUploadSuccess csvDomainUploadSuccess = (CsvDomainUploadSuccess)other;
                return this.numberOfRecords == csvDomainUploadSuccess.numberOfRecords;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus$CvsDomainRecordValidationFailed;", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainUploadStatus;", "csvRecordErrors", "", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$CsvDomainRecordResult$CsvDomainRecordError;", "(Ljava/util/List;)V", "getCsvRecordErrors", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jira-migration-plugin"})
        public static final class CvsDomainRecordValidationFailed
        extends CsvDomainUploadStatus {
            @org.jetbrains.annotations.NotNull
            private final List<CsvDomainRecordResult.CsvDomainRecordError> csvRecordErrors;

            public CvsDomainRecordValidationFailed(@org.jetbrains.annotations.NotNull List<CsvDomainRecordResult.CsvDomainRecordError> csvRecordErrors) {
                Intrinsics.checkNotNullParameter(csvRecordErrors, (String)"csvRecordErrors");
                super(null);
                this.csvRecordErrors = csvRecordErrors;
            }

            @org.jetbrains.annotations.NotNull
            public final List<CsvDomainRecordResult.CsvDomainRecordError> getCsvRecordErrors() {
                return this.csvRecordErrors;
            }

            @org.jetbrains.annotations.NotNull
            public final List<CsvDomainRecordResult.CsvDomainRecordError> component1() {
                return this.csvRecordErrors;
            }

            @org.jetbrains.annotations.NotNull
            public final CvsDomainRecordValidationFailed copy(@org.jetbrains.annotations.NotNull List<CsvDomainRecordResult.CsvDomainRecordError> csvRecordErrors) {
                Intrinsics.checkNotNullParameter(csvRecordErrors, (String)"csvRecordErrors");
                return new CvsDomainRecordValidationFailed(csvRecordErrors);
            }

            public static /* synthetic */ CvsDomainRecordValidationFailed copy$default(CvsDomainRecordValidationFailed cvsDomainRecordValidationFailed, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = cvsDomainRecordValidationFailed.csvRecordErrors;
                }
                return cvsDomainRecordValidationFailed.copy(list);
            }

            @org.jetbrains.annotations.NotNull
            public String toString() {
                return "CvsDomainRecordValidationFailed(csvRecordErrors=" + this.csvRecordErrors + ')';
            }

            public int hashCode() {
                return ((Object)this.csvRecordErrors).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CvsDomainRecordValidationFailed)) {
                    return false;
                }
                CvsDomainRecordValidationFailed cvsDomainRecordValidationFailed = (CvsDomainRecordValidationFailed)other;
                return Intrinsics.areEqual(this.csvRecordErrors, cvsDomainRecordValidationFailed.csvRecordErrors);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/email/EmailTrustedDomainService$NotBlank;", "Lorg/supercsv/cellprocessor/CellProcessorAdaptor;", "next", "Lorg/supercsv/cellprocessor/ift/CellProcessor;", "(Lorg/supercsv/cellprocessor/ift/CellProcessor;)V", "execute", "T", "value", "", "context", "Lorg/supercsv/util/CsvContext;", "(Ljava/lang/Object;Lorg/supercsv/util/CsvContext;)Ljava/lang/Object;", "jira-migration-plugin"})
    public static final class NotBlank
    extends CellProcessorAdaptor {
        public NotBlank(@org.jetbrains.annotations.NotNull CellProcessor next) {
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            super(next);
        }

        public <T> T execute(@Nullable Object value, @Nullable CsvContext context) {
            if (value == null) {
                throw new SuperCsvConstraintViolationException("the Domain name should not be null", context, (CellProcessor)this);
            }
            if (!(value instanceof String) || !(!StringsKt.isBlank((CharSequence)((CharSequence)value)))) {
                if (value instanceof String && StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                    throw new SuperCsvConstraintViolationException("the Domain name should not be blank", context, (CellProcessor)this);
                }
                throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
            }
            String string = ((String)value).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return (T)this.next.execute((Object)string, context);
        }
    }
}

