/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.email.CorrectedEmailService;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.correctedemails.CsvState;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCConfigAction;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingConfig;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingConfigDTO;
import com.atlassian.migration.udc.config.ConfigUpdateResult;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B7\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB5\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0017J\u000e\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*J\u001a\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u001b2\b\b\u0002\u0010-\u001a\u00020#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "correctedEmailService", "Lcom/atlassian/jira/migration/email/CorrectedEmailService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "udcGlobalEmailFixesConfigService", "Lcom/atlassian/migration/udc/config/GlobalEmailFixesConfigService;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/email/CorrectedEmailService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/migration/udc/config/GlobalEmailFixesConfigService;)V", "pluginSettings", "Lcom/atlassian/sal/api/pluginsettings/PluginSettings;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettings;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/email/CorrectedEmailService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/migration/udc/config/GlobalEmailFixesConfigService;)V", "getConfirmedUdcModeConfig", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UDCMode;", "getDuplicatedEmailsConfig", "Lcom/atlassian/jira/migration/email/DuplicatedEmailsConfig;", "getInvalidEmailsConfig", "Lcom/atlassian/jira/migration/email/InvalidEmailsConfig;", "getRawDuplicatedEmailsConfig", "", "getRawInvalidEmailsConfig", "getRawUserMappingConfig", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UserMappingConfig;", "getUdcModeConfig", "getUserMappingConfig", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UserMappingConfigDTO;", "isAnyMigrationRunning", "", "saveDuplicatedEmailsConfig", "Lcom/atlassian/migration/udc/config/ConfigUpdateResult;", "config", "saveInvalidEmailsConfig", "saveUserMappingConfigState", "action", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UDCConfigAction;", "saveUserMappingFileName", "fileName", "draft", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nGlobalEmailFixesConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalEmailFixesConfigService.kt\ncom/atlassian/jira/migration/email/GlobalEmailFixesConfigService\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n51#2:249\n51#2:250\n819#3:251\n847#3,2:252\n*S KotlinDebug\n*F\n+ 1 GlobalEmailFixesConfigService.kt\ncom/atlassian/jira/migration/email/GlobalEmailFixesConfigService\n*L\n58#1:249\n89#1:250\n133#1:251\n133#1:252,2\n*E\n"})
public final class GlobalEmailFixesConfigService {
    @NotNull
    private final PluginSettings pluginSettings;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final CorrectedEmailService correctedEmailService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final com.atlassian.migration.udc.config.GlobalEmailFixesConfigService udcGlobalEmailFixesConfigService;

    public GlobalEmailFixesConfigService(@NotNull PluginSettings pluginSettings, @NotNull ObjectMapper objectMapper2, @NotNull MigrationRepository migrationRepository, @NotNull CorrectedEmailService correctedEmailService, @NotNull DiscoveryService discoveryService, @NotNull com.atlassian.migration.udc.config.GlobalEmailFixesConfigService udcGlobalEmailFixesConfigService) {
        Intrinsics.checkNotNullParameter((Object)pluginSettings, (String)"pluginSettings");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)correctedEmailService, (String)"correctedEmailService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)udcGlobalEmailFixesConfigService, (String)"udcGlobalEmailFixesConfigService");
        this.pluginSettings = pluginSettings;
        this.objectMapper = objectMapper2;
        this.migrationRepository = migrationRepository;
        this.correctedEmailService = correctedEmailService;
        this.discoveryService = discoveryService;
        this.udcGlobalEmailFixesConfigService = udcGlobalEmailFixesConfigService;
    }

    @Inject
    public GlobalEmailFixesConfigService(@NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationRepository migrationRepository, @NotNull CorrectedEmailService correctedEmailService, @NotNull DiscoveryService discoveryService, @NotNull com.atlassian.migration.udc.config.GlobalEmailFixesConfigService udcGlobalEmailFixesConfigService) {
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)correctedEmailService, (String)"correctedEmailService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)udcGlobalEmailFixesConfigService, (String)"udcGlobalEmailFixesConfigService");
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pluginSettings, (String)"createGlobalSettings(...)");
        this(pluginSettings, objectMapperFactory.createObjectMapper(), migrationRepository, correctedEmailService, discoveryService, udcGlobalEmailFixesConfigService);
    }

    @NotNull
    public final DuplicatedEmailsConfig getDuplicatedEmailsConfig() {
        DuplicatedEmailsConfig savedConfig;
        DuplicatedEmailsConfig duplicatedEmailsConfig;
        DuplicatedEmailsConfig duplicatedEmailsConfig2;
        String string = this.getRawDuplicatedEmailsConfig();
        if (string != null) {
            DuplicatedEmailsConfig duplicatedEmailsConfig3;
            String config2 = string;
            boolean bl = false;
            boolean $i$f$jacksonTypeRef = false;
            DuplicatedEmailsConfig duplicatedEmailsConfig4 = duplicatedEmailsConfig3 = (DuplicatedEmailsConfig)this.objectMapper.readValue(config2, (TypeReference)new TypeReference<DuplicatedEmailsConfig>(){});
            if (duplicatedEmailsConfig4 != null) {
                Intrinsics.checkNotNull((Object)duplicatedEmailsConfig4);
                DuplicatedEmailsConfig it = duplicatedEmailsConfig3;
                boolean bl2 = false;
                CsvState csvState = this.correctedEmailService.getStateForBasicMode(EmailCheckType.DUP);
                it.setCsvUploaded(csvState.isCsvUploaded());
                it.setCsvOutdated(csvState.isCsvOutdated());
                duplicatedEmailsConfig2 = it;
            } else {
                duplicatedEmailsConfig2 = null;
            }
        } else {
            duplicatedEmailsConfig2 = null;
        }
        if ((duplicatedEmailsConfig = (savedConfig = duplicatedEmailsConfig2)) == null) {
            duplicatedEmailsConfig = new DuplicatedEmailsConfig(null, null, null, null, 15, null);
        }
        return duplicatedEmailsConfig;
    }

    private final String getRawDuplicatedEmailsConfig() {
        return (String)this.pluginSettings.get("com.atlassian.jira.migration.jira-migration-plugin:duplicatedEmailsConfig");
    }

    @NotNull
    public final ConfigUpdateResult saveDuplicatedEmailsConfig(@NotNull DuplicatedEmailsConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (config2.getOnMigration() == DuplicatedEmailsConfig.OnMigration.MERGE_BEFORE_CUT_OFF_DATE && config2.getMergeCutoffDate() == null) {
            return (ConfigUpdateResult)new ConfigUpdateResult.ValidationError("mergeCutoffDate needs to be provided when MERGE_BEFORE_CUT_OFF_DATE option is selected");
        }
        if (this.isAnyMigrationRunning()) {
            return (ConfigUpdateResult)ConfigUpdateResult.MigrationIsRunningError.INSTANCE;
        }
        this.pluginSettings.put("com.atlassian.jira.migration.jira-migration-plugin:duplicatedEmailsConfig", (Object)this.objectMapper.writeValueAsString((Object)config2));
        this.udcGlobalEmailFixesConfigService.saveUdcModeConfig(UDCMode.BASIC);
        return (ConfigUpdateResult)ConfigUpdateResult.Success.INSTANCE;
    }

    @NotNull
    public final InvalidEmailsConfig getInvalidEmailsConfig() {
        InvalidEmailsConfig savedConfig;
        InvalidEmailsConfig invalidEmailsConfig;
        InvalidEmailsConfig invalidEmailsConfig2;
        String string = this.getRawInvalidEmailsConfig();
        if (string != null) {
            InvalidEmailsConfig invalidEmailsConfig3;
            String config2 = string;
            boolean bl = false;
            boolean $i$f$jacksonTypeRef = false;
            InvalidEmailsConfig invalidEmailsConfig4 = invalidEmailsConfig3 = (InvalidEmailsConfig)this.objectMapper.readValue(config2, (TypeReference)new TypeReference<InvalidEmailsConfig>(){});
            if (invalidEmailsConfig4 != null) {
                Intrinsics.checkNotNull((Object)invalidEmailsConfig4);
                InvalidEmailsConfig it = invalidEmailsConfig3;
                boolean bl2 = false;
                CsvState state = this.correctedEmailService.getStateForBasicMode(EmailCheckType.INV);
                it.setCsvUploaded(state.isCsvUploaded());
                it.setCsvOutdated(state.isCsvOutdated());
                invalidEmailsConfig2 = it;
            } else {
                invalidEmailsConfig2 = null;
            }
        } else {
            invalidEmailsConfig2 = null;
        }
        if ((invalidEmailsConfig = (savedConfig = invalidEmailsConfig2)) == null) {
            invalidEmailsConfig = new InvalidEmailsConfig(null, null, null, null, 15, null);
        }
        return invalidEmailsConfig;
    }

    private final String getRawInvalidEmailsConfig() {
        return (String)this.pluginSettings.get("com.atlassian.jira.migration.jira-migration-plugin:invalidEmailsConfig");
    }

    @NotNull
    public final ConfigUpdateResult saveInvalidEmailsConfig(@NotNull InvalidEmailsConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (config2.getOnMigration() == InvalidEmailsConfig.OnMigration.TOMBSTONE_BEFORE_CUT_OFF_DATE && config2.getTombstoneCutoffDate() == null) {
            return (ConfigUpdateResult)new ConfigUpdateResult.ValidationError("tombstoneCutoffDate needs to be provided when TOMBSTONE_BEFORE_CUT_OFF_DATE option is selected");
        }
        if (this.isAnyMigrationRunning()) {
            return (ConfigUpdateResult)ConfigUpdateResult.MigrationIsRunningError.INSTANCE;
        }
        this.pluginSettings.put("com.atlassian.jira.migration.jira-migration-plugin:invalidEmailsConfig", (Object)this.objectMapper.writeValueAsString((Object)config2));
        this.udcGlobalEmailFixesConfigService.saveUdcModeConfig(UDCMode.BASIC);
        return (ConfigUpdateResult)ConfigUpdateResult.Success.INSTANCE;
    }

    @NotNull
    public final UserMappingConfigDTO getUserMappingConfig() {
        return this.udcGlobalEmailFixesConfigService.getUserMappingConfig();
    }

    @NotNull
    public final UserMappingConfig getRawUserMappingConfig() {
        return this.udcGlobalEmailFixesConfigService.getRawUserMappingConfig();
    }

    @NotNull
    public final ConfigUpdateResult saveUserMappingConfigState(@NotNull UDCConfigAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.udcGlobalEmailFixesConfigService.saveUserMappingConfigState(action);
    }

    @Nullable
    public final Object saveUserMappingFileName(@NotNull String fileName, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.udcGlobalEmailFixesConfigService.saveUserMappingFileName(fileName, draft);
    }

    public static /* synthetic */ Object saveUserMappingFileName$default(GlobalEmailFixesConfigService globalEmailFixesConfigService, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return globalEmailFixesConfigService.saveUserMappingFileName(string, bl);
    }

    @NotNull
    public final UDCMode getUdcModeConfig() {
        return this.udcGlobalEmailFixesConfigService.getUdcModeConfig();
    }

    @Nullable
    public final UDCMode getConfirmedUdcModeConfig() {
        return this.udcGlobalEmailFixesConfigService.getConfirmedUdcModeConfig();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAnyMigrationRunning() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.migrationRepository.getInProgressMigrations();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Migration it = (Migration)element$iv$iv;
            boolean bl = false;
            Object object = DiscoveryService.retrievePlanFor$default(this.discoveryService, it.getMigrationId(), false, 2, null);
            if (object != null && (object = ((Plan)object).isShadowPlan()) != null ? (Boolean)object : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return !((Collection)((List)destination$iv$iv)).isEmpty();
    }
}

