/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.email.CorrectedEmailService;
import com.atlassian.jira.migration.email.DuplicateEmailsFixResult;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.email.EmailConfigServiceKt;
import com.atlassian.jira.migration.email.FixAllEmailsResult;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.email.InvalidEmailsFixResult;
import com.atlassian.jira.migration.email.model.CorrectedEmail;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.utils.UDCConverterKt;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.context.Context;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.email.NewEmailSuggestingService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 =2\u00020\u0001:\u0003=>?B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J \u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u001c\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eJ\u001c\u0010 \u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010!\u001a\u00020\"J,\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010!\u001a\u00020\"H\u0002J*\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0016\u00105\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J*\u00106\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0016\u00107\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001e\u00108\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010!\u001a\u00020\"H\u0002J.\u00109\u001a\u00020(2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler;", "", "configService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "directoryManager", "Lcom/atlassian/crowd/manager/directory/DirectoryManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "newEmailSuggestingService", "Lcom/atlassian/migration/udc/email/NewEmailSuggestingService;", "correctedEmailService", "Lcom/atlassian/jira/migration/email/CorrectedEmailService;", "udcDelegate", "Lcom/atlassian/migration/udc/fixer/GlobalUnsupportedUserHandler;", "(Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/crowd/manager/directory/DirectoryManager;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/migration/udc/email/NewEmailSuggestingService;Lcom/atlassian/jira/migration/email/CorrectedEmailService;Lcom/atlassian/migration/udc/fixer/GlobalUnsupportedUserHandler;)V", "applyUserMappings", "Lcom/atlassian/jira/migration/email/FixAllEmailsResult;", "validUsers", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "buildCsvDuplicateEmailsFixResult", "Lcom/atlassian/jira/migration/email/DuplicateEmailsFixResult;", "duplicateUsers", "draft", "", "buildCsvInvalidEmailsFixResult", "Lcom/atlassian/jira/migration/email/InvalidEmailsFixResult;", "invalidUsers", "fixDuplicateEmails", "containerToken", "", "migrationScopeId", "fixInvalidEmails", "migrationScopeContext", "Lcom/atlassian/jira/migration/common/MigrationScopeContext;", "generateNewEmails", "users", "type", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "getBeforeCutOffDateMergeUsersAndRemapUsersPair", "Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler$RemoveOrFixUsersResult;", "duplicateUserConfig", "Lcom/atlassian/jira/migration/email/DuplicatedEmailsConfig;", "getBeforeCutOffDateTombstoneUsersAndRemapUsersPair", "invalidUserConfig", "Lcom/atlassian/jira/migration/email/InvalidEmailsConfig;", "getCsvCorrectedUsers", "Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler$CsvCorrectedUsers;", "incorrectUsers", "getLastLoginMillis", "", "applicationUser", "Lcom/atlassian/jira/user/ApplicationUser;", "handleDuplicateEmailsWithAdvancedMode", "handleDuplicateEmailsWithBasicMode", "handleInvalidEmailsWithAdvancedMode", "handleInvalidEmailsWithBasicMode", "removeOrFixUsers", "tombstoneCutoffDate", "Ljava/time/LocalDate;", "checkType", "Companion", "CsvCorrectedUsers", "RemoveOrFixUsersResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nGlobalUnsupportedUserHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalUnsupportedUserHandler.kt\ncom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n766#2:224\n857#2,2:225\n1549#2:227\n1620#2,3:228\n1477#2:231\n1502#2,3:232\n1505#2,3:242\n1238#2,4:247\n1603#2,9:251\n1855#2:260\n1856#2:262\n1612#2:263\n3190#2,10:264\n1549#2:274\n1620#2,3:275\n1549#2:278\n1620#2,3:279\n1549#2:282\n1620#2,3:283\n372#3,7:235\n453#3:245\n403#3:246\n1#4:261\n*S KotlinDebug\n*F\n+ 1 GlobalUnsupportedUserHandler.kt\ncom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler\n*L\n147#1:224\n147#1:225,2\n148#1:227\n148#1:228,3\n163#1:231\n163#1:232,3\n163#1:242,3\n164#1:247,4\n201#1:251,9\n201#1:260\n201#1:262\n201#1:263\n202#1:264,10\n207#1:274\n207#1:275,3\n208#1:278\n208#1:279,3\n209#1:282\n209#1:283,3\n163#1:235,7\n164#1:245\n164#1:246\n201#1:261\n*E\n"})
public final class GlobalUnsupportedUserHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalEmailFixesConfigService configService;
    @NotNull
    private final DirectoryManager directoryManager;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final NewEmailSuggestingService newEmailSuggestingService;
    @NotNull
    private final CorrectedEmailService correctedEmailService;
    @NotNull
    private final com.atlassian.migration.udc.fixer.GlobalUnsupportedUserHandler udcDelegate;
    private static final Logger log = LoggerFactory.getLogger(GlobalUnsupportedUserHandler.class);

    @Inject
    public GlobalUnsupportedUserHandler(@NotNull GlobalEmailFixesConfigService configService, @NotNull DirectoryManager directoryManager, @NotNull UserManager userManager, @NotNull NewEmailSuggestingService newEmailSuggestingService, @NotNull CorrectedEmailService correctedEmailService, @Named(value="udcGlobalUnsupportedUserHandler") @NotNull com.atlassian.migration.udc.fixer.GlobalUnsupportedUserHandler udcDelegate) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)directoryManager, (String)"directoryManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)newEmailSuggestingService, (String)"newEmailSuggestingService");
        Intrinsics.checkNotNullParameter((Object)correctedEmailService, (String)"correctedEmailService");
        Intrinsics.checkNotNullParameter((Object)udcDelegate, (String)"udcDelegate");
        this.configService = configService;
        this.directoryManager = directoryManager;
        this.userManager = userManager;
        this.newEmailSuggestingService = newEmailSuggestingService;
        this.correctedEmailService = correctedEmailService;
        this.udcDelegate = udcDelegate;
    }

    @NotNull
    public final FixAllEmailsResult applyUserMappings(@NotNull List<JiraUser> validUsers) {
        Intrinsics.checkNotNullParameter(validUsers, (String)"validUsers");
        return UDCConverterKt.toJCMA(this.udcDelegate.applyUserMappings(UDCConverterKt.toUDCUsers(validUsers)));
    }

    @NotNull
    public final InvalidEmailsFixResult fixInvalidEmails(@NotNull List<JiraUser> invalidUsers, @NotNull MigrationScopeContext migrationScopeContext) {
        InvalidEmailsFixResult invalidEmailsFixResult;
        Intrinsics.checkNotNullParameter(invalidUsers, (String)"invalidUsers");
        Intrinsics.checkNotNullParameter((Object)migrationScopeContext, (String)"migrationScopeContext");
        switch (WhenMappings.$EnumSwitchMapping$0[this.configService.getUdcModeConfig().ordinal()]) {
            case 1: {
                invalidEmailsFixResult = this.handleInvalidEmailsWithAdvancedMode(invalidUsers);
                break;
            }
            case 2: {
                invalidEmailsFixResult = this.handleInvalidEmailsWithBasicMode(invalidUsers, migrationScopeContext);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        InvalidEmailsFixResult fixResult = invalidEmailsFixResult;
        log.info("Found " + fixResult.getTombstone().size() + " users to tombstone, " + fixResult.getNewMail().size() + " with new emails, " + fixResult.getInvalid().size() + " still invalid");
        return fixResult;
    }

    private final InvalidEmailsFixResult handleInvalidEmailsWithAdvancedMode(List<JiraUser> invalidUsers) {
        return UDCConverterKt.toJCMA(this.udcDelegate.handleInvalidEmailsWithAdvancedMode(UDCConverterKt.toUDCUsers(invalidUsers)));
    }

    private final InvalidEmailsFixResult handleInvalidEmailsWithBasicMode(List<JiraUser> invalidUsers, MigrationScopeContext migrationScopeContext) {
        InvalidEmailsFixResult invalidEmailsFixResult;
        InvalidEmailsConfig config2 = this.configService.getInvalidEmailsConfig();
        switch (WhenMappings.$EnumSwitchMapping$1[config2.getOnMigration().ordinal()]) {
            case 1: {
                invalidEmailsFixResult = new InvalidEmailsFixResult(null, null, invalidUsers, 3, null);
                break;
            }
            case 2: {
                invalidEmailsFixResult = new InvalidEmailsFixResult(null, invalidUsers, null, 5, null);
                break;
            }
            case 3: {
                invalidEmailsFixResult = new InvalidEmailsFixResult(this.generateNewEmails(invalidUsers, EmailCheckType.INV, migrationScopeContext), null, null, 6, null);
                break;
            }
            case 4: {
                RemoveOrFixUsersResult fixedUsers = this.getBeforeCutOffDateTombstoneUsersAndRemapUsersPair(config2, invalidUsers, migrationScopeContext);
                List<JiraUser> list = fixedUsers.getTombstoneOrMerge();
                List<JiraUser> list2 = fixedUsers.getNewEmail();
                invalidEmailsFixResult = new InvalidEmailsFixResult(list2, list, null, 4, null);
                break;
            }
            case 5: {
                invalidEmailsFixResult = GlobalUnsupportedUserHandler.buildCsvInvalidEmailsFixResult$default(this, invalidUsers, false, 2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        InvalidEmailsFixResult result2 = invalidEmailsFixResult;
        log.info("Fixing invalid emails in-memory completed with config = " + (Object)((Object)config2.getOnMigration()) + " and UDC mode = " + UDCMode.BASIC);
        return result2;
    }

    private final InvalidEmailsFixResult buildCsvInvalidEmailsFixResult(List<JiraUser> invalidUsers, boolean draft) {
        CsvCorrectedUsers csvCorrectedUsers = this.getCsvCorrectedUsers(invalidUsers, EmailCheckType.INV, draft);
        List<JiraUser> list = csvCorrectedUsers.getTombstone();
        List<JiraUser> list2 = csvCorrectedUsers.getNewMail();
        List<JiraUser> list3 = csvCorrectedUsers.getNotFixed();
        return new InvalidEmailsFixResult(list2, list, list3);
    }

    static /* synthetic */ InvalidEmailsFixResult buildCsvInvalidEmailsFixResult$default(GlobalUnsupportedUserHandler globalUnsupportedUserHandler, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return globalUnsupportedUserHandler.buildCsvInvalidEmailsFixResult(list, bl);
    }

    private final RemoveOrFixUsersResult getBeforeCutOffDateTombstoneUsersAndRemapUsersPair(InvalidEmailsConfig invalidUserConfig, List<JiraUser> invalidUsers, MigrationScopeContext migrationScopeContext) {
        LocalDate tombstoneCutoffDate = invalidUserConfig.getTombstoneCutoffDate();
        if (tombstoneCutoffDate == null) {
            throw new IllegalStateException("The tombstone cut-off date must be set to perform this operation.");
        }
        return this.removeOrFixUsers(invalidUsers, tombstoneCutoffDate, EmailCheckType.INV, migrationScopeContext);
    }

    @NotNull
    public final DuplicateEmailsFixResult fixDuplicateEmails(@NotNull List<JiraUser> duplicateUsers, @Nullable String containerToken, @Nullable String migrationScopeId2) {
        DuplicateEmailsFixResult duplicateEmailsFixResult;
        Intrinsics.checkNotNullParameter(duplicateUsers, (String)"duplicateUsers");
        switch (WhenMappings.$EnumSwitchMapping$0[this.configService.getUdcModeConfig().ordinal()]) {
            case 1: {
                duplicateEmailsFixResult = this.handleDuplicateEmailsWithAdvancedMode(duplicateUsers);
                break;
            }
            case 2: {
                duplicateEmailsFixResult = this.handleDuplicateEmailsWithBasicMode(duplicateUsers, containerToken, migrationScopeId2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DuplicateEmailsFixResult fixResult = duplicateEmailsFixResult;
        log.info("Found " + fixResult.getTombstone().size() + " users to tombstone, " + fixResult.getNewMail().size() + " to use new emails, " + fixResult.getMerge().size() + " to merge, " + fixResult.getDuplicate().size() + " still duplicated");
        return fixResult;
    }

    private final DuplicateEmailsFixResult handleDuplicateEmailsWithAdvancedMode(List<JiraUser> duplicateUsers) {
        return UDCConverterKt.toJCMA(this.udcDelegate.handleDuplicateEmailsWithAdvancedMode(UDCConverterKt.toUDCUsers(duplicateUsers)));
    }

    private final DuplicateEmailsFixResult handleDuplicateEmailsWithBasicMode(List<JiraUser> duplicateUsers, String containerToken, String migrationScopeId2) {
        DuplicateEmailsFixResult duplicateEmailsFixResult;
        DuplicatedEmailsConfig config2 = this.configService.getDuplicatedEmailsConfig();
        MigrationScopeContext migrationScopeContext = new MigrationScopeContext(containerToken, migrationScopeId2);
        switch (WhenMappings.$EnumSwitchMapping$2[config2.getOnMigration().ordinal()]) {
            case 1: {
                duplicateEmailsFixResult = new DuplicateEmailsFixResult(null, null, null, duplicateUsers, 7, null);
                break;
            }
            case 2: {
                duplicateEmailsFixResult = new DuplicateEmailsFixResult(null, duplicateUsers, null, null, 13, null);
                break;
            }
            case 3: {
                duplicateEmailsFixResult = new DuplicateEmailsFixResult(this.generateNewEmails(duplicateUsers, EmailCheckType.DUP, migrationScopeContext), null, null, null, 14, null);
                break;
            }
            case 4: {
                RemoveOrFixUsersResult fixedUsers = this.getBeforeCutOffDateMergeUsersAndRemapUsersPair(config2, duplicateUsers, migrationScopeContext);
                List<JiraUser> list = fixedUsers.getTombstoneOrMerge();
                List<JiraUser> list2 = fixedUsers.getNewEmail();
                duplicateEmailsFixResult = new DuplicateEmailsFixResult(list2, list, null, null, 12, null);
                break;
            }
            case 5: {
                duplicateEmailsFixResult = GlobalUnsupportedUserHandler.buildCsvDuplicateEmailsFixResult$default(this, duplicateUsers, false, 2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DuplicateEmailsFixResult result2 = duplicateEmailsFixResult;
        log.info("Fixing duplicated emails in-memory completed with config=" + (Object)((Object)config2.getOnMigration()) + " and UDC mode = " + UDCMode.BASIC + '.');
        return result2;
    }

    private final DuplicateEmailsFixResult buildCsvDuplicateEmailsFixResult(List<JiraUser> duplicateUsers, boolean draft) {
        CsvCorrectedUsers csvCorrectedUsers = this.getCsvCorrectedUsers(duplicateUsers, EmailCheckType.DUP, draft);
        List<JiraUser> list = csvCorrectedUsers.getTombstone();
        List<JiraUser> list2 = csvCorrectedUsers.getNewMail();
        List<JiraUser> list3 = csvCorrectedUsers.getNotFixed();
        return new DuplicateEmailsFixResult(list2, null, list, list3, 2, null);
    }

    static /* synthetic */ DuplicateEmailsFixResult buildCsvDuplicateEmailsFixResult$default(GlobalUnsupportedUserHandler globalUnsupportedUserHandler, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return globalUnsupportedUserHandler.buildCsvDuplicateEmailsFixResult(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JiraUser> generateNewEmails(List<JiraUser> users2, EmailCheckType type, MigrationScopeContext migrationScopeContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JiraUser jiraUser;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = users2;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            jiraUser = (JiraUser)element$iv$iv;
            boolean bl = false;
            if (!StringExtensionsKt.isNotNullOrBlank(jiraUser.getUserKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            jiraUser = (JiraUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getUserKey();
            Intrinsics.checkNotNull((Object)string);
            collection.add(JiraUser.copy$default((JiraUser)it, this.newEmailSuggestingService.suggest(string, it.getEmail(), type, (Context)new Context.CloudContext(migrationScopeContext.getContainerToken(), migrationScopeContext.getMigrationScopeId())), null, false, null, null, null, null, null, null, 510, null));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final CsvCorrectedUsers getCsvCorrectedUsers(List<JiraUser> incorrectUsers, EmailCheckType type, boolean draft) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        CsvCorrectedUsers result2 = new CsvCorrectedUsers(null, null, null, 7, null);
        Iterable iterable = this.correctedEmailService.fetchByEmailCheckType(type, this.configService.getUdcModeConfig(), draft);
        boolean $i$f$groupBy = false;
        void var8_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            CorrectedEmail it = (CorrectedEmail)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getUserKey().getStringValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            CorrectedEmail correctedEmail = (CorrectedEmail)CollectionsKt.first((List)((List)it.getValue()));
            map2.put(k, correctedEmail);
        }
        Map userKeyToCorrectedUser = destination$iv$iv;
        for (JiraUser user : incorrectUsers) {
            CorrectedEmail correctedUser = (CorrectedEmail)userKeyToCorrectedUser.get(user.getUserKey());
            if (correctedUser == null) {
                result2.getNotFixed().add(user);
                continue;
            }
            if (correctedUser.getTombstone()) {
                result2.getTombstone().add(user);
                continue;
            }
            result2.getNewMail().add(JiraUser.copy$default(user, correctedUser.getNewEmail(), null, false, null, null, null, null, null, null, 510, null));
        }
        return result2;
    }

    static /* synthetic */ CsvCorrectedUsers getCsvCorrectedUsers$default(GlobalUnsupportedUserHandler globalUnsupportedUserHandler, List list, EmailCheckType emailCheckType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return globalUnsupportedUserHandler.getCsvCorrectedUsers(list, emailCheckType, bl);
    }

    private final RemoveOrFixUsersResult getBeforeCutOffDateMergeUsersAndRemapUsersPair(DuplicatedEmailsConfig duplicateUserConfig, List<JiraUser> invalidUsers, MigrationScopeContext migrationScopeContext) {
        LocalDate mergeCutoffDate = duplicateUserConfig.getMergeCutoffDate();
        if (mergeCutoffDate == null) {
            throw new IllegalStateException("The merge cut-off date must be set to perform this operation.");
        }
        return this.removeOrFixUsers(invalidUsers, mergeCutoffDate, EmailCheckType.DUP, migrationScopeContext);
    }

    /*
     * WARNING - void declaration
     */
    private final RemoveOrFixUsersResult removeOrFixUsers(List<JiraUser> users2, LocalDate tombstoneCutoffDate, EmailCheckType checkType, MigrationScopeContext migrationScopeContext) {
        Collection<JiraUser> collection;
        JiraUser it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$partition$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = users2;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ApplicationUser it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JiraUser it2 = (JiraUser)element$iv$iv;
            boolean bl2 = false;
            if (this.userManager.getUserByKeyEvenWhenUnknown(it2.getUserKey()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$partition = false;
        Iterable first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            ApplicationUser it3 = (ApplicationUser)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it3);
            if (this.getLastLoginMillis(it3) < EmailConfigServiceKt.toMillis(tombstoneCutoffDate)) {
                ((ArrayList)first$iv).add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List usersToTombstoneOrMerge = (List)pair.component1();
        List usersToRemap = (List)pair.component2();
        first$iv = usersToTombstoneOrMerge;
        boolean $i$f$map = false;
        Iterator $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv = (ApplicationUser)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(JiraUser.Companion.fromApplicationUser((ApplicationUser)it));
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JiraUser)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            String string = IdentityAcceptedEmailValidator.cleanse((String)it.getEmail());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanse(...)");
            collection2.add(JiraUser.copy$default(it, string, null, false, null, null, null, null, null, null, 510, null));
        }
        $this$map$iv = usersToRemap;
        GlobalUnsupportedUserHandler globalUnsupportedUserHandler = this;
        collection2 = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ApplicationUser)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(JiraUser.Companion.fromApplicationUser((ApplicationUser)it));
        }
        collection = (List)destination$iv$iv2;
        List<JiraUser> list = globalUnsupportedUserHandler.generateNewEmails((List<JiraUser>)collection, checkType, migrationScopeContext);
        Collection collection3 = collection2;
        return new RemoveOrFixUsersResult((List<JiraUser>)collection3, list);
    }

    private final long getLastLoginMillis(ApplicationUser applicationUser) {
        String string = this.directoryManager.findUserWithAttributesByName(applicationUser.getDirectoryId(), applicationUser.getUsername()).getValue("login.lastLoginMillis");
        return string != null ? Long.parseLong(string) : EmailConfigServiceKt.neverLogInMillis();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler$CsvCorrectedUsers;", "", "tombstone", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "newMail", "notFixed", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getNewMail", "()Ljava/util/List;", "getNotFixed", "getTombstone", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    private static final class CsvCorrectedUsers {
        @NotNull
        private final List<JiraUser> tombstone;
        @NotNull
        private final List<JiraUser> newMail;
        @NotNull
        private final List<JiraUser> notFixed;

        public CsvCorrectedUsers(@NotNull List<JiraUser> tombstone, @NotNull List<JiraUser> newMail, @NotNull List<JiraUser> notFixed) {
            Intrinsics.checkNotNullParameter(tombstone, (String)"tombstone");
            Intrinsics.checkNotNullParameter(newMail, (String)"newMail");
            Intrinsics.checkNotNullParameter(notFixed, (String)"notFixed");
            this.tombstone = tombstone;
            this.newMail = newMail;
            this.notFixed = notFixed;
        }

        public /* synthetic */ CsvCorrectedUsers(List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            if ((n & 2) != 0) {
                list2 = new ArrayList();
            }
            if ((n & 4) != 0) {
                list3 = new ArrayList();
            }
            this(list, list2, list3);
        }

        @NotNull
        public final List<JiraUser> getTombstone() {
            return this.tombstone;
        }

        @NotNull
        public final List<JiraUser> getNewMail() {
            return this.newMail;
        }

        @NotNull
        public final List<JiraUser> getNotFixed() {
            return this.notFixed;
        }

        @NotNull
        public final List<JiraUser> component1() {
            return this.tombstone;
        }

        @NotNull
        public final List<JiraUser> component2() {
            return this.newMail;
        }

        @NotNull
        public final List<JiraUser> component3() {
            return this.notFixed;
        }

        @NotNull
        public final CsvCorrectedUsers copy(@NotNull List<JiraUser> tombstone, @NotNull List<JiraUser> newMail, @NotNull List<JiraUser> notFixed) {
            Intrinsics.checkNotNullParameter(tombstone, (String)"tombstone");
            Intrinsics.checkNotNullParameter(newMail, (String)"newMail");
            Intrinsics.checkNotNullParameter(notFixed, (String)"notFixed");
            return new CsvCorrectedUsers(tombstone, newMail, notFixed);
        }

        public static /* synthetic */ CsvCorrectedUsers copy$default(CsvCorrectedUsers csvCorrectedUsers, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = csvCorrectedUsers.tombstone;
            }
            if ((n & 2) != 0) {
                list2 = csvCorrectedUsers.newMail;
            }
            if ((n & 4) != 0) {
                list3 = csvCorrectedUsers.notFixed;
            }
            return csvCorrectedUsers.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "CsvCorrectedUsers(tombstone=" + this.tombstone + ", newMail=" + this.newMail + ", notFixed=" + this.notFixed + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.tombstone).hashCode();
            result2 = result2 * 31 + ((Object)this.newMail).hashCode();
            result2 = result2 * 31 + ((Object)this.notFixed).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CsvCorrectedUsers)) {
                return false;
            }
            CsvCorrectedUsers csvCorrectedUsers = (CsvCorrectedUsers)other;
            if (!Intrinsics.areEqual(this.tombstone, csvCorrectedUsers.tombstone)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.newMail, csvCorrectedUsers.newMail)) {
                return false;
            }
            return Intrinsics.areEqual(this.notFixed, csvCorrectedUsers.notFixed);
        }

        public CsvCorrectedUsers() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler$RemoveOrFixUsersResult;", "", "tombstoneOrMerge", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "newEmail", "(Ljava/util/List;Ljava/util/List;)V", "getNewEmail", "()Ljava/util/List;", "getTombstoneOrMerge", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    private static final class RemoveOrFixUsersResult {
        @NotNull
        private final List<JiraUser> tombstoneOrMerge;
        @NotNull
        private final List<JiraUser> newEmail;

        public RemoveOrFixUsersResult(@NotNull List<JiraUser> tombstoneOrMerge, @NotNull List<JiraUser> newEmail) {
            Intrinsics.checkNotNullParameter(tombstoneOrMerge, (String)"tombstoneOrMerge");
            Intrinsics.checkNotNullParameter(newEmail, (String)"newEmail");
            this.tombstoneOrMerge = tombstoneOrMerge;
            this.newEmail = newEmail;
        }

        @NotNull
        public final List<JiraUser> getTombstoneOrMerge() {
            return this.tombstoneOrMerge;
        }

        @NotNull
        public final List<JiraUser> getNewEmail() {
            return this.newEmail;
        }

        @NotNull
        public final List<JiraUser> component1() {
            return this.tombstoneOrMerge;
        }

        @NotNull
        public final List<JiraUser> component2() {
            return this.newEmail;
        }

        @NotNull
        public final RemoveOrFixUsersResult copy(@NotNull List<JiraUser> tombstoneOrMerge, @NotNull List<JiraUser> newEmail) {
            Intrinsics.checkNotNullParameter(tombstoneOrMerge, (String)"tombstoneOrMerge");
            Intrinsics.checkNotNullParameter(newEmail, (String)"newEmail");
            return new RemoveOrFixUsersResult(tombstoneOrMerge, newEmail);
        }

        public static /* synthetic */ RemoveOrFixUsersResult copy$default(RemoveOrFixUsersResult removeOrFixUsersResult, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = removeOrFixUsersResult.tombstoneOrMerge;
            }
            if ((n & 2) != 0) {
                list2 = removeOrFixUsersResult.newEmail;
            }
            return removeOrFixUsersResult.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "RemoveOrFixUsersResult(tombstoneOrMerge=" + this.tombstoneOrMerge + ", newEmail=" + this.newEmail + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.tombstoneOrMerge).hashCode();
            result2 = result2 * 31 + ((Object)this.newEmail).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoveOrFixUsersResult)) {
                return false;
            }
            RemoveOrFixUsersResult removeOrFixUsersResult = (RemoveOrFixUsersResult)other;
            if (!Intrinsics.areEqual(this.tombstoneOrMerge, removeOrFixUsersResult.tombstoneOrMerge)) {
                return false;
            }
            return Intrinsics.areEqual(this.newEmail, removeOrFixUsersResult.newEmail);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[UDCMode.values().length];
            try {
                nArray[UDCMode.ADVANCED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UDCMode.BASIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InvalidEmailsConfig.OnMigration.values().length];
            try {
                nArray[InvalidEmailsConfig.OnMigration.DO_NOTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InvalidEmailsConfig.OnMigration.TOMBSTONE_ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InvalidEmailsConfig.OnMigration.USE_NEW_EMAILS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InvalidEmailsConfig.OnMigration.TOMBSTONE_BEFORE_CUT_OFF_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InvalidEmailsConfig.OnMigration.USE_CSV.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[DuplicatedEmailsConfig.OnMigration.values().length];
            try {
                nArray[DuplicatedEmailsConfig.OnMigration.DO_NOTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuplicatedEmailsConfig.OnMigration.MERGE_ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuplicatedEmailsConfig.OnMigration.USE_NEW_EMAILS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuplicatedEmailsConfig.OnMigration.MERGE_BEFORE_CUT_OFF_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuplicatedEmailsConfig.OnMigration.USE_CSV.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

