/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.email.CsvWritingResult;
import com.atlassian.jira.migration.email.EmailCsvFileService;
import com.atlassian.jira.migration.email.FileCreationResult;
import com.atlassian.jira.migration.email.IncorrectEmailCsvWritingService;
import com.atlassian.jira.migration.email.OutputStreamWritingResult;
import com.atlassian.jira.migration.email.db.IncorrectEmailRepository;
import com.atlassian.jira.migration.email.model.BatchReadResult;
import com.atlassian.jira.migration.email.model.IncorrectEmail;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/email/IncorrectEmailCsvZipStreamingService;", "", "csvFileService", "Lcom/atlassian/jira/migration/email/EmailCsvFileService;", "incorrectEmailRepository", "Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;", "incorrectEmailCsvWritingService", "Lcom/atlassian/jira/migration/email/IncorrectEmailCsvWritingService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/email/EmailCsvFileService;Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;Lcom/atlassian/jira/migration/email/IncorrectEmailCsvWritingService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createAndWriteCsv", "Lcom/atlassian/jira/migration/email/FileCreationResult;", "preflightExecutionId", "", "emailCheckType", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "createCsvAndWriteToOutput", "Lcom/atlassian/jira/migration/email/OutputStreamWritingResult;", "outputStream", "Ljava/io/OutputStream;", "writeFileToOutput", "fileCreated", "Lcom/atlassian/jira/migration/email/FileCreationResult$Success;", "jira-migration-plugin"})
public final class IncorrectEmailCsvZipStreamingService {
    @NotNull
    private final EmailCsvFileService csvFileService;
    @NotNull
    private final IncorrectEmailRepository incorrectEmailRepository;
    @NotNull
    private final IncorrectEmailCsvWritingService incorrectEmailCsvWritingService;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public IncorrectEmailCsvZipStreamingService(@NotNull EmailCsvFileService csvFileService, @NotNull IncorrectEmailRepository incorrectEmailRepository, @NotNull IncorrectEmailCsvWritingService incorrectEmailCsvWritingService, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)csvFileService, (String)"csvFileService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailRepository, (String)"incorrectEmailRepository");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailCsvWritingService, (String)"incorrectEmailCsvWritingService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.csvFileService = csvFileService;
        this.incorrectEmailRepository = incorrectEmailRepository;
        this.incorrectEmailCsvWritingService = incorrectEmailCsvWritingService;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final FileCreationResult createAndWriteCsv(@NotNull String preflightExecutionId, @Nullable EmailCheckType emailCheckType) {
        FileCreationResult fileCreationResult;
        Intrinsics.checkNotNullParameter((Object)preflightExecutionId, (String)"preflightExecutionId");
        FileCreationResult csvCreationResult = this.csvFileService.tryCreateCsv(preflightExecutionId, "incorrect-email");
        if (csvCreationResult instanceof FileCreationResult.Success) {
            Sequence<BatchReadResult<IncorrectEmail>> readBatches2 = emailCheckType == null ? this.incorrectEmailRepository.read(preflightExecutionId, 100, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>((Object)this.objectMapper){

                @NotNull
                public final IncorrectEmail invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ObjectMapper $this$readValue$iv = (ObjectMapper)this.receiver;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    return (IncorrectEmail)$this$readValue$iv.readValue(p0, (TypeReference)new TypeReference<IncorrectEmail>(){});
                }
            })) : this.incorrectEmailRepository.readByType(preflightExecutionId, emailCheckType, 1000, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>((Object)this.objectMapper){

                @NotNull
                public final IncorrectEmail invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ObjectMapper $this$readValue$iv = (ObjectMapper)this.receiver;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    return (IncorrectEmail)$this$readValue$iv.readValue(p0, (TypeReference)new TypeReference<IncorrectEmail>(){});
                }
            }));
            CsvWritingResult res = this.incorrectEmailCsvWritingService.write((FileCreationResult.Success)csvCreationResult, readBatches2);
            if (res instanceof CsvWritingResult.Success) {
                fileCreationResult = csvCreationResult;
                return fileCreationResult;
            } else {
                if (!(res instanceof CsvWritingResult.Failed)) throw new NoWhenBranchMatchedException();
                this.csvFileService.tryDeleteCsv((FileCreationResult.Success)csvCreationResult);
                fileCreationResult = new FileCreationResult.Failed(preflightExecutionId, ((CsvWritingResult.Failed)res).getError());
            }
            return fileCreationResult;
        } else {
            if (!(csvCreationResult instanceof FileCreationResult.Failed)) throw new NoWhenBranchMatchedException();
            fileCreationResult = csvCreationResult;
        }
        return fileCreationResult;
    }

    public static /* synthetic */ FileCreationResult createAndWriteCsv$default(IncorrectEmailCsvZipStreamingService incorrectEmailCsvZipStreamingService, String string, EmailCheckType emailCheckType, int n, Object object) {
        if ((n & 2) != 0) {
            emailCheckType = null;
        }
        return incorrectEmailCsvZipStreamingService.createAndWriteCsv(string, emailCheckType);
    }

    @NotNull
    public final OutputStreamWritingResult writeFileToOutput(@NotNull FileCreationResult.Success fileCreated, @NotNull OutputStream outputStream) {
        OutputStreamWritingResult outputStreamWritingResult;
        Intrinsics.checkNotNullParameter((Object)fileCreated, (String)"fileCreated");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        OutputStreamWritingResult $this$writeFileToOutput_u24lambda_u240 = outputStreamWritingResult = this.csvFileService.writeAsZip(fileCreated, outputStream);
        boolean bl = false;
        if ($this$writeFileToOutput_u24lambda_u240 instanceof OutputStreamWritingResult.Failed) {
            this.csvFileService.tryDeleteCsv(fileCreated);
        }
        return outputStreamWritingResult;
    }

    @NotNull
    public final OutputStreamWritingResult createCsvAndWriteToOutput(@NotNull String preflightExecutionId, @NotNull OutputStream outputStream) {
        OutputStreamWritingResult outputStreamWritingResult;
        Intrinsics.checkNotNullParameter((Object)preflightExecutionId, (String)"preflightExecutionId");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        FileCreationResult csvCreateResult = IncorrectEmailCsvZipStreamingService.createAndWriteCsv$default(this, preflightExecutionId, null, 2, null);
        if (csvCreateResult instanceof FileCreationResult.Success) {
            outputStreamWritingResult = this.writeFileToOutput((FileCreationResult.Success)csvCreateResult, outputStream);
        } else if (csvCreateResult instanceof FileCreationResult.Failed) {
            outputStreamWritingResult = new OutputStreamWritingResult.Failed(preflightExecutionId, outputStream, ((FileCreationResult.Failed)csvCreateResult).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return outputStreamWritingResult;
    }
}

