/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.email.EmailConfigServiceKt;
import com.atlassian.jira.migration.email.model.IncorrectEmail;
import com.atlassian.jira.migration.jiraservice.JiraUserKeyService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.context.Context;
import com.atlassian.migration.udc.email.NewEmailSuggestingService;
import com.atlassian.sal.api.user.UserKey;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ:\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/email/IncorrectEmailSequenceGenerator;", "", "jiraUserKeyService", "Lcom/atlassian/jira/migration/jiraservice/JiraUserKeyService;", "newEmailSuggestingService", "Lcom/atlassian/migration/udc/email/NewEmailSuggestingService;", "directoryManager", "Lcom/atlassian/crowd/manager/directory/DirectoryManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "(Lcom/atlassian/jira/migration/jiraservice/JiraUserKeyService;Lcom/atlassian/migration/udc/email/NewEmailSuggestingService;Lcom/atlassian/crowd/manager/directory/DirectoryManager;Lcom/atlassian/jira/user/util/UserManager;)V", "generate", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/email/model/IncorrectEmail;", "checkType", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "preflightCheckType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "executionId", "", "emailDataList", "", "Lcom/atlassian/cmpt/check/email/EmailData;", "migrationScopeContext", "Lcom/atlassian/jira/migration/common/MigrationScopeContext;", "getLastLoginMillis", "", "applicationUser", "Lcom/atlassian/jira/user/ApplicationUser;", "(Lcom/atlassian/jira/user/ApplicationUser;)Ljava/lang/Long;", "jira-migration-plugin"})
public final class IncorrectEmailSequenceGenerator {
    @NotNull
    private final JiraUserKeyService jiraUserKeyService;
    @NotNull
    private final NewEmailSuggestingService newEmailSuggestingService;
    @NotNull
    private final DirectoryManager directoryManager;
    @NotNull
    private final UserManager userManager;

    @Inject
    public IncorrectEmailSequenceGenerator(@NotNull JiraUserKeyService jiraUserKeyService, @NotNull NewEmailSuggestingService newEmailSuggestingService, @NotNull DirectoryManager directoryManager, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter((Object)jiraUserKeyService, (String)"jiraUserKeyService");
        Intrinsics.checkNotNullParameter((Object)newEmailSuggestingService, (String)"newEmailSuggestingService");
        Intrinsics.checkNotNullParameter((Object)directoryManager, (String)"directoryManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        this.jiraUserKeyService = jiraUserKeyService;
        this.newEmailSuggestingService = newEmailSuggestingService;
        this.directoryManager = directoryManager;
        this.userManager = userManager;
    }

    @NotNull
    public final Sequence<IncorrectEmail> generate(@NotNull EmailCheckType checkType, @NotNull CheckType preflightCheckType, @NotNull String executionId, @NotNull List<? extends EmailData> emailDataList, @NotNull MigrationScopeContext migrationScopeContext) {
        Intrinsics.checkNotNullParameter((Object)checkType, (String)"checkType");
        Intrinsics.checkNotNullParameter((Object)((Object)preflightCheckType), (String)"preflightCheckType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(emailDataList, (String)"emailDataList");
        Intrinsics.checkNotNullParameter((Object)migrationScopeContext, (String)"migrationScopeContext");
        return SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)emailDataList), (Function1)((Function1)new Function1<EmailData, Pair<? extends String, ? extends EmailData>>(this){
            final /* synthetic */ IncorrectEmailSequenceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<String, EmailData> invoke(@NotNull EmailData emailData) {
                Pair pair;
                String userKey;
                Intrinsics.checkNotNullParameter((Object)emailData, (String)"emailData");
                JiraUserKeyService jiraUserKeyService = IncorrectEmailSequenceGenerator.access$getJiraUserKeyService$p(this.this$0);
                String string = emailData.id;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
                String string2 = userKey = jiraUserKeyService.getKeyForUsername(string);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)userKey, (Object)emailData);
                } else {
                    pair = null;
                }
                return pair;
            }
        })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends EmailData>, IncorrectEmail>(this, executionId, checkType, preflightCheckType, migrationScopeContext){
            final /* synthetic */ IncorrectEmailSequenceGenerator this$0;
            final /* synthetic */ String $executionId;
            final /* synthetic */ EmailCheckType $checkType;
            final /* synthetic */ CheckType $preflightCheckType;
            final /* synthetic */ MigrationScopeContext $migrationScopeContext;
            {
                this.this$0 = $receiver;
                this.$executionId = $executionId;
                this.$checkType = $checkType;
                this.$preflightCheckType = $preflightCheckType;
                this.$migrationScopeContext = $migrationScopeContext;
                super(1);
            }

            @NotNull
            public final IncorrectEmail invoke(@NotNull Pair<String, ? extends EmailData> pair) {
                Directory directory;
                ApplicationUser user;
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                String userKey = (String)pair.component1();
                EmailData emailData = (EmailData)pair.component2();
                ApplicationUser applicationUser = user = IncorrectEmailSequenceGenerator.access$getUserManager$p(this.this$0).getUserByKey(userKey);
                if (applicationUser != null) {
                    ApplicationUser applicationUser2 = applicationUser;
                    IncorrectEmailSequenceGenerator incorrectEmailSequenceGenerator = this.this$0;
                    ApplicationUser it = applicationUser2;
                    boolean bl = false;
                    directory = IncorrectEmailSequenceGenerator.access$getDirectoryManager$p(incorrectEmailSequenceGenerator).findDirectoryById(user.getDirectoryId());
                } else {
                    directory = null;
                }
                Directory directory2 = directory;
                UserKey userKey2 = new UserKey(userKey);
                NewEmailSuggestingService newEmailSuggestingService = IncorrectEmailSequenceGenerator.access$getNewEmailSuggestingService$p(this.this$0);
                String string = emailData.email;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"email");
                ApplicationUser applicationUser3 = user;
                Directory directory3 = directory2;
                return new IncorrectEmail(this.$executionId, userKey2, emailData, this.$checkType, this.$preflightCheckType, newEmailSuggestingService.suggest(userKey, string, this.$checkType, (Context)new Context.CloudContext(this.$migrationScopeContext.getContainerToken(), this.$migrationScopeContext.getMigrationScopeId())), applicationUser3 != null ? Long.valueOf(applicationUser3.getDirectoryId()) : null, directory3 != null ? directory3.getName() : null, IncorrectEmailSequenceGenerator.access$getLastLoginMillis(this.this$0, user));
            }
        }));
    }

    private final Long getLastLoginMillis(ApplicationUser applicationUser) {
        if (applicationUser == null) {
            return null;
        }
        String string = this.directoryManager.findUserWithAttributesByName(applicationUser.getDirectoryId(), applicationUser.getUsername()).getValue("login.lastLoginMillis");
        return string != null ? Long.valueOf(Long.parseLong(string)) : Long.valueOf(EmailConfigServiceKt.neverLogInMillis());
    }

    public static final /* synthetic */ JiraUserKeyService access$getJiraUserKeyService$p(IncorrectEmailSequenceGenerator $this) {
        return $this.jiraUserKeyService;
    }

    public static final /* synthetic */ UserManager access$getUserManager$p(IncorrectEmailSequenceGenerator $this) {
        return $this.userManager;
    }

    public static final /* synthetic */ NewEmailSuggestingService access$getNewEmailSuggestingService$p(IncorrectEmailSequenceGenerator $this) {
        return $this.newEmailSuggestingService;
    }

    public static final /* synthetic */ Long access$getLastLoginMillis(IncorrectEmailSequenceGenerator $this, ApplicationUser applicationUser) {
        return $this.getLastLoginMillis(applicationUser);
    }

    public static final /* synthetic */ DirectoryManager access$getDirectoryManager$p(IncorrectEmailSequenceGenerator $this) {
        return $this.directoryManager;
    }
}

