/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.common.SequenceExtensionKt;
import com.atlassian.jira.migration.email.ActionOnMigration;
import com.atlassian.jira.migration.email.DuplicateEmailsFixResult;
import com.atlassian.jira.migration.email.DuplicatedEmailStatisticsCacheKey;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.email.EmailStatistics;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.GlobalUnsupportedUserHandler;
import com.atlassian.jira.migration.email.IncorrectEmailDTO;
import com.atlassian.jira.migration.email.IncorrectEmailService;
import com.atlassian.jira.migration.email.IncorrectEmailServiceKt;
import com.atlassian.jira.migration.email.InvalidAndDuplicateEmailFix;
import com.atlassian.jira.migration.email.InvalidEmailStatisticsCacheKey;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.email.InvalidEmailsFixResult;
import com.atlassian.jira.migration.email.db.CorrectedEmailRepository;
import com.atlassian.jira.migration.email.db.IncorrectEmailRepository;
import com.atlassian.jira.migration.email.model.IncorrectEmail;
import com.atlassian.jira.migration.email.model.PageResponse;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.SortOrder;
import com.atlassian.jira.migration.serverdataextractors.UserBaseScanSortKey;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MBG\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0015\u0012\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0015\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#J<\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J>\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010$\u001a\u0004\u0018\u00010#J.\u00101\u001a\b\u0012\u0004\u0012\u00020'022\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0002J$\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u00103\u001a\u000204J\u0018\u00108\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#J<\u00109\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J>\u00109\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010$\u001a\u0004\u0018\u00010#J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020;022\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=02H\u0002J\u0012\u0010>\u001a\u0002002\b\u0010$\u001a\u0004\u0018\u00010#H\u0002J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020706J$\u0010@\u001a\b\u0012\u0004\u0012\u00020'022\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=022\u0006\u0010A\u001a\u00020BH\u0002J$\u0010C\u001a\b\u0012\u0004\u0012\u00020'022\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=022\u0006\u0010D\u001a\u00020EH\u0002J\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020G2\u0006\u0010\"\u001a\u00020#J\u0018\u0010I\u001a\u00020G2\u0006\u0010\"\u001a\u00020#2\b\u00103\u001a\u0004\u0018\u000104J\u000e\u0010J\u001a\u00020G2\u0006\u0010\"\u001a\u00020#J\u0010\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020#H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0018\u001aB\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001c0\u001c \u001b* \u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u001d\u001aB\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001e0\u001e\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001c0\u001c \u001b* \u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001e0\u001e\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/atlassian/jira/migration/email/IncorrectEmailService;", "", "incorrectEmailRepository", "Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;", "globalUnsupportedUserHandler", "Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "globalEmailFixesConfigService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "correctedEmailService", "Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;", "(Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;)V", "correctedEmailRepository", "invalidCacheBuilder", "Lcom/google/common/cache/CacheBuilder;", "duplicatedCacheBuilder", "(Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;Lcom/google/common/cache/CacheBuilder;Lcom/google/common/cache/CacheBuilder;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "duplicatedEmailStatisticsCache", "Lcom/google/common/cache/Cache;", "Lcom/atlassian/jira/migration/email/DuplicatedEmailStatisticsCacheKey;", "kotlin.jvm.PlatformType", "Lcom/atlassian/jira/migration/email/EmailStatistics;", "invalidEmailStatisticsCache", "Lcom/atlassian/jira/migration/email/InvalidEmailStatisticsCacheKey;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDuplicatedEmailStatistics", "executionId", "", "cloudId", "getDuplicatedEmails", "Lcom/atlassian/jira/migration/email/model/PageResponse;", "Lcom/atlassian/jira/migration/email/IncorrectEmailDTO;", "limit", "", "page", "sortKey", "Lcom/atlassian/jira/migration/serverdataextractors/UserBaseScanSortKey;", "sortOrder", "Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;", "migrationScopeContext", "Lcom/atlassian/jira/migration/common/MigrationScopeContext;", "getIncorrectEmails", "", "emailCheckType", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "getIncorrectEmailsSequence", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/email/InvalidAndDuplicateEmailFix;", "getInvalidEmailStatistics", "getInvalidEmails", "getJiraUsers", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "data", "Lcom/atlassian/jira/migration/email/model/IncorrectEmail;", "getMigrationContext", "getModifiedValidEmailsSequence", "handleDuplicatedEmails", "fixedDuplicatedEmails", "Lcom/atlassian/jira/migration/email/DuplicateEmailsFixResult;", "handleInvalidEmails", "fixedInvalidEmails", "Lcom/atlassian/jira/migration/email/InvalidEmailsFixResult;", "invalidateAllEmailStatisticsCache", "", "invalidateDuplicatedEmailStatisticsCache", "invalidateEmailStatisticsCache", "invalidateInvalidEmailStatisticsCache", "parseIncorrectEmail", "source", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIncorrectEmailService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncorrectEmailService.kt\ncom/atlassian/jira/migration/email/IncorrectEmailService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,516:1\n1045#2:517\n1477#2:518\n1502#2,3:519\n1505#2,3:529\n1477#2:532\n1502#2,3:533\n1505#2,3:543\n1238#2,4:548\n1477#2:552\n1502#2,3:553\n1505#2,3:563\n1238#2,4:568\n1549#2:572\n1620#2,3:573\n1045#2:576\n1477#2:577\n1502#2,3:578\n1505#2,3:588\n1477#2:591\n1502#2,3:592\n1505#2,3:602\n1238#2,4:607\n1477#2:611\n1502#2,3:612\n1505#2,3:622\n1238#2,4:627\n1477#2:631\n1502#2,3:632\n1505#2,3:642\n1238#2,4:647\n1549#2:651\n1620#2,3:652\n1603#2,9:655\n1855#2:664\n1856#2:666\n1612#2:667\n1549#2:668\n1620#2,3:669\n1549#2:672\n1620#2,3:673\n372#3,7:522\n372#3,7:536\n453#3:546\n403#3:547\n372#3,7:556\n453#3:566\n403#3:567\n372#3,7:581\n372#3,7:595\n453#3:605\n403#3:606\n372#3,7:615\n453#3:625\n403#3:626\n372#3,7:635\n453#3:645\n403#3:646\n1#4:665\n*S KotlinDebug\n*F\n+ 1 IncorrectEmailService.kt\ncom/atlassian/jira/migration/email/IncorrectEmailService\n*L\n116#1:517\n126#1:518\n126#1:519,3\n126#1:529,3\n129#1:532\n129#1:533,3\n129#1:543,3\n129#1:548,4\n131#1:552\n131#1:553,3\n131#1:563,3\n131#1:568,4\n135#1:572\n135#1:573,3\n182#1:576\n282#1:577\n282#1:578,3\n282#1:588,3\n285#1:591\n285#1:592,3\n285#1:602,3\n285#1:607,4\n286#1:611\n286#1:612,3\n286#1:622,3\n286#1:627,4\n288#1:631\n288#1:632,3\n288#1:642,3\n288#1:647,4\n292#1:651\n292#1:652,3\n390#1:655,9\n390#1:664\n390#1:666\n390#1:667\n391#1:668\n391#1:669,3\n392#1:672\n392#1:673,3\n126#1:522,7\n129#1:536,7\n129#1:546\n129#1:547\n131#1:556,7\n131#1:566\n131#1:567\n282#1:581,7\n285#1:595,7\n285#1:605\n285#1:606\n286#1:615,7\n286#1:625\n286#1:626\n288#1:635,7\n288#1:645\n288#1:646\n390#1:665\n*E\n"})
public final class IncorrectEmailService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IncorrectEmailRepository incorrectEmailRepository;
    @NotNull
    private final GlobalUnsupportedUserHandler globalUnsupportedUserHandler;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    @NotNull
    private final CorrectedEmailRepository correctedEmailRepository;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Cache<InvalidEmailStatisticsCacheKey, EmailStatistics> invalidEmailStatisticsCache;
    private final Cache<DuplicatedEmailStatisticsCacheKey, EmailStatistics> duplicatedEmailStatisticsCache;
    public static final int LIMIT_PER_PAGE = 100;

    public IncorrectEmailService(@NotNull IncorrectEmailRepository incorrectEmailRepository, @NotNull GlobalUnsupportedUserHandler globalUnsupportedUserHandler, @NotNull UserManager userManager, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationScopeManager migrationScopeManager, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService, @NotNull CorrectedEmailRepository correctedEmailRepository, @NotNull CacheBuilder<Object, Object> invalidCacheBuilder, @NotNull CacheBuilder<Object, Object> duplicatedCacheBuilder, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)incorrectEmailRepository, (String)"incorrectEmailRepository");
        Intrinsics.checkNotNullParameter((Object)globalUnsupportedUserHandler, (String)"globalUnsupportedUserHandler");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        Intrinsics.checkNotNullParameter((Object)correctedEmailRepository, (String)"correctedEmailRepository");
        Intrinsics.checkNotNullParameter(invalidCacheBuilder, (String)"invalidCacheBuilder");
        Intrinsics.checkNotNullParameter(duplicatedCacheBuilder, (String)"duplicatedCacheBuilder");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.incorrectEmailRepository = incorrectEmailRepository;
        this.globalUnsupportedUserHandler = globalUnsupportedUserHandler;
        this.userManager = userManager;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationScopeManager = migrationScopeManager;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.correctedEmailRepository = correctedEmailRepository;
        this.objectMapper = objectMapperFactory.createObjectMapper();
        this.invalidEmailStatisticsCache = invalidCacheBuilder.expireAfterAccess(1L, IncorrectEmailServiceKt.access$getCACHE_TIME_UNIT$p()).build();
        this.duplicatedEmailStatisticsCache = duplicatedCacheBuilder.expireAfterAccess(1L, IncorrectEmailServiceKt.access$getCACHE_TIME_UNIT$p()).build();
    }

    @Inject
    public IncorrectEmailService(@NotNull IncorrectEmailRepository incorrectEmailRepository, @NotNull GlobalUnsupportedUserHandler globalUnsupportedUserHandler, @NotNull UserManager userManager, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationScopeManager migrationScopeManager, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull CorrectedEmailRepository correctedEmailService) {
        Intrinsics.checkNotNullParameter((Object)incorrectEmailRepository, (String)"incorrectEmailRepository");
        Intrinsics.checkNotNullParameter((Object)globalUnsupportedUserHandler, (String)"globalUnsupportedUserHandler");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)correctedEmailService, (String)"correctedEmailService");
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"newBuilder(...)");
        CacheBuilder cacheBuilder2 = CacheBuilder.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder2, (String)"newBuilder(...)");
        this(incorrectEmailRepository, globalUnsupportedUserHandler, userManager, cloudSiteRepository, migrationScopeManager, globalEmailFixesConfigService, correctedEmailService, (CacheBuilder<Object, Object>)cacheBuilder, (CacheBuilder<Object, Object>)cacheBuilder2, objectMapperFactory);
    }

    @NotNull
    public final PageResponse<IncorrectEmailDTO> getInvalidEmails(@NotNull String executionId, int limit, int page, @NotNull UserBaseScanSortKey sortKey, @NotNull SortOrder sortOrder, @Nullable String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return this.getInvalidEmails(executionId, limit, page, sortKey, sortOrder, this.getMigrationContext(cloudId2));
    }

    @NotNull
    public final PageResponse<IncorrectEmailDTO> getInvalidEmails(@NotNull String executionId, int limit, int page, @NotNull UserBaseScanSortKey sortKey, @NotNull SortOrder sortOrder, @NotNull MigrationScopeContext migrationScopeContext) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Intrinsics.checkNotNullParameter((Object)migrationScopeContext, (String)"migrationScopeContext");
        List<IncorrectEmail> data2 = this.incorrectEmailRepository.findByTypeAndExecutionId(executionId, EmailCheckType.INV, limit, page, sortKey, sortOrder, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>(this){
            final /* synthetic */ IncorrectEmailService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IncorrectEmail invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IncorrectEmailService.access$parseIncorrectEmail(this.this$0, it);
            }
        }));
        long count2 = this.incorrectEmailRepository.countByTypeAndExecutionId(executionId, EmailCheckType.INV);
        InvalidEmailsFixResult inMemoryFix = this.globalUnsupportedUserHandler.fixInvalidEmails(this.getJiraUsers(data2), migrationScopeContext);
        List result2 = this.handleInvalidEmails(data2, inMemoryFix);
        if (sortKey == UserBaseScanSortKey.ON_MIGRATION) {
            Iterable $this$sortedBy$iv = result2;
            boolean $i$f$sortedBy = false;
            result2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IncorrectEmailDTO it = (IncorrectEmailDTO)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getActionOnMigration());
                    it = (IncorrectEmailDTO)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getActionOnMigration())));
                }
            });
        }
        return new PageResponse<IncorrectEmailDTO>(result2, count2, (long)Math.ceil((double)count2 / (double)limit));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncorrectEmailDTO> handleInvalidEmails(List<IncorrectEmail> data2, InvalidEmailsFixResult fixedInvalidEmails) {
        void $this$mapTo$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$groupByTo$iv$iv;
        ActionOnMigration actionOnMigration;
        Object object;
        Object k;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv2;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv2;
        void $this$groupByTo$iv$iv3;
        Iterable $this$groupBy$iv = fixedInvalidEmails.getNewMail();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv3) {
            Object object2;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            String key$iv$iv2 = p0.getUserKey();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
            if (value$iv$iv$iv2 == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv2;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map newEmails = destination$iv$iv;
        Object $this$groupBy$iv2 = fixedInvalidEmails.getInvalid();
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object3;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            key$iv$iv = p0.getUserKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv2 = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv2 = $this$mapValues$iv2;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl4 = false;
            actionOnMigration = ActionOnMigration.DO_NOTHING;
            object.put(k, actionOnMigration);
        }
        Map invalidEmails = destination$iv$iv2;
        Object $this$groupBy$iv3 = fixedInvalidEmails.getTombstone();
        boolean $i$f$groupBy3 = false;
        destination$iv$iv2 = $this$groupBy$iv3;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo3 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object4;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            String key$iv$iv3 = p0.getUserKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv3 = $this$getOrPut$iv$iv$iv.get(key$iv$iv3);
            if (value$iv$iv$iv3 == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv3, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv3;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv3 = destination$iv$iv3;
        boolean $i$f$mapValues2 = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            Map.Entry key$iv$iv3 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            Map.Entry value$iv$iv$iv3 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object = map;
            boolean bl6 = false;
            actionOnMigration = ActionOnMigration.TOMBSTONE;
            object.put(k, actionOnMigration);
        }
        Map tombstoneEmails = destination$iv$iv3;
        Map emailsMap = MapsKt.plus((Map)invalidEmails, (Map)tombstoneEmails);
        Iterable $this$map$iv = data2;
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IncorrectEmailDTO incorrectEmailDTO;
            void it;
            IncorrectEmail element$iv$iv$iv = (IncorrectEmail)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            if (newEmails.containsKey(it.getUserKeyValue())) {
                Object v = newEmails.get(it.getUserKeyValue());
                Intrinsics.checkNotNull(v);
                incorrectEmailDTO = IncorrectEmailDTO.Companion.fromIncorrectEmail(IncorrectEmail.copy$default((IncorrectEmail)it, null, null, null, null, null, ((JiraUser)CollectionsKt.first((List)((List)v))).getEmail(), null, null, null, 479, null), ActionOnMigration.USE_NEW_EMAIL);
            } else {
                incorrectEmailDTO = IncorrectEmailDTO.Companion.fromIncorrectEmail((IncorrectEmail)it, emailsMap.getOrDefault(it.getUserKeyValue(), ActionOnMigration.DO_NOTHING));
            }
            object.add(incorrectEmailDTO);
        }
        return (List)destination$iv$iv4;
    }

    @NotNull
    public final PageResponse<IncorrectEmailDTO> getDuplicatedEmails(@NotNull String executionId, int limit, int page, @NotNull UserBaseScanSortKey sortKey, @NotNull SortOrder sortOrder, @Nullable String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return this.getDuplicatedEmails(executionId, limit, page, sortKey, sortOrder, this.getMigrationContext(cloudId2));
    }

    @NotNull
    public final PageResponse<IncorrectEmailDTO> getDuplicatedEmails(@NotNull String executionId, int limit, int page, @NotNull UserBaseScanSortKey sortKey, @NotNull SortOrder sortOrder, @NotNull MigrationScopeContext migrationScopeContext) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Intrinsics.checkNotNullParameter((Object)migrationScopeContext, (String)"migrationScopeContext");
        List<IncorrectEmail> data2 = this.incorrectEmailRepository.findByTypeAndExecutionId(executionId, EmailCheckType.DUP, limit, page, sortKey, sortOrder, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>(this){
            final /* synthetic */ IncorrectEmailService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IncorrectEmail invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IncorrectEmailService.access$parseIncorrectEmail(this.this$0, it);
            }
        }));
        long count2 = this.incorrectEmailRepository.countByTypeAndExecutionId(executionId, EmailCheckType.DUP);
        DuplicateEmailsFixResult inMemoryFix = this.globalUnsupportedUserHandler.fixDuplicateEmails(this.getJiraUsers(data2), migrationScopeContext.getContainerToken(), migrationScopeContext.getMigrationScopeId());
        List result2 = this.handleDuplicatedEmails(data2, inMemoryFix);
        if (sortKey == UserBaseScanSortKey.ON_MIGRATION) {
            Iterable $this$sortedBy$iv = result2;
            boolean $i$f$sortedBy = false;
            result2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IncorrectEmailDTO it = (IncorrectEmailDTO)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getActionOnMigration());
                    it = (IncorrectEmailDTO)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getActionOnMigration())));
                }
            });
        }
        return new PageResponse<IncorrectEmailDTO>(result2, count2, (long)Math.ceil((double)count2 / (double)limit));
    }

    @NotNull
    public final EmailStatistics getInvalidEmailStatistics(@NotNull String executionId, @Nullable String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        InvalidEmailsConfig.OnMigration onMigration = this.globalEmailFixesConfigService.getInvalidEmailsConfig().getOnMigration();
        InvalidEmailStatisticsCacheKey cacheKey = new InvalidEmailStatisticsCacheKey(executionId, onMigration);
        Object object = this.invalidEmailStatisticsCache.get((Object)cacheKey, () -> IncorrectEmailService.getInvalidEmailStatistics$lambda$7(this, cloudId2, executionId));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (EmailStatistics)object;
    }

    @NotNull
    public final EmailStatistics getDuplicatedEmailStatistics(@NotNull String executionId, @Nullable String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        DuplicatedEmailsConfig.OnMigration onMigration = this.globalEmailFixesConfigService.getDuplicatedEmailsConfig().getOnMigration();
        DuplicatedEmailStatisticsCacheKey cacheKey = new DuplicatedEmailStatisticsCacheKey(executionId, onMigration);
        Object object = this.duplicatedEmailStatisticsCache.get((Object)cacheKey, () -> IncorrectEmailService.getDuplicatedEmailStatistics$lambda$8(this, cloudId2, executionId));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (EmailStatistics)object;
    }

    public final void invalidateAllEmailStatisticsCache() {
        this.invalidEmailStatisticsCache.invalidateAll();
        this.duplicatedEmailStatisticsCache.invalidateAll();
    }

    public final void invalidateEmailStatisticsCache(@NotNull String executionId, @Nullable EmailCheckType emailCheckType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        EmailCheckType emailCheckType2 = emailCheckType;
        switch (emailCheckType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[emailCheckType2.ordinal()]) {
            case -1: {
                this.invalidateInvalidEmailStatisticsCache(executionId);
                this.invalidateDuplicatedEmailStatisticsCache(executionId);
                break;
            }
            case 1: {
                this.invalidateInvalidEmailStatisticsCache(executionId);
                break;
            }
            case 2: {
                this.invalidateDuplicatedEmailStatisticsCache(executionId);
            }
        }
    }

    public final void invalidateInvalidEmailStatisticsCache(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        for (InvalidEmailsConfig.OnMigration onMigration : InvalidEmailsConfig.OnMigration.values()) {
            InvalidEmailStatisticsCacheKey cacheKey = new InvalidEmailStatisticsCacheKey(executionId, onMigration);
            this.invalidEmailStatisticsCache.invalidate((Object)cacheKey);
        }
    }

    public final void invalidateDuplicatedEmailStatisticsCache(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        for (DuplicatedEmailsConfig.OnMigration onMigration : DuplicatedEmailsConfig.OnMigration.values()) {
            DuplicatedEmailStatisticsCacheKey cacheKey = new DuplicatedEmailStatisticsCacheKey(executionId, onMigration);
            this.duplicatedEmailStatisticsCache.invalidate((Object)cacheKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncorrectEmailDTO> handleDuplicatedEmails(List<IncorrectEmail> data2, DuplicateEmailsFixResult fixedDuplicatedEmails) {
        void $this$mapTo$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$groupByTo$iv$iv;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv2;
        void $this$groupByTo$iv$iv2;
        ActionOnMigration actionOnMigration;
        Object object;
        Object k;
        void $this$mapValuesTo$iv$iv3;
        void $this$mapValues$iv3;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv3;
        void $this$groupByTo$iv$iv4;
        Iterable $this$groupBy$iv = fixedDuplicatedEmails.getNewMail();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv4) {
            Object object2;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            String key$iv$iv2 = p0.getUserKey();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
            if (value$iv$iv$iv2 == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv2;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map newEmails = destination$iv$iv;
        Object $this$groupBy$iv2 = fixedDuplicatedEmails.getDuplicate();
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv3) {
            Object object3;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            key$iv$iv = p0.getUserKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv2 = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv3 = $this$mapValues$iv3;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv3.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv3.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl4 = false;
            actionOnMigration = ActionOnMigration.DO_NOTHING;
            object.put(k, actionOnMigration);
        }
        Map duplicateEmails = destination$iv$iv2;
        Object $this$groupBy$iv3 = fixedDuplicatedEmails.getMerge();
        boolean $i$f$groupBy3 = false;
        destination$iv$iv2 = $this$groupBy$iv3;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo3 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object4;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            String key$iv$iv3 = p0.getUserKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv3 = $this$getOrPut$iv$iv$iv.get(key$iv$iv3);
            if (value$iv$iv$iv3 == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv3, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv3;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv3 = destination$iv$iv3;
        boolean $i$f$mapValues2 = false;
        $this$groupByTo$iv$iv2 = $this$mapValues$iv2;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            Map.Entry key$iv$iv3 = (Map.Entry)element$iv$iv$iv;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean bl = false;
            Map.Entry value$iv$iv$iv3 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl6 = false;
            actionOnMigration = ActionOnMigration.MERGE;
            object.put(k, actionOnMigration);
        }
        Map mergeEmails = destination$iv$iv3;
        Object $this$groupBy$iv4 = fixedDuplicatedEmails.getTombstone();
        boolean $i$f$groupBy4 = false;
        destination$iv$iv3 = $this$groupBy$iv4;
        Object destination$iv$iv4 = new LinkedHashMap();
        boolean $i$f$groupByTo4 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object5;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            String key$iv$iv4 = p0.getUserKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv4 = $this$getOrPut$iv$iv$iv.get(key$iv$iv4);
            if (value$iv$iv$iv4 == null) {
                boolean bl7 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv4, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv4;
            }
            List list$iv$iv = (List)object5;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv4 = destination$iv$iv4;
        boolean $i$f$mapValues3 = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo3 = false;
        Iterable $this$associateByTo$iv$iv$iv3 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo3 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv3) {
            void it$iv$iv;
            Map.Entry key$iv$iv4 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv4;
            boolean bl = false;
            Map.Entry value$iv$iv$iv4 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object = map;
            boolean bl8 = false;
            actionOnMigration = ActionOnMigration.TOMBSTONE;
            object.put(k, actionOnMigration);
        }
        Map tombstoneEmails = destination$iv$iv4;
        Map emailsMap = MapsKt.plus((Map)MapsKt.plus((Map)duplicateEmails, (Map)mergeEmails), (Map)tombstoneEmails);
        Iterable $this$map$iv = data2;
        boolean $i$f$map = false;
        destination$iv$iv4 = $this$map$iv;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IncorrectEmailDTO incorrectEmailDTO;
            void it;
            IncorrectEmail element$iv$iv$iv = (IncorrectEmail)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl = false;
            if (newEmails.containsKey(it.getUserKeyValue())) {
                Object v = newEmails.get(it.getUserKeyValue());
                Intrinsics.checkNotNull(v);
                incorrectEmailDTO = IncorrectEmailDTO.Companion.fromIncorrectEmail(IncorrectEmail.copy$default((IncorrectEmail)it, null, null, null, null, null, ((JiraUser)CollectionsKt.first((List)((List)v))).getEmail(), null, null, null, 479, null), ActionOnMigration.USE_NEW_EMAIL);
            } else {
                incorrectEmailDTO = IncorrectEmailDTO.Companion.fromIncorrectEmail((IncorrectEmail)it, emailsMap.getOrDefault(it.getUserKeyValue(), ActionOnMigration.DO_NOTHING));
            }
            object.add(incorrectEmailDTO);
        }
        return (List)destination$iv$iv5;
    }

    @NotNull
    public final Sequence<InvalidAndDuplicateEmailFix> getIncorrectEmailsSequence(@NotNull String executionId, @NotNull String cloudId2, @NotNull EmailCheckType emailCheckType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)emailCheckType, (String)"emailCheckType");
        MigrationScopeContext migrationContext = this.getMigrationContext(cloudId2);
        return (Sequence)new Sequence<InvalidAndDuplicateEmailFix>(this, emailCheckType, executionId, migrationContext){
            final /* synthetic */ IncorrectEmailService this$0;
            final /* synthetic */ EmailCheckType $emailCheckType;
            final /* synthetic */ String $executionId;
            final /* synthetic */ MigrationScopeContext $migrationContext;
            {
                this.this$0 = $receiver;
                this.$emailCheckType = $emailCheckType;
                this.$executionId = $executionId;
                this.$migrationContext = $migrationContext;
            }

            @NotNull
            public Iterator<InvalidAndDuplicateEmailFix> iterator() {
                return new Iterator<InvalidAndDuplicateEmailFix>(this.this$0, this.$emailCheckType, this.$executionId, this.$migrationContext){
                    private int incorrectEmailsPage;
                    @NotNull
                    private final LinkedList<IncorrectEmailDTO> incorrectEmailsBuffer;
                    final /* synthetic */ IncorrectEmailService this$0;
                    final /* synthetic */ EmailCheckType $emailCheckType;
                    final /* synthetic */ String $executionId;
                    final /* synthetic */ MigrationScopeContext $migrationContext;
                    {
                        this.this$0 = $receiver;
                        this.$emailCheckType = $emailCheckType;
                        this.$executionId = $executionId;
                        this.$migrationContext = $migrationContext;
                        this.incorrectEmailsPage = 1;
                        this.incorrectEmailsBuffer = new LinkedList<E>();
                    }

                    public final int getIncorrectEmailsPage() {
                        return this.incorrectEmailsPage;
                    }

                    public final void setIncorrectEmailsPage(int n) {
                        this.incorrectEmailsPage = n;
                    }

                    @NotNull
                    public final LinkedList<IncorrectEmailDTO> getIncorrectEmailsBuffer() {
                        return this.incorrectEmailsBuffer;
                    }

                    public boolean hasNext() {
                        if (this.incorrectEmailsBuffer.isEmpty()) {
                            this.incorrectEmailsBuffer.addAll(IncorrectEmailService.access$getIncorrectEmails(this.this$0, this.$emailCheckType, this.$executionId, this.incorrectEmailsPage, this.$migrationContext));
                            int n = this.incorrectEmailsPage;
                            this.incorrectEmailsPage = n + 1;
                        }
                        return !((Collection)this.incorrectEmailsBuffer).isEmpty();
                    }

                    @NotNull
                    public InvalidAndDuplicateEmailFix next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        IncorrectEmailDTO incorrectEmailDTO = this.incorrectEmailsBuffer.pop();
                        Intrinsics.checkNotNullExpressionValue((Object)incorrectEmailDTO, (String)"pop(...)");
                        return new InvalidAndDuplicateEmailFix(incorrectEmailDTO);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public final Sequence<InvalidAndDuplicateEmailFix> getModifiedValidEmailsSequence() {
        Sequence sequence;
        switch (WhenMappings.$EnumSwitchMapping$1[this.globalEmailFixesConfigService.getUdcModeConfig().ordinal()]) {
            case 1: {
                sequence = SequencesKt.emptySequence();
                break;
            }
            case 2: {
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.correctedEmailRepository.fetchByEmailCheckType(null, UDCMode.ADVANCED, false)), (Function1)getModifiedValidEmailsSequence.1.INSTANCE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sequence;
    }

    private final List<IncorrectEmailDTO> getIncorrectEmails(EmailCheckType emailCheckType, String executionId, int page, MigrationScopeContext migrationScopeContext) {
        return emailCheckType == EmailCheckType.DUP ? this.getDuplicatedEmails(executionId, 100, page, UserBaseScanSortKey.USERNAME, SortOrder.ASC, migrationScopeContext).getData() : this.getInvalidEmails(executionId, 100, page, UserBaseScanSortKey.USERNAME, SortOrder.ASC, migrationScopeContext).getData();
    }

    private final MigrationScopeContext getMigrationContext(String cloudId2) {
        String string = cloudId2;
        if (string != null) {
            CloudSite cloudSite2;
            String it = string;
            boolean bl = false;
            CloudSite cloudSite3 = cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
            Intrinsics.checkNotNull((Object)cloudSite3);
            String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite3);
            return new MigrationScopeContext(cloudSite2.getContainerToken(), migrationScopeId2);
        }
        return MigrationScopeContext.Companion.getEMPTY();
    }

    private final IncorrectEmail parseIncorrectEmail(String source) {
        Object object = this.objectMapper.readValue(source, IncorrectEmail.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (IncorrectEmail)object;
    }

    private final List<JiraUser> getJiraUsers(List<IncorrectEmail> data2) {
        JiraUser it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = data2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ApplicationUser applicationUser = $this$forEach$iv$iv$iv.iterator();
        while (applicationUser.hasNext()) {
            ApplicationUser it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = applicationUser.next();
            boolean bl = false;
            IncorrectEmail it2 = (IncorrectEmail)element$iv$iv;
            boolean bl2 = false;
            if (this.userManager.getUserByKey(it2.getUserKeyValue()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            applicationUser = (ApplicationUser)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(JiraUser.Companion.fromApplicationUser((ApplicationUser)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JiraUser)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = IdentityAcceptedEmailValidator.cleanse((String)it.getEmail());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanse(...)");
            collection.add(JiraUser.copy$default(it, string, null, false, null, null, null, null, null, null, 510, null));
        }
        return (List)destination$iv$iv;
    }

    private static final EmailStatistics getInvalidEmailStatistics$lambda$7(IncorrectEmailService this$0, String $cloudId, String $executionId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        MigrationScopeContext migrationScopeContent = this$0.getMigrationContext($cloudId);
        List data2 = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable(SequenceExtensionKt.takeWhileInclusive(this$0.incorrectEmailRepository.readByType($executionId, EmailCheckType.INV, 1000, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>(this$0){
            final /* synthetic */ IncorrectEmailService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IncorrectEmail invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IncorrectEmailService.access$parseIncorrectEmail(this.this$0, it);
            }
        })), getInvalidEmailStatistics.1.data.2.INSTANCE), (Function1)getInvalidEmailStatistics.1.data.3.INSTANCE));
        return EmailStatistics.Companion.fromIncorrectEmails(this$0.handleInvalidEmails(data2, this$0.globalUnsupportedUserHandler.fixInvalidEmails(this$0.getJiraUsers(data2), migrationScopeContent)));
    }

    private static final EmailStatistics getDuplicatedEmailStatistics$lambda$8(IncorrectEmailService this$0, String $cloudId, String $executionId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        MigrationScopeContext migrationScopeContent = this$0.getMigrationContext($cloudId);
        List data2 = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable(SequenceExtensionKt.takeWhileInclusive(this$0.incorrectEmailRepository.readByType($executionId, EmailCheckType.DUP, 1000, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>(this$0){
            final /* synthetic */ IncorrectEmailService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IncorrectEmail invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IncorrectEmailService.access$parseIncorrectEmail(this.this$0, it);
            }
        })), getDuplicatedEmailStatistics.1.data.2.INSTANCE), (Function1)getDuplicatedEmailStatistics.1.data.3.INSTANCE));
        return EmailStatistics.Companion.fromIncorrectEmails(this$0.handleDuplicatedEmails(data2, this$0.globalUnsupportedUserHandler.fixDuplicateEmails(this$0.getJiraUsers(data2), migrationScopeContent.getContainerToken(), migrationScopeContent.getMigrationScopeId())));
    }

    public static final /* synthetic */ IncorrectEmail access$parseIncorrectEmail(IncorrectEmailService $this, String source) {
        return $this.parseIncorrectEmail(source);
    }

    public static final /* synthetic */ List access$getIncorrectEmails(IncorrectEmailService $this, EmailCheckType emailCheckType, String executionId, int page, MigrationScopeContext migrationScopeContext) {
        return $this.getIncorrectEmails(emailCheckType, executionId, page, migrationScopeContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/email/IncorrectEmailService$Companion;", "", "()V", "LIMIT_PER_PAGE", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[EmailCheckType.values().length];
            try {
                nArray[EmailCheckType.INV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmailCheckType.DUP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UDCMode.values().length];
            try {
                nArray[UDCMode.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UDCMode.ADVANCED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

