/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.jira.migration.common.DomainId;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.email.BlockedDomainUmsService;
import com.atlassian.jira.migration.email.EmailsSource;
import com.atlassian.jira.migration.email.NewEmailSuggestingService;
import com.atlassian.jira.migration.email.NoValidEmailsException;
import com.atlassian.jira.migration.email.model.BlockedDomainLookupMethod;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.NewEmailSuggestingEventFinished;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUsersAndGroupsService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u0012H\u0002J]\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u00192-\u0010\u001a\u001a)\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J,\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)JF\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J(\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\b\b\u0002\u00105\u001a\u0002062\u0006\u0010$\u001a\u00020%J(\u00107\u001a\u0004\u0018\u00010\u000f2\u0014\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00132\u0006\u00109\u001a\u00020\u0014H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\r\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/atlassian/jira/migration/email/NewEmailSuggestingService;", "", "jiraUsersAndGroupsService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "blockedDomainUmsService", "Lcom/atlassian/jira/migration/email/BlockedDomainUmsService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/email/BlockedDomainUmsService;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "alphabetRegex", "Lkotlin/text/Regex;", "cachedMostFrequentDomainName", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "prefixFinders", "Lkotlin/sequences/Sequence;", "Lkotlin/Function1;", "Lcom/atlassian/jira/user/ApplicationUser;", "spaceRegex", "fetchAllUsersEmails", "getMostFrequentDomainName", "emailsProvider", "Lkotlin/Function0;", "blockedDomainsProvider", "", "Lcom/atlassian/jira/migration/common/DomainId;", "Lkotlin/ParameterName;", "name", "domainsToCheck", "blockedDomainsLookupType", "Lcom/atlassian/jira/migration/email/model/BlockedDomainLookupMethod;", "emailsSource", "Lcom/atlassian/jira/migration/email/EmailsSource;", "migrationScopeContext", "Lcom/atlassian/jira/migration/common/MigrationScopeContext;", "invalidateCache", "", "isMostFrequentDomainNameCached", "", "sendFinishedAnalyticsEvent", "emailsFetchedCount", "", "uniqueDomainsFetchedCount", "blockedEmailsDomains", "startBlockedDomainsProviderCall", "", "start", "suggest", "userKey", "defaultEmail", "type", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "tryNewPrefix", "findIt", "appUser", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nNewEmailSuggestingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewEmailSuggestingService.kt\ncom/atlassian/jira/migration/email/NewEmailSuggestingService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1055#2:182\n526#3:183\n511#3,6:184\n551#3:190\n536#3,6:191\n1#4:197\n*S KotlinDebug\n*F\n+ 1 NewEmailSuggestingService.kt\ncom/atlassian/jira/migration/email/NewEmailSuggestingService\n*L\n63#1:182\n65#1:183\n65#1:184,6\n71#1:190\n71#1:191,6\n*E\n"})
public final class NewEmailSuggestingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraUsersAndGroupsService jiraUsersAndGroupsService;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final BlockedDomainUmsService blockedDomainUmsService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private final Cache<String, String> cachedMostFrequentDomainName;
    @NotNull
    private final Sequence<Function1<ApplicationUser, String>> prefixFinders;
    @NotNull
    private final Regex spaceRegex;
    @NotNull
    private final Regex alphabetRegex;
    @NotNull
    private static final String MOST_FREQ_DOMAIN_NAME = "domain";
    private static final Logger log = LoggerFactory.getLogger(NewEmailSuggestingService.class);

    @Inject
    public NewEmailSuggestingService(@NotNull JiraUsersAndGroupsService jiraUsersAndGroupsService, @NotNull UserManager userManager, @NotNull BlockedDomainUmsService blockedDomainUmsService, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)jiraUsersAndGroupsService, (String)"jiraUsersAndGroupsService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)blockedDomainUmsService, (String)"blockedDomainUmsService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.jiraUsersAndGroupsService = jiraUsersAndGroupsService;
        this.userManager = userManager;
        this.blockedDomainUmsService = blockedDomainUmsService;
        this.migrationEventBus = migrationEventBus;
        this.cachedMostFrequentDomainName = CacheBuilder.newBuilder().build();
        Object[] objectArray = new Function1[]{prefixFinders.1.INSTANCE, prefixFinders.2.INSTANCE, prefixFinders.3.INSTANCE};
        this.prefixFinders = SequencesKt.sequenceOf((Object[])objectArray);
        this.spaceRegex = new Regex("\\s");
        this.alphabetRegex = new Regex("^[a-zA-Z]*$");
    }

    public final void invalidateCache() {
        this.cachedMostFrequentDomainName.invalidate((Object)MOST_FREQ_DOMAIN_NAME);
        log.info("The {} cache has been invalidated", (Object)MOST_FREQ_DOMAIN_NAME);
    }

    public final boolean isMostFrequentDomainNameCached() {
        return this.cachedMostFrequentDomainName.getIfPresent((Object)MOST_FREQ_DOMAIN_NAME) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final String getMostFrequentDomainName(Function0<? extends Sequence<String>> emailsProvider, Function1<? super List<DomainId>, ? extends List<DomainId>> blockedDomainsProvider, BlockedDomainLookupMethod blockedDomainsLookupType, EmailsSource emailsSource) {
        Object v0;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Map $this$groupingBy$iv;
        long start = System.currentTimeMillis();
        Sequence sequence = SequencesKt.mapNotNull((Sequence)((Sequence)emailsProvider.invoke()), (Function1)getMostFrequentDomainName.emailsDomains.1.INSTANCE);
        boolean $i$f$groupingBy = false;
        $this$groupingBy$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<DomainId, DomainId>((Sequence)$this$groupingBy$iv){
            final /* synthetic */ Sequence $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<DomainId> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                DomainId it = (DomainId)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = object.next();
            boolean bl = false;
            if (!IdentityAcceptedEmailValidator.isValidEmailAddress((String)((DomainId)it.getKey()).generateRandomEmail())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map emailsDomains2 = destination$iv$iv;
        long startBlockedDomainsProviderCall = System.currentTimeMillis();
        List blockedEmailsDomains = (List)blockedDomainsProvider.invoke((Object)CollectionsKt.toList((Iterable)emailsDomains2.keySet()));
        object = emailsDomains2;
        boolean $i$f$filterNot = false;
        it = $this$filterNot$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (blockedEmailsDomains.contains(it2.getKey())) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable iterable = destination$iv$iv2.entrySet();
        Iterator iterator3 = iterable.iterator();
        if (!iterator3.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator3.next();
            if (!iterator3.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it3 = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it3.getValue()).intValue();
                do {
                    Object t2 = iterator3.next();
                    Map.Entry it4 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-NewEmailSuggestingService$getMostFrequentDomainName$domain$2 = false;
                    int n2 = ((Number)it4.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator3.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        DomainId domain = entry != null ? (DomainId)entry.getKey() : null;
        log.info("Refreshed most frequent domain name cache using blocked domains lookup of: " + blockedDomainsLookupType.name());
        this.sendFinishedAnalyticsEvent(CollectionsKt.sumOfInt((Iterable)emailsDomains2.values()), emailsDomains2.keySet().size(), blockedEmailsDomains, emailsSource, blockedDomainsLookupType, startBlockedDomainsProviderCall, start);
        if (domain == null) {
            throw new NoValidEmailsException("No valid domain found for any email from: " + (Object)((Object)emailsSource));
        }
        return domain.getStandardizedDomain();
    }

    @Nullable
    public final String getMostFrequentDomainName(@NotNull Function0<? extends Sequence<String>> emailsProvider, @NotNull EmailsSource emailsSource, @NotNull MigrationScopeContext migrationScopeContext) {
        Intrinsics.checkNotNullParameter(emailsProvider, (String)"emailsProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)emailsSource), (String)"emailsSource");
        Intrinsics.checkNotNullParameter((Object)migrationScopeContext, (String)"migrationScopeContext");
        BlockedDomainLookupMethod blockedDomainLookupMethod = migrationScopeContext.hasContext() ? BlockedDomainLookupMethod.UMS : BlockedDomainLookupMethod.NONE;
        return (String)this.cachedMostFrequentDomainName.get((Object)MOST_FREQ_DOMAIN_NAME, () -> NewEmailSuggestingService.getMostFrequentDomainName$lambda$4(this, emailsProvider, blockedDomainLookupMethod, emailsSource, migrationScopeContext));
    }

    @Nullable
    public final String getMostFrequentDomainName(@NotNull MigrationScopeContext migrationScopeContext) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeContext, (String)"migrationScopeContext");
        return this.getMostFrequentDomainName((Function0<? extends Sequence<String>>)((Function0)new Function0<Sequence<? extends String>>(this){
            final /* synthetic */ NewEmailSuggestingService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Sequence<String> invoke() {
                return NewEmailSuggestingService.access$fetchAllUsersEmails(this.this$0);
            }
        }), EmailsSource.FETCHED, migrationScopeContext);
    }

    private final Sequence<String> fetchAllUsersEmails() {
        return SequencesKt.map((Sequence)JiraUsersAndGroupsService.allUsersForMigrationExceptJsmCustomers$default(this.jiraUsersAndGroupsService, null, 1, null), (Function1)fetchAllUsersEmails.1.INSTANCE);
    }

    @NotNull
    public final String suggest(@NotNull String userKey, @NotNull String defaultEmail, @NotNull EmailCheckType type, @NotNull MigrationScopeContext migrationScopeContext) {
        Object object;
        block5: {
            block4: {
                String prefix2;
                Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
                Intrinsics.checkNotNullParameter((Object)defaultEmail, (String)"defaultEmail");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)migrationScopeContext, (String)"migrationScopeContext");
                ApplicationUser appUser = this.userManager.getUserByKey(userKey);
                String string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull(this.prefixFinders, (Function1)((Function1)new Function1<Function1<? super ApplicationUser, ? extends String>, String>(appUser, this){
                    final /* synthetic */ ApplicationUser $appUser;
                    final /* synthetic */ NewEmailSuggestingService this$0;
                    {
                        this.$appUser = $appUser;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final String invoke(@NotNull Function1<? super ApplicationUser, String> findIt) {
                        String string;
                        Intrinsics.checkNotNullParameter(findIt, (String)"findIt");
                        ApplicationUser applicationUser = this.$appUser;
                        if (applicationUser != null) {
                            ApplicationUser applicationUser2 = applicationUser;
                            NewEmailSuggestingService newEmailSuggestingService = this.this$0;
                            ApplicationUser appUser = applicationUser2;
                            boolean bl = false;
                            string = NewEmailSuggestingService.access$tryNewPrefix(newEmailSuggestingService, findIt, appUser);
                        } else {
                            string = null;
                        }
                        return string;
                    }
                })));
                if (string == null) {
                    string = prefix2 = type.name();
                }
                if ((object = appUser) == null) break block4;
                ApplicationUser it = object;
                boolean bl = false;
                String string2 = prefix2 + '_' + it.getId() + '@' + this.getMostFrequentDomainName(migrationScopeContext);
                object = string2;
                if (string2 != null) break block5;
            }
            String string = IdentityAcceptedEmailValidator.cleanse((String)defaultEmail);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanse(...)");
        }
        return object;
    }

    public static /* synthetic */ String suggest$default(NewEmailSuggestingService newEmailSuggestingService, String string, String string2, EmailCheckType emailCheckType, MigrationScopeContext migrationScopeContext, int n, Object object) {
        if ((n & 4) != 0) {
            emailCheckType = EmailCheckType.INV;
        }
        return newEmailSuggestingService.suggest(string, string2, emailCheckType, migrationScopeContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String tryNewPrefix(Function1<? super ApplicationUser, String> findIt, ApplicationUser appUser) {
        CharSequence charSequence;
        String string;
        String string2 = (String)findIt.invoke((Object)appUser);
        if (string2 == null) return null;
        String it = string2;
        boolean bl = false;
        String string3 = it.length() > 10 ? StringsKt.take((String)it, (int)10) : it;
        if (string3 == null) return null;
        Regex regex = this.spaceRegex;
        CharSequence charSequence2 = string3;
        String string4 = "";
        String string5 = regex.replace(charSequence2, string4);
        if (string5 == null) return null;
        String string6 = string = string5;
        boolean bl2 = false;
        if (StringsKt.isBlank((CharSequence)string6)) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        String string7 = string;
        charSequence2 = string7;
        if (charSequence2 == null) return null;
        CharSequence charSequence3 = charSequence = charSequence2;
        boolean bl4 = false;
        CharSequence charSequence4 = charSequence3;
        if (!this.alphabetRegex.matches(charSequence4)) return null;
        CharSequence charSequence5 = charSequence;
        return charSequence5;
    }

    private final void sendFinishedAnalyticsEvent(int emailsFetchedCount, int uniqueDomainsFetchedCount, List<DomainId> blockedEmailsDomains, EmailsSource emailsSource, BlockedDomainLookupMethod blockedDomainsLookupType, long startBlockedDomainsProviderCall, long start) {
        long finishedTime = System.currentTimeMillis();
        this.migrationEventBus.post(new NewEmailSuggestingEventFinished(emailsFetchedCount, uniqueDomainsFetchedCount, blockedEmailsDomains.size(), emailsSource.name(), blockedDomainsLookupType.name(), finishedTime - startBlockedDomainsProviderCall, finishedTime - start));
    }

    private static final String getMostFrequentDomainName$lambda$4(NewEmailSuggestingService this$0, Function0 $emailsProvider, BlockedDomainLookupMethod $blockedDomainLookupMethod, EmailsSource $emailsSource, MigrationScopeContext $migrationScopeContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$emailsProvider, (String)"$emailsProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)$blockedDomainLookupMethod), (String)"$blockedDomainLookupMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)$emailsSource), (String)"$emailsSource");
        Intrinsics.checkNotNullParameter((Object)$migrationScopeContext, (String)"$migrationScopeContext");
        return this$0.getMostFrequentDomainName((Function0<? extends Sequence<String>>)$emailsProvider, (Function1<? super List<DomainId>, ? extends List<DomainId>>)((Function1)new Function1<List<? extends DomainId>, List<? extends DomainId>>($blockedDomainLookupMethod, this$0, $migrationScopeContext){
            final /* synthetic */ BlockedDomainLookupMethod $blockedDomainLookupMethod;
            final /* synthetic */ NewEmailSuggestingService this$0;
            final /* synthetic */ MigrationScopeContext $migrationScopeContext;
            {
                this.$blockedDomainLookupMethod = $blockedDomainLookupMethod;
                this.this$0 = $receiver;
                this.$migrationScopeContext = $migrationScopeContext;
                super(1);
            }

            @NotNull
            public final List<DomainId> invoke(@NotNull List<DomainId> it) {
                List<DomainId> list;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (this.$blockedDomainLookupMethod == BlockedDomainLookupMethod.UMS) {
                    BlockedDomainUmsService blockedDomainUmsService = NewEmailSuggestingService.access$getBlockedDomainUmsService$p(this.this$0);
                    String string = this.$migrationScopeContext.getContainerToken();
                    Intrinsics.checkNotNull((Object)string);
                    String string2 = this.$migrationScopeContext.getMigrationScopeId();
                    Intrinsics.checkNotNull((Object)string2);
                    list = blockedDomainUmsService.getBlockedDomainsFromUms(string, string2, it);
                } else {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        }), $blockedDomainLookupMethod, $emailsSource);
    }

    public static final /* synthetic */ Sequence access$fetchAllUsersEmails(NewEmailSuggestingService $this) {
        return $this.fetchAllUsersEmails();
    }

    public static final /* synthetic */ String access$tryNewPrefix(NewEmailSuggestingService $this, Function1 findIt, ApplicationUser appUser) {
        return $this.tryNewPrefix((Function1<? super ApplicationUser, String>)findIt, appUser);
    }

    public static final /* synthetic */ BlockedDomainUmsService access$getBlockedDomainUmsService$p(NewEmailSuggestingService $this) {
        return $this.blockedDomainUmsService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/email/NewEmailSuggestingService$Companion;", "", "()V", "MOST_FREQ_DOMAIN_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

