/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.email.DuplicateEmailsFixResult;
import com.atlassian.jira.migration.email.FixAllEmailsResult;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.GlobalUnsupportedUserHandler;
import com.atlassian.jira.migration.email.InvalidEmailService;
import com.atlassian.jira.migration.email.InvalidEmailsFixResult;
import com.atlassian.jira.migration.email.NoValidEmailsException;
import com.atlassian.jira.migration.email.UsersFixedData;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissions;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.atlassian.jira.migration.serverdataextractors.usergroup.MergedUsers;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.usermapping.event.UserMappingEventMigrationStart;
import com.atlassian.jira.migration.utils.CompletableFutureUtil;
import com.atlassian.jira.migration.utils.EmailValidityCheckerUtil;
import com.atlassian.migration.udc.common.model.user.AccountType;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.email.MostFrequentDomainService;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 R2\u00020\u0001:\u0001RB9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J8\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J$\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0004\u0012\u00020$0\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0002J:\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0(2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020.J(\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$H\u0002J*\u00101\u001a\b\u0012\u0004\u0012\u00020\u001d022\u0006\u00103\u001a\u0002042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002JN\u00106\u001a\u00020\u00162\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u00108\u001a\u00020.2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010+\u001a\u0004\u0018\u00010$2\b\u0010,\u001a\u0004\u0018\u00010$2\b\b\u0002\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020:J4\u0010<\u001a\u00020\u00162\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010=\u001a\u00020.2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$J(\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001d0 J4\u0010A\u001a\u00020\u00162\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010=\u001a\u00020.2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$J*\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001d022\u0006\u0010C\u001a\u00020D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J*\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001d022\u0006\u0010C\u001a\u00020D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002JH\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d022\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$H\u0002J \u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 J:\u0010I\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\u0004\u0012\u00020D0J2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0002J\u0010\u00109\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0002J2\u0010K\u001a\b\u0012\u0004\u0012\u00020$022\f\u0010L\u001a\b\u0012\u0004\u0012\u00020$022\u0014\u0010M\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0004\u0012\u00020$0\u001cH\u0002J0\u0010N\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020$020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010!\u001a\u00020\"H\u0002J$\u0010O\u001a\u00020\u00162\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020$JJ\u0010P\u001a\u00020\u00162\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u00108\u001a\u00020.2\u0006\u0010#\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010,\u001a\u00020$2\b\b\u0002\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020:J(\u0010Q\u001a\u00020)2\u0006\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/atlassian/jira/migration/email/UserEmailFixer;", "", "globalUnsupportedUserHandler", "Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler;", "invalidEmailService", "Lcom/atlassian/jira/migration/email/InvalidEmailService;", "configService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "mostFrequentDomainService", "Lcom/atlassian/migration/udc/email/MostFrequentDomainService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/atlassian/jira/migration/email/GlobalUnsupportedUserHandler;Lcom/atlassian/jira/migration/email/InvalidEmailService;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/migration/udc/email/MostFrequentDomainService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Ljava/util/concurrent/ExecutorService;)V", "buildAndSendAnalyticsEvent", "", "invalidEmailsFixResult", "Lcom/atlassian/jira/migration/email/InvalidEmailsFixResult;", "duplicatedEmailsFixResult", "Lcom/atlassian/jira/migration/email/DuplicateEmailsFixResult;", "mappedUsers", "Lcom/atlassian/jira/migration/email/FixAllEmailsResult;", "allUserCount", "", "buildJiraUserGroupMigrationData", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserGroupMigrationData;", "usersTobeMigrated", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/MergedUsers;", "usersToBeRemapped", "", "data", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "migrationScopeId", "", "buildUserKeyToEmailMap", "usersToMigrate", "buildUsersFixedData", "Ljava/util/concurrent/CompletableFuture;", "Lcom/atlassian/jira/migration/email/UsersFixedData;", "usersExtractionResult", "preflightCheckExecutionId", "containerToken", "accountType", "Lcom/atlassian/migration/udc/common/model/user/AccountType;", "customersFixedData", "customersExtractionResult", "extractJiraUsersFromCheckResults", "", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "userNameToUserMap", "fixAllEmailsInMemory", "users", "usersAccountType", "refreshMostFrequentDomainName", "", "sendUserMergeAnalytics", "fixDuplicatedEmailsInMemory", "usersAccType", "fixEmailCasingForDuplicateEmails", "distinctUsers", "allUsers", "fixInvalidEmailsInMemory", "getUsersWithDuplicateEmails", "checkContext", "Lcom/atlassian/cmpt/check/email/EmailCheckContext;", "userNameToUser", "getUsersWithInvalidEmails", "getUsersWithInvalidEmailsFromUMS", "mergeDuplicateUsers", "prepareUserData", "Lkotlin/Triple;", "replaceUserKeysWithEmails", "members", "keyToEmailMap", "rewriteMembershipsForCloudMigration", "safelyFixAllCustomerEmailInMemory", "safelyFixAllEmailInMemory", "usersFixedData", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserEmailFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserEmailFixer.kt\ncom/atlassian/jira/migration/email/UserEmailFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,458:1\n1054#2:459\n1477#2:460\n1502#2,3:461\n1505#2,3:471\n1194#2,2:478\n1222#2,4:480\n1549#2:484\n1620#2,3:485\n1238#2,4:490\n1179#2,2:494\n1253#2,4:496\n1603#2,9:500\n1855#2:509\n1856#2:511\n1612#2:512\n1477#2:514\n1502#2,3:515\n1505#2,3:525\n1549#2:535\n1620#2,3:536\n766#2:539\n857#2,2:540\n1549#2:542\n1620#2,3:543\n1549#2:546\n1620#2,3:547\n1549#2:550\n1620#2,3:551\n1477#2:554\n1502#2,3:555\n1505#2,3:565\n1238#2,4:570\n1549#2:574\n1620#2,3:575\n1360#2:578\n1446#2,5:579\n1549#2:584\n1620#2,3:585\n372#3,7:464\n453#3:488\n403#3:489\n372#3,7:518\n526#3:528\n511#3,6:529\n372#3,7:558\n453#3:568\n403#3:569\n125#4:474\n152#4,3:475\n1#5:510\n1#5:513\n*S KotlinDebug\n*F\n+ 1 UserEmailFixer.kt\ncom/atlassian/jira/migration/email/UserEmailFixer\n*L\n160#1:459\n161#1:460\n161#1:461,3\n161#1:471,3\n175#1:478,2\n175#1:480,4\n176#1:484\n176#1:485,3\n192#1:490,4\n197#1:494,2\n197#1:496,4\n200#1:500,9\n200#1:509\n200#1:511\n200#1:512\n317#1:514\n317#1:515,3\n317#1:525,3\n319#1:535\n319#1:536,3\n322#1:539\n322#1:540,2\n353#1:542\n353#1:543,3\n357#1:546\n357#1:547,3\n359#1:550\n359#1:551,3\n360#1:554\n360#1:555,3\n360#1:565,3\n360#1:570,4\n372#1:574\n372#1:575,3\n381#1:578\n381#1:579,5\n381#1:584\n381#1:585,3\n161#1:464,7\n192#1:488\n192#1:489\n317#1:518,7\n318#1:528\n318#1:529,6\n360#1:558,7\n360#1:568\n360#1:569\n162#1:474\n162#1:475,3\n200#1:510\n*E\n"})
public final class UserEmailFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalUnsupportedUserHandler globalUnsupportedUserHandler;
    @NotNull
    private final InvalidEmailService invalidEmailService;
    @NotNull
    private final GlobalEmailFixesConfigService configService;
    @NotNull
    private final MostFrequentDomainService mostFrequentDomainService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final ExecutorService executorService;
    private static final Logger log = LoggerFactory.getLogger(UserEmailFixer.class);

    @Inject
    public UserEmailFixer(@NotNull GlobalUnsupportedUserHandler globalUnsupportedUserHandler, @NotNull InvalidEmailService invalidEmailService, @NotNull GlobalEmailFixesConfigService configService, @NotNull MostFrequentDomainService mostFrequentDomainService, @NotNull MigrationEventBus migrationEventBus, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)globalUnsupportedUserHandler, (String)"globalUnsupportedUserHandler");
        Intrinsics.checkNotNullParameter((Object)invalidEmailService, (String)"invalidEmailService");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)mostFrequentDomainService, (String)"mostFrequentDomainService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.globalUnsupportedUserHandler = globalUnsupportedUserHandler;
        this.invalidEmailService = invalidEmailService;
        this.configService = configService;
        this.mostFrequentDomainService = mostFrequentDomainService;
        this.migrationEventBus = migrationEventBus;
        this.executorService = executorService;
    }

    public /* synthetic */ UserEmailFixer(GlobalUnsupportedUserHandler globalUnsupportedUserHandler, InvalidEmailService invalidEmailService, GlobalEmailFixesConfigService globalEmailFixesConfigService, MostFrequentDomainService mostFrequentDomainService, MigrationEventBus migrationEventBus, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            ExecutorService executorService2 = Executors.newCachedThreadPool(new GroupedThreadFactory("UserEmailFixer"));
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newCachedThreadPool(...)");
            executorService = executorService2;
        }
        this(globalUnsupportedUserHandler, invalidEmailService, globalEmailFixesConfigService, mostFrequentDomainService, migrationEventBus, executorService);
    }

    @NotNull
    public final CompletableFuture<UsersFixedData> buildUsersFixedData(@NotNull CompletableFuture<UsersGroupsExtractionResult> usersExtractionResult, @NotNull String preflightCheckExecutionId, @NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull AccountType accountType) {
        Intrinsics.checkNotNullParameter(usersExtractionResult, (String)"usersExtractionResult");
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)accountType, (String)"accountType");
        CompletableFuture<UsersFixedData> completableFuture = CompletableFuture.supplyAsync(() -> UserEmailFixer.buildUsersFixedData$lambda$0(accountType, this, usersExtractionResult, migrationScopeId2, preflightCheckExecutionId, containerToken), this.executorService);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private final UsersFixedData customersFixedData(UsersGroupsExtractionResult customersExtractionResult, String migrationScopeId2, String preflightCheckExecutionId, String containerToken) {
        FixAllEmailsResult fixAllEmailsResult;
        try {
            fixAllEmailsResult = UserEmailFixer.fixAllEmailsInMemory$default(this, CollectionsKt.toList((Iterable)customersExtractionResult.getUsers()), AccountType.CUSTOMER, migrationScopeId2, preflightCheckExecutionId, containerToken, false, false, 96, null);
        }
        catch (UncheckedExecutionException e) {
            if (!(ExceptionUtils.getRootCause((Throwable)e) instanceof NoValidEmailsException)) {
                throw e;
            }
            fixAllEmailsResult = new FixAllEmailsResult(null, null, null, CollectionsKt.toList((Iterable)customersExtractionResult.getUsers()), null, null, null, null, null, null, null, 2039, null);
        }
        FixAllEmailsResult customersFixResults = fixAllEmailsResult;
        return new UsersFixedData(customersFixResults, null, 2, null);
    }

    private final UsersFixedData usersFixedData(UsersGroupsExtractionResult usersExtractionResult, String migrationScopeId2, String preflightCheckExecutionId, String containerToken) {
        FixAllEmailsResult fixAllEmailsResult;
        try {
            fixAllEmailsResult = UserEmailFixer.fixAllEmailsInMemory$default(this, CollectionsKt.toList((Iterable)usersExtractionResult.getUsers()), AccountType.USER, migrationScopeId2, preflightCheckExecutionId, containerToken, false, false, 96, null);
        }
        catch (UncheckedExecutionException e) {
            if (!(ExceptionUtils.getRootCause((Throwable)e) instanceof NoValidEmailsException)) {
                throw e;
            }
            fixAllEmailsResult = new FixAllEmailsResult(null, null, null, CollectionsKt.toList((Iterable)usersExtractionResult.getUsers()), null, null, null, null, null, null, null, 2039, null);
        }
        FixAllEmailsResult userFixResults = fixAllEmailsResult;
        List<JiraUser> notTombstonedUsers = userFixResults.notTombstonedUsers();
        Map<JiraUser, MergedUsers> distinctUsers = this.mergeDuplicateUsers(notTombstonedUsers);
        JiraUserGroupMigrationData userData = this.buildJiraUserGroupMigrationData(distinctUsers, this.fixEmailCasingForDuplicateEmails(CollectionsKt.toList((Iterable)distinctUsers.keySet()), notTombstonedUsers), usersExtractionResult, migrationScopeId2);
        return new UsersFixedData(userFixResults, userData);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<JiraUser, MergedUsers> mergeDuplicateUsers(@NotNull List<JiraUser> users2) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        boolean bl;
        JiraUser it;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(users2, (String)"users");
        Iterable $this$sortedByDescending$iv = users2;
        boolean $i$f$sortedByDescending = false;
        Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JiraUser it = (JiraUser)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getActive());
                it = (JiraUser)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getActive()));
            }
        });
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object t = iterator2.next();
            it = (JiraUser)t;
            bl = false;
            String key$iv$iv = Companion.sanitizeDuplicatedEmailForMerge(it.getEmail());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = entry;
            Object object = destination$iv$iv;
            bl = false;
            object.add(TuplesKt.to(((List)it.getValue()).get(0), (Object)new MergedUsers(((List)it.getValue()).size() > 1 ? ((List)it.getValue()).subList(1, ((List)it.getValue()).size()) : CollectionsKt.emptyList())));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JiraUser> fixEmailCasingForDuplicateEmails(@NotNull List<JiraUser> distinctUsers, @NotNull List<JiraUser> allUsers2) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(distinctUsers, (String)"distinctUsers");
        Intrinsics.checkNotNullParameter(allUsers2, (String)"allUsers");
        Iterable $this$associateBy$iv = distinctUsers;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            JiraUser jiraUser = (JiraUser)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(Companion.sanitizeDuplicatedEmailForMerge(it.getEmail()), element$iv$iv);
        }
        Map emailToUserMap = destination$iv$iv;
        Iterable $this$map$iv = allUsers2;
        boolean $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (JiraUser)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Object v = emailToUserMap.get(Companion.sanitizeDuplicatedEmailForMerge(it.getEmail()));
            Intrinsics.checkNotNull(v);
            object.add(JiraUser.copy$default((JiraUser)it, ((JiraUser)v).getEmail(), null, false, null, null, null, null, null, null, 510, null));
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public final JiraUserGroupMigrationData buildJiraUserGroupMigrationData(@NotNull Map<JiraUser, MergedUsers> usersTobeMigrated, @NotNull List<JiraUser> usersToBeRemapped, @NotNull UsersGroupsExtractionResult data2, @NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter(usersTobeMigrated, (String)"usersTobeMigrated");
        Intrinsics.checkNotNullParameter(usersToBeRemapped, (String)"usersToBeRemapped");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        return new JiraUserGroupMigrationData(usersTobeMigrated, (List<JiraGroupWithPermissions>)CollectionsKt.toList((Iterable)data2.getGroups()), this.rewriteMembershipsForCloudMigration(usersToBeRemapped, data2), migrationScopeId2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Set<String>> rewriteMembershipsForCloudMigration(List<JiraUser> usersToBeRemapped, UsersGroupsExtractionResult data2) {
        void $this$mapValuesTo$iv$iv;
        Map<String, String> keyToEmailMap = this.buildUserKeyToEmailMap(usersToBeRemapped);
        Map<String, Set<String>> $this$mapValues$iv = data2.getMembership();
        boolean $i$f$mapValues = false;
        Map<String, Set<String>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Set<String> set = this.replaceUserKeysWithEmails((Set)it.getValue(), keyToEmailMap);
            map3.put(k, set);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> buildUserKeyToEmailMap(List<JiraUser> usersToMigrate) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = usersToMigrate;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            JiraUser it = (JiraUser)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getUserKey(), (Object)it.getEmail());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> replaceUserKeysWithEmails(Set<String> members, Map<String, String> keyToEmailMap) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = members;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (keyToEmailMap.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final FixAllEmailsResult safelyFixAllEmailInMemory(@NotNull List<JiraUser> users2, @NotNull AccountType usersAccountType, @NotNull String migrationScopeId2, @Nullable String preflightCheckExecutionId, @NotNull String containerToken, boolean refreshMostFrequentDomainName, boolean sendUserMergeAnalytics) {
        Intrinsics.checkNotNullParameter(users2, (String)"users");
        Intrinsics.checkNotNullParameter((Object)usersAccountType, (String)"usersAccountType");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        FixAllEmailsResult fixedEmails = this.fixAllEmailsInMemory(users2, usersAccountType, migrationScopeId2, preflightCheckExecutionId, containerToken, refreshMostFrequentDomainName, sendUserMergeAnalytics);
        if (!(fixedEmails.getInvalid().isEmpty() && fixedEmails.getDuplicate().isEmpty())) {
            boolean bl = false;
            String string = "Failed to migrate because " + fixedEmails.getInvalid().size() + " invalid and " + fixedEmails.getDuplicate().size() + " duplicated emails were detected.";
            throw new IllegalStateException(string.toString());
        }
        return fixedEmails;
    }

    public static /* synthetic */ FixAllEmailsResult safelyFixAllEmailInMemory$default(UserEmailFixer userEmailFixer, List list, AccountType accountType, String string, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        return userEmailFixer.safelyFixAllEmailInMemory(list, accountType, string, string2, string3, bl, bl2);
    }

    @NotNull
    public final FixAllEmailsResult safelyFixAllCustomerEmailInMemory(@NotNull List<JiraUser> users2, @NotNull String migrationScopeId2, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter(users2, (String)"users");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        return UserEmailFixer.safelyFixAllEmailInMemory$default(this, users2, AccountType.CUSTOMER, migrationScopeId2, null, containerToken, true, false, 64, null);
    }

    @NotNull
    public final FixAllEmailsResult fixAllEmailsInMemory(@NotNull List<JiraUser> users2, @NotNull AccountType usersAccountType, @Nullable String migrationScopeId2, @Nullable String preflightCheckExecutionId, @Nullable String containerToken, boolean refreshMostFrequentDomainName, boolean sendUserMergeAnalytics) {
        FixAllEmailsResult mappedUsers;
        DuplicateEmailsFixResult duplicatedEmailsFixResult;
        List duplicateUsersList;
        InvalidEmailsFixResult invalidEmailsFixResult;
        List invalidUsersList;
        block9: {
            Object object;
            Set<JiraUser> set;
            Intrinsics.checkNotNullParameter(users2, (String)"users");
            Intrinsics.checkNotNullParameter((Object)usersAccountType, (String)"usersAccountType");
            this.refreshMostFrequentDomainName(refreshMostFrequentDomainName);
            if (users2.isEmpty()) {
                return new FixAllEmailsResult(null, null, null, null, null, null, null, null, null, null, null, 2047, null);
            }
            Triple<List<JiraUser>, Map<String, JiraUser>, EmailCheckContext> triple = this.prepareUserData(users2);
            List usersWithTrimmedEmails = (List)triple.component1();
            Map userNameToUserMap = (Map)triple.component2();
            EmailCheckContext checkContext = (EmailCheckContext)triple.component3();
            if (usersAccountType == AccountType.CUSTOMER || Intrinsics.areEqual((Object)migrationScopeId2, (Object)"dummyMigrationScopeId")) {
                set = this.getUsersWithInvalidEmails(checkContext, userNameToUserMap);
            } else {
                if (migrationScopeId2 == null) {
                    boolean $i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$42 = false;
                    String $i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$42 = "Migration scope ID is required to get invalid emails using UMS";
                    throw new IllegalArgumentException($i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$42.toString());
                }
                if (preflightCheckExecutionId == null) {
                    boolean $i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$52 = false;
                    String $i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$52 = "Preflight check execution ID is required to get invalid emails using UMS";
                    throw new IllegalArgumentException($i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$52.toString());
                }
                if (containerToken == null) {
                    boolean $i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$62 = false;
                    String $i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$62 = "Container token is required to get invalid emails using UMS";
                    throw new IllegalArgumentException($i$a$-requireNotNull-UserEmailFixer$fixAllEmailsInMemory$invalidUsers$62.toString());
                }
                set = this.getUsersWithInvalidEmailsFromUMS(userNameToUserMap, usersWithTrimmedEmails, migrationScopeId2, preflightCheckExecutionId, containerToken);
            }
            Set<JiraUser> invalidUsers = set;
            invalidUsersList = CollectionsKt.toList((Iterable)invalidUsers);
            invalidEmailsFixResult = this.globalUnsupportedUserHandler.fixInvalidEmails(invalidUsersList, new MigrationScopeContext(containerToken, migrationScopeId2));
            Set duplicatedUsers = SetsKt.minus(this.getUsersWithDuplicateEmails(checkContext, userNameToUserMap), (Iterable)invalidUsers);
            duplicateUsersList = CollectionsKt.toList((Iterable)duplicatedUsers);
            duplicatedEmailsFixResult = this.globalUnsupportedUserHandler.fixDuplicateEmails(duplicateUsersList, containerToken, migrationScopeId2);
            List validUsers = CollectionsKt.minus((Iterable)usersWithTrimmedEmails, (Iterable)SetsKt.plus((Set)duplicatedUsers, (Iterable)invalidUsers));
            mappedUsers = this.globalUnsupportedUserHandler.applyUserMappings(validUsers);
            if (!sendUserMergeAnalytics || this.configService.getUdcModeConfig() != UDCMode.ADVANCED) break block9;
            Object object2 = this;
            try {
                UserEmailFixer $this$fixAllEmailsInMemory_u24lambda_u2413 = object2;
                boolean bl = false;
                $this$fixAllEmailsInMemory_u24lambda_u2413.buildAndSendAnalyticsEvent(invalidEmailsFixResult, duplicatedEmailsFixResult, mappedUsers, users2.size());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                log.warn("Failed to send user mapping analytics event", (Throwable)it);
            }
        }
        return new FixAllEmailsResult(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)invalidEmailsFixResult.getNewMail(), (Iterable)duplicatedEmailsFixResult.getNewMail()), (Iterable)mappedUsers.getNewMail()), duplicatedEmailsFixResult.getMerge(), CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)invalidEmailsFixResult.getTombstone(), (Iterable)duplicatedEmailsFixResult.getTombstone()), (Iterable)mappedUsers.getTombstone()), invalidEmailsFixResult.getInvalid(), duplicatedEmailsFixResult.getDuplicate(), mappedUsers.getValid(), duplicatedEmailsFixResult.getNewMail(), invalidEmailsFixResult.getNewMail(), mappedUsers.getNewMail(), invalidUsersList, duplicateUsersList);
    }

    public static /* synthetic */ FixAllEmailsResult fixAllEmailsInMemory$default(UserEmailFixer userEmailFixer, List list, AccountType accountType, String string, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        return userEmailFixer.fixAllEmailsInMemory(list, accountType, string, string2, string3, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAndSendAnalyticsEvent(InvalidEmailsFixResult invalidEmailsFixResult, DuplicateEmailsFixResult duplicatedEmailsFixResult, FixAllEmailsResult mappedUsers, int allUserCount) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv22;
        void $this$filterTo$iv$iv2;
        Map allEmailsGrouped;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        int modifiedInvalidCount = invalidEmailsFixResult.getNewMail().size() + invalidEmailsFixResult.getTombstone().size();
        int modifiedDuplicateCount = duplicatedEmailsFixResult.getNewMail().size() + duplicatedEmailsFixResult.getTombstone().size();
        int modifiedValidCount = mappedUsers.getNewMail().size() + mappedUsers.getTombstone().size();
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)invalidEmailsFixResult.getNewMail(), (Iterable)duplicatedEmailsFixResult.getNewMail()), (Iterable)mappedUsers.getNewMail()), (Iterable)mappedUsers.getValid());
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            JiraUser jiraUser = (JiraUser)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = Companion.sanitizeDuplicatedEmailForMerge(jiraUser.getEmail());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list = (List)object;
            list.add(element$iv$iv2);
        }
        Map $this$filter$iv = allEmailsGrouped = destination$iv$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        element$iv$iv2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry entry;
            Map.Entry it2 = entry = (Map.Entry)element$iv$iv2.next();
            boolean bl = false;
            if (!(((List)it2.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(entry.getKey(), entry.getValue());
        }
        Map emailsToBeMerged = destination$iv$iv2;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)invalidEmailsFixResult.getNewMail(), (Iterable)duplicatedEmailsFixResult.getNewMail()), (Iterable)mappedUsers.getNewMail());
        boolean $i$f$map232 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            void it3;
            JiraUser bl = (JiraUser)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl3 = false;
            collection.add(it3.getEmail());
        }
        List allNewEmailsGrouped = (List)destination$iv$iv3;
        Iterable $i$f$map232 = emailsToBeMerged.values();
        int $this$mapTo$iv$iv22 = 0;
        for (Object $i$f$mapTo22 : $i$f$map232) {
            List list = (List)$i$f$mapTo22;
            int n = $this$mapTo$iv$iv22;
            boolean bl = false;
            int n2 = list.size();
            $this$mapTo$iv$iv22 = n + n2;
        }
        int mergeUserCount = $this$mapTo$iv$iv22;
        Iterable $this$filter$iv2 = allNewEmailsGrouped;
        boolean $i$f$filter2 = false;
        Iterable $i$f$mapTo22 = $this$filter$iv2;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            String it4 = (String)element$iv$iv3;
            boolean bl = false;
            if (!(!emailsToBeMerged.keySet().contains(it4))) continue;
            collection.add(element$iv$iv3);
        }
        int useNewEmailUserCount = ((List)collection).size();
        int tombstoneUserCount = invalidEmailsFixResult.getTombstone().size() + duplicatedEmailsFixResult.getTombstone().size() + mappedUsers.getTombstone().size();
        UserMappingEventMigrationStart userMappingEvent = new UserMappingEventMigrationStart(modifiedInvalidCount, modifiedDuplicateCount, modifiedValidCount, allUserCount, mergeUserCount, useNewEmailUserCount, tombstoneUserCount);
        this.migrationEventBus.post(userMappingEvent);
    }

    private final Set<JiraUser> getUsersWithInvalidEmailsFromUMS(Map<String, JiraUser> userNameToUserMap, List<JiraUser> users2, String migrationScopeId2, String preflightCheckExecutionId, String containerToken) {
        CheckResult checkResult = this.invalidEmailService.validate(preflightCheckExecutionId, containerToken, migrationScopeId2, users2);
        return this.extractJiraUsersFromCheckResults(checkResult, userNameToUserMap);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<JiraUser> extractJiraUsersFromCheckResults(CheckResult checkResult, Map<String, JiraUser> userNameToUserMap) {
        void $this$mapTo$iv$iv;
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        Iterable $this$map$iv = EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailData emailData = (EmailData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JiraUser jiraUser = userNameToUserMap.get(it.id);
            Intrinsics.checkNotNull((Object)jiraUser);
            collection.add(jiraUser);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Triple<List<JiraUser>, Map<String, JiraUser>, EmailCheckContext> prepareUserData(List<JiraUser> users2) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = users2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JiraUser jiraUser = (JiraUser)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = IdentityAcceptedEmailValidator.cleanse((String)it.getEmail());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanse(...)");
            object.add(JiraUser.copy$default((JiraUser)it, string, null, false, null, null, null, null, null, null, 510, null));
        }
        List usersWithTrimmedEmails = (List)destination$iv$iv;
        Iterable $this$map$iv2 = usersWithTrimmedEmails;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            JiraUser bl = (JiraUser)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(new EmailData(user.getUserName(), user.getEmail()));
        }
        List emailData = (List)destination$iv$iv2;
        Object $this$groupBy$iv = usersWithTrimmedEmails;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            JiraUser p0 = (JiraUser)element$iv$iv;
            boolean bl = false;
            key$iv$iv = p0.getUserName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map;
            boolean bl4 = false;
            JiraUser jiraUser = (JiraUser)CollectionsKt.first((List)((List)it.getValue()));
            object.put(k, jiraUser);
        }
        Map userNameToUserMap = destination$iv$iv3;
        EmailCheckContext checkContext = new EmailCheckContext(emailData);
        return new Triple((Object)usersWithTrimmedEmails, (Object)userNameToUserMap, (Object)checkContext);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<JiraUser> getUsersWithInvalidEmails(EmailCheckContext checkContext, Map<String, JiraUser> userNameToUser) {
        void $this$mapTo$iv$iv;
        CheckResult checkResult = EmailValidityCheckerUtil.INSTANCE.check(checkContext);
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        List invalidEmails = EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map);
        Iterable $this$map$iv = invalidEmails;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailData emailData = (EmailData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JiraUser jiraUser = userNameToUser.get(it.id);
            Intrinsics.checkNotNull((Object)jiraUser);
            collection.add(jiraUser);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<JiraUser> getUsersWithDuplicateEmails(EmailCheckContext checkContext, Map<String, JiraUser> userNameToUser) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        EmailDuplicate it;
        void $this$flatMapTo$iv$iv;
        CheckResult checkResult = new EmailDuplicateChecker().check(checkContext);
        List invalidEmails = EmailDuplicateChecker.retrieveEmailDuplicates((Map)checkResult.details);
        Intrinsics.checkNotNull((Object)invalidEmails);
        Iterable $this$flatMap$iv = invalidEmails;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (EmailDuplicate)element$iv$iv;
            boolean bl = false;
            List list = it.ids;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ids");
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JiraUser jiraUser = userNameToUser.get(it);
            Intrinsics.checkNotNull((Object)jiraUser);
            collection.add(jiraUser);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final FixAllEmailsResult fixInvalidEmailsInMemory(@NotNull List<JiraUser> users2, @NotNull AccountType usersAccType, @NotNull String migrationScopeId2, @NotNull String preflightCheckExecutionId, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter(users2, (String)"users");
        Intrinsics.checkNotNullParameter((Object)usersAccType, (String)"usersAccType");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Triple<List<JiraUser>, Map<String, JiraUser>, EmailCheckContext> triple = this.prepareUserData(users2);
        List usersWithTrimmedEmails = (List)triple.component1();
        Map userNameToUserMap = (Map)triple.component2();
        EmailCheckContext checkContext = (EmailCheckContext)triple.component3();
        Set<JiraUser> invalidUsers = usersAccType == AccountType.CUSTOMER ? this.getUsersWithInvalidEmails(checkContext, userNameToUserMap) : this.getUsersWithInvalidEmailsFromUMS(userNameToUserMap, usersWithTrimmedEmails, migrationScopeId2, preflightCheckExecutionId, containerToken);
        InvalidEmailsFixResult invalidEmailsFixResult = this.globalUnsupportedUserHandler.fixInvalidEmails(CollectionsKt.toList((Iterable)invalidUsers), new MigrationScopeContext(containerToken, migrationScopeId2));
        return new FixAllEmailsResult(invalidEmailsFixResult.getNewMail(), CollectionsKt.emptyList(), invalidEmailsFixResult.getTombstone(), invalidEmailsFixResult.getInvalid(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, null, null, null, null, 1984, null);
    }

    @NotNull
    public final FixAllEmailsResult fixDuplicatedEmailsInMemory(@NotNull List<JiraUser> users2, @NotNull AccountType usersAccType, @NotNull String migrationScopeId2, @NotNull String preflightCheckExecutionId, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter(users2, (String)"users");
        Intrinsics.checkNotNullParameter((Object)usersAccType, (String)"usersAccType");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Triple<List<JiraUser>, Map<String, JiraUser>, EmailCheckContext> triple = this.prepareUserData(users2);
        List usersWithTrimmedEmails = (List)triple.component1();
        Map userNameToUserMap = (Map)triple.component2();
        EmailCheckContext checkContext = (EmailCheckContext)triple.component3();
        Set<JiraUser> invalidEmails = usersAccType == AccountType.CUSTOMER ? this.getUsersWithInvalidEmails(checkContext, userNameToUserMap) : this.getUsersWithInvalidEmailsFromUMS(userNameToUserMap, usersWithTrimmedEmails, migrationScopeId2, preflightCheckExecutionId, containerToken);
        Set duplicatedUsers = SetsKt.minus(this.getUsersWithDuplicateEmails(checkContext, userNameToUserMap), (Iterable)invalidEmails);
        DuplicateEmailsFixResult duplicatedEmailsFixResult = this.globalUnsupportedUserHandler.fixDuplicateEmails(CollectionsKt.toList((Iterable)duplicatedUsers), containerToken, migrationScopeId2);
        return new FixAllEmailsResult(duplicatedEmailsFixResult.getNewMail(), duplicatedEmailsFixResult.getMerge(), duplicatedEmailsFixResult.getTombstone(), CollectionsKt.emptyList(), duplicatedEmailsFixResult.getDuplicate(), CollectionsKt.emptyList(), null, null, null, null, null, 1984, null);
    }

    private final void refreshMostFrequentDomainName(boolean refreshMostFrequentDomainName) {
        if (refreshMostFrequentDomainName && (this.configService.getDuplicatedEmailsConfig().getOnMigration().createsNewEmails() || this.configService.getInvalidEmailsConfig().getOnMigration().createsNewEmails())) {
            this.mostFrequentDomainService.invalidateCache();
        }
    }

    private static final UsersFixedData buildUsersFixedData$lambda$0(AccountType $accountType, UserEmailFixer this$0, CompletableFuture $usersExtractionResult, String $migrationScopeId, String $preflightCheckExecutionId, String $containerToken) {
        UsersFixedData usersFixedData;
        Intrinsics.checkNotNullParameter((Object)$accountType, (String)"$accountType");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$usersExtractionResult, (String)"$usersExtractionResult");
        Intrinsics.checkNotNullParameter((Object)$migrationScopeId, (String)"$migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)$preflightCheckExecutionId, (String)"$preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)$containerToken, (String)"$containerToken");
        if ($accountType == AccountType.CUSTOMER) {
            Object object = CompletableFutureUtil.INSTANCE.getCompletedValue((Future)$usersExtractionResult);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCompletedValue(...)");
            usersFixedData = this$0.customersFixedData((UsersGroupsExtractionResult)object, $migrationScopeId, $preflightCheckExecutionId, $containerToken);
        } else {
            Object object = CompletableFutureUtil.INSTANCE.getCompletedValue((Future)$usersExtractionResult);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCompletedValue(...)");
            usersFixedData = this$0.usersFixedData((UsersGroupsExtractionResult)object, $migrationScopeId, $preflightCheckExecutionId, $containerToken);
        }
        return usersFixedData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/email/UserEmailFixer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sanitizeDuplicatedEmailForMerge", "", "email", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String sanitizeDuplicatedEmailForMerge(@NotNull String email) {
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            String string = email;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

