/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email.db;

import com.atlassian.jira.migration.email.db.RepositoryDeleter;
import com.atlassian.jira.migration.email.db.RepositoryUtilityFactory;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/email/db/EmailRepositoryCleaner;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "repositoryUtilityFactory", "Lcom/atlassian/jira/migration/email/db/RepositoryUtilityFactory;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/email/db/RepositoryUtilityFactory;)V", "cleanup", "", "executionId", "", "jira-migration-plugin"})
public final class EmailRepositoryCleaner {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final RepositoryUtilityFactory repositoryUtilityFactory;

    @Inject
    public EmailRepositoryCleaner(@NotNull DatabaseAccessor databaseAccessor, @NotNull RepositoryUtilityFactory repositoryUtilityFactory) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)repositoryUtilityFactory, (String)"repositoryUtilityFactory");
        this.databaseAccessor = databaseAccessor;
        this.repositoryUtilityFactory = repositoryUtilityFactory;
    }

    public final long cleanup(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object = this.databaseAccessor.run(arg_0 -> EmailRepositoryCleaner.cleanup$lambda$0(this, executionId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return ((Number)object).longValue();
    }

    private static final Long cleanup$lambda$0(EmailRepositoryCleaner this$0, String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        RepositoryDeleter.ForIncorrectEmail forIncorrectEmail = this$0.repositoryUtilityFactory.deleterForIncorrectEmail();
        Intrinsics.checkNotNull((Object)db);
        long incorrectEmailsDeleted = RepositoryDeleter.ForIncorrectEmail.deleteByExecutionId$default(forIncorrectEmail, db, $executionId, null, 4, null);
        long expelledUsersDeleted = this$0.repositoryUtilityFactory.deleterForExpelledUser().deleteByExecutionId(db, $executionId);
        return incorrectEmailsDeleted + expelledUsersDeleted;
    }
}

