/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email.db;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.migration.email.db.EmailTrustedDomainEntity;
import com.atlassian.jira.migration.email.db.EmailTrustedDomainRepository;
import com.atlassian.jira.migration.email.db.RepositoryDeleter;
import com.atlassian.jira.migration.email.db.RepositoryReader;
import com.atlassian.jira.migration.email.db.RepositoryUpserter;
import com.atlassian.jira.migration.email.db.RepositoryUtilityFactory;
import com.atlassian.jira.migration.email.db.UpsertInputCalculator;
import com.atlassian.jira.migration.email.model.BatchUpsertResult;
import com.atlassian.jira.migration.email.model.EmailTrustedDomain;
import com.atlassian.jira.migration.email.model.UpsertInput;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J4\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001a0\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\n \u000f*\u0004\u0018\u00010\"0\"2\u0006\u0010#\u001a\u00020\u0017H\u0002J\u0006\u0010$\u001a\u00020\u0014J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\"2\u0006\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\u0014J\u0014\u0010-\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\"H\u0002J\u0018\u00100\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/atlassian/jira/migration/email/db/EmailTrustedDomainRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "upsertInputCalculator", "Lcom/atlassian/jira/migration/email/db/UpsertInputCalculator;", "repositoryUtilityFactory", "Lcom/atlassian/jira/migration/email/db/RepositoryUtilityFactory;", "jiraSystemProperties", "Lcom/atlassian/jira/config/properties/JiraProperties;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/email/db/UpsertInputCalculator;Lcom/atlassian/jira/migration/email/db/RepositoryUtilityFactory;Lcom/atlassian/jira/config/properties/JiraProperties;)V", "batchSize", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "sharedLock", "Ljava/util/concurrent/locks/ReentrantLock;", "batchDelete", "", "trustedDomains", "", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomain;", "batchUpsert", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/email/model/BatchUpsertResult;", "updateUsers", "", "updateRules", "countByReviewMethod", "reviewMethod", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomain$ReviewMethod;", "createRecord", "Lcom/atlassian/jira/migration/email/db/EmailTrustedDomainEntity;", "trustedDomain", "deleteBlockedDomainRules", "findAllBlockedDomainsForSite", "findAllForSite", "findAllNotBlockedDomainsForSite", "findAllTrustedDomainsForSite", "findDomain", "domainName", "", "resetUserModifiedDomainRules", "setAllForSite", "toTrustedDomain", "entity", "upsert", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailTrustedDomainRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailTrustedDomainRepository.kt\ncom/atlassian/jira/migration/email/db/EmailTrustedDomainRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n11065#2:235\n11400#2,3:236\n11065#2:239\n11400#2,3:240\n11065#2:243\n11400#2,3:244\n11065#2:247\n11400#2,3:248\n13309#2,2:253\n1855#3,2:251\n1855#3,2:255\n1549#3:257\n1620#3,3:258\n1#4:261\n*S KotlinDebug\n*F\n+ 1 EmailTrustedDomainRepository.kt\ncom/atlassian/jira/migration/email/db/EmailTrustedDomainRepository\n*L\n68#1:235\n68#1:236,3\n77#1:239\n77#1:240,3\n86#1:243\n86#1:244,3\n95#1:247\n95#1:248,3\n46#1:253,2\n158#1:251,2\n47#1:255,2\n162#1:257\n162#1:258,3\n*E\n"})
public final class EmailTrustedDomainRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final UpsertInputCalculator upsertInputCalculator;
    @NotNull
    private final RepositoryUtilityFactory repositoryUtilityFactory;
    @NotNull
    private final ReentrantLock sharedLock;
    private final Integer batchSize;
    public static final int defaultBatchSize = 100;

    @Inject
    public EmailTrustedDomainRepository(@NotNull ActiveObjects ao, @NotNull DatabaseAccessor databaseAccessor, @NotNull UpsertInputCalculator upsertInputCalculator, @NotNull RepositoryUtilityFactory repositoryUtilityFactory, @NotNull JiraProperties jiraSystemProperties) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)upsertInputCalculator, (String)"upsertInputCalculator");
        Intrinsics.checkNotNullParameter((Object)repositoryUtilityFactory, (String)"repositoryUtilityFactory");
        Intrinsics.checkNotNullParameter((Object)jiraSystemProperties, (String)"jiraSystemProperties");
        this.ao = ao;
        this.databaseAccessor = databaseAccessor;
        this.upsertInputCalculator = upsertInputCalculator;
        this.repositoryUtilityFactory = repositoryUtilityFactory;
        this.sharedLock = new ReentrantLock();
        this.batchSize = jiraSystemProperties.getInteger("trusted.domains.db.batch.size", Integer.valueOf(100));
    }

    public final void setAllForSite(@NotNull List<EmailTrustedDomain> trustedDomains) {
        Intrinsics.checkNotNullParameter(trustedDomains, (String)"trustedDomains");
        this.ao.executeInTransaction(() -> EmailTrustedDomainRepository.setAllForSite$lambda$2(this, trustedDomains));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EmailTrustedDomain> findAllForSite() {
        void $this$mapTo$iv$iv;
        RawEntity[] rawEntityArray = this.ao.find(EmailTrustedDomainEntity.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailTrustedDomainEntity emailTrustedDomainEntity = (EmailTrustedDomainEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toTrustedDomain((EmailTrustedDomainEntity)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EmailTrustedDomain> findAllTrustedDomainsForSite() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Object[]{EmailTrustedDomain.DomainNameRule.TRUSTED};
        RawEntity[] rawEntityArray = this.ao.find(EmailTrustedDomainEntity.class, Query.select().where("RULE = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailTrustedDomainEntity emailTrustedDomainEntity = (EmailTrustedDomainEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toTrustedDomain((EmailTrustedDomainEntity)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EmailTrustedDomain> findAllNotBlockedDomainsForSite() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Object[]{EmailTrustedDomain.DomainNameRule.BLOCKED};
        RawEntity[] rawEntityArray = this.ao.find(EmailTrustedDomainEntity.class, Query.select().where("RULE != ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailTrustedDomainEntity emailTrustedDomainEntity = (EmailTrustedDomainEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toTrustedDomain((EmailTrustedDomainEntity)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EmailTrustedDomain> findAllBlockedDomainsForSite() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Object[]{EmailTrustedDomain.DomainNameRule.BLOCKED};
        RawEntity[] rawEntityArray = this.ao.find(EmailTrustedDomainEntity.class, Query.select().where("RULE = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailTrustedDomainEntity emailTrustedDomainEntity = (EmailTrustedDomainEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toTrustedDomain((EmailTrustedDomainEntity)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Object upsert(@NotNull EmailTrustedDomain trustedDomain, boolean updateUsers) {
        EmailTrustedDomainEntity emailTrustedDomainEntity;
        Intrinsics.checkNotNullParameter((Object)trustedDomain, (String)"trustedDomain");
        EmailTrustedDomainEntity emailTrustedDomainEntity2 = this.findDomain(trustedDomain.getDomainName());
        if (emailTrustedDomainEntity2 != null) {
            EmailTrustedDomainEntity it = emailTrustedDomainEntity2;
            boolean bl = false;
            String string = trustedDomain.getDomainName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            it.setDomainName(((Object)StringsKt.trim((CharSequence)string)).toString());
            it.setRule(trustedDomain.getRule());
            it.setReviewMethod(trustedDomain.getReviewMethod());
            it.setActiveUsers(updateUsers ? trustedDomain.getActiveUsers() : it.getActiveUsers());
            it.setInactiveUsers(updateUsers ? trustedDomain.getInactiveUsers() : it.getInactiveUsers());
            it.save();
            emailTrustedDomainEntity = Unit.INSTANCE;
        } else {
            EmailTrustedDomainEntity emailTrustedDomainEntity3 = this.createRecord(trustedDomain);
            emailTrustedDomainEntity = emailTrustedDomainEntity3;
            Intrinsics.checkNotNullExpressionValue((Object)emailTrustedDomainEntity3, (String)"createRecord(...)");
        }
        return emailTrustedDomainEntity;
    }

    public static /* synthetic */ Object upsert$default(EmailTrustedDomainRepository emailTrustedDomainRepository, EmailTrustedDomain emailTrustedDomain, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return emailTrustedDomainRepository.upsert(emailTrustedDomain, bl);
    }

    @NotNull
    public final Sequence<BatchUpsertResult<EmailTrustedDomain>> batchUpsert(@NotNull List<EmailTrustedDomain> trustedDomains, boolean updateUsers, boolean updateRules) {
        Intrinsics.checkNotNullParameter(trustedDomains, (String)"trustedDomains");
        List<EmailTrustedDomain> $this$batchUpsert_u24lambda_u248 = trustedDomains;
        boolean bl = false;
        RepositoryUpserter.ForTrustedDomains upserter = this.repositoryUtilityFactory.upserterForTrustedDomains(updateUsers, updateRules);
        RepositoryReader.ForTrustedDomainsId reader = this.repositoryUtilityFactory.readerForTrustedDomainsId();
        Sequence sequence = CollectionsKt.asSequence((Iterable)$this$batchUpsert_u24lambda_u248);
        Integer n = this.batchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"batchSize");
        return SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)sequence, (int)((Number)n).intValue()), (Function1)((Function1)new Function1<List<? extends EmailTrustedDomain>, BatchUpsertResult<EmailTrustedDomain>>(this, upserter, reader){
            final /* synthetic */ EmailTrustedDomainRepository this$0;
            final /* synthetic */ RepositoryUpserter.ForTrustedDomains $upserter;
            final /* synthetic */ RepositoryReader.ForTrustedDomainsId $reader;
            {
                this.this$0 = $receiver;
                this.$upserter = $upserter;
                this.$reader = $reader;
                super(1);
            }

            public final BatchUpsertResult<EmailTrustedDomain> invoke(@NotNull List<EmailTrustedDomain> chunk) {
                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                return (BatchUpsertResult)EmailTrustedDomainRepository.access$getDatabaseAccessor$p(this.this$0).run(arg_0 -> batchUpsert.1.1.invoke$lambda$1(this.this$0, chunk, this.$upserter, this.$reader, arg_0), OnRollback.NOOP);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final BatchUpsertResult invoke$lambda$1(EmailTrustedDomainRepository this$0, List $chunk, RepositoryUpserter.ForTrustedDomains $upserter, RepositoryReader.ForTrustedDomainsId $reader, DatabaseConnection db) {
                BatchUpsertResult<EmailTrustedDomain> batchUpsertResult;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$chunk, (String)"$chunk");
                Intrinsics.checkNotNullParameter((Object)$upserter, (String)"$upserter");
                Intrinsics.checkNotNullParameter((Object)$reader, (String)"$reader");
                Lock lock = EmailTrustedDomainRepository.access$getSharedLock$p(this$0);
                lock.lock();
                try {
                    boolean bl = false;
                    UpsertInput<EmailTrustedDomain> upsertInput2 = EmailTrustedDomainRepository.access$getUpsertInputCalculator$p(this$0).calculateByDomainName($chunk, (Function1<? super List<String>, ? extends List<String>>)((Function1)new Function1<List<? extends String>, List<? extends String>>($reader, db){
                        final /* synthetic */ RepositoryReader.ForTrustedDomainsId $reader;
                        final /* synthetic */ DatabaseConnection $db;
                        {
                            this.$reader = $reader;
                            this.$db = $db;
                            super(1);
                        }

                        @NotNull
                        public final List<String> invoke(@NotNull List<String> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            DatabaseConnection databaseConnection = this.$db;
                            Intrinsics.checkNotNullExpressionValue((Object)databaseConnection, (String)"$db");
                            return this.$reader.readBatchByDomainNames(databaseConnection, it);
                        }
                    }));
                    Intrinsics.checkNotNull((Object)db);
                    batchUpsertResult = $upserter.upsertBatch(db, upsertInput2);
                }
                finally {
                    lock.unlock();
                }
                return batchUpsertResult;
            }
        }));
    }

    public static /* synthetic */ Sequence batchUpsert$default(EmailTrustedDomainRepository emailTrustedDomainRepository, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return emailTrustedDomainRepository.batchUpsert(list, bl, bl2);
    }

    public final void resetUserModifiedDomainRules() {
        RepositoryUpserter.ForTrustedDomains upserter = RepositoryUtilityFactory.upserterForTrustedDomains$default(this.repositoryUtilityFactory, false, false, 3, null);
        this.databaseAccessor.run(arg_0 -> EmailTrustedDomainRepository.resetUserModifiedDomainRules$lambda$10(this, upserter, arg_0), OnRollback.NOOP);
    }

    public final void deleteBlockedDomainRules() {
        RepositoryDeleter.ForTrustedDomains deleter = this.repositoryUtilityFactory.deleterForTrustedDomains();
        this.databaseAccessor.run(arg_0 -> EmailTrustedDomainRepository.deleteBlockedDomainRules$lambda$12(this, deleter, arg_0), OnRollback.NOOP);
    }

    public final void batchDelete(@NotNull List<EmailTrustedDomain> trustedDomains) {
        Intrinsics.checkNotNullParameter(trustedDomains, (String)"trustedDomains");
        RepositoryDeleter.ForTrustedDomains deleter = this.repositoryUtilityFactory.deleterForTrustedDomains();
        Iterable iterable = trustedDomains;
        Integer n = this.batchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"batchSize");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)iterable, (int)((Number)n).intValue());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            this.databaseAccessor.run(arg_0 -> EmailTrustedDomainRepository.batchDelete$lambda$17$lambda$16(this, chunk, deleter, arg_0), OnRollback.NOOP);
        }
    }

    public final int countByReviewMethod(@NotNull EmailTrustedDomain.ReviewMethod reviewMethod) {
        Intrinsics.checkNotNullParameter((Object)((Object)reviewMethod), (String)"reviewMethod");
        Object[] objectArray = new Object[]{reviewMethod.name()};
        return this.ao.count(EmailTrustedDomainEntity.class, Query.select().where("REVIEW_METHOD = ?", objectArray));
    }

    private final EmailTrustedDomainEntity findDomain(String domainName) {
        Query query = Query.select();
        Object[] objectArray = new Object[1];
        String string = domainName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        objectArray[0] = ((Object)StringsKt.trim((CharSequence)string)).toString();
        RawEntity[] rawEntityArray = this.ao.find(EmailTrustedDomainEntity.class, query.where("DOMAIN_NAME = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (EmailTrustedDomainEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    private final EmailTrustedDomainEntity createRecord(EmailTrustedDomain trustedDomain) {
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"ID", (Object)UUID.randomUUID().toString());
        String string = trustedDomain.getDomainName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        pairArray[1] = TuplesKt.to((Object)"DOMAIN_NAME", (Object)((Object)StringsKt.trim((CharSequence)string)).toString());
        pairArray[2] = TuplesKt.to((Object)"RULE", (Object)((Object)trustedDomain.getRule()));
        pairArray[3] = TuplesKt.to((Object)"ACTIVE_USERS", (Object)trustedDomain.getActiveUsers());
        pairArray[4] = TuplesKt.to((Object)"INACTIVE_USERS", (Object)trustedDomain.getInactiveUsers());
        pairArray[5] = TuplesKt.to((Object)"REVIEW_METHOD", (Object)((Object)trustedDomain.getReviewMethod()));
        return (EmailTrustedDomainEntity)this.ao.create(EmailTrustedDomainEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    private final EmailTrustedDomain toTrustedDomain(EmailTrustedDomainEntity entity) {
        return new EmailTrustedDomain(entity.getDomainName(), entity.getRule(), entity.getActiveUsers(), entity.getInactiveUsers(), entity.getReviewMethod());
    }

    private static final Unit setAllForSite$lambda$2(EmailTrustedDomainRepository this$0, List $trustedDomains) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$trustedDomains, (String)"$trustedDomains");
        RawEntity[] rawEntityArray = this$0.ao.find(EmailTrustedDomainEntity.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object $this$forEach$iv = rawEntityArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EmailTrustedDomainEntity it = (EmailTrustedDomainEntity)element$iv;
            boolean bl = false;
            RawEntity[] rawEntityArray2 = new RawEntity[]{it};
            this$0.ao.delete(rawEntityArray2);
        }
        $this$forEach$iv = $trustedDomains;
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            EmailTrustedDomain it = (EmailTrustedDomain)element$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ID", (Object)UUID.randomUUID().toString()), TuplesKt.to((Object)"DOMAIN_NAME", (Object)it.getDomainName()), TuplesKt.to((Object)"RULE", (Object)((Object)it.getRule())), TuplesKt.to((Object)"ACTIVE_USERS", (Object)it.getActiveUsers()), TuplesKt.to((Object)"INACTIVE_USERS", (Object)it.getInactiveUsers()), TuplesKt.to((Object)"REVIEW_METHOD", (Object)((Object)it.getReviewMethod()))};
            this$0.ao.create(EmailTrustedDomainEntity.class, MapsKt.mapOf((Pair[])pairArray));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long resetUserModifiedDomainRules$lambda$10(EmailTrustedDomainRepository this$0, RepositoryUpserter.ForTrustedDomains $upserter, DatabaseConnection db) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$upserter, (String)"$upserter");
        Lock lock = this$0.sharedLock;
        lock.lock();
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)db);
            l = $upserter.resetUserModifiedDomainRules(db);
        }
        finally {
            lock.unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long deleteBlockedDomainRules$lambda$12(EmailTrustedDomainRepository this$0, RepositoryDeleter.ForTrustedDomains $deleter, DatabaseConnection db) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$deleter, (String)"$deleter");
        Lock lock = this$0.sharedLock;
        lock.lock();
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)db);
            l = $deleter.deleteBlockedDomainRules(db);
        }
        finally {
            lock.unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit batchDelete$lambda$17$lambda$16(EmailTrustedDomainRepository this$0, List $chunk, RepositoryDeleter.ForTrustedDomains $deleter, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$chunk, (String)"$chunk");
        Intrinsics.checkNotNullParameter((Object)$deleter, (String)"$deleter");
        Lock lock = this$0.sharedLock;
        lock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = $chunk;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void domain;
                EmailTrustedDomain emailTrustedDomain = (EmailTrustedDomain)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(domain.getDomainName());
            }
            List it = (List)destination$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)db);
            $deleter.deleteBatchByDomainNames(db, it);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ DatabaseAccessor access$getDatabaseAccessor$p(EmailTrustedDomainRepository $this) {
        return $this.databaseAccessor;
    }

    public static final /* synthetic */ UpsertInputCalculator access$getUpsertInputCalculator$p(EmailTrustedDomainRepository $this) {
        return $this.upsertInputCalculator;
    }

    public static final /* synthetic */ ReentrantLock access$getSharedLock$p(EmailTrustedDomainRepository $this) {
        return $this.sharedLock;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/email/db/EmailTrustedDomainRepository$Companion;", "", "()V", "defaultBatchSize", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

