/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email.db;

import com.atlassian.jira.migration.email.db.CorrectedEmailTable;
import com.atlassian.jira.migration.email.db.EmailTrustedDomainTable;
import com.atlassian.jira.migration.email.db.IncorrectEmailTable;
import com.atlassian.jira.migration.email.db.RepositoryReader;
import com.atlassian.jira.migration.email.model.IncorrectEmail;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.spi.querydsl.EnhancedRelationalPathBase;
import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.SQLQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u00020\u0004:\u0004\u0014\u0015\u0016\u0017B\u0015\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\u0006JH\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00020\n2\u001e\u0010\u000b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\fJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H&R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0004\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/email/db/RepositoryReader;", "T", "TABLE", "Lcom/atlassian/pocketknife/spi/querydsl/EnhancedRelationalPathBase;", "", "table", "(Lcom/atlassian/pocketknife/spi/querydsl/EnhancedRelationalPathBase;)V", "readBatch", "Lkotlin/sequences/Sequence;", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "queryTransformer", "Lkotlin/Function1;", "Lcom/querydsl/sql/SQLQuery;", "Lcom/querydsl/core/Tuple;", "mapper", "readBatchByIds", "", "ids", "", "ForCorrectedEmailId", "ForIncorrectEmail", "ForIncorrectEmailId", "ForTrustedDomainsId", "Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForCorrectedEmailId;", "Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForIncorrectEmail;", "Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForIncorrectEmailId;", "Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForTrustedDomainsId;", "jira-migration-plugin"})
public abstract class RepositoryReader<T, TABLE extends EnhancedRelationalPathBase<TABLE>> {
    @NotNull
    private final EnhancedRelationalPathBase<TABLE> table;

    private RepositoryReader(EnhancedRelationalPathBase<TABLE> table) {
        this.table = table;
    }

    @NotNull
    public final Sequence<T> readBatch(@NotNull DatabaseConnection db, @NotNull Function1<? super SQLQuery<Tuple>, ? extends SQLQuery<Tuple>> queryTransformer, @NotNull Function1<? super Tuple, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(queryTransformer, (String)"queryTransformer");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        ProjectableSQLQuery projectableSQLQuery = this.table.all();
        projectableSQLQuery = db.select((Expression[])Arrays.copyOf(projectableSQLQuery, ((Path[])projectableSQLQuery).length)).from((Expression)this.table);
        List list = ((SQLQuery)queryTransformer.invoke((Object)projectableSQLQuery)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), mapper);
    }

    @NotNull
    public abstract List<T> readBatchByIds(@NotNull DatabaseConnection var1, @NotNull List<String> var2);

    public /* synthetic */ RepositoryReader(EnhancedRelationalPathBase table, DefaultConstructorMarker $constructor_marker) {
        this(table);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForCorrectedEmailId;", "Lcom/atlassian/jira/migration/email/db/RepositoryReader;", "", "Lcom/atlassian/jira/migration/email/db/CorrectedEmailTable;", "()V", "readBatchByIds", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "ids", "jira-migration-plugin"})
    public static final class ForCorrectedEmailId
    extends RepositoryReader<String, CorrectedEmailTable> {
        public ForCorrectedEmailId() {
            super(CorrectedEmailTable.INSTANCE, null);
        }

        @Override
        @NotNull
        public List<String> readBatchByIds(@NotNull DatabaseConnection db, @NotNull List<String> ids) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            return SequencesKt.toList(this.readBatch(db, (Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>)((Function1)new Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>(ids){
                final /* synthetic */ List<String> $ids;
                {
                    this.$ids = $ids;
                    super(1);
                }

                @NotNull
                public final SQLQuery<Tuple> invoke(@NotNull SQLQuery<Tuple> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    QueryBase queryBase = it.where((Predicate)CorrectedEmailTable.INSTANCE.getID().in((Collection)this.$ids));
                    Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
                    return (SQLQuery)queryBase;
                }
            }), readBatchByIds.2.INSTANCE));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForIncorrectEmail;", "Lcom/atlassian/jira/migration/email/db/RepositoryReader;", "Lcom/atlassian/jira/migration/email/model/IncorrectEmail;", "Lcom/atlassian/jira/migration/email/db/IncorrectEmailTable;", "clob2Bean", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "readBatchByExecutionId", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "executionId", "pageNum", "", "batchSize", "readBatchByIds", "ids", "jira-migration-plugin"})
    public static final class ForIncorrectEmail
    extends RepositoryReader<IncorrectEmail, IncorrectEmailTable> {
        @NotNull
        private final Function1<String, IncorrectEmail> clob2Bean;

        public ForIncorrectEmail(@NotNull Function1<? super String, IncorrectEmail> clob2Bean) {
            Intrinsics.checkNotNullParameter(clob2Bean, (String)"clob2Bean");
            super(IncorrectEmailTable.INSTANCE, null);
            this.clob2Bean = clob2Bean;
        }

        @Override
        @NotNull
        public List<IncorrectEmail> readBatchByIds(@NotNull DatabaseConnection db, @NotNull List<String> ids) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            return SequencesKt.toList(this.readBatch(db, (Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>)((Function1)new Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>(ids){
                final /* synthetic */ List<String> $ids;
                {
                    this.$ids = $ids;
                    super(1);
                }

                @NotNull
                public final SQLQuery<Tuple> invoke(@NotNull SQLQuery<Tuple> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    QueryBase queryBase = it.where((Predicate)IncorrectEmailTable.INSTANCE.getID().in((Collection)this.$ids));
                    Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
                    return (SQLQuery)queryBase;
                }
            }), (Function1)new Function1<Tuple, IncorrectEmail>(this){
                final /* synthetic */ ForIncorrectEmail this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final IncorrectEmail invoke(@NotNull Tuple it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1 function1 = ForIncorrectEmail.access$getClob2Bean$p(this.this$0);
                    Object object = it.get((Expression)IncorrectEmailTable.INSTANCE.getEMAIL_CORRECTION_DATA());
                    Intrinsics.checkNotNull((Object)object);
                    return (IncorrectEmail)function1.invoke(object);
                }
            }));
        }

        @NotNull
        public final List<IncorrectEmail> readBatchByExecutionId(@NotNull DatabaseConnection db, @NotNull String executionId, long pageNum, long batchSize) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            return SequencesKt.toList(this.readBatch(db, (Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>)((Function1)new Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>(pageNum, batchSize, executionId){
                final /* synthetic */ long $pageNum;
                final /* synthetic */ long $batchSize;
                final /* synthetic */ String $executionId;
                {
                    this.$pageNum = $pageNum;
                    this.$batchSize = $batchSize;
                    this.$executionId = $executionId;
                    super(1);
                }

                @NotNull
                public final SQLQuery<Tuple> invoke(@NotNull SQLQuery<Tuple> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    long offset = (this.$pageNum - 1L) * this.$batchSize;
                    OrderSpecifier[] orderSpecifierArray = new OrderSpecifier[]{IncorrectEmailTable.INSTANCE.getTYPE().desc(), IncorrectEmailTable.INSTANCE.getOLD_EMAIL().asc()};
                    QueryBase queryBase = ((SQLQuery)((SQLQuery)((SQLQuery)it.where((Predicate)IncorrectEmailTable.INSTANCE.getEXECUTION_ID().eq((Object)this.$executionId))).orderBy(orderSpecifierArray)).offset(offset)).limit(offset + this.$batchSize);
                    Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"limit(...)");
                    return (SQLQuery)queryBase;
                }
            }), (Function1)new Function1<Tuple, IncorrectEmail>(this){
                final /* synthetic */ ForIncorrectEmail this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final IncorrectEmail invoke(@NotNull Tuple it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1 function1 = ForIncorrectEmail.access$getClob2Bean$p(this.this$0);
                    Object object = it.get((Expression)IncorrectEmailTable.INSTANCE.getEMAIL_CORRECTION_DATA());
                    Intrinsics.checkNotNull((Object)object);
                    return (IncorrectEmail)function1.invoke(object);
                }
            }));
        }

        public static /* synthetic */ List readBatchByExecutionId$default(ForIncorrectEmail forIncorrectEmail, DatabaseConnection databaseConnection, String string, long l, long l2, int n, Object object) {
            if ((n & 4) != 0) {
                l = 1L;
            }
            if ((n & 8) != 0) {
                l2 = 100L;
            }
            return forIncorrectEmail.readBatchByExecutionId(databaseConnection, string, l, l2);
        }

        public static final /* synthetic */ Function1 access$getClob2Bean$p(ForIncorrectEmail $this) {
            return $this.clob2Bean;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForIncorrectEmailId;", "Lcom/atlassian/jira/migration/email/db/RepositoryReader;", "", "Lcom/atlassian/jira/migration/email/db/IncorrectEmailTable;", "()V", "readBatchByIds", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "ids", "jira-migration-plugin"})
    public static final class ForIncorrectEmailId
    extends RepositoryReader<String, IncorrectEmailTable> {
        public ForIncorrectEmailId() {
            super(IncorrectEmailTable.INSTANCE, null);
        }

        @Override
        @NotNull
        public List<String> readBatchByIds(@NotNull DatabaseConnection db, @NotNull List<String> ids) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            return SequencesKt.toList(this.readBatch(db, (Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>)((Function1)new Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>(ids){
                final /* synthetic */ List<String> $ids;
                {
                    this.$ids = $ids;
                    super(1);
                }

                @NotNull
                public final SQLQuery<Tuple> invoke(@NotNull SQLQuery<Tuple> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    QueryBase queryBase = it.where((Predicate)IncorrectEmailTable.INSTANCE.getID().in((Collection)this.$ids));
                    Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
                    return (SQLQuery)queryBase;
                }
            }), readBatchByIds.2.INSTANCE));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/email/db/RepositoryReader$ForTrustedDomainsId;", "Lcom/atlassian/jira/migration/email/db/RepositoryReader;", "", "Lcom/atlassian/jira/migration/email/db/EmailTrustedDomainTable;", "()V", "readBatchByDomainNames", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "domainNames", "readBatchByIds", "ids", "jira-migration-plugin"})
    public static final class ForTrustedDomainsId
    extends RepositoryReader<String, EmailTrustedDomainTable> {
        public ForTrustedDomainsId() {
            super(EmailTrustedDomainTable.INSTANCE, null);
        }

        @Override
        @NotNull
        public List<String> readBatchByIds(@NotNull DatabaseConnection db, @NotNull List<String> ids) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            return SequencesKt.toList(this.readBatch(db, (Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>)((Function1)new Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>(ids){
                final /* synthetic */ List<String> $ids;
                {
                    this.$ids = $ids;
                    super(1);
                }

                @NotNull
                public final SQLQuery<Tuple> invoke(@NotNull SQLQuery<Tuple> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    QueryBase queryBase = it.where((Predicate)EmailTrustedDomainTable.INSTANCE.getID().in((Collection)this.$ids));
                    Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
                    return (SQLQuery)queryBase;
                }
            }), readBatchByIds.2.INSTANCE));
        }

        @NotNull
        public final List<String> readBatchByDomainNames(@NotNull DatabaseConnection db, @NotNull List<String> domainNames) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter(domainNames, (String)"domainNames");
            return SequencesKt.toList(this.readBatch(db, (Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>)((Function1)new Function1<SQLQuery<Tuple>, SQLQuery<Tuple>>(domainNames){
                final /* synthetic */ List<String> $domainNames;
                {
                    this.$domainNames = $domainNames;
                    super(1);
                }

                @NotNull
                public final SQLQuery<Tuple> invoke(@NotNull SQLQuery<Tuple> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    QueryBase queryBase = it.where((Predicate)EmailTrustedDomainTable.INSTANCE.getDOMAIN_NAME().in((Collection)this.$domainNames));
                    Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
                    return (SQLQuery)queryBase;
                }
            }), readBatchByDomainNames.2.INSTANCE));
        }
    }
}

