/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email.model;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/email/model/ExpelledUser;", "", "userKey", "", "email", "preflightExecutionId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEmail", "()Ljava/lang/String;", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "getPreflightExecutionId", "getUserKey", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
public final class ExpelledUser {
    @NotNull
    private final String userKey;
    @Nullable
    private final String email;
    @NotNull
    private final String preflightExecutionId;

    public ExpelledUser(@NotNull String userKey, @Nullable String email, @NotNull String preflightExecutionId) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Intrinsics.checkNotNullParameter((Object)preflightExecutionId, (String)"preflightExecutionId");
        this.userKey = userKey;
        this.email = email;
        this.preflightExecutionId = preflightExecutionId;
    }

    @NotNull
    public final String getUserKey() {
        return this.userKey;
    }

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    @NotNull
    public final String getPreflightExecutionId() {
        return this.preflightExecutionId;
    }

    @NotNull
    public final UUID getId() {
        String string = this.preflightExecutionId + '-' + this.userKey;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        UUID uUID = UUID.nameUUIDFromBytes(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"nameUUIDFromBytes(...)");
        return uUID;
    }

    @NotNull
    public final String component1() {
        return this.userKey;
    }

    @Nullable
    public final String component2() {
        return this.email;
    }

    @NotNull
    public final String component3() {
        return this.preflightExecutionId;
    }

    @NotNull
    public final ExpelledUser copy(@NotNull String userKey, @Nullable String email, @NotNull String preflightExecutionId) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Intrinsics.checkNotNullParameter((Object)preflightExecutionId, (String)"preflightExecutionId");
        return new ExpelledUser(userKey, email, preflightExecutionId);
    }

    public static /* synthetic */ ExpelledUser copy$default(ExpelledUser expelledUser, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = expelledUser.userKey;
        }
        if ((n & 2) != 0) {
            string2 = expelledUser.email;
        }
        if ((n & 4) != 0) {
            string3 = expelledUser.preflightExecutionId;
        }
        return expelledUser.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "ExpelledUser(userKey=" + this.userKey + ", email=" + this.email + ", preflightExecutionId=" + this.preflightExecutionId + ')';
    }

    public int hashCode() {
        int result2 = this.userKey.hashCode();
        result2 = result2 * 31 + (this.email == null ? 0 : this.email.hashCode());
        result2 = result2 * 31 + this.preflightExecutionId.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExpelledUser)) {
            return false;
        }
        ExpelledUser expelledUser = (ExpelledUser)other;
        if (!Intrinsics.areEqual((Object)this.userKey, (Object)expelledUser.userKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.email, (Object)expelledUser.email)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.preflightExecutionId, (Object)expelledUser.preflightExecutionId);
    }
}

