/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email.rest;

import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.email.EmailTrustedDomainService;
import com.atlassian.jira.migration.email.IncorrectEmailAtomicMutateService;
import com.atlassian.jira.migration.email.IncorrectEmailCsvZipStreamingService;
import com.atlassian.jira.migration.email.IncorrectEmailUpsertResult;
import com.atlassian.jira.migration.email.IncorrectEmailUpsertService;
import com.atlassian.jira.migration.email.OutputStreamWritingResult;
import com.atlassian.jira.migration.email.model.AtomicMutateResult;
import com.atlassian.jira.migration.email.model.EmailTrustedDomain;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.codehaus.jackson.annotate.JsonCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="debug/email")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0007J\b\u0010\u0016\u001a\u00020\u0010H\u0007J\b\u0010\u0017\u001a\u00020\u0010H\u0007J\u0016\u0010\u0018\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H\u0007J\u0016\u0010\u001b\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailDebugResource;", "", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "incorrectEmailUpsertService", "Lcom/atlassian/jira/migration/email/IncorrectEmailUpsertService;", "incorrectEmailAtomicMutateService", "Lcom/atlassian/jira/migration/email/IncorrectEmailAtomicMutateService;", "incorrectEmailCsvZipStreamingService", "Lcom/atlassian/jira/migration/email/IncorrectEmailCsvZipStreamingService;", "emailTrustedDomainService", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "(Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/email/IncorrectEmailUpsertService;Lcom/atlassian/jira/migration/email/IncorrectEmailAtomicMutateService;Lcom/atlassian/jira/migration/email/IncorrectEmailCsvZipStreamingService;Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;Lcom/atlassian/sal/api/ApplicationProperties;)V", "atomicDeleteAndUpsertDuplicateEmails", "Ljavax/ws/rs/core/Response;", "userKeys", "", "", "atomicDeleteAndUpsertInvalidEmails", "downloadIncorrectEmailsCsv", "removeAllEmailDomainRules", "setAllEmailDomainsAsTrusted", "upsertDuplicateEmails", "emailDataList", "Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$EmailUpsertDto;", "upsertInvalidEmails", "AtomicMutateResultDto", "EmailUpsertDto", "EmailUpsertResultDto", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailDebugResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailDebugResource.kt\ncom/atlassian/jira/migration/email/rest/EmailDebugResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1549#2:240\n1620#2,3:241\n1549#2:244\n1620#2,3:245\n1549#2:248\n1620#2,3:249\n1864#2,3:252\n1549#2:255\n1620#2,3:256\n*S KotlinDebug\n*F\n+ 1 EmailDebugResource.kt\ncom/atlassian/jira/migration/email/rest/EmailDebugResource\n*L\n64#1:240\n64#1:241,3\n79#1:244\n79#1:245,3\n93#1:248\n93#1:249,3\n117#1:252,3\n155#1:255\n155#1:256,3\n*E\n"})
public final class EmailDebugResource {
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final IncorrectEmailUpsertService incorrectEmailUpsertService;
    @NotNull
    private final IncorrectEmailAtomicMutateService incorrectEmailAtomicMutateService;
    @NotNull
    private final IncorrectEmailCsvZipStreamingService incorrectEmailCsvZipStreamingService;
    @NotNull
    private final EmailTrustedDomainService emailTrustedDomainService;
    @NotNull
    private final ApplicationProperties applicationProperties;

    @Inject
    public EmailDebugResource(@NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull IncorrectEmailUpsertService incorrectEmailUpsertService, @NotNull IncorrectEmailAtomicMutateService incorrectEmailAtomicMutateService, @NotNull IncorrectEmailCsvZipStreamingService incorrectEmailCsvZipStreamingService, @NotNull EmailTrustedDomainService emailTrustedDomainService, @NotNull ApplicationProperties applicationProperties) {
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailUpsertService, (String)"incorrectEmailUpsertService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailAtomicMutateService, (String)"incorrectEmailAtomicMutateService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailCsvZipStreamingService, (String)"incorrectEmailCsvZipStreamingService");
        Intrinsics.checkNotNullParameter((Object)emailTrustedDomainService, (String)"emailTrustedDomainService");
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.incorrectEmailUpsertService = incorrectEmailUpsertService;
        this.incorrectEmailAtomicMutateService = incorrectEmailAtomicMutateService;
        this.incorrectEmailCsvZipStreamingService = incorrectEmailCsvZipStreamingService;
        this.emailTrustedDomainService = emailTrustedDomainService;
        this.applicationProperties = applicationProperties;
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="incorrect-email/upsert-invalid-emails")
    @NotNull
    public final Response upsertInvalidEmails(@NotNull List<EmailUpsertDto> emailDataList) {
        Collection<EmailData> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(emailDataList, (String)"emailDataList");
        String executionId = "DebugResourceIncorrectEmailsExecutionId";
        Iterable iterable = emailDataList;
        String string = executionId;
        IncorrectEmailUpsertService incorrectEmailUpsertService = this.incorrectEmailUpsertService;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            EmailUpsertDto emailUpsertDto = (EmailUpsertDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getEmailData());
        }
        collection = (List)destination$iv$iv;
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
        IncorrectEmailUpsertResult upsertResult = incorrectEmailUpsertService.upsertInvalidEmails(string, (List<? extends EmailData>)collection, applicationUser, CheckType.InvalidEmails);
        return ResponseUtils.INSTANCE.ok(EmailUpsertResultDto.Companion.fromIncorrectEmailUpsertResult(upsertResult));
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="incorrect-email/upsert-duplicate-emails")
    @NotNull
    public final Response upsertDuplicateEmails(@NotNull List<EmailUpsertDto> emailDataList) {
        Collection<EmailData> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(emailDataList, (String)"emailDataList");
        String executionId = "DebugResourceIncorrectEmailsExecutionId";
        Iterable iterable = emailDataList;
        String string = executionId;
        IncorrectEmailUpsertService incorrectEmailUpsertService = this.incorrectEmailUpsertService;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            EmailUpsertDto emailUpsertDto = (EmailUpsertDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getEmailData());
        }
        collection = (List)destination$iv$iv;
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
        IncorrectEmailUpsertResult upsertResult = incorrectEmailUpsertService.upsertDuplicateEmails(string, (List<? extends EmailData>)collection, applicationUser, CheckType.SharedEmails);
        return ResponseUtils.INSTANCE.ok(EmailUpsertResultDto.Companion.fromIncorrectEmailUpsertResult(upsertResult));
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="incorrect-email/atomic-delete-upsert-invalid-emails")
    @NotNull
    public final Response atomicDeleteAndUpsertInvalidEmails(@NotNull List<String> userKeys) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userKeys, (String)"userKeys");
        String executionId = "DebugResourceIncorrectEmailsExecutionId";
        Random random = new Random();
        Iterable $this$map$iv = (Iterable)new IntRange(0, 250);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EmailData(userKeys.get(random.nextInt(userKeys.size())), "invalid" + (int)it + "@!!"));
        }
        List invalidEmails = (List)destination$iv$iv;
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
        AtomicMutateResult result2 = this.incorrectEmailAtomicMutateService.deleteAndUpsertInvalidEmails(executionId, invalidEmails, applicationUser, CheckType.InvalidEmails, MigrationScopeContext.Companion.getEMPTY());
        return ResponseUtils.INSTANCE.ok(AtomicMutateResultDto.Companion.fromAtomicMutateResult(result2));
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="incorrect-email/atomic-delete-upsert-duplicate-emails")
    @NotNull
    public final Response atomicDeleteAndUpsertDuplicateEmails(@NotNull List<String> userKeys) {
        Intrinsics.checkNotNullParameter(userKeys, (String)"userKeys");
        String executionId = "DebugResourceIncorrectEmailsExecutionId";
        List duplicateEmails = new ArrayList();
        Map userNameToEmailMap = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = userKeys;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void userKey;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl = false;
            String email = "valid" + i + "@gmail.com";
            duplicateEmails.add(new EmailDuplicate(email, CollectionsKt.listOf((Object)userKey)));
            userNameToEmailMap.put(userKey, email);
        }
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
        AtomicMutateResult result2 = this.incorrectEmailAtomicMutateService.deleteAndUpsertDuplicateEmails(userNameToEmailMap, executionId, duplicateEmails, applicationUser, CheckType.SharedEmails, MigrationScopeContext.Companion.getEMPTY());
        return ResponseUtils.INSTANCE.ok(AtomicMutateResultDto.Companion.fromAtomicMutateResult(result2));
    }

    @GET
    @Path(value="incorrect-email/download-csv")
    @NotNull
    public final Response downloadIncorrectEmailsCsv() {
        String executionId = "DebugResourceIncorrectEmailsExecutionId";
        Response response2 = Response.ok(arg_0 -> EmailDebugResource.downloadIncorrectEmailsCsv$lambda$3(this, executionId, arg_0)).type("text/csv").header("Content-disposition", (Object)("attachment; filename=incorrect-email-" + executionId + ".zip")).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="trust-all-domains")
    @NotNull
    public final Response setAllEmailDomainsAsTrusted() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.emailTrustedDomainService.getAllDomains();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmailTrustedDomain emailTrustedDomain = (EmailTrustedDomain)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EmailTrustedDomain(it.getDomainName(), EmailTrustedDomain.DomainNameRule.TRUSTED, it.getActiveUsers(), it.getInactiveUsers(), null, 16, null));
        }
        List allDomains = (List)destination$iv$iv;
        this.emailTrustedDomainService.setDomains(allDomains);
        Response response2 = Response.temporaryRedirect((URI)new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/secure/migration-app-action.jspa#/choose-domains")).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="remove-all-domain-rules")
    @NotNull
    public final Response removeAllEmailDomainRules() {
        this.emailTrustedDomainService.setDomains(CollectionsKt.emptyList());
        Response response2 = Response.temporaryRedirect((URI)new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/secure/migration-app-action.jspa#/choose-domains")).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    private static final void downloadIncorrectEmailsCsv$lambda$3(EmailDebugResource this$0, String $executionId, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        IncorrectEmailCsvZipStreamingService incorrectEmailCsvZipStreamingService = this$0.incorrectEmailCsvZipStreamingService;
        Intrinsics.checkNotNull((Object)it);
        OutputStreamWritingResult res = incorrectEmailCsvZipStreamingService.createCsvAndWriteToOutput($executionId, it);
        if (!(res instanceof OutputStreamWritingResult.Success) && res instanceof OutputStreamWritingResult.Failed) {
            throw new WebApplicationException(((OutputStreamWritingResult.Failed)res).getError());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB/\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$AtomicMutateResultDto;", "", "totalInserted", "", "totalUpdated", "totalDeleted", "error", "", "(JJJLjava/lang/String;)V", "getError", "()Ljava/lang/String;", "getTotalDeleted", "()J", "getTotalInserted", "getTotalUpdated", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "jira-migration-plugin"})
    public static final class AtomicMutateResultDto {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @org.codehaus.jackson.annotate.JsonProperty(value="totalInserted")
        @JsonProperty(value="totalInserted")
        private final long totalInserted;
        @org.codehaus.jackson.annotate.JsonProperty(value="totalUpdated")
        @JsonProperty(value="totalUpdated")
        private final long totalUpdated;
        @org.codehaus.jackson.annotate.JsonProperty(value="totalDeleted")
        @JsonProperty(value="totalDeleted")
        private final long totalDeleted;
        @org.codehaus.jackson.annotate.JsonProperty(value="error")
        @JsonProperty(value="error")
        @NotNull
        private final String error;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public AtomicMutateResultDto(long totalInserted, long totalUpdated, long totalDeleted, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.totalInserted = totalInserted;
            this.totalUpdated = totalUpdated;
            this.totalDeleted = totalDeleted;
            this.error = error;
        }

        public /* synthetic */ AtomicMutateResultDto(long l, long l2, long l3, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                string = "";
            }
            this(l, l2, l3, string);
        }

        public final long getTotalInserted() {
            return this.totalInserted;
        }

        public final long getTotalUpdated() {
            return this.totalUpdated;
        }

        public final long getTotalDeleted() {
            return this.totalDeleted;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        public final long component1() {
            return this.totalInserted;
        }

        public final long component2() {
            return this.totalUpdated;
        }

        public final long component3() {
            return this.totalDeleted;
        }

        @NotNull
        public final String component4() {
            return this.error;
        }

        @NotNull
        public final AtomicMutateResultDto copy(long totalInserted, long totalUpdated, long totalDeleted, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new AtomicMutateResultDto(totalInserted, totalUpdated, totalDeleted, error);
        }

        public static /* synthetic */ AtomicMutateResultDto copy$default(AtomicMutateResultDto atomicMutateResultDto, long l, long l2, long l3, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = atomicMutateResultDto.totalInserted;
            }
            if ((n & 2) != 0) {
                l2 = atomicMutateResultDto.totalUpdated;
            }
            if ((n & 4) != 0) {
                l3 = atomicMutateResultDto.totalDeleted;
            }
            if ((n & 8) != 0) {
                string = atomicMutateResultDto.error;
            }
            return atomicMutateResultDto.copy(l, l2, l3, string);
        }

        @NotNull
        public String toString() {
            return "AtomicMutateResultDto(totalInserted=" + this.totalInserted + ", totalUpdated=" + this.totalUpdated + ", totalDeleted=" + this.totalDeleted + ", error=" + this.error + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.totalInserted);
            result2 = result2 * 31 + Long.hashCode(this.totalUpdated);
            result2 = result2 * 31 + Long.hashCode(this.totalDeleted);
            result2 = result2 * 31 + this.error.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AtomicMutateResultDto)) {
                return false;
            }
            AtomicMutateResultDto atomicMutateResultDto = (AtomicMutateResultDto)other;
            if (this.totalInserted != atomicMutateResultDto.totalInserted) {
                return false;
            }
            if (this.totalUpdated != atomicMutateResultDto.totalUpdated) {
                return false;
            }
            if (this.totalDeleted != atomicMutateResultDto.totalDeleted) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)atomicMutateResultDto.error);
        }

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public AtomicMutateResultDto() {
            this(0L, 0L, 0L, null, 15, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$AtomicMutateResultDto$Companion;", "", "()V", "fromAtomicMutateResult", "Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$AtomicMutateResultDto;", "upsertResult", "Lcom/atlassian/jira/migration/email/model/AtomicMutateResult;", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AtomicMutateResultDto fromAtomicMutateResult(@NotNull AtomicMutateResult upsertResult) {
                AtomicMutateResultDto atomicMutateResultDto;
                Intrinsics.checkNotNullParameter((Object)upsertResult, (String)"upsertResult");
                AtomicMutateResult atomicMutateResult = upsertResult;
                if (atomicMutateResult instanceof AtomicMutateResult.Success) {
                    atomicMutateResultDto = new AtomicMutateResultDto(((AtomicMutateResult.Success)upsertResult).getTotalInserted(), ((AtomicMutateResult.Success)upsertResult).getTotalUpdated(), ((AtomicMutateResult.Success)upsertResult).getTotalDeleted(), null, 8, null);
                } else if (atomicMutateResult instanceof AtomicMutateResult.Failed) {
                    String string = ((AtomicMutateResult.Failed)upsertResult).getError().getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    atomicMutateResultDto = new AtomicMutateResultDto(0L, 0L, 0L, string, 7, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return atomicMutateResultDto;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$EmailUpsertDto;", "", "username", "", "email", "(Ljava/lang/String;Ljava/lang/String;)V", "getEmail", "()Ljava/lang/String;", "emailData", "Lcom/atlassian/cmpt/check/email/EmailData;", "getEmailData", "()Lcom/atlassian/cmpt/check/email/EmailData;", "getUsername", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class EmailUpsertDto {
        @NotNull
        private final String username;
        @NotNull
        private final String email;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public EmailUpsertDto(@org.codehaus.jackson.annotate.JsonProperty(value="username") @JsonProperty(value="username") @NotNull String username, @org.codehaus.jackson.annotate.JsonProperty(value="email") @JsonProperty(value="email") @NotNull String email) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            this.username = username;
            this.email = email;
        }

        @NotNull
        public final String getUsername() {
            return this.username;
        }

        @NotNull
        public final String getEmail() {
            return this.email;
        }

        @NotNull
        public final EmailData getEmailData() {
            return new EmailData(this.username, this.email);
        }

        @NotNull
        public final String component1() {
            return this.username;
        }

        @NotNull
        public final String component2() {
            return this.email;
        }

        @NotNull
        public final EmailUpsertDto copy(@org.codehaus.jackson.annotate.JsonProperty(value="username") @JsonProperty(value="username") @NotNull String username, @org.codehaus.jackson.annotate.JsonProperty(value="email") @JsonProperty(value="email") @NotNull String email) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            return new EmailUpsertDto(username, email);
        }

        public static /* synthetic */ EmailUpsertDto copy$default(EmailUpsertDto emailUpsertDto, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = emailUpsertDto.username;
            }
            if ((n & 2) != 0) {
                string2 = emailUpsertDto.email;
            }
            return emailUpsertDto.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "EmailUpsertDto(username=" + this.username + ", email=" + this.email + ')';
        }

        public int hashCode() {
            int result2 = this.username.hashCode();
            result2 = result2 * 31 + this.email.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmailUpsertDto)) {
                return false;
            }
            EmailUpsertDto emailUpsertDto = (EmailUpsertDto)other;
            if (!Intrinsics.areEqual((Object)this.username, (Object)emailUpsertDto.username)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.email, (Object)emailUpsertDto.email);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB/\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$EmailUpsertResultDto;", "", "totalInserted", "", "totalUpdated", "unprocessed", "error", "", "(JJJLjava/lang/String;)V", "getError", "()Ljava/lang/String;", "getTotalInserted", "()J", "getTotalUpdated", "getUnprocessed", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "jira-migration-plugin"})
    public static final class EmailUpsertResultDto {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @org.codehaus.jackson.annotate.JsonProperty(value="totalInserted")
        @JsonProperty(value="totalInserted")
        private final long totalInserted;
        @org.codehaus.jackson.annotate.JsonProperty(value="totalUpdated")
        @JsonProperty(value="totalUpdated")
        private final long totalUpdated;
        @org.codehaus.jackson.annotate.JsonProperty(value="unprocessed")
        @JsonProperty(value="unprocessed")
        private final long unprocessed;
        @org.codehaus.jackson.annotate.JsonProperty(value="error")
        @JsonProperty(value="error")
        @NotNull
        private final String error;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public EmailUpsertResultDto(long totalInserted, long totalUpdated, long unprocessed, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.totalInserted = totalInserted;
            this.totalUpdated = totalUpdated;
            this.unprocessed = unprocessed;
            this.error = error;
        }

        public /* synthetic */ EmailUpsertResultDto(long l, long l2, long l3, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                string = "";
            }
            this(l, l2, l3, string);
        }

        public final long getTotalInserted() {
            return this.totalInserted;
        }

        public final long getTotalUpdated() {
            return this.totalUpdated;
        }

        public final long getUnprocessed() {
            return this.unprocessed;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        public final long component1() {
            return this.totalInserted;
        }

        public final long component2() {
            return this.totalUpdated;
        }

        public final long component3() {
            return this.unprocessed;
        }

        @NotNull
        public final String component4() {
            return this.error;
        }

        @NotNull
        public final EmailUpsertResultDto copy(long totalInserted, long totalUpdated, long unprocessed, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new EmailUpsertResultDto(totalInserted, totalUpdated, unprocessed, error);
        }

        public static /* synthetic */ EmailUpsertResultDto copy$default(EmailUpsertResultDto emailUpsertResultDto, long l, long l2, long l3, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = emailUpsertResultDto.totalInserted;
            }
            if ((n & 2) != 0) {
                l2 = emailUpsertResultDto.totalUpdated;
            }
            if ((n & 4) != 0) {
                l3 = emailUpsertResultDto.unprocessed;
            }
            if ((n & 8) != 0) {
                string = emailUpsertResultDto.error;
            }
            return emailUpsertResultDto.copy(l, l2, l3, string);
        }

        @NotNull
        public String toString() {
            return "EmailUpsertResultDto(totalInserted=" + this.totalInserted + ", totalUpdated=" + this.totalUpdated + ", unprocessed=" + this.unprocessed + ", error=" + this.error + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.totalInserted);
            result2 = result2 * 31 + Long.hashCode(this.totalUpdated);
            result2 = result2 * 31 + Long.hashCode(this.unprocessed);
            result2 = result2 * 31 + this.error.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmailUpsertResultDto)) {
                return false;
            }
            EmailUpsertResultDto emailUpsertResultDto = (EmailUpsertResultDto)other;
            if (this.totalInserted != emailUpsertResultDto.totalInserted) {
                return false;
            }
            if (this.totalUpdated != emailUpsertResultDto.totalUpdated) {
                return false;
            }
            if (this.unprocessed != emailUpsertResultDto.unprocessed) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)emailUpsertResultDto.error);
        }

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public EmailUpsertResultDto() {
            this(0L, 0L, 0L, null, 15, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$EmailUpsertResultDto$Companion;", "", "()V", "fromIncorrectEmailUpsertResult", "Lcom/atlassian/jira/migration/email/rest/EmailDebugResource$EmailUpsertResultDto;", "upsertResult", "Lcom/atlassian/jira/migration/email/IncorrectEmailUpsertResult;", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final EmailUpsertResultDto fromIncorrectEmailUpsertResult(@NotNull IncorrectEmailUpsertResult upsertResult) {
                EmailUpsertResultDto emailUpsertResultDto;
                Intrinsics.checkNotNullParameter((Object)upsertResult, (String)"upsertResult");
                IncorrectEmailUpsertResult incorrectEmailUpsertResult = upsertResult;
                if (incorrectEmailUpsertResult instanceof IncorrectEmailUpsertResult.Success) {
                    emailUpsertResultDto = new EmailUpsertResultDto(((IncorrectEmailUpsertResult.Success)upsertResult).getTotalInserted(), ((IncorrectEmailUpsertResult.Success)upsertResult).getTotalUpdated(), 0L, null, 12, null);
                } else if (incorrectEmailUpsertResult instanceof IncorrectEmailUpsertResult.Failed) {
                    long l = ((IncorrectEmailUpsertResult.Failed)upsertResult).getUnprocessed().size();
                    String string = ((IncorrectEmailUpsertResult.Failed)upsertResult).getError().getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    emailUpsertResultDto = new EmailUpsertResultDto(0L, 0L, l, string, 3, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return emailUpsertResultDto;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

