/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email.rest;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.email.EmailTrustedDomainService;
import com.atlassian.jira.migration.email.model.EmailTrustedDomain;
import com.atlassian.jira.migration.email.rest.EmailDomainResource;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import com.atlassian.jira.migration.preflight.EmailBlockedDomainUmsService;
import com.atlassian.jira.migration.preflight.TrustedDomainsCsvZipException;
import com.atlassian.jira.migration.preflight.TrustedDomainsCsvZipService;
import com.atlassian.jira.migration.preflight.model.DomainScanStatus;
import com.atlassian.jira.migration.utils.CsvUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="email-domain")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0010H\u0007J\b\u0010\u0014\u001a\u00020\u0010H\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0007J\u0012\u0010\u0016\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001a\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u0012H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailDomainResource;", "", "emailTrustedDomainService", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;", "emailBlockedDomainUmsService", "Lcom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService;", "trustedDomainsCsvZipService", "Lcom/atlassian/jira/migration/preflight/TrustedDomainsCsvZipService;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "authenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "(Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;Lcom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService;Lcom/atlassian/jira/migration/preflight/TrustedDomainsCsvZipService;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/security/JiraAuthenticationContext;)V", "downloadDomainsFile", "Ljavax/ws/rs/core/Response;", "cloudId", "", "getAllUsersEmailDomains", "getDomainScanStatus", "resetAllUserModifiedDomainRules", "triggerDomainScan", "updateTrustedDomainRule", "trustedDomain", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomain;", "uploadDomainsFile", "fileInputStream", "Ljava/io/InputStream;", "fileName", "jira-migration-plugin"})
public final class EmailDomainResource {
    @NotNull
    private final EmailTrustedDomainService emailTrustedDomainService;
    @NotNull
    private final EmailBlockedDomainUmsService emailBlockedDomainUmsService;
    @NotNull
    private final TrustedDomainsCsvZipService trustedDomainsCsvZipService;
    @NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final JiraAuthenticationContext authenticationContext;

    @Inject
    public EmailDomainResource(@NotNull EmailTrustedDomainService emailTrustedDomainService, @NotNull EmailBlockedDomainUmsService emailBlockedDomainUmsService, @NotNull TrustedDomainsCsvZipService trustedDomainsCsvZipService, @NotNull ContainerTokenTTLService containerTokenTTLService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull JiraAuthenticationContext authenticationContext) {
        Intrinsics.checkNotNullParameter((Object)emailTrustedDomainService, (String)"emailTrustedDomainService");
        Intrinsics.checkNotNullParameter((Object)emailBlockedDomainUmsService, (String)"emailBlockedDomainUmsService");
        Intrinsics.checkNotNullParameter((Object)trustedDomainsCsvZipService, (String)"trustedDomainsCsvZipService");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)authenticationContext, (String)"authenticationContext");
        this.emailTrustedDomainService = emailTrustedDomainService;
        this.emailBlockedDomainUmsService = emailBlockedDomainUmsService;
        this.trustedDomainsCsvZipService = trustedDomainsCsvZipService;
        this.containerTokenTTLService = containerTokenTTLService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.authenticationContext = authenticationContext;
    }

    @POST
    @Path(value="/scan/{cloudId}")
    @NotNull
    public final Response triggerDomainScan(@PathParam(value="cloudId") @NotNull String cloudId2) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        String containerToken = cloudSite2 != null ? cloudSite2.getContainerToken() : null;
        if (containerToken == null) {
            Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            response2 = response3;
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        } else if (!this.containerTokenTTLService.isValidToken(containerToken)) {
            Response response4 = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("Container-token-expired", (Object)"true").build();
            Intrinsics.checkNotNull((Object)response4);
            response2 = response4;
        } else {
            ApplicationUser applicationUser = this.authenticationContext.getLoggedInUser();
            Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
            this.emailBlockedDomainUmsService.startDomainScanSafely(cloudId2, applicationUser);
            Response response5 = Response.status((Response.Status)Response.Status.ACCEPTED).build();
            Intrinsics.checkNotNull((Object)response5);
            response2 = response5;
        }
        return response2;
    }

    @GET
    @Path(value="/scan/summary")
    @NotNull
    public final Response getDomainScanStatus() {
        Response response2 = Response.ok((Object)this.emailBlockedDomainUmsService.getDomainScanStatus().toString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/domains")
    @NotNull
    public final Response getAllUsersEmailDomains() {
        Response response2;
        if (this.emailBlockedDomainUmsService.getDomainScanStatus() == DomainScanStatus.IN_PROGRESS) {
            Response response3 = Response.ok((Object)CollectionsKt.emptyList()).build();
            Intrinsics.checkNotNull((Object)response3);
            response2 = response3;
        } else {
            Response response4 = Response.ok(this.emailTrustedDomainService.getAllDomains()).build();
            Intrinsics.checkNotNull((Object)response4);
            response2 = response4;
        }
        return response2;
    }

    @PUT
    @Path(value="/rules")
    @NotNull
    public final Response updateTrustedDomainRule(@NotNull EmailTrustedDomain trustedDomain) {
        Intrinsics.checkNotNullParameter((Object)trustedDomain, (String)"trustedDomain");
        this.emailTrustedDomainService.updateTrustedDomain(trustedDomain);
        Response response2 = Response.ok((Object)"Trusted domain rule updated").build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @POST
    @Path(value="/rules/reset")
    @NotNull
    public final Response resetAllUserModifiedDomainRules() {
        this.emailTrustedDomainService.resetUserModifiedDomainRules();
        Response response2 = Response.ok((Object)"All user modified trusted domain rules updated to NO_DECISION_MADE").build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/upload/domains")
    @Consumes(value={"application/octet-stream"})
    @NotNull
    public final Response uploadDomainsFile(@NotNull InputStream fileInputStream, @QueryParam(value="fileName") @NotNull String fileName) {
        Object object;
        EmailTrustedDomainService.CsvDomainUploadStatus csvDomainUploadStatus;
        Intrinsics.checkNotNullParameter((Object)fileInputStream, (String)"fileInputStream");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!CsvUtil.INSTANCE.isFileCsv(fileName)) {
            Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid file type").build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        Object object2 = new BufferedInputStream(fileInputStream);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)object2;
            boolean bl = false;
            csvDomainUploadStatus = this.emailTrustedDomainService.processDomainCsvContent(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        EmailTrustedDomainService.CsvDomainUploadStatus result2 = csvDomainUploadStatus;
        object2 = result2;
        if (object2 instanceof EmailTrustedDomainService.CsvDomainUploadStatus.CsvDomainUploadSuccess) {
            Response response3 = Response.ok((Object)"File upload successful. All records are valid.").build();
            object = response3;
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        } else if (object2 instanceof EmailTrustedDomainService.CsvDomainUploadStatus.CvsDomainRecordValidationFailed) {
            throwable = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)CollectionsKt.joinToString$default((Iterable)((EmailTrustedDomainService.CsvDomainUploadStatus.CvsDomainRecordValidationFailed)result2).getCsvRecordErrors(), (CharSequence)"\n", null, null, (int)0, null, (Function1)uploadDomainsFile.1.INSTANCE, (int)30, null)).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else if (object2 instanceof EmailTrustedDomainService.CsvDomainUploadStatus.CsvDomainRecordInsertFailed) {
            throwable = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)((EmailTrustedDomainService.CsvDomainUploadStatus.CsvDomainRecordInsertFailed)result2).getErrorMessage()).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else if (object2 instanceof EmailTrustedDomainService.CsvDomainUploadStatus.CsvDomainRecordFailed) {
            throwable = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((EmailTrustedDomainService.CsvDomainUploadStatus.CsvDomainRecordFailed)result2).getErrorMessage()).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/download/domains/{cloudId}")
    @NotNull
    public final Response downloadDomainsFile(@PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        long fileTimestamp = Instant.now().toEpochMilli();
        ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
        try {
            this.trustedDomainsCsvZipService.writeDomainsCsvZip(inMemoryOutputStream, fileTimestamp);
        }
        catch (TrustedDomainsCsvZipException e) {
            Response response2;
            switch (WhenMappings.$EnumSwitchMapping$0[e.getType().ordinal()]) {
                case 1: {
                    Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)TrustedDomainsCsvZipException.Type.INVALID_CLOUD_ID.getMessage()).build();
                    response2 = response3;
                    Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
                    break;
                }
                case 2: {
                    Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)TrustedDomainsCsvZipException.Type.COULD_NOT_CREATE_CSV.getMessage()).build();
                    response2 = response4;
                    Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"build(...)");
                    break;
                }
                case 3: {
                    Response response5 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_CSV.getMessage()).build();
                    response2 = response5;
                    Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"build(...)");
                    break;
                }
                case 4: {
                    Response response6 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_ZIP.getMessage()).build();
                    response2 = response6;
                    Intrinsics.checkNotNullExpressionValue((Object)response6, (String)"build(...)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return response2;
        }
        Response response7 = Response.ok(arg_0 -> EmailDomainResource.downloadDomainsFile$lambda$1(inMemoryOutputStream, arg_0)).type("application/zip").header("Content-disposition", (Object)("attachment; filename=trusted-domains-" + fileTimestamp + ".zip")).build();
        Intrinsics.checkNotNullExpressionValue((Object)response7, (String)"build(...)");
        return response7;
    }

    private static final void downloadDomainsFile$lambda$1(ByteArrayOutputStream $inMemoryOutputStream, OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)$inMemoryOutputStream, (String)"$inMemoryOutputStream");
        $inMemoryOutputStream.writeTo(outputStream);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrustedDomainsCsvZipException.Type.values().length];
            try {
                nArray[TrustedDomainsCsvZipException.Type.INVALID_CLOUD_ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrustedDomainsCsvZipException.Type.COULD_NOT_CREATE_CSV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_CSV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_ZIP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

