/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.email.rest;

import com.atlassian.jira.migration.containerToken.ContainerTokenValidator;
import com.atlassian.jira.migration.email.CorrectedEmailService;
import com.atlassian.jira.migration.email.CorrectedEmails;
import com.atlassian.jira.migration.email.CsvUploadStatus;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.email.EmailConfig;
import com.atlassian.jira.migration.email.EmailConfigService;
import com.atlassian.jira.migration.email.FileCreationResult;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.IncorrectEmailCsvZipStreamingService;
import com.atlassian.jira.migration.email.IncorrectEmailDTO;
import com.atlassian.jira.migration.email.IncorrectEmailService;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.email.OutputStreamWritingResult;
import com.atlassian.jira.migration.email.model.PageResponse;
import com.atlassian.jira.migration.email.rest.DuplicatedEmailsConfigDTO;
import com.atlassian.jira.migration.email.rest.EmailResource;
import com.atlassian.jira.migration.email.rest.InvalidEmailsConfigDTO;
import com.atlassian.jira.migration.preflight.ScanSummaryService;
import com.atlassian.jira.migration.serverdataextractors.SortOrder;
import com.atlassian.jira.migration.serverdataextractors.UserBaseScanSortKey;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.config.ConfigUpdateResult;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="email")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0012\u0010\u0019\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u001aH\u0007J\u0012\u0010\u001b\u001a\u00020\u00122\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0007J\u001e\u0010\u001e\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0003\u0010\u0018\u001a\u0004\u0018\u00010\u001aH\u0007J\b\u0010\u001f\u001a\u00020\u0012H\u0007J\b\u0010 \u001a\u00020\u0012H\u0007J\u0012\u0010!\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J\u001c\u0010!\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\"\u001a\u00020\u0017H\u0007J:\u0010#\u001a\u00020\u00122\b\b\u0001\u0010$\u001a\u00020\u00172\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020&2\b\b\u0001\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020+H\u0007JF\u0010#\u001a\u00020\u00122\b\b\u0001\u0010$\u001a\u00020\u00172\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020&2\b\b\u0001\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020+2\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0007J\b\u0010,\u001a\u00020\u0012H\u0007J\u0012\u0010-\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J\u001c\u0010-\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\"\u001a\u00020\u0017H\u0007J:\u0010.\u001a\u00020\u00122\b\b\u0001\u0010$\u001a\u00020\u00172\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020&2\b\b\u0001\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020+H\u0007JF\u0010.\u001a\u00020\u00122\b\b\u0001\u0010$\u001a\u00020\u00172\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020&2\b\b\u0001\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020+2\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0007J\u0010\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u000201H\u0007J\u0010\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u000204H\u0007J\u0010\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u000207H\u0007J&\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u001aH\u0007J2\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u001aH\u0007J\u0010\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020&H\u0002J,\u0010=\u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailResource;", "", "correctedEmailService", "Lcom/atlassian/jira/migration/email/CorrectedEmailService;", "emailConfigService", "Lcom/atlassian/jira/migration/email/EmailConfigService;", "incorrectEmailCsvZipStreamingService", "Lcom/atlassian/jira/migration/email/IncorrectEmailCsvZipStreamingService;", "globalEmailFixesConfigService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "incorrectEmailService", "Lcom/atlassian/jira/migration/email/IncorrectEmailService;", "scanSummaryService", "Lcom/atlassian/jira/migration/preflight/ScanSummaryService;", "containerTokenValidator", "Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;", "(Lcom/atlassian/jira/migration/email/CorrectedEmailService;Lcom/atlassian/jira/migration/email/EmailConfigService;Lcom/atlassian/jira/migration/email/IncorrectEmailCsvZipStreamingService;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/email/IncorrectEmailService;Lcom/atlassian/jira/migration/preflight/ScanSummaryService;Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;)V", "createStreamingResponse", "Ljavax/ws/rs/core/Response;", "kotlin.jvm.PlatformType", "fileCreateResult", "Lcom/atlassian/jira/migration/email/FileCreationResult$Success;", "executionId", "", "emailCheckType", "deleteCorrectedUsers", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "downloadCorrectedUsers", "skipValidation", "", "downloadFile", "getConfig", "getDuplicatedEmailConfig", "getDuplicatedEmailStatistics", "cloudId", "getDuplicatedEmails", "userBaseScanId", "limit", "", "page", "sortKey", "Lcom/atlassian/jira/migration/serverdataextractors/UserBaseScanSortKey;", "sortOrder", "Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;", "getInvalidEmailConfig", "getInvalidEmailStatistics", "getInvalidEmails", "saveConfig", "emailConfig", "Lcom/atlassian/jira/migration/email/EmailConfig;", "saveDuplicatedEmailConfig", "duplicatedEmailsConfigDTO", "Lcom/atlassian/jira/migration/email/rest/DuplicatedEmailsConfigDTO;", "saveInvalidEmailConfig", "invalidEmailsConfigDTO", "Lcom/atlassian/jira/migration/email/rest/InvalidEmailsConfigDTO;", "uploadFile", "file", "Ljava/io/InputStream;", "validateLimit", "param", "validateUDCPaginatedRequest", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailResource.kt\ncom/atlassian/jira/migration/email/rest/EmailResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,461:1\n1#2:462\n11065#3:463\n11400#3,3:464\n11065#3:467\n11400#3,3:468\n*S KotlinDebug\n*F\n+ 1 EmailResource.kt\ncom/atlassian/jira/migration/email/rest/EmailResource\n*L\n137#1:463\n137#1:464,3\n203#1:467\n203#1:468,3\n*E\n"})
public final class EmailResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CorrectedEmailService correctedEmailService;
    @NotNull
    private final EmailConfigService emailConfigService;
    @NotNull
    private final IncorrectEmailCsvZipStreamingService incorrectEmailCsvZipStreamingService;
    @NotNull
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    @NotNull
    private final IncorrectEmailService incorrectEmailService;
    @NotNull
    private final ScanSummaryService scanSummaryService;
    @NotNull
    private final ContainerTokenValidator containerTokenValidator;
    private static final Logger log = LoggerFactory.getLogger(EmailResource.class);

    @Inject
    public EmailResource(@NotNull CorrectedEmailService correctedEmailService, @NotNull EmailConfigService emailConfigService, @NotNull IncorrectEmailCsvZipStreamingService incorrectEmailCsvZipStreamingService, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService, @NotNull IncorrectEmailService incorrectEmailService, @NotNull ScanSummaryService scanSummaryService, @NotNull ContainerTokenValidator containerTokenValidator) {
        Intrinsics.checkNotNullParameter((Object)correctedEmailService, (String)"correctedEmailService");
        Intrinsics.checkNotNullParameter((Object)emailConfigService, (String)"emailConfigService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailCsvZipStreamingService, (String)"incorrectEmailCsvZipStreamingService");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailService, (String)"incorrectEmailService");
        Intrinsics.checkNotNullParameter((Object)scanSummaryService, (String)"scanSummaryService");
        Intrinsics.checkNotNullParameter((Object)containerTokenValidator, (String)"containerTokenValidator");
        this.correctedEmailService = correctedEmailService;
        this.emailConfigService = emailConfigService;
        this.incorrectEmailCsvZipStreamingService = incorrectEmailCsvZipStreamingService;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.incorrectEmailService = incorrectEmailService;
        this.scanSummaryService = scanSummaryService;
        this.containerTokenValidator = containerTokenValidator;
    }

    @POST
    @Path(value="/config")
    @NotNull
    public final Response saveConfig(@NotNull EmailConfig emailConfig) {
        Intrinsics.checkNotNullParameter((Object)emailConfig, (String)"emailConfig");
        this.emailConfigService.saveConfig(emailConfig);
        Response response2 = Response.ok((Object)"Email check scope configs updated").build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/config")
    @NotNull
    public final Response getConfig() {
        Response response2;
        Response response3;
        Response response4;
        EmailConfig emailConfig = this.emailConfigService.getConfig();
        if (emailConfig != null) {
            EmailConfig it = emailConfig;
            boolean bl = false;
            response4 = Response.ok((Object)it).build();
        } else {
            response4 = response3 = null;
        }
        if (response3 == null) {
            Response response5 = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Email config had never been set.").build();
            response2 = response5;
            Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"build(...)");
        } else {
            response2 = response3;
        }
        return response2;
    }

    @GET
    @Path(value="/duplicated")
    @NotNull
    public final Response getDuplicatedEmails(@QueryParam(value="userBaseScanId") @NotNull String userBaseScanId, @QueryParam(value="limit") int limit, @QueryParam(value="page") int page, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") @NotNull UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)userBaseScanId, (String)"userBaseScanId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return this.getDuplicatedEmails(userBaseScanId, limit, page, sortKey, sortOrder, null);
    }

    @GET
    @Path(value="/duplicated/{cloudId}")
    @NotNull
    public final Response getDuplicatedEmails(@QueryParam(value="userBaseScanId") @NotNull String userBaseScanId, @QueryParam(value="limit") int limit, @QueryParam(value="page") int page, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") @NotNull UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") @NotNull SortOrder sortOrder, @PathParam(value="cloudId") @Nullable String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)userBaseScanId, (String)"userBaseScanId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Response response2 = this.validateUDCPaginatedRequest(cloudId2, userBaseScanId, limit, page);
        if (response2 != null) {
            Response it = response2;
            boolean bl = false;
            return it;
        }
        PageResponse<IncorrectEmailDTO> emails = this.incorrectEmailService.getDuplicatedEmails(userBaseScanId, limit, page, sortKey, sortOrder, cloudId2);
        Response response3 = Response.ok(emails).build();
        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        return response3;
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="/duplicated/config")
    @NotNull
    public final Response saveDuplicatedEmailConfig(@NotNull DuplicatedEmailsConfigDTO duplicatedEmailsConfigDTO) {
        Response response2;
        DuplicatedEmailsConfig.OnMigration onMigration;
        Intrinsics.checkNotNullParameter((Object)duplicatedEmailsConfigDTO, (String)"duplicatedEmailsConfigDTO");
        try {
            String string = duplicatedEmailsConfigDTO.getOnMigration().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            onMigration = DuplicatedEmailsConfig.OnMigration.valueOf(string);
        }
        catch (IllegalArgumentException iae) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DuplicatedEmailsConfig.OnMigration[] onMigrationArray = DuplicatedEmailsConfig.OnMigration.values();
            StringBuilder stringBuilder = new StringBuilder().append(duplicatedEmailsConfigDTO.getOnMigration()).append(" argument provided for onMigration parameter is invalid.\nList of allowed parameters: ");
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DuplicatedEmailsConfig.OnMigration onMigration2 = (DuplicatedEmailsConfig.OnMigration)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.name());
            }
            collection = (List)destination$iv$iv;
            Response response3 = responseBuilder.entity((Object)stringBuilder.append(collection).toString()).build();
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
            return response3;
        }
        DuplicatedEmailsConfig.OnMigration onMigrationValue = onMigration;
        DuplicatedEmailsConfig config2 = new DuplicatedEmailsConfig(onMigrationValue, duplicatedEmailsConfigDTO.getMergeCutoffDate(), null, null, 12, null);
        ConfigUpdateResult result2 = this.globalEmailFixesConfigService.saveDuplicatedEmailsConfig(config2);
        if (Intrinsics.areEqual((Object)result2, (Object)ConfigUpdateResult.Success.INSTANCE)) {
            Response response4 = Response.ok((Object)"Duplicated emails check scope configs updated").build();
            response2 = response4;
            Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"build(...)");
        } else if (Intrinsics.areEqual((Object)result2, (Object)ConfigUpdateResult.MigrationIsRunningError.INSTANCE)) {
            Response response5 = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Can't update config when a migration is running").build();
            response2 = response5;
            Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"build(...)");
        } else if (result2 instanceof ConfigUpdateResult.ValidationError) {
            Response response6 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((ConfigUpdateResult.ValidationError)result2).getErrorMessage()).build();
            response2 = response6;
            Intrinsics.checkNotNullExpressionValue((Object)response6, (String)"build(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return response2;
    }

    @GET
    @Path(value="/duplicated/config")
    @NotNull
    public final Response getDuplicatedEmailConfig() {
        Response response2 = Response.ok((Object)this.globalEmailFixesConfigService.getDuplicatedEmailsConfig()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/invalid")
    @NotNull
    public final Response getInvalidEmails(@QueryParam(value="userBaseScanId") @NotNull String userBaseScanId, @QueryParam(value="limit") int limit, @QueryParam(value="page") int page, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") @NotNull UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)userBaseScanId, (String)"userBaseScanId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return this.getInvalidEmails(userBaseScanId, limit, page, sortKey, sortOrder, null);
    }

    @GET
    @Path(value="/invalid/{cloudId}")
    @NotNull
    public final Response getInvalidEmails(@QueryParam(value="userBaseScanId") @NotNull String userBaseScanId, @QueryParam(value="limit") int limit, @QueryParam(value="page") int page, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") @NotNull UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") @NotNull SortOrder sortOrder, @PathParam(value="cloudId") @Nullable String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)userBaseScanId, (String)"userBaseScanId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Response response2 = this.validateUDCPaginatedRequest(cloudId2, userBaseScanId, limit, page);
        if (response2 != null) {
            Response it = response2;
            boolean bl = false;
            return it;
        }
        PageResponse<IncorrectEmailDTO> emails = this.incorrectEmailService.getInvalidEmails(userBaseScanId, limit, page, sortKey, sortOrder, cloudId2);
        Response response3 = Response.ok(emails).build();
        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        return response3;
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="/invalid/config")
    @NotNull
    public final Response saveInvalidEmailConfig(@NotNull InvalidEmailsConfigDTO invalidEmailsConfigDTO) {
        Response response2;
        InvalidEmailsConfig.OnMigration onMigration;
        Intrinsics.checkNotNullParameter((Object)invalidEmailsConfigDTO, (String)"invalidEmailsConfigDTO");
        try {
            String string = invalidEmailsConfigDTO.getOnMigration().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            onMigration = InvalidEmailsConfig.OnMigration.valueOf(string);
        }
        catch (IllegalArgumentException iae) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InvalidEmailsConfig.OnMigration[] onMigrationArray = InvalidEmailsConfig.OnMigration.values();
            StringBuilder stringBuilder = new StringBuilder().append(invalidEmailsConfigDTO.getOnMigration()).append(" argument provided for onMigration parameter is invalid.\nList of allowed parameters: ");
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InvalidEmailsConfig.OnMigration onMigration2 = (InvalidEmailsConfig.OnMigration)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.name());
            }
            collection = (List)destination$iv$iv;
            Response response3 = responseBuilder.entity((Object)stringBuilder.append(collection).toString()).build();
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
            return response3;
        }
        InvalidEmailsConfig.OnMigration onMigrationValue = onMigration;
        InvalidEmailsConfig config2 = new InvalidEmailsConfig(onMigrationValue, invalidEmailsConfigDTO.getTombstoneCutoffDate(), null, null, 12, null);
        ConfigUpdateResult result2 = this.globalEmailFixesConfigService.saveInvalidEmailsConfig(config2);
        if (Intrinsics.areEqual((Object)result2, (Object)ConfigUpdateResult.Success.INSTANCE)) {
            Response response4 = Response.ok((Object)"Invalid emails check scope configs updated").build();
            response2 = response4;
            Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"build(...)");
        } else if (Intrinsics.areEqual((Object)result2, (Object)ConfigUpdateResult.MigrationIsRunningError.INSTANCE)) {
            Response response5 = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Can't update config when a migration is running").build();
            response2 = response5;
            Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"build(...)");
        } else if (result2 instanceof ConfigUpdateResult.ValidationError) {
            Response response6 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((ConfigUpdateResult.ValidationError)result2).getErrorMessage()).build();
            response2 = response6;
            Intrinsics.checkNotNullExpressionValue((Object)response6, (String)"build(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return response2;
    }

    @GET
    @Path(value="/invalid/config")
    @NotNull
    public final Response getInvalidEmailConfig() {
        Response response2 = Response.ok((Object)this.globalEmailFixesConfigService.getInvalidEmailsConfig()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/invalid/statistics/{executionId}/{cloudId}")
    @NotNull
    public final Response getInvalidEmailStatistics(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Response response2 = Response.ok((Object)this.incorrectEmailService.getInvalidEmailStatistics(executionId, cloudId2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/invalid/statistics/{executionId}")
    @NotNull
    public final Response getInvalidEmailStatistics(@PathParam(value="executionId") @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Response response2 = Response.ok((Object)this.incorrectEmailService.getInvalidEmailStatistics(executionId, null)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/duplicated/statistics/{executionId}/{cloudId}")
    @NotNull
    public final Response getDuplicatedEmailStatistics(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Response response2 = Response.ok((Object)this.incorrectEmailService.getDuplicatedEmailStatistics(executionId, cloudId2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/duplicated/statistics/{executionId}")
    @NotNull
    public final Response getDuplicatedEmailStatistics(@PathParam(value="executionId") @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Response response2 = Response.ok((Object)this.incorrectEmailService.getDuplicatedEmailStatistics(executionId, null)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @POST
    @Path(value="/upload/{executionId}")
    @Consumes(value={"application/octet-stream"})
    @NotNull
    public final Response uploadFile(@NotNull InputStream file2, @PathParam(value="executionId") @NotNull String executionId, @QueryParam(value="emailType") @Nullable EmailCheckType emailCheckType) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return this.uploadFile(file2, executionId, null, emailCheckType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/upload/{executionId}/{cloudId}")
    @Consumes(value={"application/octet-stream"})
    @NotNull
    public final Response uploadFile(@NotNull InputStream file2, @PathParam(value="executionId") @NotNull String executionId, @PathParam(value="cloudId") @Nullable String cloudId2, @QueryParam(value="emailType") @Nullable EmailCheckType emailCheckType) {
        Object object;
        CsvUploadStatus csvUploadStatus;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        log.info("Uploading CSV with email fixes for executionId=" + executionId);
        this.incorrectEmailService.invalidateEmailStatisticsCache(executionId, emailCheckType);
        Object object2 = file2;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)object2;
            boolean bl = false;
            csvUploadStatus = this.correctedEmailService.processCsvContent(executionId, cloudId2, it, emailCheckType);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        CsvUploadStatus result2 = csvUploadStatus;
        object2 = result2;
        if (object2 instanceof CsvUploadStatus.CsvUploadSuccess) {
            Response response2 = Response.ok((Object)"File upload successful. All records are valid.").build();
            object = response2;
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        } else if (object2 instanceof CsvUploadStatus.CvsRecordValidationFailed) {
            log.info("Could not read record from uploaded CSV for executionId=" + executionId);
            throwable = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)CollectionsKt.joinToString$default((Iterable)((CsvUploadStatus.CvsRecordValidationFailed)result2).getCsvRecordErrors(), (CharSequence)"\n", null, null, (int)0, null, (Function1)uploadFile.1.INSTANCE, (int)30, null)).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else if (object2 instanceof CsvUploadStatus.CsvRecordInsertFailed) {
            log.error("Error occurred while inserting CSV records for executionId=" + executionId);
            throwable = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)((CsvUploadStatus.CsvRecordInsertFailed)result2).getErrorMessage()).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else if (object2 instanceof CsvUploadStatus.CsvRecordCountFailed) {
            log.info("CSV record count failed occurred for executionId=" + executionId + " : {" + ((CsvUploadStatus.CsvRecordCountFailed)result2).getErrorMessage());
            throwable = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((CsvUploadStatus.CsvRecordCountFailed)result2).getErrorMessage()).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else if (object2 instanceof CsvUploadStatus.CsvUmsInvalidEmailCheckFailed) {
            log.info("UMS validation failed for uploaded CSV for executionId=" + executionId);
            throwable = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((CsvUploadStatus.CsvUmsInvalidEmailCheckFailed)result2).getUmsInvalidEmailsResponseDTO()).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else if (object2 instanceof CsvUploadStatus.CsvFileStructureMismatch) {
            log.info("CSV file structure mismatch occurred for executionId=" + executionId + " : {" + ((CsvUploadStatus.CsvFileStructureMismatch)result2).getErrorMessage());
            throwable = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((CsvUploadStatus.CsvFileStructureMismatch)result2).getErrorMessage()).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else if (object2 instanceof CsvUploadStatus.CsvInvalidEmailsCsv) {
            log.info("CSV contains invalid emails for executionId=" + executionId);
            throwable = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/csv").entity((Object)((CsvUploadStatus.CsvInvalidEmailsCsv)result2).getCsvText()).build();
            Intrinsics.checkNotNull((Object)throwable);
            object = throwable;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @GET
    @Path(value="/correctedUsers/download")
    @NotNull
    public final Response downloadCorrectedUsers(@QueryParam(value="skipValidation") @DefaultValue(value="false") boolean skipValidation) {
        Response response2;
        CorrectedEmails correctedEmails = this.correctedEmailService.loadAllCorrectedEmails(skipValidation);
        if (correctedEmails instanceof CorrectedEmails.Stream) {
            Response response3 = Response.ok((Object)((CorrectedEmails.Stream)correctedEmails).getStream()).type("text/csv").header("Content-disposition", (Object)"attachment; filename=corrected-users.csv").build();
            Intrinsics.checkNotNull((Object)response3);
            response2 = response3;
        } else if (correctedEmails instanceof CorrectedEmails.DuplicatesValidationError) {
            Response response4 = Response.ok((Object)((CorrectedEmails.DuplicatesValidationError)correctedEmails).getDetails()).type("application/json").build();
            Intrinsics.checkNotNull((Object)response4);
            response2 = response4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return response2;
    }

    @DELETE
    @Path(value="/correctedUsers")
    @NotNull
    public final Response deleteCorrectedUsers(@QueryParam(value="emailCheckType") @NotNull EmailCheckType emailCheckType) {
        Intrinsics.checkNotNullParameter((Object)emailCheckType, (String)"emailCheckType");
        this.incorrectEmailService.invalidateAllEmailStatisticsCache();
        long deletedRows = this.correctedEmailService.deleteByEmailCheckType(emailCheckType, this.globalEmailFixesConfigService.getUdcModeConfig());
        log.info("Deleted " + deletedRows + " entries for " + emailCheckType + " email check type");
        Response response2 = Response.noContent().entity((Object)("Deleted " + deletedRows + " entries")).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/download/{executionId}")
    @NotNull
    public final Response downloadFile(@PathParam(value="executionId") @NotNull String executionId, @QueryParam(value="emailCheckType") @Nullable EmailCheckType emailCheckType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        if (this.scanSummaryService.getScanSummary(executionId).getStartedAt() == null) {
            Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        try {
            FileCreationResult fileCreationResult = this.incorrectEmailCsvZipStreamingService.createAndWriteCsv(executionId, emailCheckType);
            if (fileCreationResult instanceof FileCreationResult.Success) {
                String string;
                EmailCheckType emailCheckType2 = emailCheckType;
                switch (emailCheckType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[emailCheckType2.ordinal()]) {
                    case 1: {
                        string = "duplicate";
                        break;
                    }
                    case 2: {
                        string = "invalid";
                        break;
                    }
                    default: {
                        string = "incorrect";
                    }
                }
                String checkType = string;
                Response response3 = this.createStreamingResponse((FileCreationResult.Success)fileCreationResult, executionId, checkType);
                Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"createStreamingResponse(...)");
                return response3;
            }
            if (fileCreationResult instanceof FileCreationResult.Failed) {
                throw ((FileCreationResult.Failed)fileCreationResult).getError();
            }
            throw new NoWhenBranchMatchedException();
        }
        catch (Throwable e) {
            Response response4 = Response.serverError().entity((Object)new WebApplicationException(e)).build();
            Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"build(...)");
            return response4;
        }
    }

    public static /* synthetic */ Response downloadFile$default(EmailResource emailResource, String string, EmailCheckType emailCheckType, int n, Object object) {
        if ((n & 2) != 0) {
            emailCheckType = null;
        }
        return emailResource.downloadFile(string, emailCheckType);
    }

    private final Response createStreamingResponse(FileCreationResult.Success fileCreateResult, String executionId, String emailCheckType) {
        return Response.ok(arg_0 -> EmailResource.createStreamingResponse$lambda$6(this, fileCreateResult, arg_0)).type("application/zip").header("Content-disposition", (Object)("attachment; filename=" + emailCheckType + "-email-" + executionId + ".zip")).build();
    }

    private final boolean validateLimit(int param) {
        return 1 <= param ? param < 101 : false;
    }

    private final Response validateUDCPaginatedRequest(String cloudId2, String userBaseScanId, int limit, int page) {
        Response response2;
        String string = cloudId2;
        if (string != null) {
            String it = string;
            boolean bl = false;
            response2 = this.containerTokenValidator.validateContainerToken(it).toResponseWhenNotValid();
        } else {
            response2 = null;
        }
        Response tokenStateResponse = response2;
        Object object = tokenStateResponse;
        if (object == null) {
            object = StringsKt.isBlank((CharSequence)userBaseScanId) ? Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"userBaseScanId is mandatory").build() : (!this.validateLimit(limit) ? Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"limit must be between 1 and 100").build() : (page < 1 ? Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"page must be greater or equal to 1").build() : null));
        }
        return object;
    }

    private static final void createStreamingResponse$lambda$6(EmailResource this$0, FileCreationResult.Success $fileCreateResult, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fileCreateResult, (String)"$fileCreateResult");
        try {
            IncorrectEmailCsvZipStreamingService incorrectEmailCsvZipStreamingService = this$0.incorrectEmailCsvZipStreamingService;
            Intrinsics.checkNotNull((Object)it);
            OutputStreamWritingResult res = incorrectEmailCsvZipStreamingService.writeFileToOutput($fileCreateResult, it);
            if (!(res instanceof OutputStreamWritingResult.Success) && res instanceof OutputStreamWritingResult.Failed) {
                throw ((OutputStreamWritingResult.Failed)res).getError();
            }
        }
        catch (Throwable e) {
            throw new WebApplicationException(e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/email/rest/EmailResource$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EmailCheckType.values().length];
            try {
                nArray[EmailCheckType.DUP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmailCheckType.INV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

