/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.eventHandlers;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PlanCompletionEvent;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.ShadowMigrationProperties;
import com.atlassian.jira.migration.progress.TaskList;
import com.atlassian.jira.migration.progress.TaskListStatus;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.utils.PlanCompletionEventsUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0017\u001a\u00020\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/eventHandlers/MetricsEventHandler;", "", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "publicPlanMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "buildShadowMigrationProperties", "Lcom/atlassian/jira/migration/platform/ShadowMigrationProperties;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "createAndSendPlanCompletionEvents", "", "currentStatus", "Lcom/atlassian/jira/migration/progress/TaskList;", "migrationId", "", "cloudId", "migrationCreator", "sendTaskStatusEvent", "migrationTaskTypeToStatusMap", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$TaskTypeStatus;", "Source", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMetricsEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsEventHandler.kt\ncom/atlassian/jira/migration/eventHandlers/MetricsEventHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n1#2:75\n215#3,2:76\n*S KotlinDebug\n*F\n+ 1 MetricsEventHandler.kt\ncom/atlassian/jira/migration/eventHandlers/MetricsEventHandler\n*L\n58#1:76,2\n*E\n"})
public final class MetricsEventHandler {
    @NotNull
    public static final Source Source = new Source(null);
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final PublicPlanMappingRepository publicPlanMappingRepository;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    public static final String MIGRATION_API = "mapi";
    @NotNull
    private static final String USER = "user";

    @Inject
    public MetricsEventHandler(@NotNull MetricsEventService metricsEventService, @NotNull MigrationEventBus migrationEventBus, @NotNull PublicPlanMappingRepository publicPlanMappingRepository, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)publicPlanMappingRepository, (String)"publicPlanMappingRepository");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.metricsEventService = metricsEventService;
        this.migrationEventBus = migrationEventBus;
        this.publicPlanMappingRepository = publicPlanMappingRepository;
        this.discoveryService = discoveryService;
    }

    public final void createAndSendPlanCompletionEvents(@NotNull TaskList currentStatus, @NotNull String migrationId, @NotNull String cloudId2) {
        ShadowMigrationProperties shadowMigrationProperties;
        Intrinsics.checkNotNullParameter((Object)currentStatus, (String)"currentStatus");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        TaskListStatus taskListStatus = PlanCompletionEventsUtil.Companion.retrieveTaskListStatus(currentStatus);
        Map<MigrationTaskType, List<GetTaskStatusResponse.TaskProgress>> migrationTaskTypeToProgressMap = PlanCompletionEventsUtil.Companion.createTaskTypeToProgressMap(currentStatus);
        Map<String, List<PlanCompletionEventsUtil.TaskProgressMap>> migrationTaskTypeToErrorMap = PlanCompletionEventsUtil.Companion.createTaskTypeToErrorMap(migrationTaskTypeToProgressMap);
        Map<MigrationTaskType, PlanCompletionEventsUtil.TaskTypeStatus> migrationTaskTypeToStatusMap = PlanCompletionEventsUtil.Companion.createTaskTypeToStatusMap(migrationTaskTypeToProgressMap);
        String migrationCreator = this.migrationCreator(migrationId);
        Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, migrationId, false, 2, null);
        if (plan2 != null) {
            Plan it = plan2;
            boolean bl = false;
            shadowMigrationProperties = this.buildShadowMigrationProperties(it);
        } else {
            shadowMigrationProperties = null;
        }
        ShadowMigrationProperties shadowPropertyMap = shadowMigrationProperties;
        MetricsEventService.sendEventForPlanStatus$default(this.metricsEventService, taskListStatus.toString(), migrationCreator, 0.0, 4, null);
        this.sendTaskStatusEvent(migrationTaskTypeToStatusMap);
        this.migrationEventBus.post(new PlanCompletionEvent(cloudId2, migrationId, migrationTaskTypeToStatusMap, migrationTaskTypeToStatusMap.size(), taskListStatus.toString(), migrationTaskTypeToErrorMap, migrationCreator, shadowPropertyMap));
    }

    private final ShadowMigrationProperties buildShadowMigrationProperties(Plan plan2) {
        Boolean bl = plan2.getCanBeShadowed();
        Boolean bl2 = plan2.isShadowPlan();
        return new ShadowMigrationProperties(bl != null ? bl : false, bl2 != null ? bl2 : false, plan2.getOriginalMigrationId());
    }

    public final void sendTaskStatusEvent(@NotNull Map<MigrationTaskType, ? extends PlanCompletionEventsUtil.TaskTypeStatus> migrationTaskTypeToStatusMap) {
        Intrinsics.checkNotNullParameter(migrationTaskTypeToStatusMap, (String)"migrationTaskTypeToStatusMap");
        Map<MigrationTaskType, ? extends PlanCompletionEventsUtil.TaskTypeStatus> $this$forEach$iv = migrationTaskTypeToStatusMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<MigrationTaskType, ? extends PlanCompletionEventsUtil.TaskTypeStatus>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<MigrationTaskType, ? extends PlanCompletionEventsUtil.TaskTypeStatus> element$iv;
            Map.Entry<MigrationTaskType, ? extends PlanCompletionEventsUtil.TaskTypeStatus> type = element$iv = iterator2.next();
            boolean bl = false;
            MetricsEventService.sendMigrationTaskStatusForPlan$default(this.metricsEventService, type.getKey().toString(), type.getValue().toString(), 0.0, 4, null);
        }
    }

    private final String migrationCreator(String migrationId) {
        return this.publicPlanMappingRepository.isPublicApiMigration(migrationId) ? MIGRATION_API : USER;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/eventHandlers/MetricsEventHandler$Source;", "", "()V", "MIGRATION_API", "", "USER", "jira-migration-plugin"})
    public static final class Source {
        private Source() {
        }

        public /* synthetic */ Source(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

