/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.eventHandlers;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.events.DataFiltersEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PlanSavedEvent;
import com.atlassian.jira.migration.events.PlanStartedEvent;
import com.atlassian.jira.migration.events.PublicPlanEvent;
import com.atlassian.jira.migration.plan.AttachmentFilters;
import com.atlassian.jira.migration.plan.IssueFilters;
import com.atlassian.jira.migration.plan.PbpMigrationMode;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.serverdataextractors.BandwidthCalculator;
import com.atlassian.jira.migration.serverdataextractors.CpuUsageCalculator;
import com.atlassian.jira.migration.serverdataextractors.ServerDataAggregator;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;", "", "serverDataAggregator", "Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "cpuUsageCalculator", "Lcom/atlassian/jira/migration/serverdataextractors/CpuUsageCalculator;", "bandwidthCalculator", "Lcom/atlassian/jira/migration/serverdataextractors/BandwidthCalculator;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/serverdataextractors/CpuUsageCalculator;Lcom/atlassian/jira/migration/serverdataextractors/BandwidthCalculator;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Ljava/util/concurrent/ExecutorService;)V", "sendDataFiltersEvent", "", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "migrationId", "", "sendEventAsync", "command", "Ljava/lang/Runnable;", "sendPlanSavedEvent", "sendPlanStartedEvent", "sendPublicPlanCheckScheduled", "publicPlanEvent", "Lcom/atlassian/jira/migration/events/PublicPlanEvent;", "sendPublicPlanMigrationStarted", "sendPublicPlanSaveEvent", "Companion", "jira-migration-plugin"})
public final class PlanEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerDataAggregator serverDataAggregator;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final CpuUsageCalculator cpuUsageCalculator;
    @NotNull
    private final BandwidthCalculator bandwidthCalculator;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final ExecutorService executor;
    private static final Logger log = LoggerFactory.getLogger(PlanEventHandler.class);
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAX_WORKER_THREADS = 1;
    private static final long KEEP_ALIVE_IN_SEC = 60L;

    @Inject
    public PlanEventHandler(@NotNull ServerDataAggregator serverDataAggregator, @NotNull MigrationEventBus migrationEventBus, @NotNull CpuUsageCalculator cpuUsageCalculator, @NotNull BandwidthCalculator bandwidthCalculator, @NotNull AnalyticsEventService analyticsEventService, @NotNull MetricsEventService metricsEventService, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)serverDataAggregator, (String)"serverDataAggregator");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)cpuUsageCalculator, (String)"cpuUsageCalculator");
        Intrinsics.checkNotNullParameter((Object)bandwidthCalculator, (String)"bandwidthCalculator");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.serverDataAggregator = serverDataAggregator;
        this.migrationEventBus = migrationEventBus;
        this.cpuUsageCalculator = cpuUsageCalculator;
        this.bandwidthCalculator = bandwidthCalculator;
        this.analyticsEventService = analyticsEventService;
        this.metricsEventService = metricsEventService;
        this.executor = executor;
    }

    public /* synthetic */ PlanEventHandler(ServerDataAggregator serverDataAggregator, MigrationEventBus migrationEventBus, CpuUsageCalculator cpuUsageCalculator, BandwidthCalculator bandwidthCalculator, AnalyticsEventService analyticsEventService, MetricsEventService metricsEventService, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            executorService = PlanEventHandler.Companion.getExecutorPool();
        }
        this(serverDataAggregator, migrationEventBus, cpuUsageCalculator, bandwidthCalculator, analyticsEventService, metricsEventService, executorService);
    }

    public final void sendEventAsync(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Object object = this;
        try {
            PlanEventHandler $this$sendEventAsync_u24lambda_u241 = object;
            boolean bl = false;
            $this$sendEventAsync_u24lambda_u241.executor.execute(() -> PlanEventHandler.sendEventAsync$lambda$1$lambda$0(command));
            return;
        }
        catch (Throwable bl) {
            block2: {
                Object object2;
                object = object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) break block2;
                Object exception = object2 = throwable;
                boolean bl2 = false;
                log.error("Failed to send event async, Reason : " + ((Throwable)exception).getMessage() + '.');
            }
            return;
        }
    }

    public final void sendPlanSavedEvent(@NotNull Plan plan2) {
        PbpMigrationMode pbpMigrationMode;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        long estimatedMigrationTime = ServerDataAggregator.getServerStats$default(this.serverDataAggregator, plan2.getProjectKeys(), null, 2, null).getTotalMigrationTimeSeconds();
        String string = plan2.getId();
        String string2 = plan2.getPreflightCheckExecutionId();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        double d = this.cpuUsageCalculator.calculateSystemCpuLoadAverage();
        int n = this.cpuUsageCalculator.calculateAvailableProcessors();
        long l = this.cpuUsageCalculator.calculateFreeHeapMemory();
        Object object = plan2.getMigrationTag();
        if (object == null || (object = object.name()) == null) {
            object = "NOT_SPECIFIED";
        }
        if ((pbpMigrationMode = plan2.getPbpMigrationMode()) == null) {
            pbpMigrationMode = PbpMigrationMode.CHOOSE_WHAT_TO_MIGRATE;
        }
        this.migrationEventBus.post(new PlanSavedEvent(string, string2, instant, estimatedMigrationTime, d, n, l, (String)object, pbpMigrationMode, (Function0<Long>)((Function0)new Function0<Long>(this, plan2){
            final /* synthetic */ PlanEventHandler this$0;
            final /* synthetic */ Plan $plan;
            {
                this.this$0 = $receiver;
                this.$plan = $plan;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return PlanEventHandler.access$getBandwidthCalculator$p(this.this$0).getOrCalculateBandwidth(this.$plan.getCloudId());
            }
        })));
        log.info("Sent Plan Saved Event for migration plan:" + plan2.getId());
    }

    public final void sendPlanStartedEvent(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        String string = plan2.getId();
        String string2 = plan2.getPreflightCheckExecutionId();
        String string3 = plan2.getCloudId();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.migrationEventBus.post(new PlanStartedEvent(string, string2, string3, instant));
        log.info("Sent Plan Started Event for migration plan:" + plan2.getId());
    }

    public final void sendDataFiltersEvent(@NotNull Plan plan2, @NotNull String migrationId) {
        AttachmentFilters attachmentFilters;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String string = plan2.getCloudId();
        IssueFilters issueFilters = plan2.getIssueFilters();
        if (issueFilters == null) {
            issueFilters = new IssueFilters(null, null, 3, null);
        }
        if ((attachmentFilters = plan2.getAttachmentFilters()) == null) {
            attachmentFilters = new AttachmentFilters(null, 1, null);
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        DataFiltersEvent event = new DataFiltersEvent(migrationId, string, issueFilters, attachmentFilters, instant);
        this.migrationEventBus.post(event);
        log.info("Sent Data Filter Event for migration id: " + migrationId);
    }

    public final void sendPublicPlanSaveEvent(@NotNull PublicPlanEvent publicPlanEvent) {
        Intrinsics.checkNotNullParameter((Object)publicPlanEvent, (String)"publicPlanEvent");
        this.sendEventAsync(() -> PlanEventHandler.sendPublicPlanSaveEvent$lambda$3(this, publicPlanEvent));
    }

    public final void sendPublicPlanCheckScheduled(@NotNull PublicPlanEvent publicPlanEvent) {
        Intrinsics.checkNotNullParameter((Object)publicPlanEvent, (String)"publicPlanEvent");
        this.sendEventAsync(() -> PlanEventHandler.sendPublicPlanCheckScheduled$lambda$4(this, publicPlanEvent));
    }

    public final void sendPublicPlanMigrationStarted(@NotNull PublicPlanEvent publicPlanEvent) {
        Intrinsics.checkNotNullParameter((Object)publicPlanEvent, (String)"publicPlanEvent");
        this.sendEventAsync(() -> PlanEventHandler.sendPublicPlanMigrationStarted$lambda$5(this, publicPlanEvent));
    }

    private static final void sendEventAsync$lambda$1$lambda$0(Runnable $command) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        $command.run();
    }

    private static final void sendPublicPlanSaveEvent$lambda$3(PlanEventHandler this$0, PublicPlanEvent $publicPlanEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$publicPlanEvent, (String)"$publicPlanEvent");
        AnalyticsEventService.saveAnalyticsEvent$default(this$0.analyticsEventService, (EventDto)$publicPlanEvent.asOperationalEvent(), null, 2, null);
        MetricsEventService metricsEventService = this$0.metricsEventService;
        MetricsEventService.OperationType operationType = MetricsEventService.OperationType.PUBLIC_PLAN_SAVE_STATUS_METRIC;
        int n = $publicPlanEvent.getStatusCode();
        long l = $publicPlanEvent.getExecutionTime();
        metricsEventService.sendEventForPublicPlan(operationType, l, n);
        log.info("Sent Public Plan Save Event for job: " + $publicPlanEvent.getJobId());
    }

    private static final void sendPublicPlanCheckScheduled$lambda$4(PlanEventHandler this$0, PublicPlanEvent $publicPlanEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$publicPlanEvent, (String)"$publicPlanEvent");
        AnalyticsEventService.saveAnalyticsEvent$default(this$0.analyticsEventService, (EventDto)$publicPlanEvent.asOperationalEvent(), null, 2, null);
        MetricsEventService metricsEventService = this$0.metricsEventService;
        MetricsEventService.OperationType operationType = MetricsEventService.OperationType.PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC;
        int n = $publicPlanEvent.getStatusCode();
        long l = $publicPlanEvent.getExecutionTime();
        metricsEventService.sendEventForPublicPlan(operationType, l, n);
        log.info("Sent Public Preflight Scheduled Event for job: " + $publicPlanEvent.getJobId());
    }

    private static final void sendPublicPlanMigrationStarted$lambda$5(PlanEventHandler this$0, PublicPlanEvent $publicPlanEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$publicPlanEvent, (String)"$publicPlanEvent");
        AnalyticsEventService.saveAnalyticsEvent$default(this$0.analyticsEventService, (EventDto)$publicPlanEvent.asOperationalEvent(), null, 2, null);
        MetricsEventService metricsEventService = this$0.metricsEventService;
        MetricsEventService.OperationType operationType = MetricsEventService.OperationType.PUBLIC_PLAN_MIGRATION_STARTED_METRIC;
        int n = $publicPlanEvent.getStatusCode();
        long l = $publicPlanEvent.getExecutionTime();
        metricsEventService.sendEventForPublicPlan(operationType, l, n);
        log.info("Sent Public Plan Migration Started Event for job: " + $publicPlanEvent.getJobId());
    }

    public static final /* synthetic */ BandwidthCalculator access$getBandwidthCalculator$p(PlanEventHandler $this) {
        return $this.bandwidthCalculator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler$Companion;", "", "()V", "CORE_POOL_SIZE", "", "KEEP_ALIVE_IN_SEC", "", "MAX_WORKER_THREADS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getExecutorPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nPlanEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanEventHandler.kt\ncom/atlassian/jira/migration/eventHandlers/PlanEventHandler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ThreadPoolExecutor getExecutorPool() {
            ThreadPoolExecutor threadPoolExecutor;
            ThreadPoolExecutor it = threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new GroupedThreadFactory("PlanEventHandler"));
            boolean bl = false;
            it.allowCoreThreadTimeOut(true);
            return threadPoolExecutor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

