/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserEmailChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u0013J\b\u0010\u001e\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/events/CrowdEventDetectionService;", "", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "pluginSettings", "Lcom/atlassian/sal/api/pluginsettings/PluginSettings;", "ticker", "Lkotlin/Function0;", "", "reportingPeriod", "Ljava/time/Duration;", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/sal/api/pluginsettings/PluginSettings;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lkotlin/jvm/functions/Function0;Ljava/time/Duration;)V", "lastReportedAt", "destroy", "", "getLastUserCreatedOrUpdatedTime", "init", "onUserCreatedEvent", "userCreatedEvent", "Lcom/atlassian/crowd/event/user/UserCreatedEvent;", "onUserEmailChangedEvent", "userEmailChangedEvent", "Lcom/atlassian/crowd/event/user/UserEmailChangedEvent;", "saveLastUserEventTimeWithDebounce", "stop", "unregisterListener", "Companion", "jira-migration-plugin"})
public final class CrowdEventDetectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final PluginSettings pluginSettings;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Function0<Long> ticker;
    @NotNull
    private final Duration reportingPeriod;
    private long lastReportedAt;
    private static final Logger log = LoggerFactory.getLogger(CrowdEventDetectionService.class);
    @NotNull
    public static final String LAST_USER_CREATED_OR_UPDATED_TIME = "lastUserCreatedOrUpdatedTime";

    public CrowdEventDetectionService(@NotNull EventPublisher eventPublisher, @NotNull PluginSettings pluginSettings, @NotNull MigrationFeatures migrationFeatures, @NotNull Function0<Long> ticker, @NotNull Duration reportingPeriod) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)pluginSettings, (String)"pluginSettings");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter(ticker, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)reportingPeriod, (String)"reportingPeriod");
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettings;
        this.migrationFeatures = migrationFeatures;
        this.ticker = ticker;
        this.reportingPeriod = reportingPeriod;
    }

    public /* synthetic */ CrowdEventDetectionService(EventPublisher eventPublisher, PluginSettings pluginSettings, MigrationFeatures migrationFeatures, Function0 function0, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        this(eventPublisher, pluginSettings, migrationFeatures, (Function0<Long>)function0, duration);
    }

    @Inject
    public CrowdEventDetectionService(@NotNull EventPublisher eventPublisher, @NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pluginSettings, (String)"createGlobalSettings(...)");
        this(eventPublisher, pluginSettings, migrationFeatures, null, null, 24, null);
    }

    public final void init() {
        block2: {
            Object object;
            log.info("Jira Migration Plugin CrowdEventDetection Listener started");
            Object object2 = this;
            try {
                CrowdEventDetectionService $this$init_u24lambda_u240 = object2;
                boolean bl = false;
                $this$init_u24lambda_u240.eventPublisher.register((Object)$this$init_u24lambda_u240);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            log.error("Failed to register CrowdEventDetectionService", (Throwable)it);
        }
    }

    public final void stop() {
        log.info("Jira Migration Plugin CrowdEventDetection Listener stopped");
        this.unregisterListener();
    }

    public final void destroy() throws Exception {
        this.unregisterListener();
    }

    private final void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public final void onUserCreatedEvent(@NotNull UserCreatedEvent userCreatedEvent) {
        Intrinsics.checkNotNullParameter((Object)userCreatedEvent, (String)"userCreatedEvent");
        this.saveLastUserEventTimeWithDebounce();
    }

    @EventListener
    public final void onUserEmailChangedEvent(@NotNull UserEmailChangedEvent userEmailChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)userEmailChangedEvent, (String)"userEmailChangedEvent");
        this.saveLastUserEventTimeWithDebounce();
    }

    public final void saveLastUserEventTimeWithDebounce() {
        if (!this.migrationFeatures.getEnableCrowdEventsPreflightCacheOptimization()) {
            return;
        }
        long now = ((Number)this.ticker.invoke()).longValue();
        Duration elapsed = Duration.ofNanos(now - this.lastReportedAt);
        if (elapsed.compareTo(this.reportingPeriod) >= 0) {
            this.pluginSettings.put(LAST_USER_CREATED_OR_UPDATED_TIME, (Object)String.valueOf(System.currentTimeMillis()));
            this.lastReportedAt = now;
        }
    }

    public final long getLastUserCreatedOrUpdatedTime() {
        String string = (String)this.pluginSettings.get(LAST_USER_CREATED_OR_UPDATED_TIME);
        return string != null ? Long.parseLong(string) : 0L;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/events/CrowdEventDetectionService$Companion;", "", "()V", "LAST_USER_CREATED_OR_UPDATED_TIME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

