/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.cmpt.analytics.events.ActionDrivenEventDto;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.jira.migration.events.EmailCorrectionEventKt;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/events/EmailCorrectionEvent;", "", "executionId", "", "numberOfEmailsUploaded", "", "(Ljava/lang/String;I)V", "getExecutionId", "()Ljava/lang/String;", "getNumberOfEmailsUploaded", "()I", "asTrackEvent", "Lcom/atlassian/cmpt/analytics/events/GenericTrackEvent;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "jira-migration-plugin"})
public final class EmailCorrectionEvent {
    @NotNull
    private final String executionId;
    private final int numberOfEmailsUploaded;

    public EmailCorrectionEvent(@NotNull String executionId, int numberOfEmailsUploaded) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.executionId = executionId;
        this.numberOfEmailsUploaded = numberOfEmailsUploaded;
    }

    @NotNull
    public final String getExecutionId() {
        return this.executionId;
    }

    public final int getNumberOfEmailsUploaded() {
        return this.numberOfEmailsUploaded;
    }

    @NotNull
    public final GenericTrackEvent asTrackEvent() {
        ActionDrivenEventDto.Builder builder = ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(Instant.now().toEpochMilli()).action("uploaded")).actionSubject("emailsCheckCsv", UUID.randomUUID().toString())).source("checkScreen")).contextContainer("preflightCheckExecutionId", this.executionId);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"contextContainer(...)");
        GenericTrackEvent genericTrackEvent = EmailCorrectionEventKt.access$setNumberOfEmailsUploaded((GenericTrackEvent.Builder)builder, this.numberOfEmailsUploaded).build();
        Intrinsics.checkNotNullExpressionValue((Object)genericTrackEvent, (String)"build(...)");
        return genericTrackEvent;
    }

    @NotNull
    public final String component1() {
        return this.executionId;
    }

    public final int component2() {
        return this.numberOfEmailsUploaded;
    }

    @NotNull
    public final EmailCorrectionEvent copy(@NotNull String executionId, int numberOfEmailsUploaded) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return new EmailCorrectionEvent(executionId, numberOfEmailsUploaded);
    }

    public static /* synthetic */ EmailCorrectionEvent copy$default(EmailCorrectionEvent emailCorrectionEvent, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = emailCorrectionEvent.executionId;
        }
        if ((n2 & 2) != 0) {
            n = emailCorrectionEvent.numberOfEmailsUploaded;
        }
        return emailCorrectionEvent.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "EmailCorrectionEvent(executionId=" + this.executionId + ", numberOfEmailsUploaded=" + this.numberOfEmailsUploaded + ')';
    }

    public int hashCode() {
        int result2 = this.executionId.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.numberOfEmailsUploaded);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EmailCorrectionEvent)) {
            return false;
        }
        EmailCorrectionEvent emailCorrectionEvent = (EmailCorrectionEvent)other;
        if (!Intrinsics.areEqual((Object)this.executionId, (Object)emailCorrectionEvent.executionId)) {
            return false;
        }
        return this.numberOfEmailsUploaded == emailCorrectionEvent.numberOfEmailsUploaded;
    }
}

