/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.cmpt.analytics.events.ActionDrivenEventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.events.ArchivedIssueExportEventKt;
import com.atlassian.jira.migration.events.IssueExportLatencyEventKt;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001dJ\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001dR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/events/IssueExportLatencyEvent;", "", "migrationId", "", "avgLatency", "", "actualLatency", "issueCount", "archivedIssueCount", "threads", "projectType", "p90Latency", "", "customFieldsCount", "version", "(Ljava/lang/String;IIIIILjava/lang/String;SILjava/lang/String;)V", "customFieldBucketed", "customFields", "getActualLatency", "", "getAvgLatency", "issueCountBucketed", "p90Bucketed", "p90Value", "threadBucket", "thread", "toOperationalEvent", "Lcom/atlassian/cmpt/analytics/events/GenericOperationalEvent;", "toTimerEventTags", "", "toTimerEventTagsForActualLatency", "Companion", "jira-migration-plugin"})
public final class IssueExportLatencyEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String migrationId;
    private final int avgLatency;
    private final int actualLatency;
    private final int issueCount;
    private final int archivedIssueCount;
    private final int threads;
    @NotNull
    private final String projectType;
    private final short p90Latency;
    private final int customFieldsCount;
    @NotNull
    private final String version;
    @NotNull
    private static final String issueCountDimension = "issue_count";
    @NotNull
    private static final String customFieldsDimension = "custom_fields";
    @NotNull
    private static final String p90ValueDimension = "p90_value";
    @NotNull
    private static final String versionDimension = "version";
    @NotNull
    private static final String projectTypeDimension = "project_type";
    @NotNull
    private static final String threadCount = "thread_count";
    @NotNull
    private static final String ACTION_PROJECT_STATS = "projectStats";
    @NotNull
    private static final String ISSUE_LATENCY = "issueLatency";

    public IssueExportLatencyEvent(@NotNull String migrationId, int avgLatency, int actualLatency, int issueCount, int archivedIssueCount, int threads, @NotNull String projectType, short p90Latency, int customFieldsCount, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)projectType, (String)"projectType");
        Intrinsics.checkNotNullParameter((Object)version, (String)versionDimension);
        this.migrationId = migrationId;
        this.avgLatency = avgLatency;
        this.actualLatency = actualLatency;
        this.issueCount = issueCount;
        this.archivedIssueCount = archivedIssueCount;
        this.threads = threads;
        this.projectType = projectType;
        this.p90Latency = p90Latency;
        this.customFieldsCount = customFieldsCount;
        this.version = version;
    }

    @NotNull
    public final GenericOperationalEvent toOperationalEvent() {
        ActionDrivenEventDto.Builder builder = ((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).action(ACTION_PROJECT_STATS)).actionSubject(ISSUE_LATENCY);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"actionSubject(...)");
        GenericOperationalEvent.Builder builder2 = ArchivedIssueExportEventKt.migrationId((GenericOperationalEvent.Builder)builder, this.migrationId);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"migrationId(...)");
        GenericOperationalEvent.Builder builder3 = IssueExportLatencyEventKt.access$averageIssueLatency(builder2, this.avgLatency);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"access$averageIssueLatency(...)");
        GenericOperationalEvent.Builder builder4 = IssueExportLatencyEventKt.access$actualIssueLatency(builder3, this.actualLatency);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"access$actualIssueLatency(...)");
        GenericOperationalEvent.Builder builder5 = IssueExportLatencyEventKt.access$issueCount(builder4, this.issueCount);
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"access$issueCount(...)");
        GenericOperationalEvent.Builder builder6 = IssueExportLatencyEventKt.access$archivedIssueCount(builder5, this.archivedIssueCount);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"access$archivedIssueCount(...)");
        GenericOperationalEvent.Builder builder7 = IssueExportLatencyEventKt.access$threadCount(builder6, this.threads);
        Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"access$threadCount(...)");
        GenericOperationalEvent.Builder builder8 = IssueExportLatencyEventKt.access$availableThreadCount(builder7, Runtime.getRuntime().availableProcessors());
        Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"access$availableThreadCount(...)");
        GenericOperationalEvent.Builder builder9 = IssueExportLatencyEventKt.access$projectType(builder8, this.projectType);
        Intrinsics.checkNotNullExpressionValue((Object)builder9, (String)"access$projectType(...)");
        GenericOperationalEvent genericOperationalEvent = IssueExportLatencyEventKt.access$customFieldCount(builder9, this.customFieldsCount).build();
        Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
        return genericOperationalEvent;
    }

    @NotNull
    public final Map<String, String> toTimerEventTags() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)issueCountDimension, (Object)this.issueCountBucketed(this.issueCount)), TuplesKt.to((Object)customFieldsDimension, (Object)this.customFieldBucketed(this.customFieldsCount)), TuplesKt.to((Object)p90ValueDimension, (Object)this.p90Bucketed(this.p90Latency)), TuplesKt.to((Object)versionDimension, (Object)this.version), TuplesKt.to((Object)projectTypeDimension, (Object)this.projectType)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Map<String, String> toTimerEventTagsForActualLatency() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)issueCountDimension, (Object)this.issueCountBucketed(this.issueCount)), TuplesKt.to((Object)threadCount, (Object)this.threadBucket(this.threads)), TuplesKt.to((Object)p90ValueDimension, (Object)this.p90Bucketed(this.p90Latency)), TuplesKt.to((Object)versionDimension, (Object)this.version), TuplesKt.to((Object)projectTypeDimension, (Object)this.projectType)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public final long getAvgLatency() {
        return this.avgLatency;
    }

    public final long getActualLatency() {
        return this.actualLatency;
    }

    private final String customFieldBucketed(int customFields) {
        return customFields >= 300 ? "300_PLUS" : (customFields >= 100 ? "100_300" : "0_100");
    }

    private final String issueCountBucketed(int issueCount) {
        return issueCount >= 50000 ? "50k_PLUS" : (issueCount >= 25000 ? "25k_50k" : (issueCount >= 5000 ? "5k_25k" : (issueCount >= 1000 ? "1k_5k" : "0_1k")));
    }

    private final String p90Bucketed(short p90Value) {
        return p90Value >= 1000 ? "1k_PLUS" : (p90Value >= 500 ? "500_1k" : (p90Value >= 250 ? "250_500" : (p90Value >= 100 ? "100_250" : (p90Value >= 40 ? "40_100" : (p90Value >= 20 ? "20_40" : "0_20")))));
    }

    private final String threadBucket(int thread) {
        String string;
        switch (thread) {
            case 1: {
                string = "1";
                break;
            }
            case 2: {
                string = "2";
                break;
            }
            case 3: {
                string = "3";
                break;
            }
            default: {
                string = "4_PLUS";
            }
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/events/IssueExportLatencyEvent$Companion;", "", "()V", "ACTION_PROJECT_STATS", "", "ISSUE_LATENCY", "customFieldsDimension", "issueCountDimension", "p90ValueDimension", "projectTypeDimension", "threadCount", "versionDimension", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

