/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.jira.migration.events.IssueExportLatencyEvent;
import com.atlassian.jira.migration.events.IssueExportStatistics;
import com.atlassian.migration.jira.classic.ProjectStatus;
import com.atlassian.migration.jira.classic.ProjectTypeKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u000223B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tH\u0016J\b\u0010%\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\u0004H\u0016J\b\u0010'\u001a\u00020\u0014H\u0002J\u0012\u0010(\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u000eH\u0016J\u0010\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/events/IssueExportStatisticsImpl;", "Lcom/atlassian/jira/migration/events/IssueExportStatistics;", "()V", "archivedIssueCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "customFields", "Lcom/atlassian/jira/migration/events/IssueExportStatisticsImpl$ValueWithCount;", "issueCount", "projectStatus", "", "projectType", "thread", "", "totalExportTime", "", "totalIssueChildrenLatency", "totalIssueLatency", "Ljava/util/concurrent/atomic/AtomicLong;", "valueForP90Latency", "", "", "addToArchivedIssueCount", "", "count", "addToCustomFieldsStats", "customFieldsCount", "addToIssueChildrenLatencyStats", "timeTakenMillis", "addToIssueCountStats", "addToIssueLatencyStats", "getActualIssueLatency", "getArchivedIssueCount", "getAvgIssueChildrenLatency", "getAvgIssueLatency", "getIssueLatencyEvent", "Lcom/atlassian/jira/migration/events/IssueExportLatencyEvent;", "migrationId", "getProjectStatus", "getTotalIssueCount", "p90Latency", "setProjectStatus", "projectStatusKey", "Lcom/atlassian/migration/jira/classic/ProjectStatus;", "setProjectTypeInStats", "projectTypeKey", "Lcom/atlassian/migration/jira/classic/ProjectTypeKey;", "setTotalExportTime", "exportTime", "updateMetricThreadCount", "threadCount", "Companion", "ValueWithCount", "jira-migration-plugin"})
public final class IssueExportStatisticsImpl
implements IssueExportStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long totalExportTime;
    @NotNull
    private String projectType = "";
    @NotNull
    private String projectStatus = "";
    @NotNull
    private AtomicLong totalIssueLatency = new AtomicLong(0L);
    private long totalIssueChildrenLatency;
    @NotNull
    private AtomicInteger issueCount = new AtomicInteger(0);
    @NotNull
    private AtomicInteger archivedIssueCount = new AtomicInteger(0);
    @NotNull
    private final ValueWithCount customFields = new ValueWithCount();
    private int thread = 1;
    @NotNull
    private Map<Short, Integer> valueForP90Latency = new ConcurrentHashMap();
    private static final double p90Ratio = 0.9;
    @NotNull
    private static final String currentVersion = "v3";
    private static final short maxP90Value = 10000;

    @Override
    public void addToIssueLatencyStats(long timeTakenMillis) {
        this.totalIssueLatency.addAndGet(timeTakenMillis);
        short latency = timeTakenMillis > 10000L ? (short)10000 : (short)timeTakenMillis;
        Short s = latency;
        this.valueForP90Latency.put(s, ((Number)this.valueForP90Latency.getOrDefault(latency, 0)).intValue() + 1);
    }

    @Override
    public void addToIssueChildrenLatencyStats(long timeTakenMillis) {
        this.totalIssueChildrenLatency += timeTakenMillis;
    }

    @Override
    public void addToIssueCountStats(int count2) {
        this.issueCount.addAndGet(count2);
    }

    @Override
    public void addToArchivedIssueCount(int count2) {
        this.archivedIssueCount.addAndGet(count2);
    }

    @Override
    public void updateMetricThreadCount(int threadCount) {
        this.thread = threadCount;
    }

    @Override
    public void addToCustomFieldsStats(int customFieldsCount) {
        this.customFields.plus(customFieldsCount);
    }

    @Override
    public void setProjectTypeInStats(@NotNull ProjectTypeKey projectTypeKey) {
        Intrinsics.checkNotNullParameter((Object)projectTypeKey, (String)"projectTypeKey");
        this.projectType = projectTypeKey.toString();
    }

    @Override
    public void setProjectStatus(@Nullable ProjectStatus projectStatusKey) {
        this.projectStatus = String.valueOf(projectStatusKey);
    }

    @Override
    public void setTotalExportTime(long exportTime) {
        this.totalExportTime = exportTime;
    }

    private final int getAvgIssueChildrenLatency() {
        return this.issueCount.get() == 0 ? 0 : MathKt.roundToInt((double)((double)this.totalIssueChildrenLatency / (double)this.issueCount.get()));
    }

    private final int getActualIssueLatency() {
        return this.issueCount.get() == 0 ? 0 : MathKt.roundToInt((double)((double)(this.totalExportTime + this.totalIssueChildrenLatency) / (double)this.issueCount.get()));
    }

    private final int getAvgIssueLatency() {
        return this.issueCount.get() == 0 ? 0 : MathKt.roundToInt((double)((double)(this.totalIssueLatency.get() + this.totalIssueChildrenLatency) / (double)this.issueCount.get()));
    }

    @Override
    @NotNull
    public IssueExportLatencyEvent getIssueLatencyEvent(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        int n = this.getAvgIssueLatency();
        int n2 = this.getActualIssueLatency();
        int n3 = this.issueCount.get();
        int n4 = this.archivedIssueCount.get();
        int n5 = this.thread;
        String string = this.projectType;
        int n6 = this.customFields.average();
        short s = this.p90Latency();
        return new IssueExportLatencyEvent(migrationId, n, n2, n3, n4, n5, string, s, n6, currentVersion);
    }

    @Override
    @NotNull
    public AtomicInteger getArchivedIssueCount() {
        return this.archivedIssueCount;
    }

    @Override
    @NotNull
    public AtomicInteger getTotalIssueCount() {
        return this.issueCount;
    }

    @Override
    @NotNull
    public String getProjectStatus() {
        return this.projectStatus;
    }

    private final short p90Latency() {
        int indexForValue = (int)Math.ceil(0.9 * (double)this.issueCount.get());
        int currIndex = 0;
        for (Map.Entry latency : ((Map)MapsKt.toSortedMap(this.valueForP90Latency)).entrySet()) {
            Object v = latency.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            if ((currIndex += ((Number)v).intValue()) < indexForValue) continue;
            return (short)(((Number)latency.getKey()).intValue() + this.getAvgIssueChildrenLatency());
        }
        return 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/events/IssueExportStatisticsImpl$Companion;", "", "()V", "currentVersion", "", "maxP90Value", "", "p90Ratio", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/events/IssueExportStatisticsImpl$ValueWithCount;", "", "(Lcom/atlassian/jira/migration/events/IssueExportStatisticsImpl;)V", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "value", "Ljava/util/concurrent/atomic/AtomicLong;", "average", "", "plus", "", "valueToAdd", "", "jira-migration-plugin"})
    private final class ValueWithCount {
        @NotNull
        private AtomicInteger count = new AtomicInteger(0);
        @NotNull
        private AtomicLong value = new AtomicLong(0L);

        public final int average() {
            return this.count.get() == 0 ? 0 : MathKt.roundToInt((double)((double)this.value.get() / (double)this.count.get()));
        }

        public final void plus(long valueToAdd) {
            this.count.incrementAndGet();
            this.value.addAndGet(valueToAdd);
        }
    }
}

