/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.ExportStartedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.index.ReindexIssuesStartedEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002&'B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002J\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J'\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010\u0010\u001a\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u000bJ\b\u0010%\u001a\u00020\u000bH\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/event/api/EventPublisher;)V", "eventMap", "", "", "", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService$EventType;", "destroy", "", "doProcessEvent", "eventType", "getEventMapForOperation", "", "operationKey", "getEventsForOperation", "", "init", "isRegistered", "", "onExportStartedEvent", "exportStartedEvent", "Lcom/atlassian/jira/bc/dataimport/ExportStartedEvent;", "onReIndexAllStartedEvent", "reindexAllStartedEvent", "Lcom/atlassian/jira/issue/index/ReindexAllStartedEvent;", "onReIndexIssuesStartedEvent", "reindexIssuesStartedEvent", "Lcom/atlassian/jira/issue/index/ReindexIssuesStartedEvent;", "runAndDetect", "T", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "stop", "unregisterListener", "Companion", "EventType", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraEventDetectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraEventDetectionService.kt\ncom/atlassian/jira/migration/events/JiraEventDetectionService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n8406#2,2:130\n9088#2,4:132\n1179#3,2:136\n1253#3,4:138\n1855#3,2:142\n*S KotlinDebug\n*F\n+ 1 JiraEventDetectionService.kt\ncom/atlassian/jira/migration/events/JiraEventDetectionService\n*L\n95#1:130,2\n95#1:132,4\n95#1:136,2\n95#1:138,4\n120#1:142,2\n*E\n"})
public final class JiraEventDetectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final Map<String, Set<EventType>> eventMap;
    private static final Logger log = LoggerFactory.getLogger(JiraEventDetectionService.class);

    @Inject
    public JiraEventDetectionService(@NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.eventPublisher = eventPublisher;
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.eventMap = map;
    }

    public final void init() {
        log.info("Jira Migration Plugin JiraEventDetection Listener started");
        this.eventPublisher.register((Object)this);
    }

    public final void stop() {
        log.info("Jira Migration Plugin JiraEventDetection Listener stopped");
        this.unregisterListener();
    }

    public final void destroy() throws Exception {
        this.unregisterListener();
        this.eventMap.clear();
    }

    private final void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T runAndDetect(@NotNull String operationKey, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Object object = this.eventMap;
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        Set set2 = set;
        object.put((String)operationKey, set2);
        try {
            object = block.invoke();
            return (T)object;
        }
        finally {
            this.eventMap.remove(operationKey);
        }
    }

    public final boolean isRegistered(@NotNull String operationKey) {
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        return this.eventMap.containsKey(operationKey);
    }

    @NotNull
    public final Set<EventType> getEventsForOperation(@NotNull String operationKey) {
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        Set set = this.eventMap.get(operationKey);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Map<String, String> getEventMapForOperation(@NotNull String operationKey) {
        Map map;
        Object $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        Object $this$associate$iv = EventType.values();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((EventType[])$this$associate$iv).length), (int)16);
        EventType[] eventTypeArray = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            Pair it = element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.name(), (Object)"false");
            map.put(it.getFirst(), it.getSecond());
        }
        $this$associate$iv = this.getEventsForOperation(operationKey);
        Map map2 = destination$iv$iv;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        Iterator iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Map map3 = destination$iv$iv;
            EventType it = (EventType)((Object)element$iv$iv);
            boolean bl = false;
            map = TuplesKt.to((Object)it.name(), (Object)"true");
            map3.put(map.getFirst(), map.getSecond());
        }
        return MapsKt.plus((Map)map2, (Map)destination$iv$iv);
    }

    @EventListener
    public final void onReIndexAllStartedEvent(@NotNull ReindexAllStartedEvent reindexAllStartedEvent) {
        Intrinsics.checkNotNullParameter((Object)reindexAllStartedEvent, (String)"reindexAllStartedEvent");
        this.doProcessEvent(EventType.REINDEX_ALL);
    }

    @EventListener
    public final void onReIndexIssuesStartedEvent(@NotNull ReindexIssuesStartedEvent reindexIssuesStartedEvent) {
        Intrinsics.checkNotNullParameter((Object)reindexIssuesStartedEvent, (String)"reindexIssuesStartedEvent");
        this.doProcessEvent(EventType.REINDEX_ISSUES);
    }

    @EventListener
    public final void onExportStartedEvent(@NotNull ExportStartedEvent exportStartedEvent) {
        Intrinsics.checkNotNullParameter((Object)exportStartedEvent, (String)"exportStartedEvent");
        this.doProcessEvent(EventType.EXPORT);
    }

    private final void doProcessEvent(EventType eventType) {
        Iterable $this$forEach$iv = this.eventMap.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((Set)it.getValue()).add(eventType);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/events/JiraEventDetectionService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/events/JiraEventDetectionService$EventType;", "", "(Ljava/lang/String;I)V", "REINDEX_ALL", "REINDEX_ISSUES", "EXPORT", "jira-migration-plugin"})
    public static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType REINDEX_ALL = new EventType();
        public static final /* enum */ EventType REINDEX_ISSUES = new EventType();
        public static final /* enum */ EventType EXPORT = new EventType();
        private static final /* synthetic */ EventType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String value) {
            return Enum.valueOf(EventType.class, value);
        }

        @NotNull
        public static EnumEntries<EventType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = eventTypeArray = new EventType[]{EventType.REINDEX_ALL, EventType.REINDEX_ISSUES, EventType.EXPORT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

