/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.jira.migration.common.CompanyUserRecognitionAlgorithm;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.UserClassificationResultEvent;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J.\u0010\u0012\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "createCounterMap", "Ljava/util/EnumMap;", "Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics$UserClassificationCounter;", "", "postEvent", "", "totalUsersCount", "numberOfUsersClassifiedAsCompanyUsers", "numberOfUsersClassifiedAsCustomers", "companyUserRecognitionAlgorithm", "Lcom/atlassian/jira/migration/common/CompanyUserRecognitionAlgorithm;", "sendClassificationAnalyticsEvents", "totalClassificationResults", "updateCountsByAlgorithm", "userClassificationResults", "", "", "Companion", "UserClassificationCounter", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraUserFilterAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraUserFilterAnalytics.kt\ncom/atlassian/jira/migration/events/JiraUserFilterAnalytics\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,117:1\n215#2,2:118\n13309#3,2:120\n9226#3,2:122\n9376#3,4:124\n*S KotlinDebug\n*F\n+ 1 JiraUserFilterAnalytics.kt\ncom/atlassian/jira/migration/events/JiraUserFilterAnalytics\n*L\n25#1:118,2\n56#1:120,2\n104#1:122,2\n104#1:124,4\n*E\n"})
public final class JiraUserFilterAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(JiraUserFilterAnalytics.class);

    @Inject
    public JiraUserFilterAnalytics(@NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.migrationEventBus = migrationEventBus;
    }

    public final void updateCountsByAlgorithm(@NotNull Map<CompanyUserRecognitionAlgorithm, Boolean> userClassificationResults, @NotNull EnumMap<UserClassificationCounter, Integer> totalClassificationResults) {
        Intrinsics.checkNotNullParameter(userClassificationResults, (String)"userClassificationResults");
        Intrinsics.checkNotNullParameter(totalClassificationResults, (String)"totalClassificationResults");
        Map<CompanyUserRecognitionAlgorithm, Boolean> $this$forEach$iv = userClassificationResults;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CompanyUserRecognitionAlgorithm, Boolean>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<CompanyUserRecognitionAlgorithm, Boolean> element$iv;
            Map.Entry<CompanyUserRecognitionAlgorithm, Boolean> entry = element$iv = iterator2.next();
            boolean bl = false;
            CompanyUserRecognitionAlgorithm algorithm = entry.getKey();
            boolean isCompanyUser = entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[algorithm.ordinal()]) {
                case 1: {
                    if (isCompanyUser) {
                        Map map = totalClassificationResults;
                        Integer n = totalClassificationResults.get((Object)UserClassificationCounter.COMPANY_USERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH);
                        Intrinsics.checkNotNull((Object)n);
                        map.put(UserClassificationCounter.COMPANY_USERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH, ((Number)n).intValue() + 1);
                        break;
                    }
                    Map map = totalClassificationResults;
                    Integer n = totalClassificationResults.get((Object)UserClassificationCounter.CUSTOMERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH);
                    Intrinsics.checkNotNull((Object)n);
                    map.put(UserClassificationCounter.CUSTOMERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH, ((Number)n).intValue() + 1);
                    break;
                }
                case 2: {
                    if (isCompanyUser) {
                        Map map = totalClassificationResults;
                        Integer n = totalClassificationResults.get((Object)UserClassificationCounter.COMPANY_USERS_DOMAIN_AND_SUBDOMAINS_MATCH);
                        Intrinsics.checkNotNull((Object)n);
                        map.put(UserClassificationCounter.COMPANY_USERS_DOMAIN_AND_SUBDOMAINS_MATCH, ((Number)n).intValue() + 1);
                        break;
                    }
                    Map map = totalClassificationResults;
                    Integer n = totalClassificationResults.get((Object)UserClassificationCounter.CUSTOMERS_DOMAIN_AND_SUBDOMAINS_MATCH);
                    Intrinsics.checkNotNull((Object)n);
                    map.put(UserClassificationCounter.CUSTOMERS_DOMAIN_AND_SUBDOMAINS_MATCH, ((Number)n).intValue() + 1);
                }
            }
        }
    }

    public final void sendClassificationAnalyticsEvents(int totalUsersCount, @NotNull EnumMap<UserClassificationCounter, Integer> totalClassificationResults) {
        Intrinsics.checkNotNullParameter(totalClassificationResults, (String)"totalClassificationResults");
        CompanyUserRecognitionAlgorithm[] $this$forEach$iv = CompanyUserRecognitionAlgorithm.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            CompanyUserRecognitionAlgorithm element$iv;
            CompanyUserRecognitionAlgorithm it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    Integer n2 = totalClassificationResults.get((Object)UserClassificationCounter.COMPANY_USERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH);
                    Intrinsics.checkNotNull((Object)n2);
                    int n3 = ((Number)n2).intValue();
                    Integer n4 = totalClassificationResults.get((Object)UserClassificationCounter.CUSTOMERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH);
                    Intrinsics.checkNotNull((Object)n4);
                    this.postEvent(totalUsersCount, n3, ((Number)n4).intValue(), it);
                    break;
                }
                case 2: {
                    Integer n5 = totalClassificationResults.get((Object)UserClassificationCounter.COMPANY_USERS_DOMAIN_AND_SUBDOMAINS_MATCH);
                    Intrinsics.checkNotNull((Object)n5);
                    int n6 = ((Number)n5).intValue();
                    Integer n7 = totalClassificationResults.get((Object)UserClassificationCounter.CUSTOMERS_DOMAIN_AND_SUBDOMAINS_MATCH);
                    Intrinsics.checkNotNull((Object)n7);
                    this.postEvent(totalUsersCount, n6, ((Number)n7).intValue(), it);
                }
            }
        }
    }

    private final void postEvent(int totalUsersCount, int numberOfUsersClassifiedAsCompanyUsers, int numberOfUsersClassifiedAsCustomers, CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm) {
        log.debug("Sending UserClassificationResultEvent for new implementation. Classified " + numberOfUsersClassifiedAsCompanyUsers + " users as company users and " + numberOfUsersClassifiedAsCustomers + " users as customers");
        this.migrationEventBus.post(new UserClassificationResultEvent(totalUsersCount, numberOfUsersClassifiedAsCompanyUsers, numberOfUsersClassifiedAsCustomers, companyUserRecognitionAlgorithm));
    }

    @NotNull
    public final EnumMap<UserClassificationCounter, Integer> createCounterMap() {
        UserClassificationCounter[] $this$associateWith$iv = UserClassificationCounter.values();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        UserClassificationCounter[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = $this$associateWithTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            UserClassificationCounter element$iv$iv;
            UserClassificationCounter userClassificationCounter = element$iv$iv = $this$associateWithTo$iv$iv[i];
            UserClassificationCounter userClassificationCounter2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n2 = 0;
            map.put(userClassificationCounter2, n2);
        }
        Map map = result$iv;
        return new EnumMap<UserClassificationCounter, Integer>(map);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics$UserClassificationCounter;", "", "(Ljava/lang/String;I)V", "COMPANY_USERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH", "COMPANY_USERS_DOMAIN_AND_SUBDOMAINS_MATCH", "CUSTOMERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH", "CUSTOMERS_DOMAIN_AND_SUBDOMAINS_MATCH", "jira-migration-plugin"})
    public static final class UserClassificationCounter
    extends Enum<UserClassificationCounter> {
        public static final /* enum */ UserClassificationCounter COMPANY_USERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH = new UserClassificationCounter();
        public static final /* enum */ UserClassificationCounter COMPANY_USERS_DOMAIN_AND_SUBDOMAINS_MATCH = new UserClassificationCounter();
        public static final /* enum */ UserClassificationCounter CUSTOMERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH = new UserClassificationCounter();
        public static final /* enum */ UserClassificationCounter CUSTOMERS_DOMAIN_AND_SUBDOMAINS_MATCH = new UserClassificationCounter();
        private static final /* synthetic */ UserClassificationCounter[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UserClassificationCounter[] values() {
            return (UserClassificationCounter[])$VALUES.clone();
        }

        public static UserClassificationCounter valueOf(String value) {
            return Enum.valueOf(UserClassificationCounter.class, value);
        }

        @NotNull
        public static EnumEntries<UserClassificationCounter> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = userClassificationCounterArray = new UserClassificationCounter[]{UserClassificationCounter.COMPANY_USERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH, UserClassificationCounter.COMPANY_USERS_DOMAIN_AND_SUBDOMAINS_MATCH, UserClassificationCounter.CUSTOMERS_LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH, UserClassificationCounter.CUSTOMERS_DOMAIN_AND_SUBDOMAINS_MATCH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompanyUserRecognitionAlgorithm.values().length];
            try {
                nArray[CompanyUserRecognitionAlgorithm.LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompanyUserRecognitionAlgorithm.DOMAIN_AND_SUBDOMAINS_MATCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

