/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.cmpt.analytics.events.ActionDrivenEventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.events.PlanSavedEventKt;
import com.atlassian.jira.migration.plan.PbpMigrationMode;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010%\u001a\u00020&R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/events/PlanSavedEvent;", "", "planId", "", "executionId", "timestamp", "Ljava/time/Instant;", "estimatedMigrationTime", "", "systemCpuLoadAverage", "", "availableProcessors", "", "freeHeapMemory", "migrationTag", "pbpMigrationMode", "Lcom/atlassian/jira/migration/plan/PbpMigrationMode;", "bandwidthSupplier", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;JDIJLjava/lang/String;Lcom/atlassian/jira/migration/plan/PbpMigrationMode;Lkotlin/jvm/functions/Function0;)V", "getAvailableProcessors", "()I", "getBandwidthSupplier", "()Lkotlin/jvm/functions/Function0;", "getEstimatedMigrationTime", "()J", "getExecutionId", "()Ljava/lang/String;", "getFreeHeapMemory", "getMigrationTag", "getPbpMigrationMode", "()Lcom/atlassian/jira/migration/plan/PbpMigrationMode;", "getPlanId", "getSystemCpuLoadAverage", "()D", "getTimestamp", "()Ljava/time/Instant;", "asOperationalEvent", "Lcom/atlassian/cmpt/analytics/events/GenericOperationalEvent;", "jira-migration-plugin"})
public final class PlanSavedEvent {
    @NotNull
    private final String planId;
    @NotNull
    private final String executionId;
    @NotNull
    private final Instant timestamp;
    private final long estimatedMigrationTime;
    private final double systemCpuLoadAverage;
    private final int availableProcessors;
    private final long freeHeapMemory;
    @NotNull
    private final String migrationTag;
    @NotNull
    private final PbpMigrationMode pbpMigrationMode;
    @NotNull
    private final Function0<Long> bandwidthSupplier;

    public PlanSavedEvent(@NotNull String planId, @NotNull String executionId, @NotNull Instant timestamp, long estimatedMigrationTime, double systemCpuLoadAverage, int availableProcessors, long freeHeapMemory, @NotNull String migrationTag, @NotNull PbpMigrationMode pbpMigrationMode, @NotNull Function0<Long> bandwidthSupplier) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)migrationTag, (String)"migrationTag");
        Intrinsics.checkNotNullParameter((Object)((Object)pbpMigrationMode), (String)"pbpMigrationMode");
        Intrinsics.checkNotNullParameter(bandwidthSupplier, (String)"bandwidthSupplier");
        this.planId = planId;
        this.executionId = executionId;
        this.timestamp = timestamp;
        this.estimatedMigrationTime = estimatedMigrationTime;
        this.systemCpuLoadAverage = systemCpuLoadAverage;
        this.availableProcessors = availableProcessors;
        this.freeHeapMemory = freeHeapMemory;
        this.migrationTag = migrationTag;
        this.pbpMigrationMode = pbpMigrationMode;
        this.bandwidthSupplier = bandwidthSupplier;
    }

    @NotNull
    public final String getPlanId() {
        return this.planId;
    }

    @NotNull
    public final String getExecutionId() {
        return this.executionId;
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    public final long getEstimatedMigrationTime() {
        return this.estimatedMigrationTime;
    }

    public final double getSystemCpuLoadAverage() {
        return this.systemCpuLoadAverage;
    }

    public final int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public final long getFreeHeapMemory() {
        return this.freeHeapMemory;
    }

    @NotNull
    public final String getMigrationTag() {
        return this.migrationTag;
    }

    @NotNull
    public final PbpMigrationMode getPbpMigrationMode() {
        return this.pbpMigrationMode;
    }

    @NotNull
    public final Function0<Long> getBandwidthSupplier() {
        return this.bandwidthSupplier;
    }

    @NotNull
    public final GenericOperationalEvent asOperationalEvent() {
        ActionDrivenEventDto.Builder builder = ((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.timestamp.toEpochMilli()).actionSubject("plan", this.planId)).action("saved");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"action(...)");
        GenericOperationalEvent.Builder builder2 = PlanSavedEventKt.access$executionId((GenericOperationalEvent.Builder)builder, this.executionId);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"access$executionId(...)");
        GenericOperationalEvent.Builder builder3 = PlanSavedEventKt.access$estimatedMigrationTime(builder2, this.estimatedMigrationTime);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"access$estimatedMigrationTime(...)");
        GenericOperationalEvent.Builder builder4 = PlanSavedEventKt.access$systemCpuLoadAverage(builder3, this.systemCpuLoadAverage);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"access$systemCpuLoadAverage(...)");
        GenericOperationalEvent.Builder builder5 = PlanSavedEventKt.access$availableProcessors(builder4, this.availableProcessors);
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"access$availableProcessors(...)");
        GenericOperationalEvent.Builder builder6 = PlanSavedEventKt.access$freeHeapMemory(builder5, this.freeHeapMemory);
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"access$freeHeapMemory(...)");
        GenericOperationalEvent.Builder builder7 = PlanSavedEventKt.access$migrationTag(builder6, this.migrationTag);
        Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"access$migrationTag(...)");
        GenericOperationalEvent.Builder builder8 = PlanSavedEventKt.access$bandwidth(builder7, ((Number)this.bandwidthSupplier.invoke()).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"access$bandwidth(...)");
        GenericOperationalEvent genericOperationalEvent = PlanSavedEventKt.access$pbpMigrationMode(builder8, this.pbpMigrationMode.toString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
        return genericOperationalEvent;
    }
}

