/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.events;

import com.atlassian.cmpt.analytics.events.ActionDrivenEventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.events.PlanStartedEventKt;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/events/PlanStartedEvent;", "", "planId", "", "executionId", "cloudId", "startTime", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;)V", "getCloudId", "()Ljava/lang/String;", "getExecutionId", "getPlanId", "getStartTime", "()Ljava/time/Instant;", "asOperationalEvent", "Lcom/atlassian/cmpt/analytics/events/GenericOperationalEvent;", "jira-migration-plugin"})
public final class PlanStartedEvent {
    @NotNull
    private final String planId;
    @NotNull
    private final String executionId;
    @NotNull
    private final String cloudId;
    @NotNull
    private final Instant startTime;

    public PlanStartedEvent(@NotNull String planId, @NotNull String executionId, @NotNull String cloudId2, @NotNull Instant startTime) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.planId = planId;
        this.executionId = executionId;
        this.cloudId = cloudId2;
        this.startTime = startTime;
    }

    @NotNull
    public final String getPlanId() {
        return this.planId;
    }

    @NotNull
    public final String getExecutionId() {
        return this.executionId;
    }

    @NotNull
    public final String getCloudId() {
        return this.cloudId;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final GenericOperationalEvent asOperationalEvent() {
        ActionDrivenEventDto.Builder builder = ((GenericOperationalEvent.Builder)PlanStartedEventKt.access$initiateBuilder(this.startTime.toEpochMilli(), this.cloudId).actionSubject("planMigration", "plan")).action("started");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"action(...)");
        GenericOperationalEvent.Builder builder2 = PlanStartedEventKt.access$planId((GenericOperationalEvent.Builder)builder, this.planId);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"access$planId(...)");
        GenericOperationalEvent genericOperationalEvent = PlanStartedEventKt.access$executionId(builder2, this.executionId).build();
        Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
        return genericOperationalEvent;
    }
}

