/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.execution;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.execution.PlanExecutionService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.progress.IncrementalMigrationStatus;
import com.atlassian.jira.migration.progress.IncrementalMigrationStatusCalculatorKt;
import com.atlassian.jira.migration.progress.MigrationStatus;
import com.atlassian.jira.migration.progress.MigrationStatusKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/execution/CachedPlanStatusService;", "", "planExecutionService", "Lcom/atlassian/jira/migration/execution/PlanExecutionService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/execution/PlanExecutionService;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "classicStatusCache", "Lcom/atlassian/cache/Cache;", "", "Lcom/atlassian/jira/migration/progress/MigrationStatus;", "incrementalMigrationStatusCache", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatus;", "clearCacheForPlan", "", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getClassicMigrationStatus", "getIncrementalMigrationStatus", "getLiftAndShiftMigrationStatus", "Companion", "jira-migration-plugin"})
public final class CachedPlanStatusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanExecutionService planExecutionService;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Cache<String, MigrationStatus> classicStatusCache;
    @NotNull
    private final Cache<String, IncrementalMigrationStatus> incrementalMigrationStatusCache;
    @NotNull
    private static final String CLASSIC_MIG_STATUS_CACHE_NAME = CachedPlanStatusService.class.getName() + ".classic.mig.status.data";
    @NotNull
    private static final String INCREMENTAL_MIG_STATUS_CACHE_NAME = CachedPlanStatusService.class.getName() + ".incremental.mig.status.data";

    @Inject
    public CachedPlanStatusService(@NotNull PlanExecutionService planExecutionService, @NotNull CacheManager cacheManager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)planExecutionService, (String)"planExecutionService");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.planExecutionService = planExecutionService;
        this.cacheManager = cacheManager;
        this.migrationFeatures = migrationFeatures;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.DAYS).replicateViaInvalidation().remote().build();
        Intrinsics.checkNotNullExpressionValue((Object)cacheSettings, (String)"build(...)");
        CacheSettings cacheSetting = cacheSettings;
        Cache cache2 = this.cacheManager.getCache(CLASSIC_MIG_STATUS_CACHE_NAME, null, cacheSetting);
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.classicStatusCache = cache2;
        Cache cache3 = this.cacheManager.getCache(INCREMENTAL_MIG_STATUS_CACHE_NAME, null, cacheSetting);
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"getCache(...)");
        this.incrementalMigrationStatusCache = cache3;
        this.classicStatusCache.removeAll();
        this.incrementalMigrationStatusCache.removeAll();
    }

    public final void clearCacheForPlan(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (plan2.isIncremental()) {
            this.incrementalMigrationStatusCache.remove((Object)plan2.getId());
        } else {
            this.classicStatusCache.remove((Object)plan2.getId());
        }
    }

    @NotNull
    public final MigrationStatus getClassicMigrationStatus(@NotNull Plan plan2) {
        MigrationStatus migrationStatus;
        block7: {
            MigrationStatus migrationStatus2;
            block6: {
                MigrationStatus migrationStatus3;
                Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
                migrationStatus = (MigrationStatus)this.classicStatusCache.get((Object)plan2.getId());
                if (migrationStatus == null) break block6;
                MigrationStatus cachedStatus = migrationStatus;
                boolean bl = false;
                if (this.migrationFeatures.getEnablePreflightCheckRepository()) {
                    MigrationStatus migrationStatus4;
                    MigrationStatus updatedStatus = migrationStatus4 = MigrationStatus.copy$default(cachedStatus, null, null, this.planExecutionService.getCoreMigrationStatus(plan2), null, 11, null);
                    boolean bl2 = false;
                    this.classicStatusCache.put((Object)plan2.getId(), (Object)updatedStatus);
                    migrationStatus3 = migrationStatus4;
                } else {
                    migrationStatus3 = cachedStatus;
                }
                migrationStatus = migrationStatus3;
                if (migrationStatus3 != null) break block7;
            }
            MigrationStatus newStatus = migrationStatus2 = this.planExecutionService.getClassicMigrationStatus(plan2);
            boolean bl = false;
            if (MigrationStatusKt.isTerminal(newStatus.getOverallStatus())) {
                this.classicStatusCache.put((Object)plan2.getId(), (Object)newStatus);
            }
            migrationStatus = migrationStatus2;
        }
        return migrationStatus;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MigrationStatus getLiftAndShiftMigrationStatus(@NotNull Plan plan2) {
        MigrationStatus migrationStatus;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        MigrationStatus cachedMigrationStatus = (MigrationStatus)this.classicStatusCache.get((Object)plan2.getId());
        if (cachedMigrationStatus != null) {
            migrationStatus = cachedMigrationStatus;
        } else {
            void var3_3;
            MigrationStatus newStatus = this.planExecutionService.getLiftAndShiftMigrationStatus(plan2);
            if (MigrationStatusKt.isTerminal(newStatus.getOverallStatus())) {
                this.classicStatusCache.put((Object)plan2.getId(), (Object)newStatus);
            }
            migrationStatus = var3_3;
        }
        return migrationStatus;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IncrementalMigrationStatus getIncrementalMigrationStatus(@NotNull Plan plan2) {
        IncrementalMigrationStatus incrementalMigrationStatus;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        IncrementalMigrationStatus cachedMigrationStatus = (IncrementalMigrationStatus)this.incrementalMigrationStatusCache.get((Object)plan2.getId());
        if (cachedMigrationStatus != null) {
            incrementalMigrationStatus = cachedMigrationStatus;
        } else {
            void var3_3;
            IncrementalMigrationStatus newStatus = this.planExecutionService.getIncrementalMigrationStatus(plan2);
            if (IncrementalMigrationStatusCalculatorKt.isTerminal(newStatus.getOverallStatus())) {
                this.incrementalMigrationStatusCache.put((Object)plan2.getId(), (Object)newStatus);
            }
            incrementalMigrationStatus = var3_3;
        }
        return incrementalMigrationStatus;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/execution/CachedPlanStatusService$Companion;", "", "()V", "CLASSIC_MIG_STATUS_CACHE_NAME", "", "getCLASSIC_MIG_STATUS_CACHE_NAME$annotations", "getCLASSIC_MIG_STATUS_CACHE_NAME", "()Ljava/lang/String;", "INCREMENTAL_MIG_STATUS_CACHE_NAME", "getINCREMENTAL_MIG_STATUS_CACHE_NAME$annotations", "getINCREMENTAL_MIG_STATUS_CACHE_NAME", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCLASSIC_MIG_STATUS_CACHE_NAME() {
            return CLASSIC_MIG_STATUS_CACHE_NAME;
        }

        @VisibleForTesting
        public static /* synthetic */ void getCLASSIC_MIG_STATUS_CACHE_NAME$annotations() {
        }

        @NotNull
        public final String getINCREMENTAL_MIG_STATUS_CACHE_NAME() {
            return INCREMENTAL_MIG_STATUS_CACHE_NAME;
        }

        @VisibleForTesting
        public static /* synthetic */ void getINCREMENTAL_MIG_STATUS_CACHE_NAME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

