/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.execution;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.execution.ExecutionExceptions;
import com.atlassian.jira.migration.execution.MigrationExecutionService;
import com.atlassian.jira.migration.execution.model.MigrationMetaData;
import com.atlassian.jira.migration.lio.model.MigrationRecipeInput;
import com.atlassian.jira.migration.lio.service.RecipeExecutionService;
import com.atlassian.jira.migration.migration.DryRunMigration;
import com.atlassian.jira.migration.migration.DryRunMigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.platform.ContainersFetchResponse;
import com.atlassian.jira.migration.platform.CreateMigrationRequest;
import com.atlassian.jira.migration.platform.ExecutionType;
import com.atlassian.jira.migration.platform.PlatformMigrationStatus;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.MigrationScopeId;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/execution/DryRunExecutionService;", "", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "dryRunMigrationRepository", "Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "recipeExecutionService", "Lcom/atlassian/jira/migration/lio/service/RecipeExecutionService;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationExecutionService", "Lcom/atlassian/jira/migration/execution/MigrationExecutionService;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/lio/service/RecipeExecutionService;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/execution/MigrationExecutionService;)V", "createMigration", "Lcom/atlassian/migration/api/MigrationId;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "migrationScopeId", "Lcom/atlassian/migration/api/MigrationScopeId;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "migrationMetadata", "Lcom/atlassian/jira/migration/execution/model/MigrationMetaData;", "isMigrationRunning", "", "", "migrationId", "startDryRun", "planId", "userKey", "Companion", "jira-migration-plugin"})
public final class DryRunExecutionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final DryRunMigrationRepository dryRunMigrationRepository;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final RecipeExecutionService recipeExecutionService;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationExecutionService migrationExecutionService;
    private static final Logger log = LoggerFactory.getLogger(DryRunExecutionService.class);

    @Inject
    public DryRunExecutionService(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull DryRunMigrationRepository dryRunMigrationRepository, @NotNull MigrationScopeManager migrationScopeManager, @NotNull PlatformService platformService, @NotNull RecipeExecutionService recipeExecutionService, @NotNull PlanRepository planRepository, @NotNull MigrationExecutionService migrationExecutionService) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)dryRunMigrationRepository, (String)"dryRunMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)recipeExecutionService, (String)"recipeExecutionService");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationExecutionService, (String)"migrationExecutionService");
        this.cloudSiteRepository = cloudSiteRepository;
        this.dryRunMigrationRepository = dryRunMigrationRepository;
        this.migrationScopeManager = migrationScopeManager;
        this.platformService = platformService;
        this.recipeExecutionService = recipeExecutionService;
        this.planRepository = planRepository;
        this.migrationExecutionService = migrationExecutionService;
    }

    public final boolean isMigrationRunning(@NotNull String containerToken, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        ContainersFetchResponse response2 = PlatformService.getPageOfContainers$default(this.platformService, new ContainerToken(containerToken), new MigrationId(migrationId), null, null, false, null, false, false, 236, null);
        return response2.getExecutionStatus() == PlatformMigrationStatus.IN_PROGRESS || response2.getMigrationStatus() == PlatformMigrationStatus.IN_PROGRESS;
    }

    @NotNull
    public final MigrationId startDryRun(@NotNull String planId, @NotNull String userKey) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Plan plan2 = this.planRepository.get(planId);
        if (plan2 == null) {
            throw ExecutionExceptions.INSTANCE.missingPlanException(planId);
        }
        Plan plan3 = plan2;
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(plan3.getCloudId());
        if (cloudSite2 == null) {
            throw ExecutionExceptions.INSTANCE.missingCloudInfoException(plan3.getCloudId());
        }
        CloudSite cloudSite3 = cloudSite2;
        ContainerToken containerToken = new ContainerToken(cloudSite3.getContainerToken());
        MigrationScopeId migrationScopeId2 = new MigrationScopeId(this.migrationScopeManager.getMigrationScope(cloudSite3));
        MigrationMetaData migrationMetaData = this.migrationExecutionService.getMigrationMetaData(plan3, migrationScopeId2, containerToken, true);
        MigrationId migrationId = this.createMigration(plan3, migrationScopeId2, containerToken, migrationMetaData);
        log.info("Created dry run migration with migration id: " + migrationId);
        this.platformService.registerContainers(containerToken, migrationId, plan3, true);
        String string = containerToken.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MigrationRecipeInput recipeInput = new MigrationRecipeInput(plan3, migrationId, migrationScopeId2, userKey, string, migrationMetaData.getMaxConcurrencyPerLoop(), migrationMetaData.getWorkplanConfig(), null, false, true);
        this.recipeExecutionService.executeRecipe(recipeInput);
        log.info("Recipe executed successfully for dry run with migration id: " + migrationId);
        this.dryRunMigrationRepository.save(new DryRunMigration(migrationId, plan3.getId(), userKey));
        return migrationId;
    }

    private final MigrationId createMigration(Plan plan2, MigrationScopeId migrationScopeId2, ContainerToken containerToken, MigrationMetaData migrationMetadata2) {
        CreateMigrationRequest req = CreateMigrationRequest.copy$default(CreateMigrationRequest.Companion.fromPlan(plan2, migrationScopeId2, null, true), null, null, null, false, this.migrationExecutionService.getMigrationProperties(plan2, migrationMetadata2), null, ExecutionType.DRY_RUN, 47, null);
        MigrationId migrationId = this.platformService.createMigrationV2(containerToken, req).getMigrationId();
        return migrationId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/execution/DryRunExecutionService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

