/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.execution;

import com.atlassian.jira.migration.execution.LithiumAppMigrationProperties;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.Plan;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012R&\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/execution/LithiumAppMigrationsHelper;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "lithiumAppProperties", "", "Lkotlin/Pair;", "", "Lcom/atlassian/jira/migration/execution/LithiumAppMigrationProperties;", "forgetLithiumAppProperties", "", "planId", "serverAppKey", "isAMPyEnabledForApp", "", "memorizeLithiumAppMigrationProperties", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "jira-migration-plugin"})
public final class LithiumAppMigrationsHelper {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Map<Pair<String, String>, LithiumAppMigrationProperties> lithiumAppProperties;

    @Inject
    public LithiumAppMigrationsHelper(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
        this.lithiumAppProperties = new LinkedHashMap();
    }

    public final void memorizeLithiumAppMigrationProperties(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (plan2.getAppsMigrationOption().getIncludedApps() == null) {
            return;
        }
        Set<String> set = plan2.getAppsMigrationOption().getIncludedApps();
        Intrinsics.checkNotNull(set);
        for (String serverAppKey : set) {
            boolean isAMPyEnabled = this.migrationFeatures.enableAMPyWorkplanForApp(serverAppKey);
            this.lithiumAppProperties.put((Pair<String, String>)new Pair((Object)plan2.getId(), (Object)serverAppKey), new LithiumAppMigrationProperties(isAMPyEnabled));
        }
    }

    public final void forgetLithiumAppProperties(@NotNull String planId, @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        this.lithiumAppProperties.keySet().removeIf(arg_0 -> LithiumAppMigrationsHelper.forgetLithiumAppProperties$lambda$0((Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(planId, serverAppKey){
            final /* synthetic */ String $planId;
            final /* synthetic */ String $serverAppKey;
            {
                this.$planId = $planId;
                this.$serverAppKey = $serverAppKey;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)it.getFirst(), (Object)this.$planId) && Intrinsics.areEqual((Object)it.getSecond(), (Object)this.$serverAppKey);
            }
        }, arg_0));
    }

    public final boolean isAMPyEnabledForApp(@NotNull String planId, @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        LithiumAppMigrationProperties lithiumAppMigrationProperties = this.lithiumAppProperties.get(new Pair((Object)planId, (Object)serverAppKey));
        return lithiumAppMigrationProperties != null ? lithiumAppMigrationProperties.isAMPyEnabled() : false;
    }

    private static final boolean forgetLithiumAppProperties$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

