/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.execution;

import com.atlassian.jira.migration.execution.LithiumProperties;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.shadow.ShadowMigrationProtocol;
import com.atlassian.migration.api.MigrationId;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0014J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "migrationIdProtocolMap", "", "", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "planToLithiumPropertiesMap", "Lcom/atlassian/jira/migration/execution/LithiumProperties;", "evaluateAndMemorizeLithiumPlanProperties", "planId", "evaluateAndMemorizeProtocolForMigration", "", "migrationId", "isV4Enabled", "", "forgetPlanLithiumProperties", "forgetProtocolForMigration", "Lcom/atlassian/migration/api/MigrationId;", "getImportMode", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getProtocolForMigration", "isV4LithiumOrchestrationEnabled", "Companion", "jira-migration-plugin"})
public final class LithiumMigrationsHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Map<String, MigrationProtocol> migrationIdProtocolMap;
    @NotNull
    private final Map<String, LithiumProperties> planToLithiumPropertiesMap;
    @NotNull
    private static final String LITHIUM_ONLY = "LithiumOnly";
    @NotNull
    private static final String LITHIUM_SHADOWS = "LithiumShadows";
    @NotNull
    private static final String LITHIUM_SHADOWS_WITH_INSERTION = "LithiumShadowsWithInsertion";

    @Inject
    public LithiumMigrationsHelper(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
        this.migrationIdProtocolMap = new LinkedHashMap();
        this.planToLithiumPropertiesMap = new LinkedHashMap();
    }

    public final boolean isV4LithiumOrchestrationEnabled(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        LithiumProperties lithiumProperties = this.planToLithiumPropertiesMap.get(plan2.getId());
        return (lithiumProperties != null ? lithiumProperties.isLioEnabled() : false) || plan2.isV4ShadowPlan();
    }

    @Nullable
    public final String getImportMode(@NotNull Plan plan2, boolean isV4Enabled) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        return isV4Enabled && Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true) ? (plan2.getShadowMigrationProtocol() == ShadowMigrationProtocol.V4_WDCS ? LITHIUM_SHADOWS_WITH_INSERTION : LITHIUM_SHADOWS) : (isV4Enabled ? LITHIUM_ONLY : null);
    }

    public final void evaluateAndMemorizeProtocolForMigration(@NotNull String migrationId, boolean isV4Enabled) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.migrationIdProtocolMap.put(migrationId, isV4Enabled ? MigrationProtocol.V4 : MigrationProtocol.V3);
    }

    @NotNull
    public final LithiumProperties evaluateAndMemorizeLithiumPlanProperties(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        LithiumProperties lithiumProperties = new LithiumProperties(this.migrationFeatures.getEnableV4LithiumOrchestration(), false);
        this.planToLithiumPropertiesMap.put(planId, lithiumProperties);
        return lithiumProperties;
    }

    @NotNull
    public final MigrationProtocol getProtocolForMigration(@NotNull MigrationId migrationId) {
        MigrationProtocol migrationProtocol;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        MigrationProtocol migrationProtocol2 = migrationProtocol = this.migrationIdProtocolMap.get(migrationId.toString());
        Intrinsics.checkNotNull((Object)((Object)migrationProtocol2));
        return migrationProtocol2;
    }

    public final void forgetProtocolForMigration(@NotNull MigrationId migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.migrationIdProtocolMap.remove(migrationId.toString());
    }

    public final void forgetPlanLithiumProperties(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        this.planToLithiumPropertiesMap.remove(planId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper$Companion;", "", "()V", "LITHIUM_ONLY", "", "LITHIUM_SHADOWS", "LITHIUM_SHADOWS_WITH_INSERTION", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

