/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.execution;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.ChecksResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.execution.CrossProjectDataProgressService;
import com.atlassian.jira.migration.execution.LithiumAppMigrationsHelper;
import com.atlassian.jira.migration.execution.LithiumMigrationsHelper;
import com.atlassian.jira.migration.execution.MigrationExecutionService;
import com.atlassian.jira.migration.execution.PlanMigrationProgress;
import com.atlassian.jira.migration.execution.ScheduledExecution;
import com.atlassian.jira.migration.execution.ScheduledExecutionRepository;
import com.atlassian.jira.migration.execution.cache.MigrationExecutionCache;
import com.atlassian.jira.migration.execution.utils.CrossProjectEntityProgressUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.fx3.Fx3Helper;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationIncrementRepository;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.migration.StartMigrationContext;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.EntityCounts;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.model.CheckMode;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.progress.AppProgress;
import com.atlassian.jira.migration.progress.AppsProgressService;
import com.atlassian.jira.migration.progress.CrossProjectEntityProgress;
import com.atlassian.jira.migration.progress.EntityProgress;
import com.atlassian.jira.migration.progress.EntityStatus;
import com.atlassian.jira.migration.progress.EntityStatusKt;
import com.atlassian.jira.migration.progress.GeneralTaskProgress;
import com.atlassian.jira.migration.progress.IncrementalAppProgress;
import com.atlassian.jira.migration.progress.IncrementalCrossProjectEntityProgress;
import com.atlassian.jira.migration.progress.IncrementalEntityProgress;
import com.atlassian.jira.migration.progress.IncrementalEntityStatus;
import com.atlassian.jira.migration.progress.IncrementalEntityStatusKt;
import com.atlassian.jira.migration.progress.IncrementalMigrationStatus;
import com.atlassian.jira.migration.progress.IncrementalMigrationStatusCalculator;
import com.atlassian.jira.migration.progress.IncrementalMigrationStatusCalculatorKt;
import com.atlassian.jira.migration.progress.IncrementalPlanProgress;
import com.atlassian.jira.migration.progress.IncrementalProjectProgress;
import com.atlassian.jira.migration.progress.IncrementalTaskStatus;
import com.atlassian.jira.migration.progress.IncrementalUsersAndGroupsProgress;
import com.atlassian.jira.migration.progress.InfraProgress;
import com.atlassian.jira.migration.progress.InfraStatus;
import com.atlassian.jira.migration.progress.LiftAndShiftTaskUtil;
import com.atlassian.jira.migration.progress.MigrationStatus;
import com.atlassian.jira.migration.progress.MigrationTaskStatus;
import com.atlassian.jira.migration.progress.PaginatedIncrementalProjectProgressDto;
import com.atlassian.jira.migration.progress.PaginatedProjectProgressDto;
import com.atlassian.jira.migration.progress.PlanProgress;
import com.atlassian.jira.migration.progress.ProjectProgress;
import com.atlassian.jira.migration.progress.ProjectProgressBuilder;
import com.atlassian.jira.migration.progress.SiteProgressBuilder;
import com.atlassian.jira.migration.progress.StatusRetrievalService;
import com.atlassian.jira.migration.progress.TaskList;
import com.atlassian.jira.migration.progress.TaskStatus;
import com.atlassian.jira.migration.progress.UsersAndGroupsProgress;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.migration.serverdataextractors.ServerProject;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.migration.utils.MigrationStatusCalculator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0007\u0018\u0000 \u0095\u00012\u00020\u0001:\u0002\u0095\u0001B\u009f\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u00a2\u0006\u0002\u0010(J\u001c\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\n\b\u0002\u00106\u001a\u0004\u0018\u00010-H\u0007J(\u00107\u001a\u0002082\u0006\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020;2\u0006\u00106\u001a\u00020-2\u0006\u0010<\u001a\u00020=H\u0002J8\u0010>\u001a\u00020?2\u0006\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020;2\u0006\u00106\u001a\u00020-2\u0006\u0010<\u001a\u00020=2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0002JG\u0010C\u001a\u00020D2\u0006\u0010:\u001a\u00020;2\b\u0010E\u001a\u0004\u0018\u00010F2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010LH\u0002\u00a2\u0006\u0002\u0010NJ+\u0010C\u001a\u00020D2\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010L2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010L\u00a2\u0006\u0002\u0010OJ,\u0010P\u001a\u00020Q2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HH\u0007J,\u0010S\u001a\b\u0012\u0004\u0012\u0002080T2\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=2\n\b\u0002\u00106\u001a\u0004\u0018\u00010-H\u0007J\u0016\u0010U\u001a\u00020V2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0XH\u0007J\u001e\u0010Z\u001a\u00020[2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0X2\u0006\u0010B\u001a\u00020AH\u0007J\u001e\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010:\u001a\u00020;2\u0006\u0010_\u001a\u00020QH\u0002J\u0016\u0010`\u001a\u0004\u0018\u0001032\n\b\u0002\u00106\u001a\u0004\u0018\u00010-H\u0007J\u000e\u0010a\u001a\u00020b2\u0006\u0010:\u001a\u00020;J\u0014\u0010c\u001a\u00020d2\n\b\u0002\u00106\u001a\u0004\u0018\u00010-H\u0007J$\u0010e\u001a\u0004\u0018\u00010f2\u0006\u00106\u001a\u00020-2\u0006\u0010B\u001a\u00020A2\b\u0010g\u001a\u0004\u0018\u00010hH\u0002J$\u0010i\u001a\u0004\u0018\u00010f2\u0006\u00106\u001a\u00020-2\u0006\u0010B\u001a\u00020A2\b\u0010g\u001a\u0004\u0018\u00010hH\u0002J\u000e\u0010j\u001a\u00020Q2\u0006\u0010:\u001a\u00020;J\u000e\u0010k\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010TJ\u000e\u0010l\u001a\u00020m2\u0006\u0010:\u001a\u00020;J\u001e\u0010n\u001a\u0004\u0018\u00010h2\n\b\u0002\u00106\u001a\u0004\u0018\u00010-2\u0006\u0010B\u001a\u00020AH\u0007J\u000e\u0010o\u001a\u00020p2\u0006\u0010:\u001a\u00020;J\u001c\u0010q\u001a\u00020f2\n\b\u0002\u00106\u001a\u0004\u0018\u00010-2\u0006\u0010B\u001a\u00020AH\u0007J\"\u0010r\u001a\u00020f2\u0006\u00106\u001a\u00020-2\u0006\u0010B\u001a\u00020A2\b\u0010g\u001a\u0004\u0018\u00010hH\u0002J\u0010\u0010s\u001a\u0004\u0018\u00010t2\u0006\u0010:\u001a\u00020;J\u000e\u0010u\u001a\u00020Q2\u0006\u0010:\u001a\u00020;J\u000e\u0010v\u001a\u00020b2\u0006\u0010:\u001a\u00020;J\u0010\u0010w\u001a\n x*\u0004\u0018\u00010+0+H\u0002J/\u0010y\u001a\u00020z2\f\u0010{\u001a\b\u0012\u0004\u0012\u0002080T2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010LH\u0002\u00a2\u0006\u0002\u0010|J/\u0010}\u001a\u00020~2\f\u0010{\u001a\b\u0012\u0004\u0012\u00020?0T2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010LH\u0002\u00a2\u0006\u0002\u0010\u007fJ\u0012\u0010\u0080\u0001\u001a\u0004\u0018\u00010J2\u0007\u0010\u0081\u0001\u001a\u00020+J%\u0010\u0082\u0001\u001a\u0004\u0018\u00010f2\u0006\u00106\u001a\u00020-2\u0006\u0010B\u001a\u00020A2\b\u0010g\u001a\u0004\u0018\u00010hH\u0002J\u0012\u0010\u0083\u0001\u001a\u0004\u0018\u00010H2\u0007\u0010\u0081\u0001\u001a\u00020+J\u0013\u0010\u0084\u0001\u001a\u0004\u0018\u00010-2\u0006\u0010:\u001a\u00020;H\u0002JJ\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010:\u001a\u00020;2\b\u0010E\u001a\u0004\u0018\u00010F2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010LH\u0002\u00a2\u0006\u0003\u0010\u0087\u0001J.\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010L2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010L\u00a2\u0006\u0003\u0010\u0088\u0001J5\u0010\u0089\u0001\u001a\u00020m2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010B\u001a\u00020AH\u0007J5\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020?0T2\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010B\u001a\u00020A2\n\b\u0002\u00106\u001a\u0004\u0018\u00010-H\u0007J\u000f\u0010\u008b\u0001\u001a\u00020D2\u0006\u0010:\u001a\u00020;J/\u0010\u008b\u0001\u001a\u00020D2\u0006\u0010:\u001a\u00020;2\b\u0010E\u001a\u0004\u0018\u00010F2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010JH\u0002J\u0010\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010:\u001a\u00020;J\u0019\u0010\u008e\u0001\u001a\u00030\u008d\u00012\u0006\u0010:\u001a\u00020;2\u0007\u0010\u008f\u0001\u001a\u00020AJ%\u0010\u0090\u0001\u001a\u00030\u008d\u00012\u0006\u0010:\u001a\u00020;2\u0011\u0010\u0091\u0001\u001a\f\u0012\u0007\u0012\u0005\u0018\u00010\u0093\u00010\u0092\u0001H\u0007J\u0012\u0010\u0094\u0001\u001a\u00030\u008d\u00012\u0006\u0010:\u001a\u00020;H\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010)\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0*8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0096\u0001\u00b2\u0006\u000e\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u0001X\u008a\u0084\u0002\u00b2\u0006\u000e\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u0001X\u008a\u0084\u0002"}, d2={"Lcom/atlassian/jira/migration/execution/PlanExecutionService;", "", "migrationExecutionService", "Lcom/atlassian/jira/migration/execution/MigrationExecutionService;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "migrationIncrementRepository", "Lcom/atlassian/jira/migration/migration/MigrationIncrementRepository;", "statusRetrievalService", "Lcom/atlassian/jira/migration/progress/StatusRetrievalService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "scheduledExecutionRepository", "Lcom/atlassian/jira/migration/execution/ScheduledExecutionRepository;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "appsProgressService", "Lcom/atlassian/jira/migration/progress/AppsProgressService;", "projectProgressBuilder", "Lcom/atlassian/jira/migration/progress/ProjectProgressBuilder;", "siteProgressBuilder", "Lcom/atlassian/jira/migration/progress/SiteProgressBuilder;", "crossProjectDataProgressService", "Lcom/atlassian/jira/migration/execution/CrossProjectDataProgressService;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "fx3Helper", "Lcom/atlassian/jira/migration/fx3/Fx3Helper;", "lithiumMigrationsHelper", "Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper;", "lithiumAppMigrationsHelper", "Lcom/atlassian/jira/migration/execution/LithiumAppMigrationsHelper;", "migrationExecutionCache", "Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache;", "(Lcom/atlassian/jira/migration/execution/MigrationExecutionService;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/migration/MigrationIncrementRepository;Lcom/atlassian/jira/migration/progress/StatusRetrievalService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/execution/ScheduledExecutionRepository;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/jira/migration/progress/AppsProgressService;Lcom/atlassian/jira/migration/progress/ProjectProgressBuilder;Lcom/atlassian/jira/migration/progress/SiteProgressBuilder;Lcom/atlassian/jira/migration/execution/CrossProjectDataProgressService;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/fx3/Fx3Helper;Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper;Lcom/atlassian/jira/migration/execution/LithiumAppMigrationsHelper;Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache;)V", "migrationProgressCache", "Lcom/google/common/cache/LoadingCache;", "", "Ljava/util/Optional;", "Lcom/atlassian/jira/migration/progress/TaskList;", "getMigrationProgressCache$annotations", "()V", "getMigrationProgressCache", "()Lcom/google/common/cache/LoadingCache;", "advancedRoadMapsPlanProgress", "Lcom/atlassian/jira/migration/progress/EntityProgress;", "selectedPlans", "", "tasks", "buildClassicProjectProgress", "Lcom/atlassian/jira/migration/progress/ProjectProgress;", "projectKey", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "startMigrationContext", "Lcom/atlassian/jira/migration/migration/StartMigrationContext;", "buildIncrementalProjectProgress", "Lcom/atlassian/jira/migration/progress/IncrementalProjectProgress;", "isPlanInTerminalStatus", "", "hasFinalIncrement", "classicPlanDetailsProgress", "Lcom/atlassian/jira/migration/progress/PlanProgress;", "checkExecutionStatus", "Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "scheduledExecution", "Lcom/atlassian/jira/migration/execution/ScheduledExecution;", "planMigrationProgress", "Lcom/atlassian/jira/migration/execution/PlanMigrationProgress;", "projectOffset", "", "projectLimit", "(Lcom/atlassian/jira/migration/plan/Plan;Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;Lcom/atlassian/jira/migration/execution/ScheduledExecution;Lcom/atlassian/jira/migration/execution/PlanMigrationProgress;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/atlassian/jira/migration/progress/PlanProgress;", "(Lcom/atlassian/jira/migration/plan/Plan;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/atlassian/jira/migration/progress/PlanProgress;", "classicPlanStatus", "Lcom/atlassian/migration/utils/MigrationStatusCalculator$CoreMigrationStatus;", "taskList", "classicProjectsProgress", "", "computeClassicMigrationCompletedTaskStatus", "Lcom/atlassian/jira/migration/progress/TaskStatus;", "items", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressItem;", "computeIncrementalMigrationCompletedTaskStatus", "Lcom/atlassian/jira/migration/progress/IncrementalTaskStatus;", "getAppProgress", "", "Lcom/atlassian/jira/migration/progress/AppProgress;", "coreMigrationStatus", "getClassicMigrationCustomerProgress", "getClassicMigrationStatus", "Lcom/atlassian/jira/migration/progress/MigrationStatus;", "getClassicUsersAndGroupsProgress", "Lcom/atlassian/jira/migration/progress/UsersAndGroupsProgress;", "getCompletedTaskProgressForUsersAndGroupsDataMigration", "Lcom/atlassian/jira/migration/progress/IncrementalUsersAndGroupsProgress;", "customerProgressStatus", "Lcom/atlassian/jira/migration/progress/IncrementalEntityProgress;", "getCompletedTaskProgressForUsersAndGroupsDataUpload", "getCoreMigrationStatus", "getInProgressPlans", "getIncrementalCoreMigrationStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$CoreMigrationStatus;", "getIncrementalMigrationCustomerProgress", "getIncrementalMigrationStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatus;", "getIncrementalUsersAndGroupsProgress", "getIncrementalUsersAndGroupsProgressFromTaskList", "getInfraOptimisationProgressStatus", "Lcom/atlassian/jira/migration/progress/InfraProgress;", "getLiftAndShiftCoreMigrationStatus", "getLiftAndShiftMigrationStatus", "getLoggedUserKey", "kotlin.jvm.PlatformType", "getPaginatedClassicProjectProgress", "Lcom/atlassian/jira/migration/progress/PaginatedProjectProgressDto;", "projectProgressList", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/atlassian/jira/migration/progress/PaginatedProjectProgressDto;", "getPaginatedIncrementalProjectProgress", "Lcom/atlassian/jira/migration/progress/PaginatedIncrementalProjectProgressDto;", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/atlassian/jira/migration/progress/PaginatedIncrementalProjectProgressDto;", "getPlanMigrationProgress", "planId", "getRunningTaskProgressForUsersAndGroupsDataMigration", "getScheduledExecution", "getSiteTaskList", "incrementalPlanDetailsProgress", "Lcom/atlassian/jira/migration/progress/IncrementalPlanProgress;", "(Lcom/atlassian/jira/migration/plan/Plan;Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;Lcom/atlassian/jira/migration/execution/ScheduledExecution;Lcom/atlassian/jira/migration/execution/PlanMigrationProgress;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/atlassian/jira/migration/progress/IncrementalPlanProgress;", "(Lcom/atlassian/jira/migration/plan/Plan;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/atlassian/jira/migration/progress/IncrementalPlanProgress;", "incrementalPlanStatus", "incrementalProjectsProgress", "liftAndShiftPlanDetailsProgress", "scheduleClassicPlanExecution", "", "scheduleIncrementalPlanExecution", "isFinalIncrement", "schedulePlanExecution", "startMigrationFunction", "Lkotlin/Function0;", "Lcom/atlassian/jira/migration/migration/Migration;", "validateIncrementalPlanCanBeScheduled", "Companion", "jira-migration-plugin", "backupProject", "Lcom/atlassian/jira/migration/serverdataextractors/ServerProject;"})
@SourceDebugExtension(value={"SMAP\nPlanExecutionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanExecutionService.kt\ncom/atlassian/jira/migration/execution/PlanExecutionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1050:1\n1#2:1051\n1549#3:1052\n1620#3,3:1053\n1549#3:1056\n1620#3,3:1057\n1549#3:1060\n1620#3,3:1061\n1549#3:1064\n1620#3,3:1065\n1747#3,3:1068\n1747#3,3:1071\n1747#3,3:1074\n1747#3,3:1077\n1549#3:1080\n1620#3,3:1081\n766#3:1084\n857#3,2:1085\n1477#3:1087\n1502#3,3:1088\n1505#3,3:1098\n1549#3:1105\n1620#3,3:1106\n766#3:1109\n857#3,2:1110\n1477#3:1112\n1502#3,3:1113\n1505#3,3:1123\n1747#3,3:1130\n1747#3,3:1133\n1726#3,3:1136\n1747#3,3:1139\n1747#3,3:1142\n1726#3,3:1145\n372#4,7:1091\n372#4,7:1116\n125#5:1101\n152#5,3:1102\n125#5:1126\n152#5,3:1127\n*S KotlinDebug\n*F\n+ 1 PlanExecutionService.kt\ncom/atlassian/jira/migration/execution/PlanExecutionService\n*L\n261#1:1052\n261#1:1053,3\n285#1:1056\n285#1:1057,3\n368#1:1060\n368#1:1061,3\n412#1:1064\n412#1:1065,3\n515#1:1068,3\n516#1:1071,3\n554#1:1074,3\n555#1:1077,3\n605#1:1080\n605#1:1081,3\n611#1:1084\n611#1:1085,2\n612#1:1087\n612#1:1088,3\n612#1:1098,3\n631#1:1105\n631#1:1106,3\n639#1:1109\n639#1:1110,2\n640#1:1112\n640#1:1113,3\n640#1:1123,3\n997#1:1130,3\n998#1:1133,3\n999#1:1136,3\n1010#1:1139,3\n1013#1:1142,3\n1016#1:1145,3\n612#1:1091,7\n640#1:1116,7\n613#1:1101\n613#1:1102,3\n641#1:1126\n641#1:1127,3\n*E\n"})
public final class PlanExecutionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationExecutionService migrationExecutionService;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final MigrationIncrementRepository migrationIncrementRepository;
    @NotNull
    private final StatusRetrievalService statusRetrievalService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final ScheduledExecutionRepository scheduledExecutionRepository;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final AppsProgressService appsProgressService;
    @NotNull
    private final ProjectProgressBuilder projectProgressBuilder;
    @NotNull
    private final SiteProgressBuilder siteProgressBuilder;
    @NotNull
    private final CrossProjectDataProgressService crossProjectDataProgressService;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final Fx3Helper fx3Helper;
    @NotNull
    private final LithiumMigrationsHelper lithiumMigrationsHelper;
    @NotNull
    private final LithiumAppMigrationsHelper lithiumAppMigrationsHelper;
    @NotNull
    private final MigrationExecutionCache migrationExecutionCache;
    @NotNull
    private final LoadingCache<String, Optional<TaskList>> migrationProgressCache;
    private static final Logger log = LoggerFactory.getLogger(PlanExecutionService.class);
    private static final int DEFAULT_PROJECT_OFFSET = 0;
    private static final int DEFAULT_PROJECT_LIMIT = 20;

    @Inject
    public PlanExecutionService(@NotNull MigrationExecutionService migrationExecutionService, @NotNull MigrationRepository migrationRepository, @NotNull MigrationIncrementRepository migrationIncrementRepository, @NotNull StatusRetrievalService statusRetrievalService, @NotNull DiscoveryService discoveryService, @NotNull PreflightService preflightService, @NotNull ScheduledExecutionRepository scheduledExecutionRepository, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull MigrationFeatures migrationFeatures, @NotNull ProjectsReader projectsReader, @NotNull AppsProgressService appsProgressService, @NotNull ProjectProgressBuilder projectProgressBuilder, @NotNull SiteProgressBuilder siteProgressBuilder, @NotNull CrossProjectDataProgressService crossProjectDataProgressService, @NotNull PlanRepository planRepository, @NotNull Fx3Helper fx3Helper, @NotNull LithiumMigrationsHelper lithiumMigrationsHelper, @NotNull LithiumAppMigrationsHelper lithiumAppMigrationsHelper, @NotNull MigrationExecutionCache migrationExecutionCache) {
        Intrinsics.checkNotNullParameter((Object)migrationExecutionService, (String)"migrationExecutionService");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationIncrementRepository, (String)"migrationIncrementRepository");
        Intrinsics.checkNotNullParameter((Object)statusRetrievalService, (String)"statusRetrievalService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutionRepository, (String)"scheduledExecutionRepository");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)appsProgressService, (String)"appsProgressService");
        Intrinsics.checkNotNullParameter((Object)projectProgressBuilder, (String)"projectProgressBuilder");
        Intrinsics.checkNotNullParameter((Object)siteProgressBuilder, (String)"siteProgressBuilder");
        Intrinsics.checkNotNullParameter((Object)crossProjectDataProgressService, (String)"crossProjectDataProgressService");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)fx3Helper, (String)"fx3Helper");
        Intrinsics.checkNotNullParameter((Object)lithiumMigrationsHelper, (String)"lithiumMigrationsHelper");
        Intrinsics.checkNotNullParameter((Object)lithiumAppMigrationsHelper, (String)"lithiumAppMigrationsHelper");
        Intrinsics.checkNotNullParameter((Object)migrationExecutionCache, (String)"migrationExecutionCache");
        this.migrationExecutionService = migrationExecutionService;
        this.migrationRepository = migrationRepository;
        this.migrationIncrementRepository = migrationIncrementRepository;
        this.statusRetrievalService = statusRetrievalService;
        this.discoveryService = discoveryService;
        this.preflightService = preflightService;
        this.scheduledExecutionRepository = scheduledExecutionRepository;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.migrationFeatures = migrationFeatures;
        this.projectsReader = projectsReader;
        this.appsProgressService = appsProgressService;
        this.projectProgressBuilder = projectProgressBuilder;
        this.siteProgressBuilder = siteProgressBuilder;
        this.crossProjectDataProgressService = crossProjectDataProgressService;
        this.planRepository = planRepository;
        this.fx3Helper = fx3Helper;
        this.lithiumMigrationsHelper = lithiumMigrationsHelper;
        this.lithiumAppMigrationsHelper = lithiumAppMigrationsHelper;
        this.migrationExecutionCache = migrationExecutionCache;
        LoadingCache loadingCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<TaskList>>(this){
            final /* synthetic */ PlanExecutionService this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Optional<TaskList> load(@NotNull String migrationId) {
                TaskList taskList2;
                Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
                PlanExecutionService.access$getLog$cp().info("loading tasklist from MO for " + migrationId);
                CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(PlanExecutionService.access$getDiscoveryService$p(this.this$0), migrationId, false, 2, null);
                if (cloudSite2 != null) {
                    CloudSite cloudSite3 = cloudSite2;
                    PlanExecutionService planExecutionService = this.this$0;
                    CloudSite cloudSite4 = cloudSite3;
                    boolean bl = false;
                    taskList2 = PlanExecutionService.access$getStatusRetrievalService$p(planExecutionService).getAdaptedMigrationStatus(cloudSite4.getContainerToken(), migrationId).getCurrentStatus();
                } else {
                    taskList2 = null;
                }
                Optional<Object> optional = Optional.ofNullable(taskList2);
                Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
                return optional;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.migrationProgressCache = loadingCache;
    }

    @NotNull
    public final LoadingCache<String, Optional<TaskList>> getMigrationProgressCache() {
        return this.migrationProgressCache;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMigrationProgressCache$annotations() {
    }

    public final void scheduleClassicPlanExecution(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        this.fx3Helper.updateUserCustomAttributes(plan2);
        this.lithiumMigrationsHelper.evaluateAndMemorizeLithiumPlanProperties(plan2.getId());
        this.lithiumAppMigrationsHelper.memorizeLithiumAppMigrationProperties(plan2);
        if (plan2.isIncremental()) {
            throw new IllegalStateException("Incremental plan was started in a Classic execution mode".toString());
        }
        if (plan2.isLiftAndShift() && this.migrationFeatures.getDisableSinglePathMigration()) {
            throw new IllegalStateException("A lift and shift migration was started when disable.single-path.migrations feature flag is on".toString());
        }
        if (plan2.isManualImport() && !this.migrationFeatures.getEnableSinglePathManualIntervention()) {
            throw new IllegalStateException("Manual intervention mode is not enabled".toString());
        }
        if (plan2.isAppDataPreload() && !this.migrationFeatures.getEnableV4LithiumOrchestration()) {
            throw new IllegalArgumentException("App data preload mode is not enabled");
        }
        MigrationStatusCalculator.OverallMigrationStatus overallStatus = this.getClassicMigrationStatus(plan2).getOverallStatus();
        if (this.migrationFeatures.getEnableIncrementalMigrations() && overallStatus != MigrationStatusCalculator.OverallMigrationStatus.SAVED) {
            throw new IllegalStateException(("Plan " + plan2.getPlanName() + " with Id " + plan2.getId() + " cannot be run because it is in the " + overallStatus + " state.").toString());
        }
        String userKey = this.getLoggedUserKey();
        this.schedulePlanExecution(plan2, (Function0<Migration>)((Function0)new Function0<Migration>(this, plan2, userKey){
            final /* synthetic */ PlanExecutionService this$0;
            final /* synthetic */ Plan $plan;
            final /* synthetic */ String $userKey;
            {
                this.this$0 = $receiver;
                this.$plan = $plan;
                this.$userKey = $userKey;
                super(0);
            }

            @Nullable
            public final Migration invoke() {
                MigrationExecutionCache migrationExecutionCache = PlanExecutionService.access$getMigrationExecutionCache$p(this.this$0);
                String string = this.$plan.getId();
                String string2 = this.$userKey;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"$userKey");
                migrationExecutionCache.addUserKeyForPlanId(string, string2);
                MigrationExecutionService migrationExecutionService = PlanExecutionService.access$getMigrationExecutionService$p(this.this$0);
                String string3 = this.$plan.getId();
                String string4 = this.$userKey;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"$userKey");
                return migrationExecutionService.startClassicMigration(string3, string4);
            }
        }));
    }

    public final void scheduleIncrementalPlanExecution(@NotNull Plan plan2, boolean isFinalIncrement) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (!this.migrationFeatures.getEnableIncrementalMigrations()) {
            throw new IllegalStateException("Incremental Migrations feature must be enabled");
        }
        this.validateIncrementalPlanCanBeScheduled(plan2);
        String userKey = this.getLoggedUserKey();
        this.schedulePlanExecution(plan2, (Function0<Migration>)((Function0)new Function0<Migration>(this, plan2, userKey, isFinalIncrement){
            final /* synthetic */ PlanExecutionService this$0;
            final /* synthetic */ Plan $plan;
            final /* synthetic */ String $userKey;
            final /* synthetic */ boolean $isFinalIncrement;
            {
                this.this$0 = $receiver;
                this.$plan = $plan;
                this.$userKey = $userKey;
                this.$isFinalIncrement = $isFinalIncrement;
                super(0);
            }

            @Nullable
            public final Migration invoke() {
                MigrationExecutionService migrationExecutionService = PlanExecutionService.access$getMigrationExecutionService$p(this.this$0);
                String string = this.$plan.getId();
                String string2 = this.$userKey;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"$userKey");
                return migrationExecutionService.startIncrementalMigration(string, string2, this.$isFinalIncrement);
            }
        }));
    }

    @VisibleForTesting
    public final void schedulePlanExecution(@NotNull Plan plan2, @NotNull Function0<Migration> startMigrationFunction) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter(startMigrationFunction, (String)"startMigrationFunction");
        if (this.scheduledExecutionRepository.get(plan2.getId()) != null || this.migrationExecutionCache.isPlanInflight(plan2.getId())) {
            log.warn("Plan " + plan2.getId() + " has already been scheduled. Skipping re-scheduling the same plan.");
            return;
        }
        this.scheduledExecutionRepository.save(ScheduledExecution.Companion.scheduled(plan2.getId()));
        this.preflightService.executeChecksForPlan(plan2.getId(), CheckType.Companion.getEmptyCheckTypeSet(), CheckMode.Preflight2, (Function1<? super PreflightService.ExecutionResult, Unit>)((Function1)new Function1<PreflightService.ExecutionResult, Unit>(this, plan2, startMigrationFunction){
            final /* synthetic */ PlanExecutionService this$0;
            final /* synthetic */ Plan $plan;
            final /* synthetic */ Function0<Migration> $startMigrationFunction;
            {
                this.this$0 = $receiver;
                this.$plan = $plan;
                this.$startMigrationFunction = $startMigrationFunction;
                super(1);
            }

            public final void invoke(@NotNull PreflightService.ExecutionResult result2) {
                Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                try {
                    if (result2 == PreflightService.ExecutionResult.ALL_SUCCEEDED) {
                        PlanExecutionService.access$getPreflightService$p(this.this$0).deletePreflightCheckResult(this.$plan.getPreflightCheckExecutionId());
                        this.$startMigrationFunction.invoke();
                    }
                    PlanExecutionService.access$getScheduledExecutionRepository$p(this.this$0).remove(this.$plan.getId());
                }
                catch (Throwable e) {
                    PlanExecutionService.access$getLog$cp().error("Exception starting migration", e);
                    ScheduledExecutionRepository scheduledExecutionRepository = PlanExecutionService.access$getScheduledExecutionRepository$p(this.this$0);
                    String string = this.$plan.getId();
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = e.toString();
                    }
                    scheduledExecutionRepository.save(ScheduledExecution.Companion.failed(string, string2));
                }
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, plan2){
            final /* synthetic */ PlanExecutionService this$0;
            final /* synthetic */ Plan $plan;
            {
                this.this$0 = $receiver;
                this.$plan = $plan;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PlanExecutionService.access$getScheduledExecutionRepository$p(this.this$0).remove(this.$plan.getId());
            }
        }));
    }

    private final void validateIncrementalPlanCanBeScheduled(Plan plan2) {
        IncrementalMigrationStatusCalculator.OverallMigrationStatus overallStatus = this.getIncrementalMigrationStatus(plan2).getOverallStatus();
        if (!plan2.isIncremental()) {
            throw new IllegalStateException("An attempt to start a Classic plan in an Incremental execution mode");
        }
        if (overallStatus == IncrementalMigrationStatusCalculator.OverallMigrationStatus.SYNCING || overallStatus == IncrementalMigrationStatusCalculator.OverallMigrationStatus.FINAL_SYNC) {
            throw new IllegalStateException("Plan " + plan2.getPlanName() + " with Id " + plan2.getId() + " cannot be run because it is in the " + (Object)((Object)overallStatus) + " state.");
        }
        if (this.migrationIncrementRepository.hasFinalIncrement(plan2.getId())) {
            throw new IllegalStateException("The incremental migration has already had a cutoff");
        }
    }

    @Nullable
    public final PlanMigrationProgress getPlanMigrationProgress(@NotNull String planId) {
        PlanMigrationProgress planMigrationProgress;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Migration migration = this.migrationRepository.findLatestByPlanId(planId);
        if (migration != null) {
            Migration mig = migration;
            boolean bl = false;
            planMigrationProgress = new PlanMigrationProgress(mig.getStartMigrationContext(), mig.getOutcome() != null ? new TaskList(mig.getOutcome()) : (mig.getStatus() != null ? new TaskList(mig.getStatus().getStatus()) : (TaskList)((Optional)this.migrationProgressCache.get((Object)mig.getMigrationId())).orElse(null)));
        } else {
            planMigrationProgress = null;
        }
        return planMigrationProgress;
    }

    @Nullable
    public final ScheduledExecution getScheduledExecution(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        ScheduledExecution scheduledExecution = this.scheduledExecutionRepository.get(planId);
        if (scheduledExecution == null) {
            PlanExecutionService planExecutionService;
            PlanExecutionService it = planExecutionService = this;
            boolean bl = false;
            PlanExecutionService planExecutionService2 = this.migrationExecutionCache.isPlanInflight(planId) ? planExecutionService : null;
            if (planExecutionService2 != null) {
                it = planExecutionService2;
                boolean bl2 = false;
                scheduledExecution = ScheduledExecution.Companion.scheduled(planId);
            } else {
                scheduledExecution = null;
            }
        }
        return scheduledExecution;
    }

    private final String getLoggedUserKey() {
        return this.jiraAuthenticationContext.getLoggedInUser().getKey();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MigrationStatus getClassicMigrationStatus(@NotNull Plan plan2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        this.preflightService.setChecksToOverride(plan2.getPreflightCheckExecutionId(), plan2.getPreflightChecksToOverride());
        MigrationStatusCalculator.CoreMigrationStatus coreMigrationStatus = this.getCoreMigrationStatus(plan2);
        Iterable $this$map$iv = this.getAppProgress(plan2, coreMigrationStatus);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppProgress appProgress = (AppProgress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStatus());
        }
        Set appProgresses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        InfraProgress infraOptimisationProgress = this.getInfraOptimisationProgressStatus(plan2);
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus = MigrationStatusCalculator.calculateAndGetOverallStatus((MigrationStatusCalculator.CoreMigrationStatus)coreMigrationStatus, (Set)appProgresses);
        Intrinsics.checkNotNullExpressionValue((Object)overallMigrationStatus, (String)"calculateAndGetOverallStatus(...)");
        MigrationStatusCalculator.OverallAppMigrationStatus overallAppMigrationStatus = MigrationStatusCalculator.calculateAndGetOverallAppsStatus((Set)appProgresses);
        Intrinsics.checkNotNullExpressionValue((Object)overallAppMigrationStatus, (String)"calculateAndGetOverallAppsStatus(...)");
        return new MigrationStatus(overallMigrationStatus, overallAppMigrationStatus, coreMigrationStatus, infraOptimisationProgress);
    }

    @NotNull
    public final IncrementalMigrationStatus getIncrementalMigrationStatus(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        this.preflightService.setChecksToOverride(plan2.getPreflightCheckExecutionId(), plan2.getPreflightChecksToOverride());
        IncrementalMigrationStatusCalculator.CoreMigrationStatus coreMigrationStatus = this.getIncrementalCoreMigrationStatus(plan2);
        return new IncrementalMigrationStatus(IncrementalMigrationStatusCalculator.Companion.calculateAndGetOverallStatus(coreMigrationStatus), IncrementalMigrationStatusCalculator.Companion.calculateAndGetOverallAppsStatus(), coreMigrationStatus);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MigrationStatus getLiftAndShiftMigrationStatus(@NotNull Plan plan2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        this.preflightService.setChecksToOverride(plan2.getPreflightCheckExecutionId(), plan2.getPreflightChecksToOverride());
        MigrationStatusCalculator.CoreMigrationStatus coreMigrationStatus = this.getLiftAndShiftCoreMigrationStatus(plan2);
        Iterable $this$map$iv = this.getAppProgress(plan2, coreMigrationStatus);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppProgress appProgress = (AppProgress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStatus());
        }
        Set appProgresses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        InfraProgress infraOptimisationProgress = this.getInfraOptimisationProgressStatus(plan2);
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus = MigrationStatusCalculator.calculateAndGetOverallStatus((MigrationStatusCalculator.CoreMigrationStatus)coreMigrationStatus, (Set)appProgresses);
        Intrinsics.checkNotNullExpressionValue((Object)overallMigrationStatus, (String)"calculateAndGetOverallStatus(...)");
        MigrationStatusCalculator.OverallAppMigrationStatus overallAppMigrationStatus = MigrationStatusCalculator.calculateAndGetOverallAppsStatus((Set)appProgresses);
        Intrinsics.checkNotNullExpressionValue((Object)overallAppMigrationStatus, (String)"calculateAndGetOverallAppsStatus(...)");
        return new MigrationStatus(overallMigrationStatus, overallAppMigrationStatus, coreMigrationStatus, infraOptimisationProgress);
    }

    @NotNull
    public final MigrationStatusCalculator.CoreMigrationStatus getCoreMigrationStatus(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        PlanMigrationProgress planMigrationProgress = this.getPlanMigrationProgress(plan2.getId());
        return this.classicPlanStatus(this.preflightService.getStatus(plan2.getPreflightCheckExecutionId()), planMigrationProgress != null ? planMigrationProgress.getTaskList() : null, this.getScheduledExecution(plan2.getId()));
    }

    @NotNull
    public final IncrementalMigrationStatusCalculator.CoreMigrationStatus getIncrementalCoreMigrationStatus(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        PlanMigrationProgress planMigrationProgress = this.getPlanMigrationProgress(plan2.getId());
        return this.incrementalPlanStatus(this.preflightService.getStatus(plan2.getPreflightCheckExecutionId()), planMigrationProgress != null ? planMigrationProgress.getTaskList() : null, this.getScheduledExecution(plan2.getId()), this.migrationIncrementRepository.hasFinalIncrement(plan2.getId()));
    }

    @NotNull
    public final MigrationStatusCalculator.CoreMigrationStatus getLiftAndShiftCoreMigrationStatus(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        TaskList taskList2 = this.getSiteTaskList(plan2);
        return this.classicPlanStatus(this.preflightService.getStatus(plan2.getPreflightCheckExecutionId()), taskList2, this.getScheduledExecution(plan2.getId()));
    }

    @NotNull
    public final PlanProgress classicPlanDetailsProgress(@NotNull Plan plan2, @Nullable Integer projectOffset, @Nullable Integer projectLimit) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        return this.classicPlanDetailsProgress(plan2, this.preflightService.getStatus(plan2.getPreflightCheckExecutionId()), this.getScheduledExecution(plan2.getId()), this.getPlanMigrationProgress(plan2.getId()), projectOffset, projectLimit);
    }

    public static /* synthetic */ PlanProgress classicPlanDetailsProgress$default(PlanExecutionService planExecutionService, Plan plan2, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return planExecutionService.classicPlanDetailsProgress(plan2, n, n2);
    }

    @NotNull
    public final IncrementalPlanProgress incrementalPlanDetailsProgress(@NotNull Plan plan2, @Nullable Integer projectOffset, @Nullable Integer projectLimit) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        return this.incrementalPlanDetailsProgress(plan2, this.preflightService.getStatus(plan2.getPreflightCheckExecutionId()), this.getScheduledExecution(plan2.getId()), this.getPlanMigrationProgress(plan2.getId()), projectOffset, projectLimit);
    }

    public static /* synthetic */ IncrementalPlanProgress incrementalPlanDetailsProgress$default(PlanExecutionService planExecutionService, Plan plan2, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return planExecutionService.incrementalPlanDetailsProgress(plan2, n, n2);
    }

    @NotNull
    public final PlanProgress liftAndShiftPlanDetailsProgress(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        return this.liftAndShiftPlanDetailsProgress(plan2, this.preflightService.getStatus(plan2.getPreflightCheckExecutionId()), this.getScheduledExecution(plan2.getId()), this.getPlanMigrationProgress(plan2.getId()));
    }

    /*
     * WARNING - void declaration
     */
    private final PlanProgress liftAndShiftPlanDetailsProgress(Plan plan2, CheckExecutionStatus checkExecutionStatus, ScheduledExecution scheduledExecution, PlanMigrationProgress planMigrationProgress) {
        ChecksResultDto checksResultDto;
        void $this$mapTo$iv$iv;
        if (!plan2.isLiftAndShift()) {
            throw new IllegalArgumentException("An attempt to get 'Lift and Shift' progress for a plan that isn't of this type");
        }
        TaskList taskList2 = this.getSiteTaskList(plan2);
        MigrationStatusCalculator.CoreMigrationStatus coreMigrationStatus = this.classicPlanStatus(checkExecutionStatus, taskList2, scheduledExecution);
        List projectProgress = CollectionsKt.emptyList();
        EntityProgress advancedRoadmapsProgress = EntityProgress.Companion.getREADY();
        CrossProjectEntityProgress crossProjectEntityProgress = new CrossProjectEntityProgress(EntityProgress.Companion.getREADY(), EntityProgress.Companion.getREADY(), EntityProgress.Companion.getREADY());
        Set<AppProgress> appProgresses = this.getAppProgress(plan2, coreMigrationStatus);
        Iterable $this$map$iv = appProgresses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppProgress appProgress = (AppProgress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStatus());
        }
        Set appProgressStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus = MigrationStatusCalculator.calculateAndGetOverallStatus((MigrationStatusCalculator.CoreMigrationStatus)coreMigrationStatus, (Set)appProgressStatuses);
        InfraProgress infraOptimisation = this.getInfraOptimisationProgressStatus(plan2);
        Intrinsics.checkNotNull((Object)overallMigrationStatus);
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus2 = overallMigrationStatus;
        CheckExecutionStatus checkExecutionStatus2 = checkExecutionStatus;
        if (checkExecutionStatus2 != null) {
            void it;
            destination$iv$iv = checkExecutionStatus2;
            MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus3 = overallMigrationStatus2;
            boolean bl = false;
            checksResultDto = this.preflightService.toCheckResultDto((CheckExecutionStatus)it);
            overallMigrationStatus2 = overallMigrationStatus3;
        } else {
            checksResultDto = null;
        }
        PlanMigrationProgress planMigrationProgress2 = planMigrationProgress;
        UsersAndGroupsProgress usersAndGroupsProgress = this.getClassicUsersAndGroupsProgress(planMigrationProgress2 != null ? planMigrationProgress2.getTaskList() : null);
        PaginatedProjectProgressDto paginatedProjectProgressDto = this.getPaginatedClassicProjectProgress(projectProgress, null, null);
        PlanMigrationProgress planMigrationProgress3 = planMigrationProgress;
        PlanMigrationProgress planMigrationProgress4 = planMigrationProgress;
        List<GeneralTaskProgress> list = this.siteProgressBuilder.siteAndAttachmentProgress(plan2, planMigrationProgress3 != null ? planMigrationProgress3.getStartMigrationContext() : null, planMigrationProgress4 != null ? planMigrationProgress4.getTaskList() : null);
        SinglePathMode singlePathMode = plan2.getSinglePathMode();
        if (singlePathMode == null) {
            singlePathMode = SinglePathMode.LIFT_AND_SHIFT;
        }
        InfraProgress infraProgress = infraOptimisation;
        SinglePathMode singlePathMode2 = singlePathMode;
        List<GeneralTaskProgress> list2 = list;
        PaginatedProjectProgressDto paginatedProjectProgressDto2 = paginatedProjectProgressDto;
        Set<AppProgress> set = appProgresses;
        CrossProjectEntityProgress crossProjectEntityProgress2 = crossProjectEntityProgress;
        EntityProgress entityProgress = advancedRoadmapsProgress;
        List list3 = projectProgress;
        UsersAndGroupsProgress usersAndGroupsProgress2 = usersAndGroupsProgress;
        ChecksResultDto checksResultDto2 = checksResultDto;
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus4 = overallMigrationStatus2;
        return new PlanProgress(overallMigrationStatus4, checksResultDto2, usersAndGroupsProgress2, list3, entityProgress, crossProjectEntityProgress2, set, paginatedProjectProgressDto2, list2, singlePathMode2, infraProgress);
    }

    /*
     * WARNING - void declaration
     */
    private final PlanProgress classicPlanDetailsProgress(Plan plan2, CheckExecutionStatus checkExecutionStatus, ScheduledExecution scheduledExecution, PlanMigrationProgress planMigrationProgress, Integer projectOffset, Integer projectLimit) {
        ChecksResultDto checksResultDto;
        void $this$mapTo$iv$iv;
        PlanMigrationProgress planMigrationProgress2 = planMigrationProgress;
        PlanMigrationProgress planMigrationProgress3 = planMigrationProgress;
        List<ProjectProgress> projectProgress = this.classicProjectsProgress(plan2, planMigrationProgress2 != null ? planMigrationProgress2.getStartMigrationContext() : null, planMigrationProgress3 != null ? planMigrationProgress3.getTaskList() : null);
        List<Long> list = plan2.getAdvancedRoadmapsPlanIds();
        PlanMigrationProgress planMigrationProgress4 = planMigrationProgress;
        EntityProgress advancedRoadmapsProgress = this.advancedRoadMapsPlanProgress(list != null ? (long)list.size() : 0L, planMigrationProgress4 != null ? planMigrationProgress4.getTaskList() : null);
        PlanMigrationProgress planMigrationProgress5 = planMigrationProgress;
        CrossProjectEntityProgress crossProjectEntityProgress = this.crossProjectDataProgressService.getCrossProjectDataProgress(planMigrationProgress5 != null ? planMigrationProgress5.getTaskList() : null);
        PlanMigrationProgress planMigrationProgress6 = planMigrationProgress;
        MigrationStatusCalculator.CoreMigrationStatus coreMigrationStatus = this.classicPlanStatus(checkExecutionStatus, planMigrationProgress6 != null ? planMigrationProgress6.getTaskList() : null, scheduledExecution);
        Set<AppProgress> appProgresses = this.getAppProgress(plan2, coreMigrationStatus);
        Iterable $this$map$iv = appProgresses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppProgress appProgress = (AppProgress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStatus());
        }
        Set appProgressStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus = MigrationStatusCalculator.calculateAndGetOverallStatus((MigrationStatusCalculator.CoreMigrationStatus)coreMigrationStatus, (Set)appProgressStatuses);
        InfraProgress infraOptimisation = this.getInfraOptimisationProgressStatus(plan2);
        Intrinsics.checkNotNull((Object)overallMigrationStatus);
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus2 = overallMigrationStatus;
        CheckExecutionStatus checkExecutionStatus2 = checkExecutionStatus;
        if (checkExecutionStatus2 != null) {
            void it;
            destination$iv$iv = checkExecutionStatus2;
            MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus3 = overallMigrationStatus2;
            boolean bl = false;
            checksResultDto = this.preflightService.toCheckResultDto((CheckExecutionStatus)it);
            overallMigrationStatus2 = overallMigrationStatus3;
        } else {
            checksResultDto = null;
        }
        PlanMigrationProgress planMigrationProgress7 = planMigrationProgress;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 768;
        InfraProgress infraProgress = infraOptimisation;
        SinglePathMode singlePathMode = null;
        List list2 = null;
        PaginatedProjectProgressDto paginatedProjectProgressDto = this.getPaginatedClassicProjectProgress(projectProgress, projectOffset, projectLimit);
        Set<AppProgress> set = appProgresses;
        CrossProjectEntityProgress crossProjectEntityProgress2 = crossProjectEntityProgress;
        EntityProgress entityProgress = advancedRoadmapsProgress;
        List<ProjectProgress> list3 = projectProgress;
        UsersAndGroupsProgress usersAndGroupsProgress = this.getClassicUsersAndGroupsProgress(planMigrationProgress7 != null ? planMigrationProgress7.getTaskList() : null);
        ChecksResultDto checksResultDto2 = checksResultDto;
        MigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus4 = overallMigrationStatus2;
        return new PlanProgress(overallMigrationStatus4, checksResultDto2, usersAndGroupsProgress, list3, entityProgress, crossProjectEntityProgress2, set, paginatedProjectProgressDto, list2, singlePathMode, infraProgress, n, defaultConstructorMarker);
    }

    private final Set<AppProgress> getAppProgress(Plan plan2, MigrationStatusCalculator.CoreMigrationStatus coreMigrationStatus) {
        return this.appsProgressService.getAppProgress(plan2, coreMigrationStatus);
    }

    /*
     * WARNING - void declaration
     */
    private final IncrementalPlanProgress incrementalPlanDetailsProgress(Plan plan2, CheckExecutionStatus checkExecutionStatus, ScheduledExecution scheduledExecution, PlanMigrationProgress planMigrationProgress, Integer projectOffset, Integer projectLimit) {
        ChecksResultDto checksResultDto;
        IncrementalMigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus;
        boolean hasFinalIncrement = this.migrationIncrementRepository.hasFinalIncrement(plan2.getId());
        PlanMigrationProgress planMigrationProgress2 = planMigrationProgress;
        PlanMigrationProgress planMigrationProgress3 = planMigrationProgress;
        List<IncrementalProjectProgress> projectProgress = this.incrementalProjectsProgress(plan2, planMigrationProgress2 != null ? planMigrationProgress2.getStartMigrationContext() : null, hasFinalIncrement, planMigrationProgress3 != null ? planMigrationProgress3.getTaskList() : null);
        PlanMigrationProgress planMigrationProgress4 = planMigrationProgress;
        IncrementalMigrationStatusCalculator.CoreMigrationStatus coreMigrationStatus = this.incrementalPlanStatus(checkExecutionStatus, planMigrationProgress4 != null ? planMigrationProgress4.getTaskList() : null, scheduledExecution, hasFinalIncrement);
        IncrementalMigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus2 = overallMigrationStatus = IncrementalMigrationStatusCalculator.Companion.calculateAndGetOverallStatus(coreMigrationStatus);
        CheckExecutionStatus checkExecutionStatus2 = checkExecutionStatus;
        if (checkExecutionStatus2 != null) {
            void it;
            CheckExecutionStatus checkExecutionStatus3 = checkExecutionStatus2;
            IncrementalMigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus3 = overallMigrationStatus2;
            boolean bl = false;
            checksResultDto = this.preflightService.toCheckResultDto((CheckExecutionStatus)it);
            overallMigrationStatus2 = overallMigrationStatus3;
        } else {
            checksResultDto = null;
        }
        PlanMigrationProgress planMigrationProgress5 = planMigrationProgress;
        PaginatedIncrementalProjectProgressDto paginatedIncrementalProjectProgressDto = this.getPaginatedIncrementalProjectProgress(projectProgress, projectOffset, projectLimit);
        Set<IncrementalAppProgress> set = this.appsProgressService.getIncrementalAppProgress();
        IncrementalCrossProjectEntityProgress incrementalCrossProjectEntityProgress = IncrementalCrossProjectEntityProgress.Companion.getReady();
        IncrementalEntityProgress incrementalEntityProgress = IncrementalEntityProgress.Companion.getReady();
        List<IncrementalProjectProgress> list = projectProgress;
        IncrementalUsersAndGroupsProgress incrementalUsersAndGroupsProgress = this.getIncrementalUsersAndGroupsProgress(planMigrationProgress5 != null ? planMigrationProgress5.getTaskList() : null, hasFinalIncrement);
        ChecksResultDto checksResultDto2 = checksResultDto;
        IncrementalMigrationStatusCalculator.OverallMigrationStatus overallMigrationStatus4 = overallMigrationStatus2;
        return new IncrementalPlanProgress(overallMigrationStatus4, checksResultDto2, incrementalUsersAndGroupsProgress, list, incrementalEntityProgress, incrementalCrossProjectEntityProgress, set, paginatedIncrementalProjectProgressDto);
    }

    private final PaginatedProjectProgressDto getPaginatedClassicProjectProgress(List<ProjectProgress> projectProgressList, Integer projectOffset, Integer projectLimit) {
        Integer n = projectOffset;
        int safeOffset = n != null ? n : 0;
        Integer n2 = projectLimit;
        int safeLimit = n2 != null ? n2 : 20;
        List<ProjectProgress> paginatedProjectProgressDto = projectProgressList.subList(Math.min(safeOffset, projectProgressList.size()), Math.min(safeOffset + safeLimit, projectProgressList.size()));
        return new PaginatedProjectProgressDto(projectProgressList.size(), safeOffset, safeLimit, paginatedProjectProgressDto);
    }

    private final PaginatedIncrementalProjectProgressDto getPaginatedIncrementalProjectProgress(List<IncrementalProjectProgress> projectProgressList, Integer projectOffset, Integer projectLimit) {
        Integer n = projectOffset;
        int safeOffset = n != null ? n : 0;
        Integer n2 = projectLimit;
        int safeLimit = n2 != null ? n2 : 20;
        List<IncrementalProjectProgress> paginatedProjectProgressDto = projectProgressList.subList(Math.min(safeOffset, projectProgressList.size()), Math.min(safeOffset + safeLimit, projectProgressList.size()));
        return new PaginatedIncrementalProjectProgressDto(projectProgressList.size(), safeOffset, safeLimit, paginatedProjectProgressDto);
    }

    @VisibleForTesting
    @NotNull
    public final MigrationStatusCalculator.CoreMigrationStatus classicPlanStatus(@Nullable CheckExecutionStatus checkExecutionStatus, @Nullable TaskList taskList2, @Nullable ScheduledExecution scheduledExecution) {
        CheckExecutionStatus checkExecutionStatus2 = checkExecutionStatus;
        if (checkExecutionStatus2 != null) {
            boolean bl;
            block12: {
                CheckResultDto check;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                ChecksResultDto $this$classicPlanStatus_u24lambda_u2413_u24lambda_u2412;
                block11: {
                    ChecksResultDto checksResultDto;
                    CheckExecutionStatus it = checkExecutionStatus2;
                    boolean bl3 = false;
                    $this$classicPlanStatus_u24lambda_u2413_u24lambda_u2412 = checksResultDto = this.preflightService.toCheckResultDto(it);
                    boolean bl4 = false;
                    List list = $this$classicPlanStatus_u24lambda_u2413_u24lambda_u2412.getChecks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChecks(...)");
                    $this$any$iv = list;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            check = (CheckResultDto)element$iv;
                            boolean bl5 = false;
                            if (!(check.getStatus() == Status.RUNNING)) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return MigrationStatusCalculator.CoreMigrationStatus.VALIDATING;
                }
                List list = $this$classicPlanStatus_u24lambda_u2413_u24lambda_u2412.getChecks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChecks(...)");
                $this$any$iv = list;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        check = (CheckResultDto)element$iv;
                        boolean bl6 = false;
                        if (!(check.getStatus() == Status.ERROR)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return MigrationStatusCalculator.CoreMigrationStatus.SAVED_PREFLIGHT_ERROR;
            }
        }
        if (taskList2 != null) {
            TaskList $this$classicPlanStatus_u24lambda_u2414 = taskList2;
            boolean bl = false;
            return !$this$classicPlanStatus_u24lambda_u2414.isCompleted() ? MigrationStatusCalculator.CoreMigrationStatus.RUNNING : ($this$classicPlanStatus_u24lambda_u2414.isCompletedSuccessfully() ? MigrationStatusCalculator.CoreMigrationStatus.COMPLETE : ($this$classicPlanStatus_u24lambda_u2414.isCompletedWithSoftFailures() || $this$classicPlanStatus_u24lambda_u2414.findFirstIncompleteProgressItem() != null ? MigrationStatusCalculator.CoreMigrationStatus.INCOMPLETE : ($this$classicPlanStatus_u24lambda_u2414.isCompletedWithBlockingFailures() ? MigrationStatusCalculator.CoreMigrationStatus.FAILED : MigrationStatusCalculator.CoreMigrationStatus.FAILED)));
        }
        if (scheduledExecution != null) {
            ScheduledExecution $this$classicPlanStatus_u24lambda_u2415 = scheduledExecution;
            boolean bl = false;
            return $this$classicPlanStatus_u24lambda_u2415.isFailed() ? MigrationStatusCalculator.CoreMigrationStatus.FAILED : MigrationStatusCalculator.CoreMigrationStatus.RUNNING;
        }
        return MigrationStatusCalculator.CoreMigrationStatus.SAVED_READY;
    }

    public static /* synthetic */ MigrationStatusCalculator.CoreMigrationStatus classicPlanStatus$default(PlanExecutionService planExecutionService, CheckExecutionStatus checkExecutionStatus, TaskList taskList2, ScheduledExecution scheduledExecution, int n, Object object) {
        if ((n & 1) != 0) {
            checkExecutionStatus = null;
        }
        if ((n & 2) != 0) {
            taskList2 = null;
        }
        if ((n & 4) != 0) {
            scheduledExecution = null;
        }
        return planExecutionService.classicPlanStatus(checkExecutionStatus, taskList2, scheduledExecution);
    }

    @VisibleForTesting
    @NotNull
    public final IncrementalMigrationStatusCalculator.CoreMigrationStatus incrementalPlanStatus(@Nullable CheckExecutionStatus checkExecutionStatus, @Nullable TaskList taskList2, @Nullable ScheduledExecution scheduledExecution, boolean hasFinalIncrement) {
        CheckExecutionStatus checkExecutionStatus2 = checkExecutionStatus;
        if (checkExecutionStatus2 != null) {
            boolean bl;
            block12: {
                CheckResultDto check;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                ChecksResultDto $this$incrementalPlanStatus_u24lambda_u2419_u24lambda_u2418;
                block11: {
                    ChecksResultDto checksResultDto;
                    CheckExecutionStatus it = checkExecutionStatus2;
                    boolean bl3 = false;
                    $this$incrementalPlanStatus_u24lambda_u2419_u24lambda_u2418 = checksResultDto = this.preflightService.toCheckResultDto(it);
                    boolean bl4 = false;
                    List list = $this$incrementalPlanStatus_u24lambda_u2419_u24lambda_u2418.getChecks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChecks(...)");
                    $this$any$iv = list;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            check = (CheckResultDto)element$iv;
                            boolean bl5 = false;
                            if (!(check.getStatus() == Status.RUNNING)) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return IncrementalMigrationStatusCalculator.CoreMigrationStatus.VALIDATING;
                }
                List list = $this$incrementalPlanStatus_u24lambda_u2419_u24lambda_u2418.getChecks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChecks(...)");
                $this$any$iv = list;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        check = (CheckResultDto)element$iv;
                        boolean bl6 = false;
                        if (!(check.getStatus() == Status.ERROR)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return IncrementalMigrationStatusCalculator.CoreMigrationStatus.SAVED_PREFLIGHT_ERROR;
            }
        }
        if (taskList2 != null) {
            TaskList $this$incrementalPlanStatus_u24lambda_u2420 = taskList2;
            boolean bl = false;
            return !$this$incrementalPlanStatus_u24lambda_u2420.isCompleted() ? IncrementalMigrationStatusCalculator.CoreMigrationStatus.Companion.getSyncing(hasFinalIncrement) : ($this$incrementalPlanStatus_u24lambda_u2420.isCompletedSuccessfully() ? IncrementalMigrationStatusCalculator.CoreMigrationStatus.Companion.getComplete(hasFinalIncrement) : ($this$incrementalPlanStatus_u24lambda_u2420.isCompletedWithSoftFailures() || $this$incrementalPlanStatus_u24lambda_u2420.findFirstIncompleteProgressItem() != null ? IncrementalMigrationStatusCalculator.CoreMigrationStatus.Companion.getIncomplete(hasFinalIncrement) : ($this$incrementalPlanStatus_u24lambda_u2420.isCompletedWithBlockingFailures() ? IncrementalMigrationStatusCalculator.CoreMigrationStatus.Companion.getFailed(hasFinalIncrement) : IncrementalMigrationStatusCalculator.CoreMigrationStatus.Companion.getFailed(hasFinalIncrement))));
        }
        if (scheduledExecution != null) {
            ScheduledExecution $this$incrementalPlanStatus_u24lambda_u2421 = scheduledExecution;
            boolean bl = false;
            return $this$incrementalPlanStatus_u24lambda_u2421.isFailed() ? IncrementalMigrationStatusCalculator.CoreMigrationStatus.Companion.getFailed(hasFinalIncrement) : IncrementalMigrationStatusCalculator.CoreMigrationStatus.Companion.getSyncing(hasFinalIncrement);
        }
        return IncrementalMigrationStatusCalculator.CoreMigrationStatus.SAVED_READY;
    }

    public static /* synthetic */ IncrementalMigrationStatusCalculator.CoreMigrationStatus incrementalPlanStatus$default(PlanExecutionService planExecutionService, CheckExecutionStatus checkExecutionStatus, TaskList taskList2, ScheduledExecution scheduledExecution, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            checkExecutionStatus = null;
        }
        if ((n & 2) != 0) {
            taskList2 = null;
        }
        if ((n & 4) != 0) {
            scheduledExecution = null;
        }
        return planExecutionService.incrementalPlanStatus(checkExecutionStatus, taskList2, scheduledExecution, bl);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<ProjectProgress> classicProjectsProgress(@NotNull Plan plan2, @Nullable StartMigrationContext startMigrationContext, @Nullable TaskList tasks) {
        Iterable $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        GetTaskStatusResponse.TaskProgress it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (plan2.isIncremental()) {
            throw new IllegalArgumentException("An attempt to get classic projects progress for an incremental plan");
        }
        if (startMigrationContext == null || tasks == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = plan2.getProjectKeys();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ServerProject serverProject = this.projectsReader.getServerProjectByKey((String)it2);
                Intrinsics.checkNotNull((Object)serverProject);
                collection.add(ProjectProgress.Companion.ready(serverProject));
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$map$iv = tasks.getTaskProgressList();
        boolean $i$f$filter = false;
        void $this$mapTo$iv$iv = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!MigrationTaskType.Companion.getPROJECT_TASK_TYPES().contains((Object)it.getTask().getMigrationTaskType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            MigrationTask migrationTask = it.getTask();
            Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask");
            String key$iv$iv = ((ProjectTask)migrationTask).getProjectKey();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            List projectTaskProgresses = (List)entry.getValue();
            object.add(this.buildClassicProjectProgress(key, plan2, new TaskList(projectTaskProgresses), startMigrationContext));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List classicProjectsProgress$default(PlanExecutionService planExecutionService, Plan plan2, StartMigrationContext startMigrationContext, TaskList taskList2, int n, Object object) {
        if ((n & 4) != 0) {
            taskList2 = null;
        }
        return planExecutionService.classicProjectsProgress(plan2, startMigrationContext, taskList2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<IncrementalProjectProgress> incrementalProjectsProgress(@NotNull Plan plan2, @Nullable StartMigrationContext startMigrationContext, boolean hasFinalIncrement, @Nullable TaskList tasks) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        GetTaskStatusResponse.TaskProgress it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (!plan2.isIncremental()) {
            throw new IllegalArgumentException("An attempt to get incremental projects progress for a classic plan");
        }
        if (startMigrationContext == null || tasks == null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = plan2.getProjectKeys();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ServerProject serverProject = this.projectsReader.getServerProjectByKey((String)it2);
                Intrinsics.checkNotNull((Object)serverProject);
                collection.add(IncrementalProjectProgress.Companion.ready(serverProject));
            }
            return (List)destination$iv$iv;
        }
        boolean isPlanInTerminalStatus = IncrementalMigrationStatusCalculatorKt.isTerminal(this.getIncrementalMigrationStatus(plan2).getOverallStatus());
        Iterable $i$f$map = tasks.getTaskProgressList();
        boolean $i$f$filter = false;
        void destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!MigrationTaskType.Companion.getPROJECT_TASK_TYPES().contains((Object)it.getTask().getMigrationTaskType())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            MigrationTask migrationTask = it.getTask();
            Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask");
            String key$iv$iv = ((ProjectTask)migrationTask).getProjectKey();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv2;
            boolean bl = false;
            String key = (String)entry.getKey();
            List projectTaskProgresses = (List)entry.getValue();
            object.add(this.buildIncrementalProjectProgress(key, plan2, new TaskList(projectTaskProgresses), startMigrationContext, isPlanInTerminalStatus, hasFinalIncrement));
        }
        return (List)destination$iv$iv2;
    }

    public static /* synthetic */ List incrementalProjectsProgress$default(PlanExecutionService planExecutionService, Plan plan2, StartMigrationContext startMigrationContext, boolean bl, TaskList taskList2, int n, Object object) {
        if ((n & 8) != 0) {
            taskList2 = null;
        }
        return planExecutionService.incrementalProjectsProgress(plan2, startMigrationContext, bl, taskList2);
    }

    @VisibleForTesting
    @NotNull
    public final EntityProgress advancedRoadMapsPlanProgress(long selectedPlans, @Nullable TaskList tasks) {
        EntityCounts arPlanEntityCounts = new MigrationTaskStatus(tasks, false, null, null, 14, null).getCrossProjectEntityTypeCounts().get("jira/advancedroadmaps:plan");
        return CrossProjectEntityProgressUtil.INSTANCE.getCrossProjectEntityProgress(selectedPlans, tasks, arPlanEntityCounts);
    }

    public static /* synthetic */ EntityProgress advancedRoadMapsPlanProgress$default(PlanExecutionService planExecutionService, long l, TaskList taskList2, int n, Object object) {
        if ((n & 2) != 0) {
            taskList2 = null;
        }
        return planExecutionService.advancedRoadMapsPlanProgress(l, taskList2);
    }

    private final ProjectProgress buildClassicProjectProgress(String projectKey, Plan plan2, TaskList tasks, StartMigrationContext startMigrationContext) {
        Object object;
        Object object2;
        Boolean isArchived;
        Boolean bl;
        Object object3;
        Object projectName;
        Lazy backupProject$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ServerProject>(this, projectKey){
            final /* synthetic */ PlanExecutionService this$0;
            final /* synthetic */ String $projectKey;
            {
                this.this$0 = $receiver;
                this.$projectKey = $projectKey;
                super(0);
            }

            @Nullable
            public final ServerProject invoke() {
                return PlanExecutionService.access$getProjectsReader$p(this.this$0).getServerProjectByKey(this.$projectKey);
            }
        }));
        Object object4 = startMigrationContext.getProjectKeyToObj().get(projectKey);
        if (object4 == null || (object4 = ((ServerProject)object4).getName()) == null) {
            ServerProject serverProject = PlanExecutionService.buildClassicProjectProgress$lambda$30((Lazy<ServerProject>)backupProject$delegate);
            object4 = projectName = serverProject != null ? serverProject.getName() : null;
        }
        if ((object3 = startMigrationContext.getProjectKeyToObj().get(projectKey)) == null || (object3 = ((ServerProject)object3).getType()) == null) {
            ServerProject serverProject = PlanExecutionService.buildClassicProjectProgress$lambda$30((Lazy<ServerProject>)backupProject$delegate);
            object3 = serverProject != null ? serverProject.getType() : null;
        }
        Object projectType = object3;
        ServerProject serverProject = startMigrationContext.getProjectKeyToObj().get(projectKey);
        if (serverProject != null) {
            bl = serverProject.getArchived();
        } else {
            ServerProject serverProject2 = PlanExecutionService.buildClassicProjectProgress$lambda$30((Lazy<ServerProject>)backupProject$delegate);
            bl = isArchived = serverProject2 != null ? Boolean.valueOf(serverProject2.getArchived()) : null;
        }
        if (projectName == null || projectType == null || isArchived == null) {
            log.error("Unable to find Project for Project Key " + projectKey + " as it is most likely deleted in the server.");
        }
        ProjectProgressBuilder.ClassicProjectProgress classicMigrationProgress = this.projectProgressBuilder.getClassicProjectProgress(plan2, tasks);
        TaskStatus taskStatus = classicMigrationProgress.getTaskStatus();
        Object object5 = projectName;
        if (object5 == null) {
            object5 = object2 = projectKey + " (deleted in Server)";
        }
        if ((object = projectType) == null) {
            object = "Unknown";
        }
        Object object6 = object;
        Boolean bl2 = isArchived;
        boolean bl3 = bl2 != null ? bl2 : false;
        EntityProgress entityProgress = classicMigrationProgress.getDataProgress();
        EntityProgress entityProgress2 = classicMigrationProgress.getAttachmentProgress();
        EntityProgress entityProgress3 = classicMigrationProgress.getAppDataPreloadProgress();
        return new ProjectProgress(taskStatus, (String)object2, projectKey, (String)object6, bl3, entityProgress, entityProgress2, entityProgress3);
    }

    private final IncrementalProjectProgress buildIncrementalProjectProgress(String projectKey, Plan plan2, TaskList tasks, StartMigrationContext startMigrationContext, boolean isPlanInTerminalStatus, boolean hasFinalIncrement) {
        Object object;
        Object object2;
        Long projectId;
        Long l;
        Boolean bl;
        Object object3;
        Object projectName;
        Lazy backupProject$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ServerProject>(this, projectKey){
            final /* synthetic */ PlanExecutionService this$0;
            final /* synthetic */ String $projectKey;
            {
                this.this$0 = $receiver;
                this.$projectKey = $projectKey;
                super(0);
            }

            @Nullable
            public final ServerProject invoke() {
                return PlanExecutionService.access$getProjectsReader$p(this.this$0).getServerProjectByKey(this.$projectKey);
            }
        }));
        Object object4 = startMigrationContext.getProjectKeyToObj().get(projectKey);
        if (object4 == null || (object4 = ((ServerProject)object4).getName()) == null) {
            ServerProject serverProject = PlanExecutionService.buildIncrementalProjectProgress$lambda$31((Lazy<ServerProject>)backupProject$delegate);
            object4 = projectName = serverProject != null ? serverProject.getName() : null;
        }
        if ((object3 = startMigrationContext.getProjectKeyToObj().get(projectKey)) == null || (object3 = ((ServerProject)object3).getType()) == null) {
            ServerProject serverProject = PlanExecutionService.buildIncrementalProjectProgress$lambda$31((Lazy<ServerProject>)backupProject$delegate);
            object3 = serverProject != null ? serverProject.getType() : null;
        }
        Object projectType = object3;
        ServerProject serverProject = startMigrationContext.getProjectKeyToObj().get(projectKey);
        if (serverProject != null) {
            bl = serverProject.getArchived();
        } else {
            ServerProject serverProject2 = PlanExecutionService.buildIncrementalProjectProgress$lambda$31((Lazy<ServerProject>)backupProject$delegate);
            bl = serverProject2 != null ? Boolean.valueOf(serverProject2.getArchived()) : null;
        }
        Boolean isArchived = bl;
        ServerProject serverProject3 = startMigrationContext.getProjectKeyToObj().get(projectKey);
        if (serverProject3 != null) {
            l = serverProject3.getId();
        } else {
            ServerProject serverProject4 = PlanExecutionService.buildIncrementalProjectProgress$lambda$31((Lazy<ServerProject>)backupProject$delegate);
            l = projectId = serverProject4 != null ? Long.valueOf(serverProject4.getId()) : null;
        }
        if (projectName == null || projectType == null || isArchived == null || projectId == null) {
            log.error("Unable to find Project for Project Key " + projectKey + " as it is most likely deleted in the server.");
        }
        IncrementalEntityProgress projectData = this.projectProgressBuilder.getIncrementalProjectDataProgress(plan2, tasks, hasFinalIncrement);
        if (projectId != null && isPlanInTerminalStatus && IncrementalEntityStatusKt.isTerminal(projectData.getStatus())) {
            projectData = this.projectProgressBuilder.getOutstandingIncrementalMigrationProjectDataProgress(projectData, plan2.getId(), projectId);
        }
        IncrementalTaskStatus incrementalTaskStatus = this.projectProgressBuilder.getIncrementalTaskStatus(plan2, tasks, hasFinalIncrement);
        Object object5 = projectName;
        if (object5 == null) {
            object5 = object2 = projectKey + " (deleted in Server)";
        }
        if ((object = projectType) == null) {
            object = "Unknown";
        }
        Object object6 = object;
        Boolean bl2 = isArchived;
        boolean bl3 = bl2 != null ? bl2 : false;
        IncrementalEntityProgress incrementalEntityProgress = projectData;
        IncrementalEntityProgress incrementalEntityProgress2 = this.projectProgressBuilder.getIncrementalAttachmentProgress(tasks, hasFinalIncrement);
        return new IncrementalProjectProgress(incrementalTaskStatus, (String)object2, projectKey, (String)object6, bl3, incrementalEntityProgress, incrementalEntityProgress2);
    }

    @VisibleForTesting
    @NotNull
    public final UsersAndGroupsProgress getClassicUsersAndGroupsProgress(@Nullable TaskList tasks) {
        Map<ProgressUnit, ProgressItem> map;
        block29: {
            EntityProgress customerProgressStatus;
            block30: {
                block28: {
                    customerProgressStatus = this.getClassicMigrationCustomerProgress(tasks);
                    if (tasks != null) break block28;
                    map = UsersAndGroupsProgress.Companion.constructProgress(this.migrationFeatures.getEnableMembershipsProgress() ? UsersAndGroupsProgress.Companion.getREADY_WITH_MEMBERSHIP() : UsersAndGroupsProgress.Companion.getREADY(), customerProgressStatus);
                    break block29;
                }
                map = tasks.runningTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_UPLOAD);
                if (map == null) break block30;
                Map<ProgressUnit, ProgressItem> it = map;
                boolean bl = false;
                UsersAndGroupsProgress usersAndGroupsProgress = UsersAndGroupsProgress.Companion.constructProgress(this.migrationFeatures.getEnableMembershipsProgress() ? UsersAndGroupsProgress.Companion.getEXPORTING_WITH_MEMBERSHIP() : UsersAndGroupsProgress.Companion.getEXPORTING(), customerProgressStatus);
                map = usersAndGroupsProgress;
                if (usersAndGroupsProgress != null) break block29;
            }
            Map<ProgressUnit, ProgressItem> map2 = tasks.runningTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_MIGRATION);
            if (map2 != null) {
                Object object;
                Object object2;
                Map<ProgressUnit, ProgressItem> it = map2;
                boolean bl = false;
                Object object3 = it.get((Object)ProgressUnit.GROUP);
                if (object3 == null || (object3 = EntityStatusKt.toEntityProgress((ProgressItem)object3, EntityStatus.RUNNING_MIGRATING)) == null) {
                    object3 = EntityProgress.Companion.getREADY();
                }
                if ((object2 = it.get((Object)ProgressUnit.USER)) == null || (object2 = EntityStatusKt.toEntityProgress((ProgressItem)object2, EntityStatus.RUNNING_MIGRATING)) == null) {
                    object2 = EntityProgress.Companion.getREADY();
                }
                if (this.migrationFeatures.getEnableMembershipsProgress()) {
                    object = it.get((Object)ProgressUnit.MEMBERSHIP);
                    if (object == null || (object = EntityStatusKt.toEntityProgress((ProgressItem)object, EntityStatus.RUNNING_MIGRATING)) == null) {
                        object = EntityProgress.Companion.getREADY();
                    }
                } else {
                    object = null;
                }
                map = new UsersAndGroupsProgress(TaskStatus.RUNNING, (EntityProgress)object3, (EntityProgress)object2, customerProgressStatus, (EntityProgress)object);
            } else {
                Object object;
                Map<ProgressUnit, ProgressItem> map3 = tasks.completedTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_MIGRATION);
                if (map3 != null) {
                    Object object4;
                    Object object5;
                    Map<ProgressUnit, ProgressItem> it = map3;
                    boolean bl = false;
                    TaskStatus taskStatus = this.computeClassicMigrationCompletedTaskStatus(it.values());
                    Object object6 = it.get((Object)ProgressUnit.GROUP);
                    if (object6 == null || (object6 = EntityStatusKt.toEntityProgress$default((ProgressItem)object6, null, 1, null)) == null) {
                        object6 = EntityProgress.Companion.getREADY();
                    }
                    if ((object5 = it.get((Object)ProgressUnit.USER)) == null || (object5 = EntityStatusKt.toEntityProgress$default((ProgressItem)object5, null, 1, null)) == null) {
                        object5 = EntityProgress.Companion.getREADY();
                    }
                    if (this.migrationFeatures.getEnableMembershipsProgress()) {
                        object4 = it.get((Object)ProgressUnit.MEMBERSHIP);
                        if (object4 == null || (object4 = EntityStatusKt.toEntityProgress$default((ProgressItem)object4, null, 1, null)) == null) {
                            object4 = EntityProgress.Companion.getREADY();
                        }
                    } else {
                        object4 = null;
                    }
                    object = new UsersAndGroupsProgress(taskStatus, (EntityProgress)object6, (EntityProgress)object5, customerProgressStatus, (EntityProgress)object4);
                } else {
                    object = map = null;
                }
                if (object == null) {
                    Object object7;
                    Map<ProgressUnit, ProgressItem> map4 = tasks.completedTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_UPLOAD);
                    if (map4 != null) {
                        Map<ProgressUnit, ProgressItem> it = map4;
                        boolean bl = false;
                        TaskStatus status = this.computeClassicMigrationCompletedTaskStatus(it.values());
                        if (status == TaskStatus.COMPLETE) {
                            object7 = UsersAndGroupsProgress.Companion.constructProgress(this.migrationFeatures.getEnableMembershipsProgress() ? UsersAndGroupsProgress.Companion.getEXPORTING_WITH_MEMBERSHIP() : UsersAndGroupsProgress.Companion.getEXPORTING(), customerProgressStatus);
                        } else {
                            Object object8;
                            Object object9;
                            Object object10 = it.get((Object)ProgressUnit.GROUP);
                            if (object10 == null || (object10 = EntityStatusKt.toEntityProgress$default((ProgressItem)object10, null, 1, null)) == null) {
                                object10 = EntityProgress.Companion.getREADY();
                            }
                            if ((object9 = it.get((Object)ProgressUnit.USER)) == null || (object9 = EntityStatusKt.toEntityProgress$default((ProgressItem)object9, null, 1, null)) == null) {
                                object9 = EntityProgress.Companion.getREADY();
                            }
                            if (this.migrationFeatures.getEnableMembershipsProgress()) {
                                object8 = it.get((Object)ProgressUnit.MEMBERSHIP);
                                if (object8 == null || (object8 = EntityStatusKt.toEntityProgress$default((ProgressItem)object8, null, 1, null)) == null) {
                                    object8 = EntityProgress.Companion.getREADY();
                                }
                            } else {
                                object8 = null;
                            }
                            object7 = new UsersAndGroupsProgress(status, (EntityProgress)object10, (EntityProgress)object9, customerProgressStatus, (EntityProgress)object8);
                        }
                    } else {
                        object7 = map = null;
                    }
                    if (object7 == null) {
                        map = UsersAndGroupsProgress.Companion.constructProgress(this.migrationFeatures.getEnableMembershipsProgress() ? UsersAndGroupsProgress.Companion.getREADY_WITH_MEMBERSHIP() : UsersAndGroupsProgress.Companion.getREADY(), customerProgressStatus);
                    }
                }
            }
        }
        return map;
    }

    public static /* synthetic */ UsersAndGroupsProgress getClassicUsersAndGroupsProgress$default(PlanExecutionService planExecutionService, TaskList taskList2, int n, Object object) {
        if ((n & 1) != 0) {
            taskList2 = null;
        }
        return planExecutionService.getClassicUsersAndGroupsProgress(taskList2);
    }

    @VisibleForTesting
    @NotNull
    public final IncrementalUsersAndGroupsProgress getIncrementalUsersAndGroupsProgress(@Nullable TaskList tasks, boolean hasFinalIncrement) {
        IncrementalEntityProgress customerProgressStatus = this.getIncrementalMigrationCustomerProgress(tasks, hasFinalIncrement);
        return tasks == null ? IncrementalUsersAndGroupsProgress.Companion.constructProgress(IncrementalUsersAndGroupsProgress.Companion.getReady(), customerProgressStatus) : this.getIncrementalUsersAndGroupsProgressFromTaskList(tasks, hasFinalIncrement, customerProgressStatus);
    }

    public static /* synthetic */ IncrementalUsersAndGroupsProgress getIncrementalUsersAndGroupsProgress$default(PlanExecutionService planExecutionService, TaskList taskList2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            taskList2 = null;
        }
        return planExecutionService.getIncrementalUsersAndGroupsProgress(taskList2, bl);
    }

    private final IncrementalUsersAndGroupsProgress getIncrementalUsersAndGroupsProgressFromTaskList(TaskList tasks, boolean hasFinalIncrement, IncrementalEntityProgress customerProgressStatus) {
        Map<ProgressUnit, ProgressItem> map;
        block5: {
            block4: {
                map = tasks.runningTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_UPLOAD);
                if (map == null) break block4;
                Map<ProgressUnit, ProgressItem> it = map;
                boolean bl = false;
                IncrementalUsersAndGroupsProgress incrementalUsersAndGroupsProgress = IncrementalUsersAndGroupsProgress.Companion.constructProgress(IncrementalUsersAndGroupsProgress.Companion.getSyncing(hasFinalIncrement), customerProgressStatus);
                map = incrementalUsersAndGroupsProgress;
                if (incrementalUsersAndGroupsProgress != null) break block5;
            }
            if ((map = this.getRunningTaskProgressForUsersAndGroupsDataMigration(tasks, hasFinalIncrement, customerProgressStatus)) == null && (map = this.getCompletedTaskProgressForUsersAndGroupsDataMigration(tasks, hasFinalIncrement, customerProgressStatus)) == null && (map = this.getCompletedTaskProgressForUsersAndGroupsDataUpload(tasks, hasFinalIncrement, customerProgressStatus)) == null) {
                map = IncrementalUsersAndGroupsProgress.Companion.constructProgress(IncrementalUsersAndGroupsProgress.Companion.getReady(), customerProgressStatus);
            }
        }
        return map;
    }

    private final IncrementalUsersAndGroupsProgress getCompletedTaskProgressForUsersAndGroupsDataUpload(TaskList tasks, boolean hasFinalIncrement, IncrementalEntityProgress customerProgressStatus) {
        IncrementalUsersAndGroupsProgress incrementalUsersAndGroupsProgress;
        Map<ProgressUnit, ProgressItem> map = tasks.completedTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_UPLOAD);
        if (map != null) {
            Map<ProgressUnit, ProgressItem> it = map;
            boolean bl = false;
            IncrementalTaskStatus status = this.computeIncrementalMigrationCompletedTaskStatus(it.values(), hasFinalIncrement);
            if (status == IncrementalTaskStatus.Companion.getComplete(hasFinalIncrement)) {
                incrementalUsersAndGroupsProgress = IncrementalUsersAndGroupsProgress.Companion.constructProgress(IncrementalUsersAndGroupsProgress.Companion.getSyncing(hasFinalIncrement), customerProgressStatus);
            } else {
                Object object;
                Object object2 = it.get((Object)ProgressUnit.GROUP);
                if (object2 == null || (object2 = IncrementalEntityStatusKt.toIncrementalEntityProgress$default((ProgressItem)object2, hasFinalIncrement, null, 2, null)) == null) {
                    object2 = IncrementalEntityProgress.Companion.getReady();
                }
                if ((object = it.get((Object)ProgressUnit.USER)) == null || (object = IncrementalEntityStatusKt.toIncrementalEntityProgress$default((ProgressItem)object, hasFinalIncrement, null, 2, null)) == null) {
                    object = IncrementalEntityProgress.Companion.getReady();
                }
                incrementalUsersAndGroupsProgress = new IncrementalUsersAndGroupsProgress(status, (IncrementalEntityProgress)object2, (IncrementalEntityProgress)object, customerProgressStatus);
            }
        } else {
            incrementalUsersAndGroupsProgress = null;
        }
        return incrementalUsersAndGroupsProgress;
    }

    private final IncrementalUsersAndGroupsProgress getCompletedTaskProgressForUsersAndGroupsDataMigration(TaskList tasks, boolean hasFinalIncrement, IncrementalEntityProgress customerProgressStatus) {
        IncrementalUsersAndGroupsProgress incrementalUsersAndGroupsProgress;
        Map<ProgressUnit, ProgressItem> map = tasks.completedTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_MIGRATION);
        if (map != null) {
            Object object;
            Map<ProgressUnit, ProgressItem> it = map;
            boolean bl = false;
            IncrementalTaskStatus incrementalTaskStatus = this.computeIncrementalMigrationCompletedTaskStatus(it.values(), hasFinalIncrement);
            Object object2 = it.get((Object)ProgressUnit.GROUP);
            if (object2 == null || (object2 = IncrementalEntityStatusKt.toIncrementalEntityProgress$default((ProgressItem)object2, hasFinalIncrement, null, 2, null)) == null) {
                object2 = IncrementalEntityProgress.Companion.getReady();
            }
            if ((object = it.get((Object)ProgressUnit.USER)) == null || (object = IncrementalEntityStatusKt.toIncrementalEntityProgress$default((ProgressItem)object, hasFinalIncrement, null, 2, null)) == null) {
                object = IncrementalEntityProgress.Companion.getReady();
            }
            incrementalUsersAndGroupsProgress = new IncrementalUsersAndGroupsProgress(incrementalTaskStatus, (IncrementalEntityProgress)object2, (IncrementalEntityProgress)object, customerProgressStatus);
        } else {
            incrementalUsersAndGroupsProgress = null;
        }
        return incrementalUsersAndGroupsProgress;
    }

    private final TaskList getSiteTaskList(Plan plan2) {
        Object object = this.getPlanMigrationProgress(plan2.getId());
        if (object == null || (object = ((PlanMigrationProgress)object).getTaskList()) == null) {
            return null;
        }
        Object taskList2 = object;
        List<GetTaskStatusResponse.TaskProgress> filteredTaskList = LiftAndShiftTaskUtil.INSTANCE.filterStageTasks(((TaskList)taskList2).getTaskProgressList());
        return new TaskList(filteredTaskList);
    }

    private final IncrementalUsersAndGroupsProgress getRunningTaskProgressForUsersAndGroupsDataMigration(TaskList tasks, boolean hasFinalIncrement, IncrementalEntityProgress customerProgressStatus) {
        IncrementalUsersAndGroupsProgress incrementalUsersAndGroupsProgress;
        Map<ProgressUnit, ProgressItem> map = tasks.runningTaskProgressFor(MigrationTaskType.USERS_GRPS_DATA_MIGRATION);
        if (map != null) {
            Object object;
            Map<ProgressUnit, ProgressItem> it = map;
            boolean bl = false;
            IncrementalTaskStatus incrementalTaskStatus = IncrementalTaskStatus.Companion.getSyncing(hasFinalIncrement);
            Object object2 = it.get((Object)ProgressUnit.GROUP);
            if (object2 == null || (object2 = IncrementalEntityStatusKt.toIncrementalEntityProgress((ProgressItem)object2, hasFinalIncrement, IncrementalEntityStatus.Companion.getSyncing(hasFinalIncrement))) == null) {
                object2 = IncrementalEntityProgress.Companion.getReady();
            }
            if ((object = it.get((Object)ProgressUnit.USER)) == null || (object = IncrementalEntityStatusKt.toIncrementalEntityProgress((ProgressItem)object, hasFinalIncrement, IncrementalEntityStatus.Companion.getSyncing(hasFinalIncrement))) == null) {
                object = IncrementalEntityProgress.Companion.getReady();
            }
            incrementalUsersAndGroupsProgress = new IncrementalUsersAndGroupsProgress(incrementalTaskStatus, (IncrementalEntityProgress)object2, (IncrementalEntityProgress)object, customerProgressStatus);
        } else {
            incrementalUsersAndGroupsProgress = null;
        }
        return incrementalUsersAndGroupsProgress;
    }

    @VisibleForTesting
    @Nullable
    public final EntityProgress getClassicMigrationCustomerProgress(@Nullable TaskList tasks) {
        Object object;
        block17: {
            block18: {
                block16: {
                    if (tasks != null) break block16;
                    object = EntityProgress.Companion.getREADY();
                    break block17;
                }
                object = tasks.runningTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_UPLOAD);
                if (object == null) break block18;
                Map<ProgressUnit, ProgressItem> it = object;
                boolean bl = false;
                EntityProgress entityProgress = EntityProgress.Companion.getEXPORTING();
                object = entityProgress;
                if (entityProgress != null) break block17;
            }
            Map<ProgressUnit, ProgressItem> map = tasks.runningTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_MIGRATION);
            if (map != null) {
                Map<ProgressUnit, ProgressItem> it = map;
                boolean bl = false;
                object = it.get((Object)ProgressUnit.CUSTOMER);
                if (object == null || (object = EntityStatusKt.toEntityProgress((ProgressItem)object, EntityStatus.RUNNING_MIGRATING)) == null) {
                    object = EntityProgress.Companion.getREADY();
                }
            } else {
                Object object2;
                Object it;
                Map<ProgressUnit, ProgressItem> map2 = tasks.completedTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_MIGRATION);
                if (map2 != null) {
                    it = map2;
                    boolean bl = false;
                    object2 = it.get((Object)ProgressUnit.CUSTOMER);
                    if (object2 == null || (object2 = EntityStatusKt.toEntityProgress$default((ProgressItem)object2, null, 1, null)) == null) {
                        object2 = EntityProgress.Companion.getREADY();
                    }
                } else {
                    object2 = object = null;
                }
                if (object2 == null) {
                    Object object3;
                    Map<ProgressUnit, ProgressItem> map3 = tasks.completedTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_UPLOAD);
                    if (map3 != null) {
                        Map<ProgressUnit, ProgressItem> it2 = map3;
                        boolean bl = false;
                        TaskStatus status = this.computeClassicMigrationCompletedTaskStatus(it2.values());
                        if (status == TaskStatus.COMPLETE) {
                            object3 = EntityProgress.Companion.getEXPORTING();
                        } else {
                            object3 = it2.get((Object)ProgressUnit.CUSTOMER);
                            if (object3 == null || (object3 = EntityStatusKt.toEntityProgress$default((ProgressItem)object3, null, 1, null)) == null) {
                                object3 = EntityProgress.Companion.getREADY();
                            }
                        }
                    } else {
                        object3 = object = null;
                    }
                    if (object3 == null) {
                        EntityProgress entityProgress = EntityProgress.Companion.getREADY();
                        it = entityProgress;
                        boolean bl = false;
                        object = tasks.hasTaskForCustomer() ? entityProgress : null;
                    }
                }
            }
        }
        return object;
    }

    public static /* synthetic */ EntityProgress getClassicMigrationCustomerProgress$default(PlanExecutionService planExecutionService, TaskList taskList2, int n, Object object) {
        if ((n & 1) != 0) {
            taskList2 = null;
        }
        return planExecutionService.getClassicMigrationCustomerProgress(taskList2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @Nullable
    public final IncrementalEntityProgress getIncrementalMigrationCustomerProgress(@Nullable TaskList tasks, boolean hasFinalIncrement) {
        Object object;
        Object it;
        Object object2;
        block12: {
            block11: {
                Object object3;
                if (tasks == null) {
                    object2 = IncrementalEntityProgress.Companion.getReady();
                    return object2;
                }
                Map<ProgressUnit, ProgressItem> map = tasks.runningTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_UPLOAD);
                if (map != null) {
                    Map<ProgressUnit, ProgressItem> it2 = map;
                    boolean bl = false;
                    IncrementalEntityProgress incrementalEntityProgress = IncrementalEntityProgress.Companion.getSyncing(hasFinalIncrement);
                    if (incrementalEntityProgress != null) {
                        object2 = incrementalEntityProgress;
                        return object2;
                    }
                }
                Map<ProgressUnit, ProgressItem> map2 = tasks.runningTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_MIGRATION);
                if (map2 != null) {
                    Map<ProgressUnit, ProgressItem> it3 = map2;
                    boolean bl = false;
                    object2 = it3.get((Object)ProgressUnit.CUSTOMER);
                    if (object2 != null) {
                        IncrementalEntityProgress incrementalEntityProgress = IncrementalEntityStatusKt.toIncrementalEntityProgress((ProgressItem)object2, hasFinalIncrement, IncrementalEntityStatus.Companion.getSyncing(hasFinalIncrement));
                        object2 = incrementalEntityProgress;
                        if (incrementalEntityProgress != null) return object2;
                    }
                    object2 = IncrementalEntityProgress.Companion.getReady();
                    return object2;
                }
                Map<ProgressUnit, ProgressItem> map3 = tasks.completedTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_MIGRATION);
                if (map3 != null) {
                    it = map3;
                    boolean bl = false;
                    object3 = it.get((Object)ProgressUnit.CUSTOMER);
                    if (object3 == null || (object3 = IncrementalEntityStatusKt.toIncrementalEntityProgress$default((ProgressItem)object3, hasFinalIncrement, null, 2, null)) == null) {
                        object3 = IncrementalEntityProgress.Companion.getReady();
                    }
                } else {
                    object3 = null;
                }
                object2 = object3;
                if (object3 != null) return object2;
                Map<ProgressUnit, ProgressItem> map4 = tasks.completedTaskProgressFor(MigrationTaskType.CUSTOMERS_DATA_UPLOAD);
                if (map4 == null) break block11;
                Map<ProgressUnit, ProgressItem> it4 = map4;
                boolean bl = false;
                IncrementalTaskStatus status = this.computeIncrementalMigrationCompletedTaskStatus(it4.values(), hasFinalIncrement);
                if (status == IncrementalTaskStatus.Companion.getComplete(hasFinalIncrement)) {
                    object = IncrementalEntityProgress.Companion.getSyncing(hasFinalIncrement);
                    break block12;
                } else {
                    object = it4.get((Object)ProgressUnit.CUSTOMER);
                    if (object == null || (object = IncrementalEntityStatusKt.toIncrementalEntityProgress$default((ProgressItem)object, hasFinalIncrement, null, 2, null)) == null) {
                        object = IncrementalEntityProgress.Companion.getReady();
                    }
                }
                break block12;
            }
            object = null;
        }
        object2 = object;
        if (object != null) return object2;
        IncrementalEntityProgress incrementalEntityProgress = IncrementalEntityProgress.Companion.getReady();
        it = incrementalEntityProgress;
        boolean bl = false;
        if (!tasks.hasTaskForCustomer()) return null;
        object2 = incrementalEntityProgress;
        return object2;
    }

    public static /* synthetic */ IncrementalEntityProgress getIncrementalMigrationCustomerProgress$default(PlanExecutionService planExecutionService, TaskList taskList2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            taskList2 = null;
        }
        return planExecutionService.getIncrementalMigrationCustomerProgress(taskList2, bl);
    }

    @VisibleForTesting
    @NotNull
    public final TaskStatus computeClassicMigrationCompletedTaskStatus(@NotNull Collection<ProgressItem> items) {
        TaskStatus taskStatus;
        ProgressItem it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block13: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            $this$any$iv = items;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ProgressItem)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCompletionStatus() == TaskCompletionStatus.FAILURE)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            taskStatus = TaskStatus.FAILED;
        } else {
            boolean bl3;
            block14: {
                $this$any$iv = items;
                $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ProgressItem)element$iv;
                        boolean bl4 = false;
                        if (!(it.getCompletionStatus() == TaskCompletionStatus.INCOMPLETE)) continue;
                        bl3 = true;
                        break block14;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                taskStatus = TaskStatus.INCOMPLETE;
            } else {
                boolean bl5;
                block15: {
                    Iterable $this$all$iv = items;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (ProgressItem)element$iv;
                            boolean bl6 = false;
                            if (it.getCompletionStatus() == TaskCompletionStatus.SUCCESS) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                taskStatus = bl5 ? TaskStatus.COMPLETE : TaskStatus.UNKNOWN;
            }
        }
        return taskStatus;
    }

    @VisibleForTesting
    @NotNull
    public final IncrementalTaskStatus computeIncrementalMigrationCompletedTaskStatus(@NotNull Collection<ProgressItem> items, boolean hasFinalIncrement) {
        IncrementalTaskStatus incrementalTaskStatus;
        ProgressItem it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block13: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            $this$any$iv = items;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ProgressItem)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCompletionStatus() == TaskCompletionStatus.FAILURE)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            incrementalTaskStatus = IncrementalTaskStatus.Companion.getFailed(hasFinalIncrement);
        } else {
            boolean bl3;
            block14: {
                $this$any$iv = items;
                $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ProgressItem)element$iv;
                        boolean bl4 = false;
                        if (!(it.getCompletionStatus() == TaskCompletionStatus.INCOMPLETE)) continue;
                        bl3 = true;
                        break block14;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                incrementalTaskStatus = IncrementalTaskStatus.Companion.getIncomplete(hasFinalIncrement);
            } else {
                boolean bl5;
                block15: {
                    Iterable $this$all$iv = items;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (ProgressItem)element$iv;
                            boolean bl6 = false;
                            if (it.getCompletionStatus() == TaskCompletionStatus.SUCCESS) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                incrementalTaskStatus = bl5 ? IncrementalTaskStatus.Companion.getComplete(hasFinalIncrement) : IncrementalTaskStatus.UNKNOWN;
            }
        }
        return incrementalTaskStatus;
    }

    @Nullable
    public final List<Plan> getInProgressPlans() {
        return this.planRepository.list().stream().filter(arg_0 -> PlanExecutionService.getInProgressPlans$lambda$56((Function1)new Function1<Plan, Boolean>(this){
            final /* synthetic */ PlanExecutionService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Plan it) {
                Intrinsics.checkNotNull((Object)it);
                return this.this$0.getClassicMigrationStatus(it).getOverallStatus() == MigrationStatusCalculator.OverallMigrationStatus.RUNNING;
            }
        }, arg_0)).collect(Collectors.toList());
    }

    @Nullable
    public final InfraProgress getInfraOptimisationProgressStatus(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        InfraStatus infraOptimisationStatus = plan2.getInfraOptimisationStatus();
        if (infraOptimisationStatus == null) {
            return (InfraProgress)((Object)infraOptimisationStatus);
        }
        return InfraStatus.NOT_RUNNING.equals((Object)infraOptimisationStatus) ? new InfraProgress(InfraStatus.NOT_RUNNING) : new InfraProgress(InfraStatus.RUNNING);
    }

    private static final ServerProject buildClassicProjectProgress$lambda$30(Lazy<ServerProject> $backupProject$delegate) {
        Lazy<ServerProject> lazy = $backupProject$delegate;
        return (ServerProject)lazy.getValue();
    }

    private static final ServerProject buildIncrementalProjectProgress$lambda$31(Lazy<ServerProject> $backupProject$delegate) {
        Lazy<ServerProject> lazy = $backupProject$delegate;
        return (ServerProject)lazy.getValue();
    }

    private static final boolean getInProgressPlans$lambda$56(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ MigrationExecutionCache access$getMigrationExecutionCache$p(PlanExecutionService $this) {
        return $this.migrationExecutionCache;
    }

    public static final /* synthetic */ MigrationExecutionService access$getMigrationExecutionService$p(PlanExecutionService $this) {
        return $this.migrationExecutionService;
    }

    public static final /* synthetic */ PreflightService access$getPreflightService$p(PlanExecutionService $this) {
        return $this.preflightService;
    }

    public static final /* synthetic */ ScheduledExecutionRepository access$getScheduledExecutionRepository$p(PlanExecutionService $this) {
        return $this.scheduledExecutionRepository;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ ProjectsReader access$getProjectsReader$p(PlanExecutionService $this) {
        return $this.projectsReader;
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(PlanExecutionService $this) {
        return $this.discoveryService;
    }

    public static final /* synthetic */ StatusRetrievalService access$getStatusRetrievalService$p(PlanExecutionService $this) {
        return $this.statusRetrievalService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/execution/PlanExecutionService$Companion;", "", "()V", "DEFAULT_PROJECT_LIMIT", "", "DEFAULT_PROJECT_OFFSET", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

