/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.execution.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0007R*\u0010\u0005\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache;", "", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "(Lcom/atlassian/cache/CacheManager;)V", "inflightPlansCache", "Lcom/atlassian/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "migrationCreatedByUserCache", "addInFlightPlanKey", "", "planId", "addUserKeyForPlanId", "userKey", "getUserKeyForPlanId", "isPlanInflight", "", "Companion", "UserKeyDoesNotExistForPlan", "jira-migration-plugin"})
public final class MigrationExecutionCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<String, String> migrationCreatedByUserCache;
    @NotNull
    private final Cache<String, Long> inflightPlansCache;
    private static final Logger log = LoggerFactory.getLogger(Companion.getClass());
    @NotNull
    private static final String CACHE_NAME = MigrationExecutionCache.class.getName() + "-MIGRATION_CREATED_BY_USER_CACHE";
    @NotNull
    private static final String CACHE_NAME_INFLIGHT_PLANS = Companion.getClass().getName() + ".plans";
    private static final long CACHE_EXPIRY_THIRTY_MINUTES = 30L;
    @NotNull
    private static final CacheSettings CACHE_SETTING;

    @Inject
    public MigrationExecutionCache(@NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Cache cache2 = cacheManager.getCache(CACHE_NAME, null, CACHE_SETTING);
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.migrationCreatedByUserCache = cache2;
        Cache cache3 = cacheManager.getCache(CACHE_NAME_INFLIGHT_PLANS, null, CACHE_SETTING);
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"getCache(...)");
        this.inflightPlansCache = cache3;
    }

    public final void addUserKeyForPlanId(@NotNull String planId, @NotNull String userKey) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        this.migrationCreatedByUserCache.put((Object)planId, (Object)userKey);
        log.info("added userKey = " + userKey + " to cache for planId = " + planId);
    }

    @NotNull
    public final String getUserKeyForPlanId(@NotNull String planId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        String string2 = (String)this.migrationCreatedByUserCache.get((Object)planId);
        if (string2 == null) {
            throw new UserKeyDoesNotExistForPlan(planId);
        }
        String it = string = string2;
        boolean bl = false;
        log.info("returning userKey = " + it + " from cache for planId = " + planId);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addInFlightPlanKey(@NotNull String planId) {
        void it;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Long l = System.currentTimeMillis();
        long l2 = ((Number)l).longValue();
        String string = planId;
        Cache<String, Long> cache2 = this.inflightPlansCache;
        boolean bl = false;
        log.info("Adding new planId = " + planId + " to cache at timeStamp = " + (long)it);
        Unit unit = Unit.INSTANCE;
        cache2.put((Object)string, (Object)l);
    }

    public final boolean isPlanInflight(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        return this.inflightPlansCache.containsKey((Object)planId);
    }

    static {
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).replicateViaCopy().remote().build();
        Intrinsics.checkNotNullExpressionValue((Object)cacheSettings, (String)"build(...)");
        CACHE_SETTING = cacheSettings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache$Companion;", "", "()V", "CACHE_EXPIRY_THIRTY_MINUTES", "", "CACHE_NAME", "", "CACHE_NAME_INFLIGHT_PLANS", "CACHE_SETTING", "Lcom/atlassian/cache/CacheSettings;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache$UserKeyDoesNotExistForPlan;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "planId", "", "(Ljava/lang/String;)V", "getPlanId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class UserKeyDoesNotExistForPlan
    extends Exception {
        @NotNull
        private final String planId;

        public UserKeyDoesNotExistForPlan(@NotNull String planId) {
            Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
            super("User key does not exist for planId = " + planId);
            this.planId = planId;
        }

        @NotNull
        public final String getPlanId() {
            return this.planId;
        }

        @NotNull
        public final String component1() {
            return this.planId;
        }

        @NotNull
        public final UserKeyDoesNotExistForPlan copy(@NotNull String planId) {
            Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
            return new UserKeyDoesNotExistForPlan(planId);
        }

        public static /* synthetic */ UserKeyDoesNotExistForPlan copy$default(UserKeyDoesNotExistForPlan userKeyDoesNotExistForPlan, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = userKeyDoesNotExistForPlan.planId;
            }
            return userKeyDoesNotExistForPlan.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "UserKeyDoesNotExistForPlan(planId=" + this.planId + ')';
        }

        public int hashCode() {
            return this.planId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserKeyDoesNotExistForPlan)) {
                return false;
            }
            UserKeyDoesNotExistForPlan userKeyDoesNotExistForPlan = (UserKeyDoesNotExistForPlan)other;
            return Intrinsics.areEqual((Object)this.planId, (Object)userKeyDoesNotExistForPlan.planId);
        }
    }
}

