/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.execution.utils;

import com.atlassian.jira.migration.execution.utils.EntityMigrationStatusUtil;
import com.atlassian.jira.migration.execution.utils.EntityProgressStatusUtil;
import com.atlassian.jira.migration.orchestratorclient.tasks.EntityCounts;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.progress.EntityProgress;
import com.atlassian.jira.migration.progress.EntityStatus;
import com.atlassian.jira.migration.progress.TaskList;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/execution/utils/CrossProjectEntityProgressUtil;", "", "()V", "getCrossProjectEntityProgress", "Lcom/atlassian/jira/migration/progress/EntityProgress;", "selectedCrossProjectEntityCount", "", "tasks", "Lcom/atlassian/jira/migration/progress/TaskList;", "crossProjectEntityMigratedCounts", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/EntityCounts;", "getEntityProgress", "entityStatus", "Lcom/atlassian/jira/migration/progress/EntityStatus;", "successfullyCompleted", "getEntityProgressForTasks", "getReadyEntityProgress", "getRunningExportingEntityProgress", "getRunningMigrationEntityProgress", "jira-migration-plugin"})
public final class CrossProjectEntityProgressUtil {
    @NotNull
    public static final CrossProjectEntityProgressUtil INSTANCE = new CrossProjectEntityProgressUtil();

    private CrossProjectEntityProgressUtil() {
    }

    @NotNull
    public final EntityProgress getCrossProjectEntityProgress(long selectedCrossProjectEntityCount, @Nullable TaskList tasks, @Nullable EntityCounts crossProjectEntityMigratedCounts) {
        return tasks == null ? this.getEntityProgress(EntityStatus.READY, 0L, selectedCrossProjectEntityCount) : this.getEntityProgressForTasks(selectedCrossProjectEntityCount, tasks, crossProjectEntityMigratedCounts);
    }

    private final EntityProgress getEntityProgressForTasks(long selectedCrossProjectEntityCount, TaskList tasks, EntityCounts crossProjectEntityMigratedCounts) {
        Map<ProgressUnit, ProgressItem> migrationProgress;
        EntityProgress entityProgress = null;
        Map<ProgressUnit, ProgressItem> exportingProgress = tasks.runningTaskProgressFor(MigrationTaskType.CROSS_PROJECT_DATA_UPLOAD);
        entityProgress = exportingProgress != null ? this.getRunningExportingEntityProgress(selectedCrossProjectEntityCount) : ((migrationProgress = tasks.runningTaskProgressFor(MigrationTaskType.CROSS_PROJECT_DATA_MIGRATION)) != null ? this.getRunningMigrationEntityProgress(selectedCrossProjectEntityCount, crossProjectEntityMigratedCounts) : this.getReadyEntityProgress(selectedCrossProjectEntityCount, crossProjectEntityMigratedCounts));
        return entityProgress;
    }

    private final EntityProgress getRunningExportingEntityProgress(long selectedCrossProjectEntityCount) {
        return this.getEntityProgress(EntityStatus.RUNNING_EXPORTING, 0L, selectedCrossProjectEntityCount);
    }

    private final EntityProgress getRunningMigrationEntityProgress(long selectedCrossProjectEntityCount, EntityCounts crossProjectEntityMigratedCounts) {
        EntityCounts entityCounts = crossProjectEntityMigratedCounts;
        long createdCount = entityCounts != null ? entityCounts.getCreated() : 0L;
        EntityCounts entityCounts2 = crossProjectEntityMigratedCounts;
        long failedCount = entityCounts2 != null ? entityCounts2.getFailed() : 0L;
        EntityStatus migrationStatus = EntityMigrationStatusUtil.INSTANCE.getCrossProjectEntityMigrationStatus(selectedCrossProjectEntityCount, createdCount, failedCount);
        return this.getEntityProgress(migrationStatus, createdCount, selectedCrossProjectEntityCount);
    }

    private final EntityProgress getReadyEntityProgress(long selectedCrossProjectEntityCount, EntityCounts crossProjectEntityMigratedCounts) {
        Object object = crossProjectEntityMigratedCounts;
        if (object == null || (object = EntityProgressStatusUtil.INSTANCE.toEntityProgress((EntityCounts)object)) == null) {
            object = this.getEntityProgress(EntityStatus.READY, 0L, selectedCrossProjectEntityCount);
        }
        return object;
    }

    private final EntityProgress getEntityProgress(EntityStatus entityStatus, long successfullyCompleted, long selectedCrossProjectEntityCount) {
        return new EntityProgress(entityStatus, successfullyCompleted, selectedCrossProjectEntityCount, null, null, 16, null);
    }
}

