/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.common.PluginAccessorExtensionsKt;
import com.atlassian.jira.migration.export.CrossProjectExportStrategy;
import com.atlassian.jira.migration.export.core.filter.service.FilterExportService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.software.board.RapidViewExportService;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.sen.JiraLicenseInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.plugin.PluginAccessor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B5\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/export/AllBoardsAndFiltersExportStrategy;", "Lcom/atlassian/jira/migration/export/CrossProjectExportStrategy;", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "rapidViewExportServiceProvider", "Ljavax/inject/Provider;", "Lcom/atlassian/jira/migration/export/software/board/RapidViewExportService;", "filterExportService", "Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService;", "crossProjectEntityStatsEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "(Ljavax/inject/Provider;Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/plugin/PluginAccessor;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "getExportMode", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAllBoardsAndFiltersExportStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllBoardsAndFiltersExportStrategy.kt\ncom/atlassian/jira/migration/export/AllBoardsAndFiltersExportStrategy\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,56:1\n17#2,6:57\n17#2,6:63\n*S KotlinDebug\n*F\n+ 1 AllBoardsAndFiltersExportStrategy.kt\ncom/atlassian/jira/migration/export/AllBoardsAndFiltersExportStrategy\n*L\n32#1:57,6\n36#1:63,6\n*E\n"})
public final class AllBoardsAndFiltersExportStrategy
extends CrossProjectExportStrategy<CrossProjectBoardAndFiltersMigrationMode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Provider<RapidViewExportService> rapidViewExportServiceProvider;
    @NotNull
    private final FilterExportService filterExportService;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private static final Logger log;

    @Inject
    public AllBoardsAndFiltersExportStrategy(@NotNull Provider<RapidViewExportService> rapidViewExportServiceProvider, @NotNull FilterExportService filterExportService, @NotNull CrossProjectEntityStatsEventService crossProjectEntityStatsEventService, @NotNull SENSupplier senSupplier, @NotNull PluginAccessor pluginAccessor) {
        Intrinsics.checkNotNullParameter(rapidViewExportServiceProvider, (String)"rapidViewExportServiceProvider");
        Intrinsics.checkNotNullParameter((Object)filterExportService, (String)"filterExportService");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityStatsEventService, (String)"crossProjectEntityStatsEventService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        super(crossProjectEntityStatsEventService);
        this.rapidViewExportServiceProvider = rapidViewExportServiceProvider;
        this.filterExportService = filterExportService;
        this.senSupplier = senSupplier;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void export(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.info("MigrationId: " + ctx.getMigrationId() + " : Exporting all filters and all cross-project boards under export mode " + (Object)((Object)ctx.getExportMode()));
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.filterExportService.exportAllFilters(ctx);
        long timeTakenInMillisToExportCrossProjectFilters = System.currentTimeMillis() - start$iv;
        JiraLicenseInfo licenses = this.senSupplier.getLicenses();
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        boolean bl2 = false;
        if (licenses.getJiraSoftwareLicense() != null && PluginAccessorExtensionsKt.hasJswInstalled(this.pluginAccessor)) {
            RapidViewExportService rapidViewExportService = (RapidViewExportService)this.rapidViewExportServiceProvider.get();
            if (rapidViewExportService != null) {
                rapidViewExportService.exportAllCrossProjectRapidViews(ctx);
            }
        }
        long timeTakenInMillisToExportCrossProjectRapidViews = System.currentTimeMillis() - start$iv2;
        this.sendCrossProjectBoardsAndFiltersExportTimeEvent(timeTakenInMillisToExportCrossProjectRapidViews, timeTakenInMillisToExportCrossProjectFilters, ctx.getMigrationTaskMetadata().getCloudId(), ctx.getMigrationId());
    }

    @Override
    @NotNull
    public CrossProjectBoardAndFiltersMigrationMode getExportMode() {
        return CrossProjectBoardAndFiltersMigrationMode.ALL;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(AllBoardsAndFiltersExportStrategy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/AllBoardsAndFiltersExportStrategy$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

