/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.export.AllConfigExporterHelper;
import com.atlassian.jira.migration.export.AllConfigExporterService;
import com.atlassian.jira.migration.export.DataExportOutcome;
import com.atlassian.jira.migration.export.framework.CompositeEventHandler;
import com.atlassian.jira.migration.export.framework.DefaultExportFailureHandler;
import com.atlassian.jira.migration.export.framework.ExportEventHandler;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.framework.IssueExportProgressEventHandler;
import com.atlassian.jira.migration.export.framework.JsonStreamingExportEventHandler;
import com.atlassian.jira.migration.export.framework.ProjectExportContext;
import com.atlassian.jira.migration.metrics.MetricsInfo;
import com.atlassian.jira.migration.metrics.TimingMetrics;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0002\u0010 \u001a\u00020!J.\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/export/AllConfigExporterService;", "", "allConfigExporterHelper", "Lcom/atlassian/jira/migration/export/AllConfigExporterHelper;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "exportFailureHandler", "Lcom/atlassian/jira/migration/export/framework/DefaultExportFailureHandler;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "timingMetrics", "Lcom/atlassian/jira/migration/metrics/TimingMetrics;", "(Lcom/atlassian/jira/migration/export/AllConfigExporterHelper;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/export/framework/DefaultExportFailureHandler;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/metrics/TimingMetrics;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createExportContext", "Lcom/atlassian/jira/migration/export/framework/ProjectExportContext;", "project", "Lcom/atlassian/jira/project/Project;", "migrationTaskMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "outputStream", "Ljava/io/FileOutputStream;", "exportAllConfig", "Lcom/atlassian/jira/migration/export/DataExportOutcome;", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "projectKeys", "", "", "isScope", "", "exportToFile", "projects", "outFile", "Ljava/io/File;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAllConfigExporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllConfigExporterService.kt\ncom/atlassian/jira/migration/export/AllConfigExporterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1549#2:136\n1620#2,3:137\n*S KotlinDebug\n*F\n+ 1 AllConfigExporterService.kt\ncom/atlassian/jira/migration/export/AllConfigExporterService\n*L\n45#1:136\n45#1:137,3\n*E\n"})
public final class AllConfigExporterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AllConfigExporterHelper allConfigExporterHelper;
    @NotNull
    private final DefaultExportFailureHandler exportFailureHandler;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final TimingMetrics timingMetrics;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(AllConfigExporterService.class);

    @Inject
    public AllConfigExporterService(@NotNull AllConfigExporterHelper allConfigExporterHelper, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull DefaultExportFailureHandler exportFailureHandler, @NotNull ProjectManager projectManager, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull TimingMetrics timingMetrics) {
        Intrinsics.checkNotNullParameter((Object)allConfigExporterHelper, (String)"allConfigExporterHelper");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)exportFailureHandler, (String)"exportFailureHandler");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)timingMetrics, (String)"timingMetrics");
        this.allConfigExporterHelper = allConfigExporterHelper;
        this.exportFailureHandler = exportFailureHandler;
        this.projectManager = projectManager;
        this.localFileDataOutput = localFileDataOutput;
        this.timingMetrics = timingMetrics;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataExportOutcome exportAllConfig(@NotNull ApplicationUser loggedInUser, @NotNull List<String> projectKeys, boolean isScope) {
        Iterable projects;
        Iterable iterable;
        Object object;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        if (!((Collection)projectKeys).isEmpty()) {
            void $this$mapTo$iv$iv;
            $this$map$iv = projectKeys;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.projectManager.getProjectObjByKey((String)it));
            }
            iterable = (List)destination$iv$iv;
        } else {
            $this$map$iv = this.projectManager.getProjects();
            Intrinsics.checkNotNull((Object)$this$map$iv);
            iterable = projects = $this$map$iv;
        }
        if (projects.isEmpty()) {
            throw new IllegalStateException("No projects exists for all config export.".toString());
        }
        MigrationTaskMetadata migrationTaskMetadata2 = MigrationTaskMetadata.Companion.dummyMigrationMetadata$default(MigrationTaskMetadata.Companion, "CONFIG_ONLY_EXPORT", loggedInUser, null, 4, null);
        File outFile = LocalFileDataOutput.outputFileForProjectData$default(this.localFileDataOutput, migrationTaskMetadata2.getMigrationId(), "config_data", null, 4, null);
        try {
            object = this.exportToFile((List<? extends Project>)projects, migrationTaskMetadata2, outFile, isScope);
        }
        catch (Exception e) {
            if (!outFile.delete()) {
                log.warn("Failed to delete export file during exception: " + e.getMessage());
            }
            throw e;
        }
        return object;
    }

    public static /* synthetic */ DataExportOutcome exportAllConfig$default(AllConfigExporterService allConfigExporterService, ApplicationUser applicationUser, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return allConfigExporterService.exportAllConfig(applicationUser, list, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataExportOutcome exportToFile(List<? extends Project> projects, MigrationTaskMetadata migrationTaskMetadata2, File outFile, boolean isScope) {
        Closeable closeable = new FileOutputStream(outFile);
        Throwable throwable = null;
        try {
            DataExportOutcome dataExportOutcome;
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = this.createExportContext(projects.get(0), migrationTaskMetadata2, it);
            Throwable throwable2 = null;
            try {
                ProjectExportContext ctx = (ProjectExportContext)closeable2;
                boolean bl2 = false;
                this.allConfigExporterHelper.exportAllConfig(projects, ctx, isScope);
                if (!ctx.getHasExportError()) {
                    log.warn("Export of config data failed, please check export log for more details.");
                }
                this.timingMetrics.printSummary((Map<String, MetricsInfo>)ctx.getMetricsMap(), ctx.getLogTimeMetricsFeatureFlag());
                dataExportOutcome = new DataExportOutcome(outFile, SetsKt.emptySet(), ctx.getExportedEntitiesCount(), ctx.getIssueExportStatistics());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            DataExportOutcome dataExportOutcome2 = dataExportOutcome;
            return dataExportOutcome2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final ProjectExportContext createExportContext(Project project, MigrationTaskMetadata migrationTaskMetadata2, FileOutputStream outputStream) {
        JsonGenerator jsonGenerator = this.objectMapper.getFactory().createGenerator((OutputStream)outputStream);
        IssueExportProgressEventHandler issueExportProgressEventHandler2 = new IssueExportProgressEventHandler((Function1<? super Long, Unit>)((Function1)createExportContext.issueExportProgressEventHandler.1.INSTANCE));
        ExportEventHandler[] exportEventHandlerArray = new ExportEventHandler[2];
        Intrinsics.checkNotNull((Object)jsonGenerator);
        exportEventHandlerArray[0] = new JsonStreamingExportEventHandler(jsonGenerator);
        exportEventHandlerArray[1] = issueExportProgressEventHandler2;
        return new ProjectExportContext(project, migrationTaskMetadata2, new CompositeEventHandler(exportEventHandlerArray), null, false, createExportContext.1.INSTANCE, this.exportFailureHandler, UsersGroupsMigrationOption.Companion.getALL(), ProjectDataMigrationMode.CONFIG_ONLY, ExportMode.COLLECT_CONFIG_ONLY, MigrationType.CLASSIC, null, null, null, null, issueExportProgressEventHandler2, null, null, null, SetsKt.emptySet(), null, 0, null, null, null, 32864280, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/AllConfigExporterService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

